/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.app.CompletionList;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetEntries;
import oracle.dbtools.util.Service;

public class SqlCompleter {
    public String lastFunctionCallName;
    private static final String color32 = "\u001b[32m";
    private static final String color1 = "\u001b[1m";
    private static final String color0 = "\u001b[0m";
    SqlEarley earley = null;
    static int approximateIndex = -1;
    static IProgram programInstance = null;
    private Connection conn = null;

    public static void main(String[] args) throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521/xe", "hr", "hr");
        SqlCompleter c = new SqlCompleter(conn);
        String input = "select job_id from employees mi! select job_id from jobs;";
        int pos = input.indexOf("!");
        input = input.replace("!", "");
        System.out.println("pos=" + pos);
        CompletionList candidates = c.complete(input, pos);
        System.out.println(candidates.toString());
    }

    public SqlCompleter(Connection conn) {
        this.conn = conn;
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public Set<Long> predict(int pos, Matrix matrix) {
        HashSet<Long> predictions = new HashSet<Long>();
        for (int x = 0; x <= pos; ++x) {
            Cell cell = matrix.get(x, pos);
            if (cell == null) continue;
            for (int i = 0; i < cell.size(); ++i) {
                int rule = cell.getRule(i);
                int p = cell.getPosition(i);
                if (p >= this.earley.rules[rule].rhs.length) continue;
                String e = this.earley.allSymbols[this.earley.rules[rule].rhs[p]];
                predictions.add(Service.lPair(this.earley.rules[rule].rhs[p], this.earley.rules[rule].head));
            }
        }
        return predictions;
    }

    public Set<String> topKWsuggestions(Set<Long> suggestions, LexerToken prefix) {
        TreeMap<Long, Integer> topN = new TreeMap<Long, Integer>();
        int N = 7;
        for (long entry : suggestions) {
            String string;
            String sym;
            String prefixKW = "'";
            if (prefix != null) {
                prefixKW = "'" + prefix.content;
            }
            if (!(sym = this.earley.allSymbols[Service.lX(entry)]).startsWith(prefixKW.toUpperCase()) || (string = this.earley.allSymbols[Service.lY(entry)]).endsWith("]\"") && 2 + sym.length() < string.length()) continue;
            long minVar = -1L;
            int minVal = Integer.MAX_VALUE;
            Iterator iterator = topN.keySet().iterator();
            while (iterator.hasNext()) {
                long s = (Long)iterator.next();
                int tmp = (Integer)topN.get(s);
                if (tmp >= minVal) continue;
                minVar = s;
                minVal = tmp;
            }
            long suggestedVar = entry;
            Integer suggestedVal = HarvestDoc.getFrequencies().get(entry);
            if (suggestedVal == null) {
                suggestedVal = 0;
            }
            if (topN.size() == 7) {
                if (suggestedVal == null || minVal >= suggestedVal) continue;
                topN.remove(minVar);
                topN.put(suggestedVar, suggestedVal);
                continue;
            }
            topN.put(suggestedVar, suggestedVal);
        }
        ArrayList myList = new ArrayList();
        for (Map.Entry e : topN.entrySet()) {
            myList.add(e);
        }
        Collections.sort(myList, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry a, Map.Entry b) {
                return ((Integer)b.getValue()).compareTo((Integer)a.getValue());
            }
        });
        int div = 0;
        if (prefix != null) {
            div = prefix.content.length();
        }
        TreeSet<String> ret = new TreeSet<String>();
        int i = 0;
        for (Map.Entry entry : myList) {
            if (7 < i) break;
            String sugg = this.earley.allSymbols[Service.lX((Long)entry.getKey())];
            sugg = sugg.substring(1, sugg.length() - 1);
            if ("true".equals(HiddenParameters.parameters.get("coloredComplete"))) {
                String pre = sugg.substring(0, div);
                String post = sugg.substring(div);
                ret.add(color0 + pre + color32 + post + color0);
            } else {
                ret.add(sugg);
            }
            ++i;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public CompletionList complete(String input, int pos) {
        CompletionList ret = new CompletionList();
        try {
            List<LexerToken> src = Lexer.parse(input);
            if (0 == src.size()) {
                return ret;
            }
            this.earley = SqlEarley.partialRecognizer();
            Matrix matrix = new Matrix(this.earley);
            this.earley.parse(src, matrix);
            SyntaxError error = SyntaxError.checkSyntax(input, new String[]{"sql_statement", "select", "insert", "update", "delete", "merge"}, src, this.earley, matrix, "^^^", "SyntaxError_DetailedMessage");
            if (error != null) {
                int select = -1;
                int from = -1;
                for (LexerToken t : src) {
                    if ("select".equalsIgnoreCase(t.content) && t.end < pos) {
                        select = t.end;
                    }
                    if (0 > select || !"from".equalsIgnoreCase(t.content)) continue;
                    if (pos < t.begin) {
                        from = t.begin;
                        break;
                    }
                    select = -1;
                }
                if (0 <= select && 0 <= from) {
                    input = input.substring(0, select) + " * " + input.substring(from);
                    src = Lexer.parse(input);
                    pos = select + 1;
                }
            }
            Parsed target = new Parsed(input, src, (Earley)this.earley, (String)null);
            approximateIndex = LexerToken.char2lex(src, pos);
            if (approximateIndex < src.size() && src.get((int)SqlCompleter.approximateIndex).begin < pos && pos <= src.get((int)SqlCompleter.approximateIndex).end) {
                ret.prefix = src.get(approximateIndex);
            }
            if (!(ret.prefix == null || ret.prefix.type != Token.OPERATION || ret.prefix.content.equals(":") || ret.prefix.content.equals("!") || ret.prefix.content.equals("^"))) {
                ret.prefix = null;
                ++approximateIndex;
            }
            if ("*".equals(ret.prefix)) {
                ret.prefix = null;
                --approximateIndex;
            }
            if (src.get((int)0).content.equalsIgnoreCase("connect")) {
                String pref = "";
                if (ret.prefix != null) {
                    pref = ret.prefix.content;
                }
                for (String sugg : NetEntries.getMatching(pref)) {
                    ret.add(new CompletionItem(sugg, CompletionItem.Type.TURLNET));
                }
                return ret;
            }
            if (4 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 4).equalsIgnoreCase("desc") || 3 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 3).equalsIgnoreCase("ddl") || 4 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 4).equalsIgnoreCase("info") || 4 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 4).equalsIgnoreCase("ctas")) {
                String pref = "";
                if (ret.prefix != null) {
                    pref = ret.prefix.content;
                }
                String owner = null;
                String obj = pref;
                if (2 < src.size() && ".".equals(src.get((int)2).content)) {
                    owner = src.get((int)1).content.toUpperCase();
                }
                for (CompletionItem sugg : this.queryObjects(owner, obj.toUpperCase(), "")) {
                    ret.add(sugg);
                }
                ret.pos = pos - pref.length();
                return ret;
            }
            int div = 0;
            if (ret.prefix != null) {
                div = ret.prefix.content.length();
            }
            Set<Long> predicted = this.predict(approximateIndex, target.getMatrix());
            TreeSet<String> predictions = new TreeSet<String>();
            for (long key : predicted) {
                predictions.add(SqlEarley.getInstance().allSymbols[Service.lX(key)]);
            }
            HashMap<String, String> alias2table = new HashMap<String, String>();
            String key = color0;
            synchronized (color0) {
                String prefix;
                Object dot;
                if (programInstance == null) {
                    programInstance = new IProgram(Service.readFile(SqlCompleter.class, "completion.prg"));
                }
                // ** MonitorExit[key] (shouldn't be in output)
                SqlCompleter.programInstance.offset = approximateIndex;
                Map<String, MaterializedPredicate> output = programInstance.eval(target, this);
                if (!predictions.contains("table_reference") && !predictions.contains("dml_table_expression_clause")) {
                    MaterializedPredicate tanqb = output.get("\"table_alias in narrowest qb\"");
                    block10: for (Tuple t : tanqb.getTuples()) {
                        void var17_27;
                        String tableExpr;
                        ParseNode table = tanqb.getAttribute(t, "table");
                        ParseNode parseNode = tanqb.getAttribute(t, "alias");
                        if (table.from + 1 == table.to && parseNode.from + 1 == parseNode.to) {
                            alias2table.put(src.get((int)parseNode.from).content.toUpperCase(), src.get((int)table.from).content.toUpperCase());
                        }
                        String _alias = "'" + src.get((int)parseNode.from).content.toUpperCase() + "'";
                        List<LexerToken> _src = src.subList(0, parseNode.from);
                        Matrix _matrix = new Matrix(this.earley);
                        this.earley.parse(_src, _matrix);
                        Set<Long> _predicted = this.predict(parseNode.from, _matrix);
                        TreeSet<String> _predictions = new TreeSet<String>();
                        for (long key2 : _predicted) {
                            _predictions.add(SqlEarley.getInstance().allSymbols[Service.lX(key2)]);
                        }
                        if (_predictions.contains(_alias)) {
                            ParseNode parseNode2 = table;
                        }
                        int begin = src.get((int)table.from).begin;
                        int end = src.get((int)(table.to - 1)).end;
                        String owner = null;
                        String tab = null;
                        if (ret.prefix != null) {
                            tab = ret.prefix.content;
                        }
                        if (0 < (tableExpr = target.getInput().substring(begin, end)).indexOf(46)) {
                            owner = tableExpr.substring(0, tableExpr.indexOf(46));
                            tab = tableExpr.substring(tableExpr.indexOf(46) + 1);
                        } else {
                            owner = null;
                            tab = tableExpr;
                        }
                        if (table == var17_27 && table.to < src.size() && ".".equals(src.get((int)table.to).content)) {
                            owner = tableExpr;
                            tab = "";
                            ret.prefix = null;
                        }
                        String aliased = src.get((int)var17_27.from).content + ".";
                        if (predictions.contains("column")) {
                            String prefix2 = null;
                            if (ret.prefix != null) {
                                if (var17_27 == table) {
                                    prefix2 = ret.prefix.content;
                                }
                                if (0 < approximateIndex && ".".equals(src.get((int)(SqlCompleter.approximateIndex - 1)).content)) {
                                    prefix2 = ret.prefix.content;
                                }
                            }
                            boolean isJoin = false;
                            for (LexerToken lt : target.getSrc()) {
                                if (!"JOIN".equalsIgnoreCase(lt.content)) continue;
                                isJoin = true;
                                break;
                            }
                            for (String sugg : this.queryColumns(owner, tab, prefix2)) {
                                if (1 < tanqb.cardinality() || isJoin) {
                                    sugg = aliased + sugg;
                                    div += aliased.length();
                                }
                                ret.add(new CompletionItem(sugg, CompletionItem.Type.COLUMN));
                            }
                        }
                        boolean predictedWhereClause = false;
                        for (String symbol : predictions) {
                            if (!symbol.startsWith("where_clause")) continue;
                            predictedWhereClause = true;
                            break;
                        }
                        for (String symbol : predictions) {
                            if (!symbol.startsWith("query_table_expression") || predictedWhereClause) continue;
                            if (!tableExpr.equals(tab) && owner == null) continue block10;
                            if (table != var17_27) continue;
                            for (CompletionItem sugg : this.queryObjects(owner, tab.toUpperCase(), "object_type in ('TABLE','VIEW','SYNONYM') and")) {
                                ret.add(sugg);
                            }
                            continue block10;
                        }
                    }
                } else {
                    String prefix3 = "";
                    if (ret.prefix != null) {
                        prefix3 = ret.prefix.content;
                    }
                    for (CompletionItem sugg : this.queryObjects(null, prefix3, "object_type in ('TABLE','VIEW','SYNONYM') and")) {
                        ret.add(sugg);
                    }
                }
                if ((predictions.contains("function_call") || predictions.contains("decl_id")) && 2 <= approximateIndex && ".".equals(dot = src.get((int)(SqlCompleter.approximateIndex - 1)).content)) {
                    String pkg = src.get((int)(SqlCompleter.approximateIndex - 2)).content;
                    prefix = "";
                    if (ret.prefix != null) {
                        prefix = ret.prefix.content;
                    }
                    for (CompletionItem completionItem : this.queryPackageProcedures(null, pkg, prefix)) {
                        ret.add(completionItem);
                    }
                }
                if (predictions.contains("condition")) {
                    for (CompletionItem item : this.joinConditions(ret.entries, alias2table)) {
                        ret.add(item);
                    }
                }
                if (this.lastFunctionCallName != null && predictions.contains("arg")) {
                    Object pkg = null;
                    String fun = null;
                    if (0 < this.lastFunctionCallName.indexOf(46)) {
                        pkg = this.lastFunctionCallName.substring(0, this.lastFunctionCallName.indexOf(46));
                        fun = this.lastFunctionCallName.substring(this.lastFunctionCallName.indexOf(46) + 1);
                    } else {
                        pkg = null;
                        fun = this.lastFunctionCallName;
                    }
                    prefix = "";
                    if (ret.prefix != null) {
                        prefix = ret.prefix.content;
                    }
                    for (String string : this.inlineArguments(this.queryArguments((String)pkg, fun, prefix))) {
                        ret.add(new CompletionItem(string, CompletionItem.Type.ARGUMENT));
                    }
                }
                if (ret.size() == 0) {
                    for (String sugg : this.topKWsuggestions(predicted, ret.prefix)) {
                        ret.add(new CompletionItem(sugg, CompletionItem.Type.KEYWORD));
                    }
                }
                if (ret.size() == 1 && 0 < ret.first().toString().indexOf(32)) {
                    return ret;
                }
                int p = pos;
                if (ret.prefix != null) {
                    p = pos - ret.prefix.content.length();
                }
                ret.pos = p;
                return ret;
            }
        }
        catch (SQLRecoverableException e) {
            return ret;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return ret;
        }
    }

    public static String discolor(String cleaned) {
        cleaned = cleaned.replace(color0, "");
        cleaned = cleaned.replace(color1, "");
        cleaned = cleaned.replace(color32, "");
        return cleaned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CompletionItem> queryObjects(String owner, String prefix, String typesClause) throws SQLException {
        Connection conn;
        int maxUsers = 20;
        String query = "select /*distinct*/ object_name, object_type from all_objects \nwhere " + typesClause + " owner=user \nand object_name like :1 ESCAPE '\\' and rownum < 50\nunion all \nselect username||'.', 'USER' from all_users where username like :2 and rownum <= " + 20 + " \norder by object_name";
        if (owner != null) {
            query = "select object_name, object_type from all_objects \nwhere " + typesClause + " owner = :1 and object_name like :2 ESCAPE '\\' \nand rownum < 50 order by object_name";
        }
        if ((conn = this.getConnection()) == null) {
            return new LinkedList<CompletionItem>();
        }
        if (3 < prefix.length()) {
            query = query.replace("owner=user", "owner in ('PUBLIC','SYS',user)");
        }
        PreparedStatement stmt = conn.prepareStatement(query);
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner.toUpperCase());
        } else {
            stmt.setObject(pos++, prefix.toUpperCase().replace("_", "\\_") + '%');
        }
        stmt.setObject(pos++, prefix.toUpperCase().replace("_", "\\_") + '%');
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<CompletionItem> users = new LinkedList<CompletionItem>();
            LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
            while (rs.next()) {
                String candidate = rs.getString(1);
                String type = rs.getString(2);
                if (candidate.endsWith(".")) {
                    users.add(new CompletionItem(candidate, CompletionItem.Type.USER));
                    continue;
                }
                if ("TABLE".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.TABLE);
                    continue;
                }
                if ("VIEW".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.VIEW);
                    continue;
                }
                if ("SYNONYM".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.SYNONYM);
                    continue;
                }
                if ("PROCEDURE".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.PROCEDURE);
                    continue;
                }
                if ("FUNCTION".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.FUNCTION);
                    continue;
                }
                if ("PACKAGE".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.PACKAGE);
                    continue;
                }
                if ("PACKAGE BODY".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.PACKAGE_BODY);
                    continue;
                }
                ret.add(new CompletionItem(candidate, null));
            }
            if (users.size() < 20) {
                ret.addAll(users);
            }
            LinkedList<CompletionItem> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> queryColumns(String owner, String table, String prefix) throws SQLException {
        Connection conn;
        String query = "select column_name from all_tab_columns where table_name = :1 and owner in ('PUBLIC','SYS',user) \nand column_name like :2 and rownum < 50 order by column_name\n";
        if (owner != null) {
            query = "select column_name from all_tab_columns where owner = :1 and table_name = :2 \nand column_name like :2 and rownum < 50 order by column_name\n";
        }
        if ((conn = this.getConnection()) == null) {
            return new LinkedList<String>();
        }
        PreparedStatement stmt = conn.prepareStatement(query);
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner.toUpperCase());
        }
        stmt.setObject(pos++, table.toUpperCase());
        if (prefix != null) {
            stmt.setObject(pos++, prefix.toUpperCase() + '%');
        } else {
            stmt.setObject(pos++, "%");
        }
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<String> ret = new LinkedList<String>();
            while (rs.next()) {
                ret.add(rs.getString(1));
            }
            LinkedList<String> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CompletionItem> queryPackageProcedures(String owner, String pkg, String prefix) throws SQLException {
        Connection conn;
        String query = "select procedure_name from sys.all_procedures where object_name = :1 and owner in ('PUBLIC','SYS',user) \nand procedure_name like :2 and rownum < 50 order by procedure_name\n";
        if (owner != null) {
            query = "select column_name from sys.all_procedures where owner = :1 and object_name = :2 \nand procedure_name like :2 and rownum < 50 order by procedure_name\n";
        }
        if ((conn = this.getConnection()) == null) {
            return new LinkedList<CompletionItem>();
        }
        PreparedStatement stmt = conn.prepareStatement(query);
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner.toUpperCase());
        }
        stmt.setObject(pos++, pkg.toUpperCase());
        if (prefix != null) {
            stmt.setObject(pos++, prefix.toUpperCase() + '%');
        } else {
            stmt.setObject(pos++, "%");
        }
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
            while (rs.next()) {
                this.addUnique(rs, ret, CompletionItem.Type.PROCEDURE);
            }
            LinkedList<CompletionItem> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> queryArguments(String pkg, String function, String prefix) throws SQLException {
        String query = "SELECT  a.owner||'.'||a.package_name||'.'||a.object_name||'.'||a.overload object_name,  a.argument_name||'=>'||substr(a.argument_name,1,1)||'/*'||a.data_type||' '||a.defaulted||'*/' argument, a.position position \nFROM all_arguments a \nWHERE rownum <=50 and    argument_name is not null \n";
        query = pkg != null ? query + "and package_name = :1 and object_name = :2  and argument_name like :3 \norder by position \n" : query + "and  object_name = :1 and owner in ('PUBLIC','SYS',user) \n and argument_name like :2 order by position";
        Connection conn = this.getConnection();
        if (conn == null) {
            return new LinkedList<String>();
        }
        PreparedStatement stmt = conn.prepareStatement(query);
        int pos = 1;
        if (pkg != null) {
            stmt.setObject(pos++, pkg.toUpperCase());
        }
        stmt.setObject(pos++, function.toUpperCase());
        if (prefix != null) {
            stmt.setObject(pos++, prefix.toUpperCase() + '%');
        } else {
            stmt.setObject(pos++, "%");
        }
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<String> ret = new LinkedList<String>();
            while (rs.next()) {
                ret.add(rs.getString(2));
            }
            LinkedList<String> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private List<String> inlineArguments(List<String> arguments) {
        LinkedList<String> ret = new LinkedList<String>();
        StringBuilder fullArgs = new StringBuilder();
        StringBuilder shortArgs = new StringBuilder();
        for (String arg : arguments) {
            boolean isDefault = 0 < arg.indexOf(" Y*/");
            arg = arg.replace(" Y*/", "*/");
            arg = arg.replace(" N*/", "*/");
            if (fullArgs.length() > 0) {
                fullArgs.append(",");
            }
            fullArgs.append(arg);
            if (isDefault) continue;
            if (shortArgs.length() > 0) {
                shortArgs.append(",");
            }
            shortArgs.append(arg);
        }
        if (fullArgs.length() != shortArgs.length()) {
            ret.add("/*min sig:*/" + shortArgs.toString());
            ret.add("/*full sig:*/" + fullArgs.toString());
        } else {
            ret.add(fullArgs.toString());
        }
        return ret;
    }

    private void addUnique(ResultSet rs, List<CompletionItem> ret, CompletionItem.Type type) throws SQLException {
        CompletionItem item = new CompletionItem(rs.getString(1), type);
        if (!ret.contains(item)) {
            ret.add(item);
        }
    }

    private List<CompletionItem> joinConditions(List<CompletionItem> items, Map<String, String> alias2table) {
        LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
        int cnt = 0;
        block0: for (CompletionItem first : items) {
            String firstName = first.entry;
            int fi = firstName.indexOf(46);
            if (fi <= 0 || !CompletionItem.Type.COLUMN.equals((Object)first.type)) continue;
            for (CompletionItem second : items) {
                String secondName = second.entry;
                int si = secondName.indexOf(46);
                if (si <= 0 || firstName.compareTo(secondName) <= 0 || !CompletionItem.Type.COLUMN.equals((Object)first.type) || !this.colNamesMatch(firstName, secondName, alias2table)) continue;
                ret.add(new CompletionItem(firstName + " = " + secondName, CompletionItem.Type.CONDITION));
                if (++cnt <= 50) continue;
                break block0;
            }
        }
        return ret;
    }

    private boolean colNamesMatch(String firstCol, String secondCol, Map<String, String> alias2table) {
        int fi = firstCol.indexOf(46);
        int si = secondCol.indexOf(46);
        String firstNAME = firstCol.substring(fi + 1).toUpperCase();
        String secondNAME = secondCol.substring(si + 1).toUpperCase();
        if (firstNAME == null) {
            return false;
        }
        if (firstNAME.equals(secondNAME)) {
            return true;
        }
        String firstTABLE = alias2table.get(firstCol.substring(0, fi).toUpperCase()).toUpperCase();
        String secondTABLE = alias2table.get(secondCol.substring(0, si).toUpperCase()).toUpperCase();
        return firstNAME.startsWith(firstTABLE) && secondNAME.equals(firstNAME + "_ID") || firstNAME.startsWith(firstTABLE) && secondNAME.equals(firstNAME + "_NAME") || secondNAME.startsWith(secondTABLE) && firstNAME.equals(secondNAME + "_ID") || secondNAME.startsWith(secondTABLE) && firstNAME.equals(secondNAME + "_NAME") || this.tabColNamesMatch(firstNAME, firstTABLE) && firstNAME.endsWith("_ID") && this.tabColNamesMatch(secondNAME, secondTABLE) && secondNAME.endsWith("_ID") || this.tabColNamesMatch(firstNAME, firstTABLE) && firstNAME.endsWith("_NAME") && this.tabColNamesMatch(secondNAME, secondTABLE) && secondNAME.endsWith("_NAME");
    }

    private boolean tabColNamesMatch(String column, String table) {
        if (table.length() < 5 || column.length() < 5) {
            return false;
        }
        for (int i = 0; i < table.length() - 5; ++i) {
            String tab = table.substring(i, i + 5);
            if (!column.contains(tab)) continue;
            return true;
        }
        return false;
    }

    static class IProgram
    extends SqlProgram {
        int offset = -1;

        private IProgram(String arboriProgram) throws IOException {
            super(arboriProgram);
        }
    }
}

