/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import oracle.dbtools.app.injection.DependencyLink;
import oracle.dbtools.app.injection.Usage;

class FlowGraph {
    private static final boolean DEBUG = false;
    List<Usage> sources = new ArrayList<Usage>();
    List<Usage> sinks = new ArrayList<Usage>();

    FlowGraph() {
    }

    void addSource(Usage source) {
        this.sources.add(source);
    }

    void addSink(Usage sink) {
        this.sinks.add(sink);
    }

    List<List<DependencyLink>> getInjections(Function<Usage, Integer> linenum) {
        Object p;
        TreeSet<Usage> debugUsages = new TreeSet<Usage>((a, b) -> a.getPos().from - b.getPos().from);
        ArrayDeque<Object> todo = new ArrayDeque<Object>();
        HashMap<Usage, Object> paths = new HashMap<Usage, Object>();
        for (Usage usage : this.sources) {
            debugUsages.add(usage);
            if (usage.isSafe()) continue;
            Path p2 = new Path(usage);
            paths.put(usage, p2);
            todo.addLast(p2);
        }
        while (!todo.isEmpty()) {
            Path cur = (Path)todo.removeFirst();
            for (Usage u : cur.getFlows()) {
                debugUsages.add(u);
                p = (Path)paths.get(u);
                if (p != null) continue;
                p = new Path(u, cur);
                paths.put(u, p);
                todo.addLast(p);
            }
            for (Usage u : cur.getSources()) {
                debugUsages.add(u);
            }
        }
        ArrayList<List<DependencyLink>> allInjections = new ArrayList<List<DependencyLink>>();
        for (Usage sink : this.sinks) {
            debugUsages.add(sink);
            p = (Path)paths.get(sink);
            if (p == null) continue;
            ArrayList<DependencyLink> injection = new ArrayList<DependencyLink>();
            for (Usage u : ((Path)p).getPath()) {
                injection.add(new DependencyLink(u.getName(), linenum.apply(u), u.getPos().from, u.getPos().to));
            }
            allInjections.add(injection);
        }
        ArrayDeque<Usage> arrayDeque = new ArrayDeque<Usage>(debugUsages);
        while (!arrayDeque.isEmpty()) {
            Usage u;
            u = (Usage)arrayDeque.removeFirst();
            for (Usage u2 : u.getFlows()) {
                if (debugUsages.contains(u2)) continue;
                debugUsages.add(u2);
                arrayDeque.addFirst(u2);
            }
            for (Usage u2 : u.getSources()) {
                if (debugUsages.contains(u2)) continue;
                debugUsages.add(u2);
                arrayDeque.addFirst(u2);
            }
        }
        for (Usage u : debugUsages) {
            for (Usage usage : u.getSources()) {
            }
            for (Usage usage : u.getFlows()) {
            }
        }
        return allInjections;
    }

    private static class Path {
        Usage usage;
        Path prev;

        private Path(Usage usage, Path reachedFrom) {
            this.usage = usage;
            this.prev = reachedFrom;
        }

        private Path(Usage usage) {
            this(usage, (Path)null);
        }

        private List<Usage> getFlows() {
            return this.usage.getFlows();
        }

        private List<Usage> getSources() {
            return this.usage.getSources();
        }

        private List<Usage> getPath() {
            List<Object> ret = this.prev == null ? new ArrayList() : this.prev.getPath();
            ret.add(this.usage);
            return ret;
        }

        private String toString(Function<Usage, Integer> linenum) {
            StringBuffer sb = new StringBuffer(this.usage.toString() + ":" + linenum.apply(this.usage) + " |");
            for (Usage u : this.getPath()) {
                sb.append(" " + u + ":" + linenum.apply(u));
            }
            return sb.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.usage.toString() + " |");
            for (Usage u : this.getPath()) {
                sb.append(" " + u);
            }
            return sb.toString();
        }
    }
}

