/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.EnumSet;
import oracle.dbtools.app.injection.PlsqlException;
import oracle.dbtools.app.injection.PlsqlType;

public class TypeConversion {
    static EnumSet<PlsqlException> exceptionsFromMerge(PlsqlType a, PlsqlType b) {
        EnumSet<PlsqlException> exceptions = TypeConversion.conversionExceptions(a, b);
        exceptions.addAll(TypeConversion.conversionExceptions(b, a));
        return exceptions;
    }

    static EnumSet<PlsqlException> conversionExceptions(PlsqlType from, PlsqlType to) {
        if (from instanceof PlsqlType.Scalar && to instanceof PlsqlType.Scalar) {
            PlsqlType.Scalar tos = (PlsqlType.Scalar)to;
            PlsqlType.Scalar froms = (PlsqlType.Scalar)from;
            switch (tos.getScalarClass()) {
                case BOOLEAN: {
                    if (froms.getScalarClass() == PlsqlType.ScalarClass.BOOLEAN) {
                        return EnumSet.noneOf(PlsqlException.class);
                    }
                    return EnumSet.of(PlsqlException.VALUE_ERROR);
                }
                case NUMERIC: {
                    return TypeConversion.toNumericExceptions(froms, tos);
                }
                case CHARACTER: {
                    return TypeConversion.toCharacterExceptions(froms, tos);
                }
                case DATETIME_INTERVAL: {
                    return TypeConversion.toDateTimeExceptions(froms, tos);
                }
                case LOB: {
                    return TypeConversion.toLobExceptions(froms, tos);
                }
            }
        }
        throw new IllegalArgumentException("Unable to convert from " + from + " to " + to);
    }

    private static EnumSet<PlsqlException> toNumericExceptions(PlsqlType.Scalar from, PlsqlType.Scalar to) {
        assert (to.getScalarClass() == PlsqlType.ScalarClass.NUMERIC);
        switch (from.getScalarClass()) {
            case NUMERIC: {
                if (from.getDataType() == to.getDataType()) {
                    if (from.getDataType() == PlsqlType.DataType.NUMBER) {
                        if (to.getSize() < from.getSize()) {
                            return EnumSet.of(PlsqlException.VALUE_ERROR);
                        }
                        return EnumSet.noneOf(PlsqlException.class);
                    }
                    if (to.getSize() < from.getSize()) {
                        return EnumSet.of(PlsqlException.VALUE_ERROR);
                    }
                    return EnumSet.noneOf(PlsqlException.class);
                }
                if (from.getDataType() == PlsqlType.DataType.BINARY_FLOAT && to.getDataType() == PlsqlType.DataType.BINARY_DOUBLE) {
                    return EnumSet.noneOf(PlsqlException.class);
                }
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case BOOLEAN: {
                return EnumSet.of(PlsqlException.INVALID_NUMBER, PlsqlException.VALUE_ERROR);
            }
            case CHARACTER: {
                return EnumSet.of(PlsqlException.INVALID_NUMBER, PlsqlException.VALUE_ERROR);
            }
            case DATETIME_INTERVAL: 
            case LOB: {
                return EnumSet.of(PlsqlException.INVALID_NUMBER);
            }
        }
        throw new NullPointerException("Unexpected ScalarClass " + (Object)((Object)from.getScalarClass()));
    }

    private static EnumSet<PlsqlException> toCharacterExceptions(PlsqlType.Scalar from, PlsqlType.Scalar to) {
        assert (to.getScalarClass() == PlsqlType.ScalarClass.CHARACTER);
        switch (from.getScalarClass()) {
            case CHARACTER: {
                if (from.getDataType() == to.getDataType() && to.sizeSafe(from.getSize())) {
                    return EnumSet.noneOf(PlsqlException.class);
                }
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case BOOLEAN: 
            case NUMERIC: 
            case DATETIME_INTERVAL: {
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case LOB: {
                switch (from.getDataType()) {
                    case BFILE: 
                    case BLOB: {
                        return EnumSet.of(PlsqlException.VALUE_ERROR);
                    }
                    case CLOB: 
                    case NCLOB: {
                        return EnumSet.of(PlsqlException.VALUE_ERROR);
                    }
                }
                throw new NullPointerException("Unexpected DataType " + (Object)((Object)from.getDataType()));
            }
        }
        throw new NullPointerException("Unexpected ScalarClass " + (Object)((Object)from.getScalarClass()));
    }

    private static EnumSet<PlsqlException> toDateTimeExceptions(PlsqlType.Scalar from, PlsqlType.Scalar to) {
        assert (to.getScalarClass() == PlsqlType.ScalarClass.DATETIME_INTERVAL);
        switch (from.getScalarClass()) {
            case DATETIME_INTERVAL: {
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case CHARACTER: {
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case BOOLEAN: 
            case NUMERIC: 
            case LOB: {
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
        }
        throw new NullPointerException("Unexpected ScalarClass " + (Object)((Object)from.getScalarClass()));
    }

    private static EnumSet<PlsqlException> toLobExceptions(PlsqlType.Scalar from, PlsqlType.Scalar to) {
        assert (to.getScalarClass() == PlsqlType.ScalarClass.LOB);
        switch (from.getScalarClass()) {
            case BOOLEAN: 
            case NUMERIC: 
            case CHARACTER: 
            case DATETIME_INTERVAL: {
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case LOB: {
                if (from.getDataType() == to.getDataType() && from.getSize() <= to.getSize()) {
                    return EnumSet.noneOf(PlsqlException.class);
                }
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
        }
        throw new NullPointerException("Unexpected ScalarClass " + (Object)((Object)from.getScalarClass()));
    }
}

