/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.arbori.AncestorDescendantNodes;
import oracle.dbtools.arbori.AncestorExpr;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.Column;
import oracle.dbtools.arbori.EqualExpr;
import oracle.dbtools.arbori.IndependentAttribute;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Parent;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Sibling;
import oracle.dbtools.parser.Parsed;

public class AttributeDefinitions
extends HashMap<String, Attribute> {
    private final Map<String, Predicate> namedPredicates;
    private Set<String> independentAttributes;
    private String evaluatedPredVar;
    private ArrayList<String> header;
    private Predicate evaluatedPredicate;

    public AttributeDefinitions(String evaluatedPredVar, Map<String, Predicate> namedPredicates) {
        this.namedPredicates = namedPredicates;
        this.independentAttributes = new HashSet<String>();
        this.evaluatedPredVar = evaluatedPredVar;
        HashSet<String> allVariables = new HashSet<String>();
        this.evaluatedPredicate = namedPredicates.get(evaluatedPredVar);
        this.evaluatedPredicate.variables(allVariables, true);
        HashSet<String> removal = new HashSet<String>();
        for (String s : allVariables) {
            this.extractDependentAttributes(s, allVariables, removal);
        }
        this.independentAttributes.removeAll(removal);
        this.evaluatedPredicate.adjustIsFunFlag(this.independentAttributes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractDependentAttributes(String name, Set<String> allVariables, Set<String> removal) {
        if (this.containsKey(name)) {
            return;
        }
        String ref = Attribute.referredTo(name);
        if (ref != null) {
            if (0 < name.indexOf(60)) {
                int pos = name.indexOf(60);
                String prefix = name.substring(0, pos);
                String postfix = name.substring(pos + 1);
                AncestorDescendantNodes.Type type = AncestorDescendantNodes.Type.CLOSEST;
                if (postfix.charAt(0) == '=' || postfix.charAt(0) == '<') {
                    postfix = postfix.substring(1);
                    type = AncestorDescendantNodes.Type.TRANSITIVE;
                }
                if (0 >= prefix.indexOf(46) && 0 >= prefix.indexOf(94) && 0 >= prefix.indexOf(43) && 0 >= prefix.indexOf(45)) {
                    AncestorExpr ee = new AncestorExpr(prefix, postfix, type, this.evaluatedPredicate);
                    this.put(ee.name, ee);
                    removal.add(ee.name);
                    this.extractDependentAttributes(ee.name, allVariables, removal);
                    return;
                }
                this.extractDependentAttributes(prefix, allVariables, removal);
                this.extractDependentAttributes(postfix, allVariables, removal);
                return;
            }
            if (0 < name.indexOf(61)) {
                int pos = name.indexOf(61);
                String prefix = name.substring(0, pos);
                String postfix = name.substring(pos + 1);
                String prefRef = Attribute.referredTo(prefix);
                String postRef = Attribute.referredTo(postfix);
                if (null == prefRef && null == postRef) {
                    int prefCnt = 0;
                    int postCnt = 0;
                    for (String s : allVariables) {
                        StringTokenizer st = new StringTokenizer(s, "=^<>[)?");
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (prefix.equals(token)) {
                                ++prefCnt;
                            }
                            if (!postfix.equals(token)) continue;
                            ++postCnt;
                        }
                    }
                    if (postCnt < prefCnt) {
                        prefRef = "not null";
                    }
                }
                if (null == prefRef) {
                    EqualExpr ee = new EqualExpr(prefix, postfix);
                    this.put(ee.name, ee);
                    removal.add(ee.name);
                    ref = postfix;
                } else {
                    if (null != postRef) {
                        this.extractDependentAttributes(prefix, allVariables, removal);
                        this.extractDependentAttributes(postfix, allVariables, removal);
                        return;
                    }
                    EqualExpr ee = new EqualExpr(postfix, prefix);
                    this.put(ee.name, ee);
                    removal.add(ee.name);
                    ref = prefix;
                }
            } else if (name.endsWith("^")) {
                this.put(name, new Parent(name));
            } else if (name.charAt(ref.length()) == '-') {
                try {
                    String suffix = name.substring(ref.length());
                    int n = Integer.parseInt(suffix);
                    this.put(name, new Sibling(name, n));
                }
                catch (NumberFormatException e) {
                    throw new AssertionError((Object)("Cant parse number in " + name));
                }
            } else if (name.charAt(ref.length()) == '+') {
                try {
                    String suffix = name.substring(ref.length());
                    int n = Integer.parseInt(suffix);
                    this.put(name, new Sibling(name, n));
                }
                catch (NumberFormatException e) {
                    throw new AssertionError((Object)("Cant parse number in " + name));
                }
            } else {
                String postfix;
                if (0 >= name.indexOf(46)) throw new AssertionError((Object)"unexpected case");
                String pred = name.substring(0, name.indexOf(46));
                MaterializedPredicate refPred = (MaterializedPredicate)this.namedPredicates.get(pred);
                if (refPred.getAttribute(postfix = name.substring(pred.length() + 1)) == null) {
                    throw new AssertionError((Object)("Undefined variable " + postfix + " in " + pred));
                }
                this.put(name, new Column(name));
                ref = pred;
            }
            this.extractDependentAttributes(ref, allVariables, removal);
            return;
        }
        this.put(name, new IndependentAttribute(name, this.namedPredicates));
        this.independentAttributes.add(name);
        Predicate pred = this.namedPredicates.get(name);
        if (pred == null) return;
        if (!(pred instanceof MaterializedPredicate)) {
            throw new AssertionError((Object)(" !(" + name + " instanceof MaterializedPredicate)"));
        }
        MaterializedPredicate defVectors = (MaterializedPredicate)pred;
        this.put(name, defVectors);
        defVectors.name = name;
    }

    public void evalDimensions(Parsed target, boolean emptyContent) {
        Predicate evaluatedPredicate = this.namedPredicates.get(this.evaluatedPredVar);
        if (Program.debug) {
            System.out.println(evaluatedPredicate.toString());
        }
        HashSet<String> signature = new HashSet<String>();
        evaluatedPredicate.signature(signature);
        this.header = new ArrayList();
        for (String candidateAttr : this.keySet()) {
            if (!signature.contains(candidateAttr)) continue;
            this.header.add(candidateAttr);
        }
        for (String var : this.independentAttributes) {
            IndependentAttribute varDef = (IndependentAttribute)this.get(var);
            if (emptyContent) continue;
            if (this.independentAttributes.size() == 1) {
                varDef.putFilter(evaluatedPredicate);
            }
            varDef.initContent(target.getRoot(), target.getSrc(), this, this.evaluatedPredVar);
        }
    }

    public Set<String> listDimensions() {
        return this.independentAttributes;
    }

    public MaterializedPredicate getDimensionContent(String name) {
        Attribute ret = (Attribute)this.get(name);
        return ((IndependentAttribute)ret).getContent();
    }

    public ArrayList<String> getHeader() {
        return this.header;
    }

    String minimalRelatedDimension(Set<String> joined, int joinedCardinality) {
        String ret = null;
        boolean isEmpty = false;
        for (String current : this.independentAttributes) {
            if (this.getDimensionContent(current).cardinality() == 0) {
                isEmpty = true;
            }
            if (joined.contains(current) || !this.isConnected(joined, current) && !isEmpty && 1 < joinedCardinality || ret != null && this.getDimensionContent(current).cardinality() >= this.getDimensionContent(ret).cardinality()) continue;
            ret = current;
        }
        return ret;
    }

    private boolean isConnected(Set<String> joined, String current) {
        Predicate p = this.namedPredicates.get(this.evaluatedPredVar);
        for (String j : joined) {
            if (!this.isRelated(current, j, p)) continue;
            return true;
        }
        return false;
    }

    private boolean isRelated(String s1, String s2, Predicate p) {
        for (String d1 : this.functions(s1)) {
            for (String d2 : this.functions(s2)) {
                if (p.isRelated(d1, d2, this) == null) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> functions(String s) {
        LinkedList<String> ret = new LinkedList<String>();
        for (String vd : this.keySet()) {
            if (!vd.startsWith(s)) continue;
            ret.add(vd);
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(super.toString());
        ret.append("\nindependentAttributes = " + this.independentAttributes.toString());
        ret.append("\nevaluatedPredVar = " + this.evaluatedPredVar);
        ret.append("\nheader = " + this.header);
        return ret.toString();
    }

    public static void main(String[] args) {
        AncestorDescendantNodes p1 = new AncestorDescendantNodes("a.b", "c", AncestorDescendantNodes.Type.TRANSITIVE);
        HashSet<String> ret = new HashSet<String>();
        p1.signature(ret);
        System.out.println(ret);
    }
}

