/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.SimpleBindings;

public class GlobalMap
extends SimpleBindings
implements Closeable {
    private static final String NASHORN_GLOBAL = "nashorn.global";
    private Bindings global;
    private Set<String> original_keys;

    public GlobalMap(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Object put(String key, Object value) {
        if (key.equals(NASHORN_GLOBAL) && value instanceof Bindings) {
            this.global = (Bindings)value;
            this.original_keys = new HashSet(this.global.keySet());
            return null;
        }
        return super.put(key, value);
    }

    @Override
    public Object get(Object key) {
        return key.equals(NASHORN_GLOBAL) ? this.global : super.get(key);
    }

    @Override
    public void close() {
        if (this.global != null) {
            HashSet keys = new HashSet(this.global.keySet());
            keys.removeAll(this.original_keys);
            for (String key : keys) {
                this.put(key, this.global.remove(key));
            }
        }
    }
}

