/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import oracle.dbtools.arbori.AggregatePredicate;
import oracle.dbtools.arbori.AncestorDescendantNodes;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.AttributeDefinitions;
import oracle.dbtools.arbori.BindVar;
import oracle.dbtools.arbori.ChildNumRelation;
import oracle.dbtools.arbori.Composite;
import oracle.dbtools.arbori.CompositeExpr;
import oracle.dbtools.arbori.False;
import oracle.dbtools.arbori.GlobalMap;
import oracle.dbtools.arbori.Head;
import oracle.dbtools.arbori.Header;
import oracle.dbtools.arbori.IndependentAttribute;
import oracle.dbtools.arbori.JSFunc;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.NodeContent;
import oracle.dbtools.arbori.NodeMatchingSrc;
import oracle.dbtools.arbori.NodesWMatchingSrc;
import oracle.dbtools.arbori.Oper;
import oracle.dbtools.arbori.Position;
import oracle.dbtools.arbori.PositionalRelation;
import oracle.dbtools.arbori.PredRef;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.PredicateDependency;
import oracle.dbtools.arbori.SameNodes;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tail;
import oracle.dbtools.arbori.True;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;

public class Program {
    public static boolean debug = false;
    public static boolean timing = false;
    protected Object struct = null;
    protected Earley parser;
    private static int attribute = -1;
    private static int backslash = -1;
    private static int closePar = -1;
    private static int closeBr = -1;
    private static int col = -1;
    private static int conj = -1;
    private static int digits = -1;
    private static int disj = -1;
    private static int dot = -1;
    private static int eq = -1;
    private static int excl = -1;
    private static int identifier = -1;
    private static int include = -1;
    private static int header = -1;
    private static int lt = -1;
    private static int minus = -1;
    private static int node_parent = -1;
    private static int node_predecessor = -1;
    private static int node_position = -1;
    private static int node_successor = -1;
    private static int node = -1;
    private static int openBr = -1;
    private static int openPar = -1;
    private static int plus = -1;
    private static int predicate = -1;
    private static int referenced_node = -1;
    private static int rule = -1;
    private static int srcPtr = -1;
    private static int semicol = -1;
    private static int sharp = -1;
    private static int slash = -1;
    private static int statement = -1;
    private static int string_literal = -1;
    private LinkedList<String> execOrder = new LinkedList();
    Map<String, Predicate> namedPredicates = new HashMap<String, Predicate>();
    private PredicateDependency dependency = new PredicateDependency();
    private Map<String, String> outputActions = new HashMap<String, String>();
    private Program compiledInstance = null;
    protected static HashMap<String, Program> compiledPrograms = new HashMap();
    private HashMap<String, Boolean> bindsInstance = null;
    public List<Program> included = new LinkedList<Program>();
    private static String javaCallbackCode = "this is java callback (not JS)";
    public Boolean addWsDividers = null;
    ScriptEngine engine = null;
    GlobalMap globals = null;

    public void setStruct(Object struct) {
        this.struct = struct;
    }

    public Program(Earley parser) {
        this(parser, null);
    }

    public Program(Earley parser, Object struct) {
        this.parser = parser;
        this.struct = struct;
    }

    public static void main(String[] args) throws Exception {
        long t1 = System.currentTimeMillis();
        final String input = Service.readFile("common/src/test/resources/oracle/dbtools/arbori/test.sql");
        final List<LexerToken> src = Lexer.parse(input);
        SqlProgram r = new SqlProgram(Service.readFile("common/src/test/resources/oracle/dbtools/arbori/test.arbori")){
            int caret;
            int offset;
            {
                super(programText);
                this.caret = input.indexOf("y");
                this.offset = LexerToken.scanner2parserOffset(src, this.caret);
            }

            @Override
            public Boolean getBoolBindVar(String name) {
                return true;
            }
        };
        Map<String, MaterializedPredicate> output = r.run(input, src, "JS action");
        long t2 = System.currentTimeMillis();
        System.out.println(t2 - t1);
    }

    public static Earley getArboriParser() throws IOException {
        Set<RuleTuple> rules = Program.getRules();
        Earley testParser = new Earley((Set)rules){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING;
            }
        };
        testParser.isCaseSensitive = true;
        attribute = (Integer)testParser.symbolIndexes.get("attribute");
        backslash = (Integer)testParser.symbolIndexes.get("'\\'");
        closePar = (Integer)testParser.symbolIndexes.get("')'");
        closeBr = (Integer)testParser.symbolIndexes.get("']'");
        col = (Integer)testParser.symbolIndexes.get("':'");
        conj = (Integer)testParser.symbolIndexes.get("'&'");
        digits = (Integer)testParser.symbolIndexes.get("digits");
        disj = (Integer)testParser.symbolIndexes.get("'|'");
        dot = (Integer)testParser.symbolIndexes.get("'.'");
        eq = (Integer)testParser.symbolIndexes.get("'='");
        excl = (Integer)testParser.symbolIndexes.get("'!'");
        identifier = (Integer)testParser.symbolIndexes.get("identifier");
        include = (Integer)testParser.symbolIndexes.get("include");
        header = (Integer)testParser.symbolIndexes.get("header");
        lt = (Integer)testParser.symbolIndexes.get("'<'");
        minus = (Integer)testParser.symbolIndexes.get("'-'");
        node_parent = (Integer)testParser.symbolIndexes.get("node_parent");
        node_position = (Integer)testParser.symbolIndexes.get("node_position");
        node_predecessor = (Integer)testParser.symbolIndexes.get("node_predecessor");
        node_successor = (Integer)testParser.symbolIndexes.get("node_successor");
        node = (Integer)testParser.symbolIndexes.get("node");
        openBr = (Integer)testParser.symbolIndexes.get("'['");
        openPar = (Integer)testParser.symbolIndexes.get("'('");
        plus = (Integer)testParser.symbolIndexes.get("'+'");
        predicate = (Integer)testParser.symbolIndexes.get("predicate");
        referenced_node = (Integer)testParser.symbolIndexes.get("referenced_node");
        rule = (Integer)testParser.symbolIndexes.get("rule");
        semicol = (Integer)testParser.symbolIndexes.get("';'");
        sharp = (Integer)testParser.symbolIndexes.get("'#'");
        slash = (Integer)testParser.symbolIndexes.get("'/'");
        srcPtr = (Integer)testParser.symbolIndexes.get("'?'");
        statement = (Integer)testParser.symbolIndexes.get("statement");
        string_literal = (Integer)testParser.symbolIndexes.get("string_literal");
        return testParser;
    }

    private static Set<RuleTuple> getRules() throws IOException {
        String input = Service.readFile(Program.class, "arbori.grammar");
        List<LexerToken> src = Lexer.parse(input, false, 1);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, ret);
        return ret;
    }

    public LinkedList<String> querySequence() {
        return this.execOrder;
    }

    private void copyState(Program source) {
        this.execOrder = source.execOrder;
        this.namedPredicates.clear();
        for (String key : source.namedPredicates.keySet()) {
            Predicate value = source.namedPredicates.get(key);
            Predicate clone = value.copy(this);
            this.namedPredicates.put(key, clone);
        }
        this.dependency = source.dependency;
        this.outputActions = source.outputActions;
        this.parser = source.parser;
        this.bindsInstance = source.bindsInstance;
        this.included = source.included;
        this.engine = source.engine;
        this.globals = source.globals;
    }

    public void compile(String programText) throws IOException {
        this.compile(programText, null);
    }

    public void compile(String programText, Object struct) throws IOException {
        this.included = new LinkedList<Program>();
        this.compiledInstance = compiledPrograms.get(programText);
        if (this.compiledInstance != null && this.compiledInstance.bindsInstance != null) {
            for (String bindVar : this.compiledInstance.bindsInstance.keySet()) {
                Boolean bindValue = this.compiledInstance.bindsInstance.get(bindVar);
                if (bindValue.equals(this.getBoolBindVar(bindVar))) continue;
                this.compiledInstance = null;
                break;
            }
        } else {
            this.compiledInstance = null;
        }
        if (this.compiledInstance == null) {
            Parsed prg = new Parsed(programText, Program.getArboriParser(), "program");
            SyntaxError error = prg.getSyntaxError();
            if (error != null) {
                throw error;
            }
            this.program(prg.getRoot(), prg.getSrc(), prg.getInput());
            this.compiledInstance = new Program(this.parser, struct);
            this.compiledInstance.copyState(this);
            this.compiledInstance.bindsInstance = new HashMap();
            Set<String> bindVars = this.listBindVariables(prg.getRoot(), prg.getSrc());
            for (String bindVar : bindVars) {
                this.compiledInstance.bindsInstance.put(bindVar, this.getBoolBindVar(bindVar));
            }
            compiledPrograms.put(programText, this.compiledInstance);
        } else {
            this.copyState(this.compiledInstance);
        }
    }

    private void program(ParseNode root, List<LexerToken> src, String input) {
        if (root.contains(statement)) {
            this.statement(root, src, input);
            return;
        }
        for (ParseNode child : root.children()) {
            this.program(child, src, input);
        }
    }

    private void statement(ParseNode root, List<LexerToken> src, String input) {
        if (root.contains(rule)) {
            this.rule(root, src, input);
        } else if (root.contains(include)) {
            this.include(root, src, input);
        }
    }

    private void include(ParseNode root, List<LexerToken> src, String input) {
        for (ParseNode child : root.children()) {
            if (child.contains("'include'")) continue;
            String filename = child.content(src);
            if (filename.startsWith("\"")) {
                filename = filename.substring(1, filename.length() - 1);
            }
            String includeContent = null;
            try {
                includeContent = Service.readFile(Program.class, filename);
            }
            catch (IOException e) {
                try {
                    Properties pr = System.getProperties();
                    String m = (String)pr.get("dbtools.arbori.home");
                    if (m != null && (m.endsWith("/") || m.endsWith("\\"))) {
                        m = m.substring(0, m.length() - 1);
                    }
                    includeContent = m == null ? Service.readFile(filename) : Service.readFile(m.toString() + "/" + filename);
                }
                catch (IOException e1) {
                    try {
                        includeContent = Service.readFile(filename);
                    }
                    catch (IOException e2) {
                        throw new AssertionError((Object)(filename + " not found"));
                    }
                }
            }
            try {
                SqlProgram prg = new SqlProgram(includeContent, this.struct);
                prg.globals = this.getGlobals();
                prg.engine = this.getEngine();
                this.included.add(prg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void rule(ParseNode root, List<LexerToken> src, String input) {
        String first = null;
        boolean legitimateOper = false;
        String name = null;
        for (ParseNode child : root.children()) {
            if (first == null) {
                if (child.from + 1 == child.to) {
                    first = child.content(src);
                    continue;
                }
                return;
            }
            if (!legitimateOper) {
                if (child.contains(col)) {
                    legitimateOper = true;
                    continue;
                }
                return;
            }
            if (child.contains(predicate)) {
                Predicate p = this.predicate(child, src, input);
                Map<String, Boolean> dependencies = p.dependencies();
                for (String s : dependencies.keySet()) {
                    this.dependency.addDependency(s, first, dependencies.get(s));
                }
                if (this.namedPredicates.containsKey(first)) {
                    throw new AssertionError((Object)("Duplicate defintion of predicate " + first));
                }
                this.execOrder.add(first);
                this.namedPredicates.put(first, p);
                continue;
            }
            if (child.contains(minus)) {
                name = first;
            }
            if (child.contains("javascript")) {
                this.outputActions.put(name, input.substring(src.get((int)child.from).begin, src.get((int)(child.to - 1)).end));
                return;
            }
            if (name == null) continue;
            this.outputActions.put(name, javaCallbackCode);
        }
    }

    private Predicate predicate(ParseNode root, List<LexerToken> src, String input) {
        if (root.contains(identifier)) {
            return new PredRef(root.content(src), this);
        }
        Predicate ret = this.isBrackets(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isParenthesis(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isConjunction(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isDisjunction(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isDifference(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isAtomicPredicate(root, src, input);
        if (ret != null) {
            return ret;
        }
        throw new AssertionError((Object)("unexpected case for: " + root.content(src)));
    }

    private Predicate isConjunction(ParseNode root, List<LexerToken> src, String input) {
        ParseNode first = null;
        boolean legitimateOper = false;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = child;
                continue;
            }
            if (!legitimateOper) {
                if (child.contains(conj)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            Predicate lft = this.predicate(first, src, input);
            Predicate rgt = this.predicate(child, src, input);
            return new CompositeExpr(lft, rgt, Oper.CONJUNCTION);
        }
        return null;
    }

    private Predicate isDisjunction(ParseNode root, List<LexerToken> src, String input) {
        ParseNode first = null;
        boolean legitimateOper = false;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = child;
                continue;
            }
            if (!legitimateOper) {
                if (child.contains(disj)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            Predicate lft = this.predicate(first, src, input);
            Predicate rgt = this.predicate(child, src, input);
            return new CompositeExpr(lft, rgt, Oper.DISJUNCTION);
        }
        return null;
    }

    private Predicate isDifference(ParseNode root, List<LexerToken> src, String input) {
        ParseNode first = null;
        boolean isLegit = false;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = child;
                continue;
            }
            if (!isLegit) {
                if (child.contains(minus)) {
                    isLegit = true;
                    continue;
                }
                return null;
            }
            Predicate lft = this.predicate(first, src, input);
            Predicate rgt = this.predicate(child, src, input);
            return new CompositeExpr(lft, rgt, Oper.DIFFERENCE);
        }
        return null;
    }

    private Predicate isParenthesis(ParseNode root, List<LexerToken> src, String input) {
        boolean isOpenParen = false;
        for (ParseNode child : root.children()) {
            if (!isOpenParen) {
                if (child.contains(openPar)) {
                    isOpenParen = true;
                    continue;
                }
                return null;
            }
            if (isOpenParen && child.contains(predicate)) {
                return this.predicate(child, src, input);
            }
            return null;
        }
        return null;
    }

    private Predicate isBrackets(ParseNode root, List<LexerToken> src, String input) {
        boolean isOpenBr = false;
        for (ParseNode child : root.children()) {
            if (!isOpenBr) {
                if (child.contains(openBr)) {
                    isOpenBr = true;
                    continue;
                }
                return null;
            }
            if (isOpenBr) {
                if (child.contains(header)) {
                    return this.header(child, src, input);
                }
                if (!child.contains(closeBr)) continue;
                return new MaterializedPredicate(new ArrayList<String>(), src, "[]");
            }
            return null;
        }
        return null;
    }

    private Header header(ParseNode root, List<LexerToken> src, String input) {
        if (root.contains(attribute)) {
            ArrayList<String> hdr = new ArrayList<String>();
            hdr.add(root.content(src));
            return new Header(hdr);
        }
        Header ret = null;
        for (ParseNode child : root.children()) {
            if (ret == null) {
                ret = this.header(child, src, input);
                continue;
            }
            Header tmp = this.header(child, src, input);
            ret.attributes.addAll(tmp.attributes);
        }
        return ret;
    }

    private Predicate isAtomicPredicate(ParseNode root, List<LexerToken> src, String input) {
        Predicate ret = this.isExclamation(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isNodeContent(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isNodeMatchingSrc(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isSameNode(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isNodeAncestorDescendant(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isAggregate(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isBoolBindVar(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isJSFunc(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isChildNumRelation(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isPositionalRelation(root, src, input);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private Predicate isAggregate(ParseNode root, List<LexerToken> src, String input) {
        Boolean slash1 = null;
        Boolean slash2 = null;
        ParseNode attribute = null;
        boolean seenOpenParen = false;
        ParseNode p = null;
        for (ParseNode child : root.children()) {
            if (slash1 == null) {
                if (child.contains(slash)) {
                    slash1 = true;
                    continue;
                }
                if (child.contains(backslash)) {
                    slash1 = false;
                    continue;
                }
                return null;
            }
            if (slash2 == null) {
                if (child.contains(slash)) {
                    slash2 = true;
                    continue;
                }
                if (child.contains(backslash)) {
                    slash2 = false;
                    continue;
                }
                return null;
            }
            if (attribute == null) {
                attribute = child;
                continue;
            }
            if (!seenOpenParen) {
                if (child.contains(openPar)) {
                    seenOpenParen = true;
                    continue;
                }
                throw new AssertionError((Object)"Syntax error not caught by parsing?");
            }
            p = child;
            break;
        }
        Predicate predicate = this.predicate(p, src, input);
        return new AggregatePredicate(attribute.content(src), predicate, slash1, slash2);
    }

    private Predicate isExclamation(ParseNode root, List<LexerToken> src, String input) {
        boolean isExcl = false;
        for (ParseNode child : root.children()) {
            if (!isExcl) {
                if (child.contains(excl)) {
                    isExcl = true;
                    continue;
                }
                return null;
            }
            if (!isExcl) continue;
            return new CompositeExpr(this.predicate(child, src, input), null, Oper.NEGATION);
        }
        return null;
    }

    private Predicate isNodeContent(ParseNode root, List<LexerToken> src, String input) {
        boolean openBrace = false;
        String first = null;
        boolean legitimateOper = false;
        String second = null;
        for (ParseNode child : root.children()) {
            if (!openBrace) {
                if (child.contains(openBr)) {
                    openBrace = true;
                    continue;
                }
                return null;
            }
            if (first == null && child.contains(node)) {
                if (child.from + 1 == child.to || child.contains(node_parent) || child.contains(node_predecessor) || child.contains(node_successor) || child.contains(referenced_node)) {
                    first = child.content(src);
                    continue;
                }
                return null;
            }
            if (!legitimateOper) {
                if (child.contains(closePar)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            if (second == null) {
                second = child.content(src);
                continue;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        Integer symbol = (Integer)this.parser.symbolIndexes.get(second);
        if (symbol == null) {
            System.err.println("Symbol '" + second + "' not found");
            return new False();
        }
        return new NodeContent(first, symbol);
    }

    private Predicate isNodeMatchingSrc(ParseNode root, List<LexerToken> src, String input) {
        boolean legitimateAt1 = false;
        String first = null;
        boolean legitimateOper = false;
        boolean legitimateAt2 = false;
        String second = null;
        for (ParseNode child : root.children()) {
            if (!legitimateAt1) {
                if (child.contains(srcPtr)) {
                    legitimateAt1 = true;
                    continue;
                }
                return null;
            }
            if (first == null) {
                if (child.contains(node)) {
                    first = child.content(src);
                    continue;
                }
                return null;
            }
            if (!legitimateOper) {
                if (child.contains(eq)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            if (!legitimateAt2) {
                if (child.contains(srcPtr)) {
                    legitimateAt2 = true;
                    continue;
                }
                if (child.contains(string_literal)) {
                    return new NodeMatchingSrc(first, child.content(src), this.addWsDividers);
                }
                return null;
            }
            if (second == null) {
                if (child.contains(node)) {
                    second = child.content(src);
                    continue;
                }
                return null;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        return new NodesWMatchingSrc(first, second);
    }

    private Predicate isNodeAncestorDescendant(ParseNode root, List<LexerToken> src, String input) {
        AncestorDescendantNodes.Type type = AncestorDescendantNodes.Type.CLOSEST;
        Pair<String, String> p = this.binaryPredicateNames(root, src, lt);
        if (p == null) {
            p = this.binaryPredicateNames(root, src, lt, eq);
            type = AncestorDescendantNodes.Type.TRANSITIVE;
            if (p == null) {
                p = this.binaryPredicateNames(root, src, lt, lt);
                type = AncestorDescendantNodes.Type.TRANSITIVE;
                if (p == null) {
                    return null;
                }
            }
        }
        return new AncestorDescendantNodes(p.first(), p.second(), type);
    }

    private Predicate isSameNode(ParseNode root, List<LexerToken> src, String input) {
        Pair<String, String> p = this.binaryPredicateNames(root, src, eq);
        if (p == null) {
            return null;
        }
        return new SameNodes(p.first(), p.second());
    }

    public Pair<String, String> binaryPredicateNames(ParseNode root, List<LexerToken> src, int oper) throws AssertionError {
        return this.binaryPredicateNames(root, src, oper, -1);
    }

    public Pair<String, String> binaryPredicateNames(ParseNode root, List<LexerToken> src, int oper1, int oper2) throws AssertionError {
        String first = null;
        boolean legitimateOper1 = false;
        boolean legitimateOper2 = -1 == oper2;
        String second = null;
        for (ParseNode child : root.children()) {
            if (first == null) {
                if (child.contains(node)) {
                    first = child.content(src);
                    if (this.namedPredicates.containsKey(first)) {
                        throw new AssertionError((Object)("Error: " + first + " is a predicate, not predicate attribute within binary operation"));
                    }
                    continue;
                }
                return null;
            }
            if (!legitimateOper1) {
                if (child.contains(oper1)) {
                    legitimateOper1 = true;
                    continue;
                }
                return null;
            }
            if (!legitimateOper2) {
                if (child.contains(oper2)) {
                    legitimateOper2 = true;
                    continue;
                }
                return null;
            }
            if (second == null) {
                if (child.contains(node)) {
                    second = child.content(src);
                    if (this.namedPredicates.containsKey(second)) {
                        throw new AssertionError((Object)("Error: " + second + " is a predicate, not predicate attribute within binary operation"));
                    }
                    continue;
                }
                return null;
            }
            if (!child.contains(semicol)) {
                throw new AssertionError((Object)("unexpected case for: " + root.content(src)));
            }
        }
        return new Pair<Object, Object>(first, second);
    }

    private Predicate isPositionalRelation(ParseNode root, List<LexerToken> src, String input) {
        Position first = null;
        boolean isGT = false;
        boolean isReflexive = false;
        Position second = null;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = this.nodeRelativePosition(child, src, input);
                if (first != null) continue;
                return null;
            }
            if (child.contains(lt)) {
                isGT = true;
                continue;
            }
            if (child.contains(eq)) {
                isReflexive = true;
                continue;
            }
            if (second == null) {
                second = this.nodeRelativePosition(child, src, input);
                if (second != null) continue;
                return null;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        return new PositionalRelation(first, second, isReflexive, isGT, this);
    }

    private Position nodeRelativePosition(ParseNode root, List<LexerToken> src, String input) {
        String name = null;
        Position t = null;
        int num = -1;
        for (ParseNode child : root.children()) {
            if (name == null && child.contains(attribute) || t instanceof BindVar) {
                name = child.content(src);
                continue;
            }
            if (child.contains(digits)) {
                num = Integer.decode(child.content(src));
                if (t == null) continue;
                ((Composite)t).addendum = num;
                continue;
            }
            if (t != null) continue;
            if (child.contains(openBr)) {
                t = new Head(name);
                continue;
            }
            if (child.contains(closePar)) {
                t = new Tail(name);
                continue;
            }
            if (child.contains(col)) {
                t = new BindVar(name);
                continue;
            }
            if (child.contains(plus)) continue;
            if (child.contains(node_position)) {
                Position tmp = this.nodeRelativePosition(child, src, input);
                name = tmp.name;
                t = new Composite(tmp, num);
                continue;
            }
            throw new AssertionError();
        }
        if (name == null) {
            throw new AssertionError((Object)"name == null");
        }
        if (t == null) {
            throw new AssertionError((Object)"t == null");
        }
        t.setName(name);
        return t;
    }

    private Predicate isChildNumRelation(ParseNode root, List<LexerToken> src, String input) {
        Integer first = null;
        boolean isGT = false;
        boolean isReflexive = false;
        String second = null;
        for (ParseNode child : root.children()) {
            if (first == null) {
                try {
                    first = Integer.parseInt(src.get((int)child.from).content);
                }
                catch (Exception e) {
                    return null;
                }
                if (first != null) continue;
                return null;
            }
            if (child.contains(lt)) {
                isGT = true;
                continue;
            }
            if (child.contains(eq)) {
                isReflexive = true;
                continue;
            }
            if (child.contains(sharp)) continue;
            if (second == null) {
                second = src.get((int)child.from).content;
                if (second != null) continue;
                return null;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        return new ChildNumRelation(first, second, isReflexive, isGT, this);
    }

    public Boolean getBoolBindVar(String name) {
        try {
            Field field = this.struct.getClass().getField(name);
            if (field.getType() == Boolean.TYPE) {
                return field.getBoolean(this.struct);
            }
        }
        catch (NoSuchFieldException field) {
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)("field.getBoolean failed due to " + e.getMessage()));
        }
        try {
            Method method = this.struct.getClass().getMethod(name, new Class[0]);
            if (method.getReturnType() == Boolean.TYPE) {
                try {
                    return (boolean)((Boolean)method.invoke(this.struct, new Object[0]));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new AssertionError((Object)("method.invoke failed due to " + e.getMessage()));
                }
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        throw new AssertionError((Object)("_getBoolBindVar(" + name + ") failed"));
    }

    private Predicate isBoolBindVar(ParseNode root, List<LexerToken> src, String input) {
        if (!root.contains("bind_var")) {
            return null;
        }
        String name = src.get((int)(root.from + 1)).content;
        Boolean b = this.getBoolBindVar(name);
        if (b == null) {
            throw new AssertionError((Object)("Bind var '" + name + "' not found."));
        }
        if (b.booleanValue()) {
            return new True();
        }
        return new False();
    }

    private Set<String> listBindVariables(ParseNode root, List<LexerToken> src) {
        HashSet<String> ret = new HashSet<String>();
        if (root.contains("bind_var") && root.contains("atomic_predicate")) {
            ret.add(src.get((int)(root.from + 1)).content);
            return ret;
        }
        for (ParseNode child : root.children()) {
            ret.addAll(this.listBindVariables(child, src));
        }
        return ret;
    }

    private Predicate isJSFunc(ParseNode root, List<LexerToken> src, String input) {
        if (!root.contains("js_condition")) {
            return null;
        }
        String name = src.get((int)(root.from + 1)).content;
        return new JSFunc(name, this);
    }

    public Map<String, MaterializedPredicate> eval(Parsed target) {
        return this.eval(target, this.struct);
    }

    public Map<String, MaterializedPredicate> eval(Parsed target, Object action) {
        this.struct = action;
        HashMap<String, MaterializedPredicate> ret = new HashMap<String, MaterializedPredicate>();
        for (Program inc : this.included) {
            Map<String, MaterializedPredicate> includedPredicates = inc.eval(target, action);
            ret.putAll(includedPredicates);
            this.namedPredicates.putAll(includedPredicates);
        }
        ParseNode root = target.getRoot();
        if (timing) {
            System.out.println("tree depth =" + root.treeDepth());
            System.out.println("#tokens =" + target.getSrc().size());
        }
        long t1 = System.currentTimeMillis();
        for (String predVar : this.execOrder) {
            String oa;
            long t11 = System.currentTimeMillis();
            if (debug) {
                System.out.println(">=================================<     " + predVar);
            }
            MaterializedPredicate table = new MaterializedPredicate(predVar, this._eval(target, predVar));
            if (timing) {
                System.out.print(predVar + " eval time = " + (System.currentTimeMillis() - t11));
                System.out.println("       (cardinality=" + table.cardinality() + ")");
            }
            table.name = predVar;
            ret.put(predVar, table);
            this.namedPredicates.put(predVar, table);
            table.trimAttributes();
            if (debug) {
                System.out.println(predVar + "=" + table);
            }
            if (action == null || (oa = this.outputActions.get(predVar)) == null) continue;
            long t2 = System.currentTimeMillis();
            if (javaCallbackCode.equals(oa)) {
                this.javaCallback(target, action, ret, predVar);
            } else {
                this.jsCallback(target, ret, predVar, oa);
            }
            if (!debug && !timing) continue;
            System.out.println("callback time = " + (System.currentTimeMillis() - t2));
        }
        if (action != null && this.outputActions.size() == 0 && !(action instanceof String)) {
            throw new AssertionError((Object)"Did you forget to mark output relations?");
        }
        this.namedPredicates = new HashMap<String, Predicate>();
        for (String key : this.compiledInstance.namedPredicates.keySet()) {
            this.namedPredicates.put(key, this.compiledInstance.namedPredicates.get(key).copy(this));
        }
        long t2 = System.currentTimeMillis();
        if (debug || timing) {
            System.out.println("eval time = " + (t2 - t1));
        }
        return ret;
    }

    protected ScriptEngine getEngine() {
        if (this.engine == null) {
            this.engine = new ScriptEngineManager().getEngineByName("nashorn");
        }
        return this.engine;
    }

    protected GlobalMap getGlobals() {
        if (this.globals == null) {
            this.globals = new GlobalMap(this.getEngine().createBindings());
        }
        return this.globals;
    }

    private void jsCallback(Parsed target, Map<String, MaterializedPredicate> ret, String predVar, String oa) {
        GlobalMap _globals = this.getGlobals();
        if (_globals == null) {
            return;
        }
        MaterializedPredicate mp = ret.get(predVar);
        for (Tuple t : mp.tuples) {
            HashMap<String, ParseNode> tuple = new HashMap<String, ParseNode>();
            for (int j = 0; j < mp.arity(); ++j) {
                String colName = mp.getAttribute(j);
                ParseNode node = mp.getAttribute(t, colName);
                tuple.put(colName, node);
            }
            try {
                _globals.put("target", (Object)target);
                _globals.put("tuple", (Object)tuple);
                _globals.put("struct", this.struct);
                _globals.put("program", (Object)this);
                this.getEngine().setBindings(_globals, 100);
                this.getEngine().eval(oa, (Bindings)_globals);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void javaCallback(Parsed target, Object action, Map<String, MaterializedPredicate> ret, String predVar) {
        if (debug) {
            System.out.println("-------->>>   " + predVar);
        }
        Class<?> c = action.getClass();
        try {
            Method callback = null;
            try {
                callback = c.getDeclaredMethod(predVar, Parsed.class, Map.class);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                callback = c.getMethod(predVar, Parsed.class, Map.class);
            }
            callback.setAccessible(true);
            MaterializedPredicate mp = ret.get(predVar);
            for (Tuple t : mp.tuples) {
                HashMap<String, ParseNode> tuple = new HashMap<String, ParseNode>();
                for (int j = 0; j < mp.arity(); ++j) {
                    String colName = mp.getAttribute(j);
                    ParseNode node = mp.getAttribute(t, colName);
                    tuple.put(colName, node);
                }
                callback.invoke(action, target, tuple);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.err.println(predVar + " callback: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private MaterializedPredicate _eval(Parsed target, String predVar) {
        Predicate evaluatedPredicate = this.namedPredicates.get(predVar);
        MaterializedPredicate ret = evaluatedPredicate.eval(target);
        if (ret != null) {
            return ret;
        }
        AttributeDefinitions varDefs = new AttributeDefinitions(predVar, this.namedPredicates);
        varDefs.evalDimensions(target, false);
        boolean firstTime = true;
        if (debug) {
            for (String string : varDefs.listDimensions()) {
                System.out.print(" " + string);
            }
            System.out.println();
            System.out.print("Eval space = ");
            for (String string : varDefs.listDimensions()) {
                System.out.print((firstTime ? "" : "x") + varDefs.getDimensionContent(string).cardinality());
                firstTime = false;
            }
            System.out.println();
        }
        firstTime = true;
        String firstDimension = null;
        for (String dim : varDefs.listDimensions()) {
            if (firstDimension != null && varDefs.getDimensionContent(dim).cardinality() >= varDefs.getDimensionContent(firstDimension).cardinality()) continue;
            firstDimension = dim;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(firstDimension);
        Attribute firstAttr = (Attribute)varDefs.get(firstDimension);
        ret = ((IndependentAttribute)firstAttr).getContent();
        while (hashSet.size() < varDefs.listDimensions().size()) {
            String current = varDefs.minimalRelatedDimension(hashSet, ret.cardinality());
            if (current == null) {
                throw new AssertionError((Object)("Cartesian product evaluation: failed to find attribute joined to " + hashSet + ".\n Independent Attributes: " + varDefs.listDimensions()));
            }
            hashSet.add(current);
            Attribute second = (Attribute)varDefs.get(current);
            MaterializedPredicate pred2 = ((IndependentAttribute)second).getContent();
            Predicate filter = new True();
            if (hashSet.size() != varDefs.listDimensions().size()) {
                for (String a : ret.attributes) {
                    if (ret.name != null) {
                        a = ret.name + "." + a;
                    }
                    for (String b : pred2.attributes) {
                        Predicate rel;
                        if (pred2.name != null) {
                            b = pred2.name + "." + b;
                        }
                        if ((rel = evaluatedPredicate.isRelated(a, b, varDefs)) == null) continue;
                        if (filter instanceof True) {
                            filter = rel;
                            continue;
                        }
                        if (filter == rel) continue;
                        filter = new CompositeExpr(filter, rel, Oper.CONJUNCTION);
                    }
                }
                if (filter instanceof True && 1 < varDefs.getDimensionContent(current).cardinality() && 1 < ret.cardinality()) {
                    throw new AssertionError((Object)"Cartesian product evaluation; check for missing binary predicates");
                }
            } else {
                filter = evaluatedPredicate;
            }
            ret = MaterializedPredicate.filteredCartesianProduct(ret, pred2, filter, varDefs, target.getRoot());
            if (!debug) continue;
            System.out.println("dim#" + hashSet.size() + ",cardinality=" + ret.cardinality());
        }
        ret = MaterializedPredicate.filter(ret, evaluatedPredicate, varDefs, target.getRoot());
        if (hashSet.size() == varDefs.listDimensions().size()) {
            return ret;
        }
        throw new AssertionError((Object)("Missing dyadic predicate in predvar " + predVar + "; won't evaluate cartesian product"));
    }
}

