/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.data.loadservice.LoadResources;
import oracle.dbtools.data.loadservice.LoadService;
import oracle.dbtools.data.loadservice.LoadServicesRegistry;
import oracle.dbtools.data.readservice.ReadParmsAPI;
import oracle.dbtools.data.readservice.ReadParmsDelimitedAPI;

public class LoadAPI {
    private static final Logger LOGGER = Logger.getLogger(LoadAPI.class.getName());
    private Connection _conn;
    private String _schemaName;
    private String _tableName;
    private InputStream _input;
    private OutputStream _response;
    private LoadParmsAPI _loadParms;
    private ReadParmsAPI _readParms;
    private final Logger _logger;
    private LoadService _service = null;

    private LoadAPI(Builder builder) {
        this._conn = builder._conn;
        this._schemaName = builder._schemaName;
        this._tableName = builder._tableName;
        this._input = builder._input;
        this._response = builder._response;
        this._loadParms = builder._loadParms;
        this._readParms = builder._readParms;
        this._logger = builder._logger != null ? builder._logger : LOGGER;
        this.validateParm(Parms.CONNECTION, this._conn);
        this.validateParm(Parms.TABLE_NAME, this._tableName);
        this.validateParm(Parms.INPUT_STREAM, this._input);
        this.validateParm(Parms.RESPONSE_STREAM, this._response);
        if (this._readParms == null) {
            this._readParms = new ReadParmsDelimitedAPI.Builder().build();
        }
        if (this._loadParms == null) {
            this._loadParms = new LoadParmsAPI.Builder(LoadParmsAPI.SERVICE_METHOD.JDBC_BATCH).build();
        }
        if (LoadServicesRegistry.isServiceRegistered(this._loadParms.getMethod().toString())) {
            this._service = LoadServicesRegistry.getService(this._loadParms.getMethod().toString());
            ExitCode exitCode = this._service.start(this._conn, this._schemaName, this._tableName, this._input, this._response, this._loadParms, this._readParms, this._logger);
            if (exitCode == ExitCode.EXIT_SEVERE) {
                String msg = LoadResources.getString("LOAD_START_ERROR");
                this._logger.log(Level.SEVERE, msg);
                throw new IllegalStateException(msg);
            }
        } else {
            String msg = LoadResources.format("INVALID_LOAD_PARM", Parms.LOAD_PARMS.toString()) + " " + LoadResources.getString("LOAD_START_ERROR");
            this._logger.log(Level.SEVERE, msg);
            throw new IllegalStateException(msg);
        }
    }

    private void validateParm(Enum<Parms> parm, Object parmValue) {
        if (parmValue == null || parmValue instanceof String && ((String)parmValue).length() == 0) {
            String msg = LoadResources.format("INVALID_LOAD_PARM", parm.toString()) + " " + LoadResources.getString("LOAD_START_ERROR");
            this._logger.log(Level.SEVERE, msg);
            throw new IllegalStateException(msg);
        }
    }

    public ExitCode load() {
        return this._service != null ? this._service.load() : ExitCode.EXIT_SEVERE;
    }

    public static class Builder {
        private Connection _conn;
        private String _schemaName;
        private String _tableName;
        private InputStream _input;
        private OutputStream _response;
        private LoadParmsAPI _loadParms;
        private ReadParmsAPI _readParms;
        private Logger _logger;

        public Builder(Connection conn, String schemaName, String tableName, InputStream input, OutputStream response) {
            this._conn = conn;
            this._schemaName = schemaName;
            this._tableName = tableName;
            this._input = input;
            this._response = response;
        }

        public Builder loadParms(LoadParmsAPI loadParms) {
            this._loadParms = loadParms;
            return this;
        }

        public Builder readParms(ReadParmsAPI readParms) {
            this._readParms = readParms;
            return this;
        }

        public Builder logger(Logger logger) {
            this._logger = logger;
            return this;
        }

        public LoadAPI build() {
            return new LoadAPI(this);
        }
    }

    private static enum Parms {
        CONNECTION,
        SCHEMA_NAME,
        TABLE_NAME,
        INPUT_STREAM,
        RESPONSE_STREAM,
        LOAD_PARMS,
        READER_PARMS,
        LOGGER;

    }
}

