/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Properties;

public class ConnectionDetails {
    private String _type = null;
    private String _url = null;
    private String _driver = null;
    private Connection _conn = null;
    private Properties _properties = new Properties();
    private static HashMap<String, String> _typeDriverMap = new HashMap();

    public ConnectionDetails(String url) {
        ConnectionDetails.registerDriver("jdbc:jtds:sqlserver", "net.sourceforge.jtds.jdbc.Driver");
        ConnectionDetails.registerDriver("jdbc:jtds:sybase", "net.sourceforge.jtds.jdbc.Driver");
        ConnectionDetails.registerDriver("jdbc:as400:", "com.ibm.db2.jcc.DB2Driver");
        ConnectionDetails.registerDriver("jdbc:db2:", "com.ibm.db2.jcc.DB2Driver");
        ConnectionDetails.registerDriver("jdbc:informix", "com.ibm.informix.Driver");
        ConnectionDetails.registerDriver("jdbc:mysql:", "com.mysql.jdbc.Driver");
        ConnectionDetails.registerDriver("jdbc:postgresql:", "org.postgresql.Driver");
        ConnectionDetails.registerDriver("jdbc:teradata:", "com.teradata.jdbc.TeraDriver");
        ConnectionDetails.registerDriver("jdbc:oracle:thin:", "oracle.jdbc.OracleDriver");
        ConnectionDetails.registerDriver("jdbc:redshift:", "com.amazon.redshift.jdbc.Driver");
        ConnectionDetails.registerDriver("jdbc:oracle:orest:", "oracle.dbtools.jdbc.orest.Driver");
        ConnectionDetails.registerDriver("http:", "oracle.dbtools.jdbc.Driver");
        ConnectionDetails.registerDriver("https:", "oracle.dbtools.jdbc.Driver");
        this.setUrl(url);
        for (String type : _typeDriverMap.keySet()) {
            if (!this.getUrl().startsWith(type)) continue;
            this.setType(type);
            this.setDriver(_typeDriverMap.get(type));
            break;
        }
    }

    private static void registerDriver(String type, String driver) {
        _typeDriverMap.put(type, driver);
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        if (url.startsWith("[")) {
            url = this.processURL(url);
        }
        this._url = url = this.resolveHashAmpersand(url);
    }

    private String processURL(String url) {
        int endIndex = url.indexOf("]");
        String argStr = url.substring(1, endIndex);
        this.processArgs(argStr);
        url = url.substring(endIndex + 1);
        return url;
    }

    private void processArgs(String argStr) {
        String[] args;
        for (String arg : args = argStr.split(",")) {
            String[] argItems = arg.split("=");
            if (argItems.length <= 1) continue;
            this._properties.put(argItems[0], argItems[1]);
        }
    }

    private String resolveHashAmpersand(String url) {
        return url.replace('#', '&');
    }

    public String getDriver() {
        return this._driver;
    }

    public void setDriver(String driver) {
        this._driver = driver;
    }

    public Connection getConn() {
        if (this._conn == null) {
            try {
                Class<?> drivercls = Class.forName(this.getDriver());
                Driver driver = (Driver)drivercls.newInstance();
                DriverManager.registerDriver(driver);
                this._conn = this._properties.size() == 2 && this._properties.containsKey("USERNAME") && this._properties.containsKey("PASSWORD") ? DriverManager.getConnection(this.getUrl(), this._properties.getProperty("USERNAME"), this._properties.getProperty("PASSWORD")) : (this._properties.size() > 0 ? DriverManager.getConnection(this.getUrl(), this._properties) : DriverManager.getConnection(this.getUrl()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._conn;
    }

    public void setConn(Connection conn) {
        this._conn = conn;
    }
}

