/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.TreeMap;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.util.Service;

public class Substitutions {
    private String input;
    private Parsed target;
    protected TreeMap<Long, String> substitutions = new TreeMap();

    public Substitutions(String input) {
        this.input = input;
    }

    public Substitutions(Parsed target) {
        this.target = target;
        this.input = target.getInput();
    }

    public void put(int X, int Y, String replacement) {
        for (long candidate : this.substitutions.keySet()) {
            if ((X != Service.lX(candidate) || Service.lY(candidate) != Y) && (X <= Service.lX(candidate) && Service.lX(candidate) < Y || X < Service.lY(candidate) && Service.lY(candidate) <= Y)) {
                throw new AssertionError((Object)("[" + Service.lX(candidate) + "," + Service.lY(candidate) + ") overlaps with [" + X + "," + Y + ")"));
            }
        }
        this.substitutions.put(Service.lPair(X, Y), replacement);
    }

    public String get(int X, int Y) {
        return this.substitutions.get(Service.lPair(X, Y));
    }

    public void replace(int X, int Y, String replacement) {
        this.put(X, Y, replacement);
    }

    public String get(ParseNode node) {
        return this.get(this.target.getSrc().get((int)node.from).begin, this.target.getSrc().get((int)(node.to - 1)).end);
    }

    public void put(ParseNode node, String replacement, String annotation) {
        String was = this.input.substring(this.target.getSrc().get((int)node.from).begin, this.target.getSrc().get((int)(node.to - 1)).end);
        String comment = "";
        if (annotation != null && !"".equals(annotation)) {
            comment = "/*" + annotation + was + " */";
        }
        this.put(this.target.getSrc().get((int)node.from).begin, this.target.getSrc().get((int)(node.to - 1)).end, replacement + comment);
    }

    public void put(ParseNode node, String replacement) {
        this.put(node, replacement, "");
    }

    public void putWcomment(ParseNode node, String replacement) {
        this.put(node, replacement, "was:");
    }

    public void delete(ParseNode node) {
        this.put(node, "", "");
    }

    public void deleteWcomment(ParseNode node) {
        this.put(node, "", "deleted: ");
    }

    public void append(ParseNode node, String appendix) {
        this.put(node, "/*added:*/" + appendix);
    }

    public void replace(ParseNode node, String replacement) {
        this.put(node, replacement);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        int lastPos = 0;
        for (long key : this.substitutions.keySet()) {
            int begin = Service.lX(key);
            int end = Service.lY(key);
            if (lastPos < begin) {
                ret.append(this.input.substring(lastPos, begin));
            }
            ret.append("\n---\n");
            ret.append(this.input.substring(begin, end));
            ret.append("\n--->>>\n");
            ret.append(this.substitutions.get(key));
            ret.append("\n---\n");
            lastPos = end;
        }
        ret.append(this.input.substring(lastPos));
        return ret.toString();
    }

    public String transformInput() {
        StringBuilder ret = new StringBuilder();
        int lastPos = 0;
        for (long key : this.substitutions.keySet()) {
            int begin = Service.lX(key);
            int end = Service.lY(key);
            if (lastPos < begin) {
                ret.append(this.input.substring(lastPos, begin));
            }
            ret.append(this.substitutions.get(key));
            lastPos = end;
        }
        ret.append(this.input.substring(lastPos));
        return ret.toString();
    }

    public boolean equals(Object obj) {
        String match;
        Substitutions cmp = (Substitutions)obj;
        for (Long key : this.substitutions.keySet()) {
            match = cmp.substitutions.get(key);
            if (match == null) {
                return false;
            }
            if (!match.equals(this.substitutions.get(key))) continue;
            return false;
        }
        for (Long key : cmp.substitutions.keySet()) {
            match = this.substitutions.get(key);
            if (match != null) continue;
            return false;
        }
        return true;
    }

    public String diff(Object obj) {
        String match;
        Substitutions cmp = (Substitutions)obj;
        for (Long key : this.substitutions.keySet()) {
            match = cmp.substitutions.get(key);
            if (match == null) {
                return "no match for " + Service.lX(key) + "," + Service.lY(key) + " `" + this.substitutions.get(key) + "`";
            }
            if (!match.equals(this.substitutions.get(key))) continue;
            return "" + Service.lX(key) + "," + Service.lY(key) + " `" + this.substitutions.get(key) + "` != `" + match + "`";
        }
        for (Long key : cmp.substitutions.keySet()) {
            match = this.substitutions.get(key);
            if (match != null) continue;
            return "no match for " + Service.lX(key) + "," + Service.lY(key) + " `" + cmp.substitutions.get(key) + "`";
        }
        return "=";
    }

    public String[] lines() {
        String[] ret = new String[this.substitutions.size()];
        int pos = -1;
        for (long key : this.substitutions.keySet()) {
            ret[++pos] = "" + Service.lX(key) + "," + Service.lY(key) + " `" + this.substitutions.get(key) + "`";
        }
        return ret;
    }

    public static void main(String[] args) {
        Substitutions repl = new Substitutions("0123456789012345");
        repl.put(1, 2, "[1,2)");
        repl.put(11, 12, "[11,12)");
        System.out.println("**** repl.toString():");
        System.out.println(repl.toString());
        System.out.println("**** repl.transformInput():");
        System.out.println(repl.transformInput());
    }
}

