/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.io.IOException;
import java.util.List;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class TreeBuilder {
    private Matrix matrix;
    private Earley parser;

    public TreeBuilder(Matrix matrix, Earley parser) {
        this.matrix = matrix;
        this.parser = parser;
    }

    public ParseNode build() {
        ParseNode root;
        Cell cell = this.matrix.get(0, this.matrix.lastY());
        if (cell != null && 0 < cell.size() && (root = this.treeForACell(cell, 0, this.matrix.lastY())) != null) {
            int payload = root.content()[0];
            this.deriveDependents(cell, root, payload);
            return root;
        }
        throw new AssertionError((Object)"TODO");
    }

    private void deriveDependents(Cell cell, ParseNode root, int symbol) {
        for (int i = 0; i < cell.size(); ++i) {
            int pos = cell.getPosition(i);
            if (pos != 1) continue;
            int rule = cell.getRule(i);
            Parser.Tuple tuple = this.parser.rules[rule];
            if (pos != tuple.rhs.length || tuple.rhs[0] != symbol) continue;
            root.addContent(tuple.head);
            this.deriveDependents(cell, root, tuple.head);
        }
    }

    private ParseNode treeForACell(Cell cellXY, int x, int y) {
        for (int i = 0; i < cellXY.size(); ++i) {
            ParseNode ret;
            int rule = cellXY.getRule(i);
            int pos = cellXY.getPosition(i);
            Parser.Tuple tuple = this.parser.rules[rule];
            if (pos != tuple.rhs.length || (ret = this.treeForACell(cellXY, x, y, tuple, pos)) == null) continue;
            ret.addContent(tuple.head);
            ret.deleteContent(-1);
            return ret;
        }
        return null;
    }

    private ParseNode treeForACell(Cell cellXY, int x, int y, Parser.Tuple tuple, int pos) {
        String symbol;
        ParseNode ret;
        if (pos == 1) {
            for (int i = 0; i < cellXY.size(); ++i) {
                int r = cellXY.getRule(i);
                int p = cellXY.getPosition(i);
                Parser.Tuple t = this.parser.rules[r];
                if (p != t.rhs.length || tuple.rhs[0] != t.head || (ret = this.treeForACell(cellXY, x, y, t, p)) == null) continue;
                ret.addContent(t.head);
                ret.addContent(tuple.head);
                ret.deleteContent(-1);
                return ret;
            }
        }
        if (0 < pos && ((symbol = this.parser.allSymbols[tuple.rhs[pos - 1]]).charAt(0) == '\'' || "identifier".equals(symbol) || "digits".equals(symbol) || "string_literal".equals(symbol))) {
            if (x + 1 == y) {
                return new ParseNode(x, y, tuple.rhs[pos - 1], this.parser);
            }
            Cell cell1 = this.matrix.get(x, y - 1);
            ParseNode node1 = this.treeForACell(cell1, x, y - 1, tuple, pos - 1);
            if (node1 != null) {
                ParseNode node2 = new ParseNode(y - 1, y, tuple.rhs[pos - 1], this.parser);
                ret = new ParseNode(x, y, -1, this.parser);
                ret.lft = node1;
                ret.lft.parent = ret;
                ret.rgt = node2;
                ret.rgt.parent = ret;
                return ret;
            }
        }
        if (tuple.rhs.length == 1 && pos == 1) {
            return null;
        }
        int mid = (y + x) / 2;
        int incr = 0;
        while (mid + incr < y || x <= mid - incr - 1) {
            ParseNode root;
            int split = mid + incr;
            if (split == x) {
                throw new AssertionError((Object)"split == x");
            }
            if (split == y) {
                throw new AssertionError((Object)"split == y");
            }
            if (split < y && (root = this.treeForACell(x, y, split, tuple, pos)) != null) {
                return root;
            }
            split = mid - incr - 1;
            if (x <= split && (root = this.treeForACell(x, y, split, tuple, pos)) != null) {
                return root;
            }
            ++incr;
        }
        return null;
    }

    private ParseNode treeForACell(int x, int y, int mid, Parser.Tuple tuple, int pos) {
        Cell pre = this.matrix.get(x, mid);
        Cell post = this.matrix.get(mid, y);
        if (post != null && pre != null) {
            for (int i = 0; i < pre.size(); ++i) {
                ParseNode lft;
                Parser.Tuple tPre;
                int rulePre = pre.getRule(i);
                int posPre = pre.getPosition(i);
                if (pos != posPre + 1 || (tPre = this.parser.rules[rulePre]) != tuple || (lft = this.treeForACell(pre, x, mid, tuple, pos - 1)) == null) continue;
                for (int j = 0; j < post.size(); ++j) {
                    ParseNode rgt;
                    int rulePost = post.getRule(j);
                    int posPost = post.getPosition(j);
                    Parser.Tuple tPost = this.parser.rules[rulePost];
                    if (posPost != tPost.rhs.length || tuple.rhs[posPre] != tPost.head || (rgt = this.treeForACell(post, mid, y, tPost, posPost)) == null) continue;
                    int head = -1;
                    if (tuple.rhs.length == pos) {
                        head = tuple.head;
                    }
                    ParseNode ret = new ParseNode(x, y, head, this.parser);
                    ret.lft = lft;
                    ret.lft.parent = ret;
                    ret.rgt = rgt;
                    ret.rgt.parent = ret;
                    return ret;
                }
            }
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        String file = "test.sql";
        String input = Service.readFile(SqlEarley.class, file);
        SqlEarley earley = SqlEarley.getInstance();
        List<LexerToken> src = Lexer.parse(input);
        Matrix matrix = new Matrix(earley);
        if (src.size() < 1000) {
            matrix.visual = new Visual(src, earley);
        }
        earley.parse(src, matrix);
        TreeBuilder builder = new TreeBuilder(matrix, earley);
        long t1 = System.currentTimeMillis();
        ParseNode root = builder.build();
        long t2 = System.currentTimeMillis();
        System.out.println("Build tree time = " + (t2 - t1));
        if (src.size() < 1000) {
            root.printTree();
        }
    }
}

