/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Scrollable;
import javax.swing.text.html.HTMLEditorKit;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.util.Service;

public class Visual
implements ActionListener {
    public long[][] visited = null;
    List<LexerToken> src;
    Parser par;
    private int zoom = 1;
    private int offset = 0;
    public Map<Long, Integer> causes;
    int X;
    int Y;
    BufferedImage img;
    Matriceable matrix;
    JLabel matrixImage = null;
    private int pixels = 1900;
    private JRadioButton yes = new JRadioButton("Yes");
    private JRadioButton no = new JRadioButton("No");

    public Visual(List<LexerToken> s, Parser c) {
        this.causes = new HashMap<Long, Integer>();
        this.src = s;
        this.visited = new long[this.src.size() + 1][this.src.size() + 1];
        this.par = c;
        if (this.src.size() < 30) {
            this.pixels = 1000;
        }
        this.zoom = 1 + this.pixels / this.src.size();
        this.offset = this.zoom / 2;
        if (this.zoom == 1) {
            this.offset = 0;
        }
        int size = this.src.size();
        this.X = (size + 1) * this.zoom;
        this.Y = (size + 1) * this.zoom;
    }

    public void draw() {
        this.matrix.getVisual().draw(this.matrix);
    }

    public void draw(Matriceable m) {
        this.img = this.drawMatrix(m);
        JFrame frame = new JFrame(this.par.getClass().getSimpleName() + " Matrix");
        try {
            frame.setDefaultCloseOperation(3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JEditorPane t = new JEditorPane();
        t.setEditorKit(new HTMLEditorKit());
        JScrollPane editorScrollPane = new JScrollPane(t);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(1000, this.pixels + 150));
        editorScrollPane.setMinimumSize(new Dimension(100, 100));
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        ButtonGroup optimGroup = new ButtonGroup();
        optimGroup.add(this.yes);
        optimGroup.add(this.no);
        radioPanel.add(new JLabel("Optim: "));
        radioPanel.add(this.yes);
        radioPanel.add(this.no);
        this.yes.addActionListener(this);
        this.no.addActionListener(this);
        JPanel matrixPanel = new JPanel(new BorderLayout());
        class ScrollablePicture
        extends JLabel
        implements Scrollable,
        MouseMotionListener,
        MouseWheelListener {
            int x0;
            int y0;
            Cell output;
            int index;
            int ambig;

            public ScrollablePicture() {
                super(new Icon(){

                    @Override
                    public int getIconHeight() {
                        return Visual.this.Y;
                    }

                    @Override
                    public int getIconWidth() {
                        return Visual.this.X;
                    }

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        g.drawImage(Visual.this.img, 0, 0, Color.orange, null);
                        Visual.this.drawSrcText(g);
                    }
                });
                this.x0 = -1;
                this.y0 = -1;
                this.output = null;
                this.index = 0;
                this.ambig = 0;
                this.setAutoscrolls(true);
                this.addMouseMotionListener(this);
                this.addMouseWheelListener(this);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Rectangle r = new Rectangle(e.getX(), e.getY(), 10, 10);
                this.scrollRectToVisible(r);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                e.consume();
                int x = e.getX() / Visual.this.zoom;
                int y = e.getY() / Visual.this.zoom;
                if (x > Visual.this.src.size()) {
                    return;
                }
                if (y > Visual.this.src.size()) {
                    return;
                }
                if (x != this.x0 || y != this.y0) {
                    this.index = 0;
                    this.ambig = 0;
                }
                this.output = Visual.this.matrix.get(x, y);
                if (this.output != null) {
                    this.x0 = x;
                    this.y0 = y;
                    this.updatePane(t);
                    this.repaint();
                } else if (this.x0 != -1) {
                    this.repaint();
                    this.x0 = -1;
                    this.y0 = -1;
                }
                String tooltip = "<html><font color=rgb(150,100,100) size=+2>[" + x + "," + y + ")</font>";
                if (Visual.this.visited != null) {
                    int completeTime = Service.lY(Visual.this.visited[x][y]);
                    int otherTime = Service.lX(Visual.this.visited[x][y]);
                    tooltip = tooltip + " time = <font color=rgb(100,150,100) size=+2> " + (completeTime + otherTime);
                    tooltip = tooltip + "</font> = <font color=rgb(150,100,100) size=+1> " + completeTime;
                    tooltip = tooltip + "</font> (completetion) + <font color=rgb(100,100,150)  size=+1> " + otherTime;
                }
                this.setToolTipText(tooltip);
            }

            private void updatePane(JEditorPane t2) {
                StringBuffer sb = new StringBuffer("<html><font color=red size=+1>[" + this.x0 + "," + this.y0 + ")</font><br>");
                this.updatePane4Earley(sb);
                sb.append("<font color=green  size=+1><br><br>");
                for (int i = this.x0; i < this.y0; ++i) {
                    sb.append(" " + Visual.this.src.get((int)i).content);
                }
                t2.setText(sb.toString());
            }

            public void updatePane4Earley(StringBuffer sb) {
                for (int j = 0; j < this.output.size(); ++j) {
                    int pos = this.output.getPosition(j);
                    int ruleNo = this.output.getRule(j);
                    int mid = -1;
                    if (j == this.index) {
                        mid = Visual.this.matrix.getEarleyBackptrs(this.x0, this.y0, this.output, j).get(this.ambig);
                    }
                    sb.append("<br>");
                    Visual.this.par.toHtml(ruleNo, pos, j == this.index, this.x0, mid, this.y0, Visual.this.matrix, sb);
                }
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return null;
            }

            @Override
            public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
                return 0;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return false;
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                return 0;
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (this.x0 != -1 && Visual.this.par instanceof Earley && this.x0 <= this.y0 && this.index < this.output.size()) {
                    g.setColor(Color.red);
                    int mid = -1;
                    mid = Visual.this.matrix.getEarleyBackptrs(this.x0, this.y0, this.output, this.index).get(this.ambig);
                    if (this.y0 < mid) {
                        g.drawLine(this.x0 * Visual.this.zoom + Visual.this.offset, (this.y0 - 1) * Visual.this.zoom + Visual.this.offset, this.x0 * Visual.this.zoom + Visual.this.offset, this.y0 * Visual.this.zoom + Visual.this.offset);
                        return;
                    }
                    if (this.x0 <= mid) {
                        g.drawLine(this.x0 * Visual.this.zoom + Visual.this.offset, mid * Visual.this.zoom + Visual.this.offset, this.x0 * Visual.this.zoom + Visual.this.offset, this.y0 * Visual.this.zoom + Visual.this.offset);
                    }
                    g.drawLine(this.x0 * Visual.this.zoom + Visual.this.offset, this.y0 * Visual.this.zoom + Visual.this.offset, mid * Visual.this.zoom + Visual.this.offset, this.y0 * Visual.this.zoom + Visual.this.offset);
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (this.output == null) {
                    return;
                }
                int ambiguityFactor = -1;
                ambiguityFactor = Visual.this.matrix.getEarleyBackptrs(this.x0, this.y0, this.output, this.index).size();
                if (0 <= this.ambig + e.getWheelRotation() && this.ambig + e.getWheelRotation() < ambiguityFactor) {
                    this.ambig += e.getWheelRotation();
                } else {
                    this.ambig = 0;
                    this.index += e.getWheelRotation() > 0 ? 1 : -1;
                    if (this.index < 0) {
                        this.index = this.output.size() + this.index;
                    }
                    if (this.index >= this.output.size()) {
                        this.index -= this.output.size();
                    }
                }
                this.repaint();
                this.updatePane(t);
            }
        }
        this.matrixImage = new ScrollablePicture();
        matrixPanel.add((Component)this.matrixImage, "Center");
        matrixPanel.add((Component)radioPanel, "East");
        JScrollPane canvasScrollPane = new JScrollPane(matrixPanel);
        canvasScrollPane.setVerticalScrollBarPolicy(20);
        canvasScrollPane.setHorizontalScrollBarPolicy(30);
        canvasScrollPane.setPreferredSize(new Dimension(this.pixels + 200, this.pixels + 100));
        canvasScrollPane.setMinimumSize(new Dimension(300, 300));
        JSplitPane sp = new JSplitPane(1);
        sp.add(canvasScrollPane);
        sp.add(editorScrollPane);
        frame.getContentPane().add(sp);
        frame.pack();
        frame.setVisible(true);
    }

    private BufferedImage drawMatrix(Matriceable matrix) {
        this.matrix = matrix;
        byte[] pixels = new byte[this.X * this.Y + 1];
        for (int j = 0; j < this.Y; ++j) {
            for (int i = 0; i <= this.X; ++i) {
                int otherTime;
                int completeTime;
                int z = j * this.X + i;
                Cell tmp = matrix.get(i / this.zoom, j / this.zoom);
                if (tmp != null) {
                    completeTime = Service.lY(this.visited[i / this.zoom][j / this.zoom]);
                    otherTime = Service.lX(this.visited[i / this.zoom][j / this.zoom]);
                    pixels[z] = 13;
                    if (completeTime + otherTime < 10000) {
                        pixels[z] = 14;
                    }
                    if (100000 < completeTime + otherTime) {
                        pixels[z] = 0;
                    }
                    if (1000000 >= completeTime + otherTime) continue;
                    pixels[z] = 7;
                    continue;
                }
                if (j < i || this.visited != null && this.visited[i / this.zoom][j / this.zoom] == 0L || this.visited == null) {
                    pixels[z] = 1;
                    continue;
                }
                pixels[z] = 4;
                if (this.visited == null || 5000 >= (completeTime = Service.lY(this.visited[i / this.zoom][j / this.zoom])) + (otherTime = Service.lX(this.visited[i / this.zoom][j / this.zoom]))) continue;
                pixels[z] = 3;
            }
        }
        DataBufferByte dbuf = new DataBufferByte(pixels, this.X * this.Y, 0);
        int numBanks = dbuf.getNumBanks();
        int[] bitMasks = new int[]{15};
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(0, this.X, this.Y, bitMasks);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dbuf, null);
        ColorModel colorModel = Visual.generateColorModel();
        BufferedImage img = new BufferedImage(colorModel, raster, false, null);
        return img;
    }

    private void drawSrcText(Graphics g) {
        if (this.zoom < 5) {
            return;
        }
        int pos = -1;
        for (LexerToken t : this.src) {
            ++pos;
            if (50 < this.zoom) {
                g.setFont(new Font("SansSerif", 1, 20));
            }
            g.setColor(Color.WHITE);
            g.drawString(t.content, pos * this.zoom + 2 * this.zoom / 3, (pos + 1) * this.zoom + 2 * this.zoom / 3);
        }
    }

    private static ColorModel generateColorModel() {
        byte[] r = new byte[16];
        byte[] g = new byte[16];
        byte[] b = new byte[16];
        r[0] = 0;
        g[0] = 0;
        b[0] = 0;
        r[1] = 0;
        g[1] = 0;
        b[1] = -64;
        r[2] = 0;
        g[2] = 0;
        b[2] = -1;
        r[3] = 0;
        g[3] = -64;
        b[3] = 0;
        r[4] = 0;
        g[4] = -1;
        b[4] = 0;
        r[5] = 0;
        g[5] = -64;
        b[5] = -64;
        r[6] = 0;
        g[6] = -1;
        b[6] = -1;
        r[7] = -64;
        g[7] = 0;
        b[7] = 0;
        r[8] = -1;
        g[8] = 0;
        b[8] = 0;
        r[9] = -64;
        g[9] = 0;
        b[9] = -64;
        r[10] = -1;
        g[10] = 0;
        b[10] = -1;
        r[11] = -64;
        g[11] = -64;
        b[11] = 0;
        r[12] = -1;
        g[12] = -1;
        b[12] = 0;
        r[13] = 80;
        g[13] = 80;
        b[13] = 80;
        r[14] = -64;
        g[14] = -64;
        b[14] = -64;
        r[15] = -1;
        g[15] = -1;
        b[15] = -1;
        return new IndexColorModel(4, 16, r, g, b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.recalculate(e.getSource() == this.yes);
    }

    public void recalculate(boolean optim) {
        this.causes = new HashMap<Long, Integer>();
        if (this.visited != null) {
            this.visited = new long[this.src.size() + 1][this.src.size() + 1];
            ((Earley)this.par).skipRanges = optim;
            this.matrix = this.matrix.recalc();
            this.par.parse(this.src, this.matrix);
        }
        this.img = this.drawMatrix(this.matrix);
        this.matrixImage.repaint();
    }
}

