/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.plsql.SqlEarley;

public class ExportGrammar {
    public static void main(String[] args) throws Exception {
        boolean isJS = true;
        if (isJS) {
            ExportGrammar.copyGrammar(isJS, "C:\\Temp\\Grammar.js");
            ExportGrammar.copyGrammar(isJS, "C:\\SQLDevWeb\\js\\libs\\sdw\\oracle-sql\\Grammar.js");
        } else {
            ExportGrammar.copyGrammar(isJS, "C:\\Temp\\sqlgrammar.txt");
        }
    }

    private static void copyGrammar(boolean isJS, String fname) throws IOException {
        File file = new File(fname);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        if (isJS) {
            String prelude = "/*\r\n * Copyright (c) 2015-17, Oracle and/or its affiliates. All rights reserved.\r\n */\r\n\r\ndefine(\r\n    [],\r\n    function(){\r\n        var rules = [\r\n            // Added by Andres\r\n            {head:\"sqldev_block\",rhs:[\"sql_query_or_dml_stmt\"]},\r\n            {head:\"sqldev_blocks\",rhs:[\"sqldev_block\"]},\r\n            {head:\"sqldev_blocks\",rhs:[\"sqldev_block\",\"'/'\"]},\r\n            {head:\"sqldev_blocks\",rhs:[\"sqldev_block\",\"'/'\",\"sqldev_blocks\"]},\r\n            // End added\r\n";
            bw.write(prelude);
        }
        for (RuleTuple rule : SqlEarley.getRules()) {
            if (isJS) {
                bw.write("            {head:\"");
                bw.write(rule.head.replace("\"", "\\\""));
                bw.write("\",rhs:[\"");
                int pos = -1;
                for (String t : rule.rhs) {
                    if (0 < ++pos) {
                        bw.write("\",\"");
                    }
                    bw.write(t.replace("\"", "\\\""));
                }
                bw.write("\"]},\n");
                continue;
            }
            bw.write(rule.toString() + "\n");
        }
        if (isJS) {
            String finale = "        ];\r\n\r\n        return {\r\n            Rules : rules,\r\n            StartRule : 'sqldev_blocks'\r\n        };\r\n    }\r\n)";
            bw.write(finale);
        }
        bw.close();
    }

    private static void saveGrammar() throws Exception {
        Class.forName("oracle.jdbc.OracleDriver");
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@llg00hon.uk.oracle.com:1521/DB12201", "hr", "hr");
        PreparedStatement stmt = conn.prepareStatement("insert into sql122_grammar values(?,?)");
        for (RuleTuple rule : SqlEarley.getRules()) {
            String r = rule.toString();
            int semiColPos = r.indexOf(58);
            String rhs = r.substring(semiColPos + 1);
            stmt.setString(1, rule.head);
            stmt.setString(2, rhs);
            stmt.execute();
            System.out.println(r);
        }
    }
}

