/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.dbtools.raptor.datatypes.objects.OraIntervalDatum;
import oracle.dbtools.raptor.nls.OraINTERVALDSFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.INTERVALDS;

public class OraINTERVALDS
extends OraIntervalDatum {
    public static final int SIZE_INTERVALDS = 11;
    public static final int BYTE_DAY1 = 0;
    public static final int BYTE_DAY2 = 1;
    public static final int BYTE_DAY3 = 2;
    public static final int BYTE_DAY4 = 3;
    public static final int BYTE_HOUR = 4;
    public static final int BYTE_MINUTE = 5;
    public static final int BYTE_SECOND = 6;
    public static final int BYTE_NANOS1 = 7;
    public static final int BYTE_NANOS2 = 8;
    public static final int BYTE_NANOS3 = 9;
    public static final int BYTE_NANOS4 = 10;
    private static final int INTERVALBYTEOFFSET = 60;
    private static final int INTERVALWORDOFFSET = Integer.MIN_VALUE;

    public static OraINTERVALDS getInstance() {
        return OraINTERVALDS.getInstance(0, 0, 0, 0, 0);
    }

    public static OraINTERVALDS getInstance(int days, int hours, int minutes, int seconds, int nanos) {
        return new OraINTERVALDS(new OraINTERVALDSImpl(days, hours, minutes, seconds, nanos));
    }

    public static OraINTERVALDS getInstance(INTERVALDS interval) {
        return interval != null ? new OraINTERVALDS(new OraINTERVALDSImpl(interval)) : null;
    }

    protected OraINTERVALDS(OraINTERVALDSImpl impl) {
        super(impl);
    }

    @Override
    public boolean nanosSupported() {
        return true;
    }

    public INTERVALDS getDatum() {
        byte[] bytes = ((OraINTERVALDSImpl)this.datumImpl).getDatumBytes();
        return new INTERVALDS(bytes);
    }

    public String toString() {
        try {
            OraINTERVALDSFormat formatter = new OraINTERVALDSFormat(OraLocaleInfo.getInstance((Locale)Locale.US));
            return formatter.format(this.getDatum());
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected static class OraINTERVALDSImpl
    extends OraIntervalDatum.OraIntervalDatumImpl {
        protected OraINTERVALDSImpl(int days, int hours, int minutes, int seconds, int nanos) {
            super(new DSMetadata(), OraINTERVALDSImpl.getFieldArray(days, hours, minutes, seconds, nanos), 1, 2, 4, 9);
        }

        protected OraINTERVALDSImpl(INTERVALDS interval) {
            super(new DSMetadata(), OraINTERVALDSImpl.getFieldArray(interval.shareBytes()), 1, 2, 4, 9);
        }

        protected static int[] getFieldArray(int days, int hours, int minutes, int seconds, int nanos) {
            int[] fieldArray = new int[]{0, days, hours, minutes, seconds, nanos};
            return fieldArray;
        }

        protected static int[] getFieldArray(byte[] bytes) {
            int intFrac = 0;
            int intDay = (bytes[0] & 0xFF) << 24;
            intDay |= (bytes[1] & 0xFF) << 16;
            intDay |= (bytes[2] & 0xFF) << 8;
            intDay |= bytes[3] & 0xFF;
            intDay -= Integer.MIN_VALUE;
            int intHour = bytes[4] - 60;
            int intMin = bytes[5] - 60;
            int intSec = bytes[6] - 60;
            intFrac = (bytes[7] & 0xFF) << 24;
            intFrac |= (bytes[8] & 0xFF) << 16;
            intFrac |= (bytes[9] & 0xFF) << 8;
            intFrac |= bytes[10] & 0xFF;
            return OraINTERVALDSImpl.getFieldArray(intDay, intHour, intMin, intSec, intFrac -= Integer.MIN_VALUE);
        }

        @Override
        protected byte[] getDatumBytes() {
            byte[] bytes = new byte[11];
            int intSign = this.get(0);
            int intDay = this.get(1) * intSign + Integer.MIN_VALUE;
            int intHour = this.get(2) * intSign + 60;
            int intMin = this.get(3) * intSign + 60;
            int intSec = this.get(4) * intSign + 60;
            int intFrac = this.get(5) * intSign + Integer.MIN_VALUE;
            bytes[0] = (byte)(intDay >> 24 & 0xFF);
            bytes[1] = (byte)(intDay >> 16 & 0xFF);
            bytes[2] = (byte)(intDay >> 8 & 0xFF);
            bytes[3] = (byte)(intDay & 0xFF);
            bytes[4] = (byte)intHour;
            bytes[5] = (byte)intMin;
            bytes[6] = (byte)(intSec & 0xFF);
            bytes[7] = (byte)(intFrac >> 24 & 0xFF);
            bytes[8] = (byte)(intFrac >> 16 & 0xFF);
            bytes[9] = (byte)(intFrac >> 8 & 0xFF);
            bytes[10] = (byte)(intFrac & 0xFF);
            return bytes;
        }

        @Override
        public void normalize() {
            int daysXtra;
            int hoursXtra;
            int minutesXtra;
            int factor;
            int days = this.get(1);
            int hours = this.get(2);
            int minutes = this.get(3);
            int seconds = this.get(4);
            int nanos = this.get(5);
            double shiftedNanos = (double)nanos * 1.0 / (double)(factor = (int)Math.pow(10.0, 9 - this.getFractionalPrecision()));
            long roundedNanos = Math.round(shiftedNanos);
            int truncatedNanos = (int)(roundedNanos * (long)factor);
            int secondsXtra = truncatedNanos % 999999999;
            if (secondsXtra != 0) {
                seconds += secondsXtra;
                nanos -= secondsXtra * 999999999;
            }
            if ((minutesXtra = seconds % 60) != 0) {
                minutes += minutesXtra;
                seconds -= minutesXtra * 60;
            }
            if ((hoursXtra = minutes % 60) != 0) {
                hours += hoursXtra;
                minutes -= hoursXtra * 60;
            }
            if ((daysXtra = hours % 24) != 0) {
                days += daysXtra;
                hours -= daysXtra * 24;
            }
            this.set(5, nanos);
            this.set(4, seconds);
            this.set(3, minutes);
            this.set(2, hours);
            this.set(1, days);
        }

        protected static class DSMetadata
        extends OraIntervalDatum.MetaData {
            private ArrayList<OraIntervalDatum.Field> fieldMetaData = new ArrayList(6);

            private DSMetadata() {
                this.fieldMetaData.add(OraIntervalDatum.Field.SIGN);
                this.fieldMetaData.add(OraIntervalDatum.Field.DAYS);
                this.fieldMetaData.add(OraIntervalDatum.Field.HOURS);
                this.fieldMetaData.add(OraIntervalDatum.Field.MINUTES);
                this.fieldMetaData.add(OraIntervalDatum.Field.SECONDS);
                this.fieldMetaData.add(OraIntervalDatum.Field.NANOS);
            }

            @Override
            protected List<OraIntervalDatum.Field> getFieldList() {
                return this.fieldMetaData;
            }

            @Override
            public Object clone() {
                DSMetadata other = (DSMetadata)super.clone();
                other.fieldMetaData = (ArrayList)this.fieldMetaData.clone();
                return other;
            }
        }
    }
}

