/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.Datum;

public class JSONPrettyFormatter
extends ResultsFormatter {
    private static final Logger LOGGER = Logger.getLogger(ResultsFormatter.class.getName());
    public static final String TYPE = "JSON-FORMATTED";
    public static final String EXT = "json-formatted";
    private static final String RESULTS = "results";
    private static final String COLUMNS = "columns";
    private static final String COLUMNS_NAME = "name";
    private static final String COLUMNS_TYPE = "type";
    private static final String ITEMS = "items";
    private boolean _topLevel = true;
    private JsonGenerator jGen = null;

    public JSONPrettyFormatter() {
        super(TYPE, Messages.getString("JSONFormatter.0"), EXT);
    }

    public void setTopLevel(boolean b) {
        this._topLevel = b;
    }

    @Override
    public void setTableName(String tName) {
    }

    @Override
    public void start() throws IOException {
        this.jGen = this.getOutputStream() != null ? JSON.std.getStreamingFactory().createGenerator(this.getOutputStream()).useDefaultPrettyPrinter() : JSON.std.getStreamingFactory().createGenerator(this.getOutWriter()).useDefaultPrettyPrinter();
        ((DefaultPrettyPrinter)this.jGen.getPrettyPrinter()).indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        this.jGen.enable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
        this.jGen.enable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
        this.jGen.writeStartObject();
        this.jGen.writeFieldName(RESULTS);
        this.jGen.writeStartArray();
        this.jGen.writeStartObject();
        try {
            this.genColumnMetadata();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        this.jGen.writeFieldName(ITEMS);
        this.jGen.writeStartArray();
    }

    private void genColumnMetadata() throws SQLException, IOException {
        this.jGen.writeFieldName(COLUMNS);
        this.jGen.writeStartArray();
        for (int i = 0; i < this.getWrapper().getColumnCount(); ++i) {
            this.jGen.writeStartObject();
            this.jGen.writeFieldName(COLUMNS_NAME);
            this.jGen.writeString(this.getWrapper().getColumnName(i));
            this.jGen.writeFieldName(COLUMNS_TYPE);
            this.jGen.writeString(this.getDataTypeName(i));
            this.jGen.writeEndObject();
        }
        this.jGen.writeEndArray();
        this.jGen.flush();
    }

    @Override
    public void startRow() throws IOException {
        long row = this.getResultsFormatterWrapper().getRowNum();
        if (row > 0L) {
            this.jGen.writeStartObject();
        }
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) {
        block18: {
            try {
                int type = this.getDataType(viewIndex);
                String name = this.getColumnName(viewIndex).toLowerCase();
                this.jGen.writeFieldName(name);
                Object val = null;
                if (type != -10) {
                    if (col != null) {
                        try {
                            switch (type) {
                                case -6: 
                                case -5: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 6: 
                                case 7: 
                                case 8: {
                                    if (col instanceof BigDecimal) {
                                        this.jGen.writeNumber(((BigDecimal)col).toString());
                                        break;
                                    }
                                    this.jGen.writeNumber(((Datum)col).stringValue());
                                    break;
                                }
                                case 2005: {
                                    Integer size = null;
                                    if (this.getScriptContext() != null) {
                                        size = (Integer)this.getScriptContext().getProperty("script.runner.setlong");
                                    }
                                    String store = null;
                                    store = size != null ? DataTypesUtil.stringValue(col, this.getScriptContext().getCurrentConnection(), size) : DataTypesUtil.stringValue(col, this.getScriptContext().getCurrentConnection());
                                    val = store;
                                    this.jGen.writeObject(val);
                                    break;
                                }
                                default: {
                                    val = this.getValue(col);
                                    this.jGen.writeObject(val);
                                    break;
                                }
                            }
                        }
                        catch (SQLException ex) {
                            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                        }
                    } else {
                        this.jGen.writeObject((Object)"");
                    }
                    break block18;
                }
                val = col;
                if (val == null) break block18;
                if (val instanceof ResultSet) {
                    this.jGen.writeStartArray();
                    try {
                        ResultSetMetaData rmeta = ((ResultSet)val).getMetaData();
                        while (((ResultSet)val).next()) {
                            int colCnt = rmeta.getColumnCount();
                            this.jGen.writeStartObject();
                            for (int i = 1; i < colCnt + 1; ++i) {
                                String cname = rmeta.getColumnName(i).toLowerCase();
                                this.jGen.writeFieldName(cname);
                                this.jGen.writeObject((Object)DataTypesUtil.stringValue(((ResultSet)val).getObject(i), this.getScriptContext().getCurrentConnection()));
                            }
                            this.jGen.writeEndObject();
                        }
                    }
                    catch (SQLException e) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                    this.jGen.writeEndArray();
                    break block18;
                }
                this.jGen.writeObject((Object)"");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void endRow() {
        long row = this.getResultsFormatterWrapper().getRowNum();
        if (row > 0L) {
            try {
                this.jGen.writeEndObject();
                this.jGen.flush();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    @Override
    public void end() throws IOException {
        this.jGen.writeEndArray();
        this.jGen.writeEndObject();
        this.jGen.writeEndArray();
        this.jGen.writeEndObject();
        this.jGen.flush();
    }

    @Override
    public Boolean isCandidateForSpoolMax() {
        return true;
    }
}

