/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.dbtools.app.Literals2Binds;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.newscriptrunner.ArgumentQuoteException;
import oracle.dbtools.raptor.newscriptrunner.BindPrinter;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ExecutePathCheckReturn;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.PLSQL;
import oracle.dbtools.raptor.newscriptrunner.PathException;
import oracle.dbtools.raptor.newscriptrunner.ProviderForSQLPATH;
import oracle.dbtools.raptor.newscriptrunner.ResetPasswordHelper;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.SqlnetInstance;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.SetAppinfo;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetEntries;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowLogin;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.NLSLang;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.util.Pair;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;

public class SQLPLUS
extends SQLCommandRunner {
    public static String PRODUCT_NAME = "SQL Developer";
    private static String SPECIALBINDFORALIASNULLS = "SPECIALBINDFORALIASNULLS";
    protected static final String m_lineSeparator = System.getProperty("line.separator");
    private String directory = null;
    public static ProviderForSQLPATH sqlpathProvider = null;
    private ScriptExecutor _runner = null;

    public SQLPLUS(ISQLCommand cmd, BufferedOutputStream out) {
        super(cmd, out);
    }

    public static void setProductName(String newName) {
        PRODUCT_NAME = newName;
    }

    @Override
    public void interrupt() {
        if (this._runner != null) {
            this._runner.interrupt();
        }
    }

    private void runGoToLine(String sql) {
        int lineNo = -1;
        try {
            lineNo = Integer.parseInt(sql.split("\\s+")[0]);
        }
        catch (NumberFormatException e) {
            this.getScriptRunnerContext().write(MessageFormat.format(Messages.getString("SQLPLUS.1"), sql));
            this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), MessageFormat.format(Messages.getString("SQLPLUS.1"), sql), sql);
        }
        if (this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().linesInBuffer() > 0 && lineNo >= 0) {
            this.getScriptRunnerContext().write(this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().list(lineNo, false));
        } else {
            this.getScriptRunnerContext().write("\nSP2-0223: No lines in SQL Buffer.");
            this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), "SP2-0223: No lines in SQL Buffer.", this.cmd.getSql());
        }
    }

    public void run() {
        String sql = this.cmd.getSql().trim();
        if (sql.endsWith(";") && sql.length() > 1) {
            this.cmd.setSql(sql.substring(0, sql.length() - 1));
        }
        if (this.cmd.isSqlPlusSetCmd()) {
            this.runSetPlus();
        }
        switch (this.cmd.getStmtSubType()) {
            case G_S_UNKNOWN: {
                try {
                    if (!this.runAliases()) {
                        if (this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString())) {
                            if (this.justANumber(sql)) {
                                this.runGoToLine(sql);
                            } else if (this.cmd.getSQLOrig().length() < 10) {
                                this.report(this.getScriptRunnerContext(), MessageFormat.format(ScriptRunnerDbArb.getString("SQLPLUS_UNKNOWN"), this.cmd.getSQLOrig()));
                                this.getScriptRunnerContext().addUnknown();
                            } else {
                                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("SQLPLUS_UNKNOWN_BEGINING2", this.cmd.getSQLOrig().substring(0, 10) + "..."));
                                this.getScriptRunnerContext().addUnknown();
                            }
                        } else if (this.justANumber(sql)) {
                            this.runGoToLine(sql);
                        } else {
                            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString("UNKNOWN_COMMAND"), this.getScriptRunnerContext()) + "\n");
                            this.getScriptRunnerContext().addUnknown();
                            this.cmd.setFail();
                            if (this.cmd.getSQLOrig().contains("\u200b")) {
                                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("ORIGINAL_TEXT_CONTAINED", "Unicode u200B"));
                            }
                        }
                        this.cmd.setProperty("EXECUTEFAILED", "EXECUTEFAILED");
                    }
                }
                catch (ArgumentQuoteException aqe) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("QUOTEMISMATCH", aqe.getMessage()), this.getScriptRunnerContext()));
                    this.doWhenever(false);
                }
                if (!this.getScriptRunnerContext().isMaxUnknown()) break;
                this.getScriptRunnerContext().write(Messages.getString("SQLPLUS.3"));
                this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), Messages.getString("SQLPLUS.3"), this.cmd.getSql());
                this.getScriptRunnerContext().resetUnknown();
                break;
            }
            case G_S_EXECUTE: {
                this.runExecute();
                break;
            }
            case G_S_VARIABLE: {
                this.runVariable();
                break;
            }
            case G_S_PRINT: {
                this.runPrint();
                break;
            }
            case G_S_DOC_PLUS: 
            case G_S_PROMPT: {
                this.runPrompt();
                break;
            }
            case G_S_START: 
            case G_S_AT: 
            case G_S_ATNESTED: {
                this.runExecuteFile();
                break;
            }
            case G_S_EXIT: 
            case G_S_QUIT: {
                this.runQuit();
                break;
            }
            case G_S_CONNECT: {
                this.runConnect();
                break;
            }
            case G_S_WHENEVER: {
                this.runWhenever();
                break;
            }
            case G_S_DEFINE: {
                this.runDefine();
                break;
            }
            case G_S_UNDEFINE: {
                this.runUndefine();
                break;
            }
            case G_S_ACCEPT: {
                break;
            }
            case G_S_COLUMN: {
                this.runColumn();
                break;
            }
            case G_S_PASSWORD: {
                this.runPassword();
                break;
            }
            case G_S_COPY: {
                this.runCopy();
                break;
            }
            case G_S_SET_CONSTRAINT: 
            case G_S_SET_ROLE: {
                break;
            }
            case G_S_DISCONNECT: {
                this.runDisconnect();
                break;
            }
            case G_S_COMMENT_PLUS: {
                break;
            }
            case G_S_SLASH: {
                this.runBuffer();
                break;
            }
            case G_S_RUN: {
                if (this.getScriptRunnerContext().getProperty("script.runner.jline") != null) {
                    this.getScriptRunnerContext().write(this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().list(false));
                }
                this.runBuffer();
                break;
            }
            case G_S_ROLLBACK_PLUS: {
                try {
                    this.conn.rollback();
                    this.report(this.getScriptRunnerContext(), "Rollback complete.");
                    break;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean justANumber(String sql) {
        Pattern pattern = Pattern.compile("^(-?\\d+.*)");
        return pattern.matcher(sql).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuffer() {
        if (this.conn != null && !SQLPLUS.isConnectionClosed(this.conn) && this.getScriptRunnerContext().getSQLPlusBuffer() != null) {
            IBuffer buf = this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe();
            if (buf.getBufferString().trim().length() > 0) {
                String toRun = "";
                if (buf.getLine(buf.size()).trim().equals(".")) {
                    toRun = buf.getBuffer().trim();
                    toRun = toRun.substring(0, toRun.length() - 1);
                } else {
                    toRun = buf.getBuffer();
                }
                this._runner = new ScriptExecutor(toRun, this.conn);
                this._runner.setScriptRunnerContext(this.getScriptRunnerContext());
                Boolean oldInSlash = (Boolean)this.getScriptRunnerContext().getProperty("script.runner.isslashstatement");
                if (oldInSlash == null) {
                    oldInSlash = Boolean.FALSE;
                }
                try {
                    this.getScriptRunnerContext().putProperty("script.runner.isslashstatement", Boolean.TRUE);
                    this._runner.run();
                }
                finally {
                    this.getScriptRunnerContext().putProperty("script.runner.isslashstatement", oldInSlash);
                }
            }
            this.getScriptRunnerContext().write(ScriptRunnerDbArb.getString("SQLPLUS_BUFFER_EMPTY"));
            try {
                this.getScriptRunnerContext().getOutputStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void disconnectMessage(Connection conn, ScriptRunnerContext src, BufferedOutputStream out) {
        if (conn != null && !SQLPLUS.isConnectionClosed(conn)) {
            String localOVersion = src.doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._O_VERSION.toString(), ScriptRunnerContext.SqlplusVariable._O_VERSION);
            if (src.getProperty("script.runner.sqlplus.silent") == null ^ src.getProperty("script.runner.sqlcl.optionx") != null) {
                src.write("\n" + ScriptRunnerDbArb.format("DISCONNECTED_FROM", localOVersion) + "\n");
                try {
                    src.getOutputStream().flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void runDisconnect() {
        if (this.conn != null && !SQLPLUS.isConnectionClosed(this.conn)) {
            if (this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH") == null || ((Boolean)this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH")).equals(Boolean.FALSE)) {
                SQLPLUS.disconnectMessage(this.conn, this.getScriptRunnerContext(), this.out);
                this.commitConnection(this.conn);
            }
            this.configureOldConnections(this.conn);
        }
        this.conn = null;
        this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
        this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._USER.toString(), "");
        this.getScriptRunnerContext().setCurrentConnection(this.conn);
        this.getScriptRunnerContext().putProperty("script.runner.sqlplus.nolog", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCopy() {
        boolean copySucceeded;
        String errorString;
        String[] stringArray;
        block353: {
            this.cmd.setSql(SQLPLUS.removeDashNewline(this.cmd, this.cmd.getSql()));
            String mySQL = this.cmd.getSql().trim();
            String copyFrom = null;
            String copyTo = null;
            String toType = null;
            String destinationTable = null;
            String destColumns = null;
            String query = null;
            stringArray = this.nextWordAndRest(mySQL);
            errorString = null;
            boolean useByte = false;
            int maxSrcCols = 0;
            copySucceeded = false;
            if (stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("COPY") && stringArray.length == 2 && stringArray[1] != null) {
                if ((stringArray = this.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("FROM") && stringArray.length == 2 && stringArray[1] != null) {
                    if ((stringArray = this.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                        copyFrom = stringArray[0];
                        stringArray = this.nextWordAndRest(stringArray[1].trim());
                    } else {
                        errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                    }
                }
                if (errorString == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("TO") && stringArray.length == 2 && stringArray[1] != null) {
                    if ((stringArray = this.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                        copyTo = stringArray[0];
                        stringArray = this.nextWordAndRest(stringArray[1].trim());
                    } else {
                        errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                    }
                }
                if (errorString == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("FROM") && stringArray.length == 2 && stringArray[1] != null) {
                    if ((stringArray = this.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                        copyFrom = stringArray[0];
                        stringArray = this.nextWordAndRest(stringArray[1].trim());
                    } else {
                        errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                    }
                }
                if (errorString == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("TO") && stringArray.length == 2 && stringArray[1] != null) {
                    if ((stringArray = this.nextWordAndRest(stringArray[1].trim())) != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                        copyTo = stringArray[0];
                        stringArray = this.nextWordAndRest(stringArray[1].trim());
                    } else {
                        errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                    }
                }
                if (copyFrom != null && copyFrom.toLowerCase().contains("as sysdba")) {
                    this.getScriptRunnerContext().write(ScriptRunnerDbArb.getString("COPY_ERR_SYSDBA"));
                    return;
                }
                if (errorString == null && stringArray != null && stringArray[0] != null && (stringArray[0].equalsIgnoreCase("APPEND") || stringArray[0].equalsIgnoreCase("APPEND_BYTE") || stringArray[0].equalsIgnoreCase("CREATE") || stringArray[0].equalsIgnoreCase("CREATE_BYTE") || stringArray[0].equalsIgnoreCase("INSERT") || stringArray[0].equalsIgnoreCase("REPLACE_BYTE") || stringArray[0].equalsIgnoreCase("REPLACE")) && stringArray.length == 2 && stringArray[1] != null) {
                    toType = stringArray[0].toUpperCase();
                    if (toType.equals("CREATE_BYTE")) {
                        useByte = true;
                        toType = "CREATE";
                    }
                    if (toType.equals("APPEND_BYTE")) {
                        useByte = true;
                        toType = "APPEND";
                    }
                    if (toType.equals("REPLACE_BYTE")) {
                        useByte = true;
                        toType = "REPLACE";
                    }
                } else {
                    errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                }
                if (errorString == null && stringArray != null) {
                    stringArray = this.nextWordAndRestOrString(stringArray[1].trim(), "(");
                }
                if (errorString == null && stringArray != null && stringArray[0] != null && stringArray.length == 2 && stringArray[1] != null) {
                    destinationTable = stringArray[0];
                    destinationTable = destinationTable.length() > 2 && destinationTable.startsWith("\"") && destinationTable.endsWith("\"") ? destinationTable.substring(1, destinationTable.length() - 1) : destinationTable.toUpperCase();
                } else {
                    errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                }
                if (errorString == null && stringArray != null) {
                    String maybeBracketted = stringArray[1].trim();
                    if (maybeBracketted.startsWith("(") && maybeBracketted.indexOf(")") != -1) {
                        destColumns = maybeBracketted.substring(1, maybeBracketted.indexOf(")"));
                        try {
                            maybeBracketted = maybeBracketted.substring(maybeBracketted.indexOf(")") + 1);
                        }
                        catch (Exception e) {
                            errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                        }
                        maybeBracketted = maybeBracketted.trim();
                    }
                    if (errorString == null && stringArray != null) {
                        stringArray = this.nextWordAndRest(maybeBracketted);
                    }
                    if (stringArray == null || stringArray == null || stringArray.length <= 0 || stringArray[0] == null || !stringArray[0].equalsIgnoreCase("USING")) {
                        this.getScriptRunnerContext().write(ScriptRunnerDbArb.getString("COPY_USING_NOT_DESCRIBED"));
                        return;
                    }
                    if (errorString == null && stringArray != null && stringArray[0] != null && stringArray[0].equalsIgnoreCase("USING") && stringArray.length == 2 && stringArray[1] != null) {
                        query = stringArray[1];
                        ArrayList<String> destArray = new ArrayList<String>();
                        if (destColumns != null) {
                            String[] interrum;
                            for (String acol : interrum = destColumns.trim().split("\\s*,\\s*")) {
                                String thisCol = null;
                                thisCol = acol;
                                thisCol = thisCol.length() > 2 && thisCol.startsWith("\"") && thisCol.endsWith("\"") ? thisCol.substring(1, thisCol.length() - 1) : thisCol.toUpperCase();
                                destArray.add(thisCol);
                            }
                        }
                        Connection[] fromToConnection = new Connection[]{null, null};
                        String[] fromToString = new String[]{copyFrom, copyTo};
                        for (int i = 0; i < 2; ++i) {
                            String toCon;
                            if (errorString != null || fromToString[i] == null) continue;
                            boolean wasThirdParty = false;
                            String retVal = toCon = fromToString[i];
                            if (toCon != null && toCon.startsWith("\"") && toCon.endsWith("\"") && toCon.length() > 2) {
                                String candidate = toCon.substring(1, toCon.length() - 1);
                                int at = retVal.lastIndexOf("@");
                                int space = retVal.indexOf(" ");
                                if (!(candidate.indexOf("\"") != -1 || at == -1 && space != -1 || at != -1 && space != -1 && space < at)) {
                                    retVal = candidate;
                                }
                            }
                            ConnectionDetails cd = ScriptUtils.getConnectionDetails("connect " + retVal);
                            fromToString[i] = retVal;
                            if (cd != null && cd.getCallUsage()) {
                                errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                                continue;
                            }
                            if (cd.getConnectName().equals("")) {
                                errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
                            }
                            if (cd != null && cd.getConnectDB() != null && !cd.getConnectDB().equals("")) {
                                oracle.dbtools.db.ConnectionDetails cd3 = null;
                                try {
                                    if (!this.hasUrlStub(cd.getConnectDB())) {
                                        cd3 = new oracle.dbtools.db.ConnectionDetails(cd.getConnectDB());
                                    }
                                }
                                catch (Exception e) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage());
                                }
                                if (cd3 != null && cd3.getDriver() != null) {
                                    wasThirdParty = true;
                                }
                            }
                            boolean cancelPressed = false;
                            Connection myconn = null;
                            ArrayList<String> urlMessage = new ArrayList<String>();
                            try {
                                if (!wasThirdParty && cd != null) {
                                    boolean bl = cancelPressed = !this.connectCallDialog(cd);
                                }
                                if (!(this.getScriptRunnerContext().getExited() || cd == null || cancelPressed || wasThirdParty)) {
                                    if (cd.getConnection() == null) {
                                        myconn = this.getConnection(urlMessage, cd.getConnectName(), cd.getConnectPassword(), cd.getConnectDB(), cd.getRole());
                                    } else {
                                        myconn = cd.getConnection();
                                        cd.setConnection(null);
                                    }
                                }
                            }
                            finally {
                                if (cd != null && cd.getConnection() != null) {
                                    try {
                                        cd.getConnection().close();
                                    }
                                    catch (SQLException e) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                    }
                                }
                            }
                            if (!this.getScriptRunnerContext().getExited()) {
                                if (cd != null && !cancelPressed && !wasThirdParty && myconn == null) {
                                    for (String outln : urlMessage) {
                                        if (this.getScriptRunnerContext().isSQLPlusClassic() && (outln == null || outln.equals(""))) continue;
                                        if (this.getScriptRunnerContext().getOutputStream() != null) {
                                            this.getScriptRunnerContext().write(outln);
                                        } else {
                                            System.out.print(outln);
                                        }
                                        if (!this.getScriptRunnerContext().isSQLPlusClassic() || outln == null || outln.equals("")) continue;
                                        break;
                                    }
                                }
                                if (myconn != null) {
                                    fromToConnection[i] = myconn;
                                }
                            }
                            if (myconn != null) continue;
                            if (fromToConnection[0] != null) {
                                try {
                                    fromToConnection[0].close();
                                }
                                catch (SQLException e) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                }
                            }
                            errorString = ScriptRunnerDbArb.getString("COPY_CONNECTION_FAILED");
                        }
                        if (errorString == null) {
                            if (fromToString[0] != null) {
                                copyFrom = fromToString[0];
                            }
                            if (fromToString[1] != null) {
                                copyTo = fromToString[1];
                            }
                        }
                        if (errorString == null && fromToConnection[0] == null && fromToConnection[1] == null) {
                            errorString = ScriptRunnerDbArb.getString("COPY_EITHER_FROM_OR_TO");
                        }
                        if (errorString == null) {
                            Connection fromConnection = fromToConnection[0];
                            Connection toConnection = fromToConnection[1];
                            Boolean getCommit = (Boolean)this.getScriptRunnerContext().getProperty("script.runner.autocommit.checkbox");
                            try {
                                if (getCommit == null || getCommit.equals(Boolean.FALSE)) {
                                    if (toConnection != null) {
                                        toConnection.setAutoCommit(false);
                                    }
                                    if (fromConnection != null) {
                                        fromConnection.setAutoCommit(false);
                                    }
                                } else {
                                    if (toConnection != null) {
                                        toConnection.setAutoCommit(true);
                                    }
                                    if (fromConnection != null) {
                                        fromConnection.setAutoCommit(true);
                                    }
                                }
                            }
                            catch (SQLException e) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                            }
                            if (fromConnection == null) {
                                fromConnection = this.getScriptRunnerContext().getCurrentConnection();
                            }
                            if (toConnection == null) {
                                toConnection = this.getScriptRunnerContext().getCurrentConnection();
                            }
                            int copyCommit = 0;
                            String cc = (String)this.getScriptRunnerContext().getProperty("script.runner.copycommit");
                            if (cc != null) {
                                try {
                                    copyCommit = Integer.parseInt(cc);
                                }
                                catch (NumberFormatException e) {
                                    copyCommit = 0;
                                }
                            }
                            Integer fs = null;
                            if (this.getScriptRunnerContext().getProperty("script.runner.arraysize") != null) {
                                fs = Integer.valueOf((String)this.getScriptRunnerContext().getProperty("script.runner.arraysize"));
                            } else {
                                Properties props = this.getConnectionInfo();
                                try {
                                    if (props != null) {
                                        fs = Integer.valueOf(props.getProperty("PreferfedFetchSize"));
                                    }
                                }
                                catch (NumberFormatException e) {
                                    fs = null;
                                }
                            }
                            String fsString = ScriptRunnerDbArb.getString("COPY_DEFAULT");
                            if (fs != null) {
                                fsString = fs.toString();
                            }
                            Integer reportFs = fs;
                            if (fs == null) {
                                reportFs = 0;
                            }
                            if (this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString())) {
                                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("COPY_ARRAY_CLASSIC", new Integer(reportFs).toString(), fsString));
                            } else {
                                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("COPY_ARRAY", new Integer(reportFs).toString(), fsString));
                            }
                            if (copyCommit == 0) {
                                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("COPY_COMMIT_WHEN_DONE"));
                            } else {
                                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("COPY_COMMIT", new Integer(copyCommit).toString()));
                            }
                            this.getScriptRunnerContext();
                            this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("COPY_LONG", this.getScriptRunnerContext().getProperty("script.runner.setlong").toString()));
                            Statement s = null;
                            ResultSet rs = null;
                            Statement ps = null;
                            boolean amILocked = false;
                            boolean commitMade = false;
                            ArrayList<Blob> blobs = new ArrayList<Blob>();
                            ArrayList<Clob> clobs = new ArrayList<Clob>();
                            try {
                                if (fromToConnection[0] == null || fromToConnection[1] == null) {
                                    if (this.getScriptRunnerContext().getCurrentConnection() != null) {
                                        amILocked = LockManager.lock(this.getScriptRunnerContext().getCurrentConnection());
                                    }
                                    if (!amILocked) {
                                        errorString = ScriptRunnerDbArb.getString("COPY_FAILED_TO_LOCK_CONNECTION");
                                    }
                                }
                                boolean destTableNotExist = false;
                                ArrayList<String> toColName = new ArrayList<String>();
                                ArrayList<String> toColTypeName = new ArrayList<String>();
                                ArrayList<Integer> toColPrecision = new ArrayList<Integer>();
                                ArrayList<Integer> toColScale = new ArrayList<Integer>();
                                ArrayList<Integer> fromColTypeInt = new ArrayList<Integer>();
                                ArrayList<String> fromColName = new ArrayList<String>();
                                ArrayList<String> fromColTypeName = new ArrayList<String>();
                                ArrayList<Integer> fromColPrecision = new ArrayList<Integer>();
                                ArrayList<Integer> fromColScale = new ArrayList<Integer>();
                                ArrayList<Boolean> fromColNullable = new ArrayList<Boolean>();
                                StringBuilder createBuilder = new StringBuilder("create table \"" + destinationTable + "\" (");
                                String createString = null;
                                try {
                                    if (errorString == null) {
                                        this.commitIgnoreAutocommitError(toConnection);
                                        commitMade = true;
                                        s = fromConnection.createStatement();
                                        rs = s.executeQuery(query);
                                        ResultSetMetaData rsmd = rs.getMetaData();
                                        maxSrcCols = rsmd.getColumnCount();
                                        if (maxSrcCols != destArray.size() && destArray.size() != 0) {
                                            errorString = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_COLUMNS_MISMATCH");
                                        } else {
                                            for (int i = 1; i <= maxSrcCols; ++i) {
                                                String precision;
                                                fromColTypeInt.add(rsmd.getColumnType(i));
                                                fromColName.add(rsmd.getColumnName(i));
                                                fromColTypeName.add(rsmd.getColumnTypeName(i));
                                                if (rsmd.isNullable(i) != 1) {
                                                    fromColNullable.add(Boolean.FALSE);
                                                } else {
                                                    fromColNullable.add(Boolean.TRUE);
                                                }
                                                Integer reportedPrecision = rsmd.getPrecision(i);
                                                if ((reportedPrecision == 0 || reportedPrecision == -1) && (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("VARCHAR2") || ((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("CHAR") || ((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("NVARCHAR2") || ((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("NCHAR") || ((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("RAW"))) {
                                                    reportedPrecision = 1;
                                                }
                                                fromColPrecision.add(reportedPrecision);
                                                fromColScale.add(rsmd.getScale(i));
                                                String createColName = (String)fromColName.get(i - 1);
                                                if (destArray.size() > 0) {
                                                    createColName = (String)destArray.get(i - 1);
                                                }
                                                if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("INTERVALDS")) {
                                                    precision = "";
                                                    if ((Integer)fromColPrecision.get(i - 1) > -1) {
                                                        precision = " (" + fromColPrecision.get(i - 1) + ")";
                                                    }
                                                    String scale = "";
                                                    if ((Integer)fromColScale.get(i - 1) > -1) {
                                                        scale = "(" + fromColScale.get(i - 1) + ") ";
                                                    }
                                                    createBuilder.append("\"" + createColName + "\" INTERVAL DAY" + precision + " TO SECOND " + scale);
                                                } else if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("INTERVALYM")) {
                                                    precision = "";
                                                    if ((Integer)fromColPrecision.get(i - 1) > -1) {
                                                        precision = " (" + fromColPrecision.get(i - 1) + ")";
                                                    }
                                                    createBuilder.append("\"" + createColName + "\" INTERVAL YEAR" + precision + " TO MONTH ");
                                                } else if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("BINARY_DOUBLE")) {
                                                    createBuilder.append("\"" + createColName + "\" BINARY_DOUBLE");
                                                } else {
                                                    createBuilder.append("\"" + createColName + "\" ");
                                                    if ((Integer)fromColPrecision.get(i - 1) != 0 && (Integer)fromColPrecision.get(i - 1) != -1) {
                                                        if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("NUMBER") && (Integer)fromColPrecision.get(i - 1) == 126) {
                                                            if ((Integer)fromColTypeInt.get(i - 1) == 2) {
                                                                fromColTypeName.set(i - 1, "FLOAT");
                                                            } else {
                                                                fromColTypeName.set(i - 1, "BINARY_FLOAT");
                                                            }
                                                            createBuilder.append((String)fromColTypeName.get(i - 1));
                                                        } else if (!((String)fromColTypeName.get(i - 1)).toUpperCase().startsWith("LONG")) {
                                                            createBuilder.append((String)fromColTypeName.get(i - 1));
                                                            createBuilder.append("(" + fromColPrecision.get(i - 1));
                                                            if (((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("VARCHAR2") || ((String)fromColTypeName.get(i - 1)).equalsIgnoreCase("CHAR")) {
                                                                if (useByte) {
                                                                    createBuilder.append(" BYTE");
                                                                } else {
                                                                    createBuilder.append(" CHAR");
                                                                }
                                                            }
                                                            if ((Integer)fromColScale.get(i - 1) != 0) {
                                                                createBuilder.append(", " + fromColScale.get(i - 1));
                                                            }
                                                            createBuilder.append(") ");
                                                        } else {
                                                            createBuilder.append((String)fromColTypeName.get(i - 1));
                                                        }
                                                    } else {
                                                        createBuilder.append((String)fromColTypeName.get(i - 1));
                                                    }
                                                }
                                                if (fromColNullable.equals(Boolean.FALSE)) {
                                                    createBuilder.append(" NOT NULL, ");
                                                    continue;
                                                }
                                                createBuilder.append(", ");
                                            }
                                            createString = createBuilder.substring(0, createBuilder.lastIndexOf(",")) + ")";
                                        }
                                    }
                                }
                                catch (SQLException e) {
                                    errorString = e.getLocalizedMessage();
                                }
                                finally {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (SQLException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                    }
                                    if (s != null) {
                                        try {
                                            s.close();
                                        }
                                        catch (SQLException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                    }
                                }
                                if (errorString == null && destArray.size() == 0) {
                                    for (int i = 1; i <= maxSrcCols; ++i) {
                                        destArray.add((String)fromColName.get(i - 1));
                                    }
                                }
                                Statement s2 = null;
                                ResultSet rs2 = null;
                                try {
                                    if (errorString == null) {
                                        s2 = toConnection.createStatement();
                                        rs2 = s2.executeQuery("select * from \"" + destinationTable + "\" where 1=2");
                                        ResultSetMetaData rsmd = rs2.getMetaData();
                                        int maxToCols = rsmd.getColumnCount();
                                        if (maxSrcCols < maxToCols) {
                                            errorString = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_SRC_COLUMNS_LESS_THAN_DEST");
                                        } else if (maxToCols < maxSrcCols) {
                                            errorString = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_SRC_COLUMNS_MORE_THAN_DEST");
                                        }
                                    }
                                }
                                catch (SQLException e) {
                                    destTableNotExist = true;
                                    if (toType.equals("INSERT")) {
                                        errorString = ScriptRunnerDbArb.getString("COPY_DESTINATION_DOES_NOT_EXIST");
                                    }
                                }
                                finally {
                                    if (rs2 != null) {
                                        try {
                                            rs2.close();
                                        }
                                        catch (SQLException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                    }
                                    if (s2 != null) {
                                        try {
                                            s2.close();
                                        }
                                        catch (SQLException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                    }
                                }
                                if (errorString == null && !destTableNotExist && toType.equals("CREATE")) {
                                    errorString = ScriptRunnerDbArb.getString("COPY_DESTINATION_DOES_EXIST");
                                }
                                String reportCommand = "";
                                try {
                                    if (errorString == null && toType.equals("REPLACE") && !destTableNotExist) {
                                        reportCommand = "drop table \"" + destinationTable + "\"";
                                        s = toConnection.createStatement();
                                        s.execute(reportCommand);
                                        s.close();
                                    }
                                    if (errorString == null && toType.equals("APPEND") && destTableNotExist || toType.equals("REPLACE") || toType.equals("CREATE") && destTableNotExist) {
                                        s = toConnection.createStatement();
                                        reportCommand = createString;
                                        s.execute(reportCommand);
                                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("COPY_TABLE_CREATED", destinationTable));
                                    }
                                }
                                catch (SQLException e) {
                                    destTableNotExist = true;
                                    errorString = ScriptRunnerDbArb.format("COPY_CREATE_ERROR", reportCommand, e.getLocalizedMessage(), "COPY_DESTINATION_WAS_NOT_CREATED");
                                }
                                finally {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (SQLException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                    }
                                    if (s != null) {
                                        try {
                                            s.close();
                                        }
                                        catch (SQLException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                    }
                                }
                                if (errorString != null) break block353;
                                try {
                                    ResultSetMetaData rsmd;
                                    int maxCols = 0;
                                    int longCol = 0;
                                    StringBuilder allCols = new StringBuilder("");
                                    StringBuilder getAll = new StringBuilder("");
                                    String allColsString = "";
                                    String getAllString = "";
                                    try {
                                        s = toConnection.createStatement();
                                        if (destArray.size() == 0) {
                                            rs = s.executeQuery("select * from \"" + destinationTable + "\"  where 1=2");
                                        } else {
                                            int i = 0;
                                            for (String theCol : destArray) {
                                                allCols.append("\"" + theCol + "\", ");
                                                getAll.append(":" + ++i + ", ");
                                            }
                                            allColsString = allCols.substring(0, allCols.lastIndexOf(","));
                                            getAllString = getAll.substring(0, getAll.lastIndexOf(","));
                                            rs = s.executeQuery("select " + allColsString + " from \"" + destinationTable + "\" where 1 = 2");
                                        }
                                        rsmd = rs.getMetaData();
                                        maxCols = rsmd.getColumnCount();
                                        if (maxCols != destArray.size() && destArray.size() != 0) {
                                            errorString = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_COLUMNS_MISMATCH");
                                        } else {
                                            for (int i = 1; i <= maxCols; ++i) {
                                                toColName.add(rsmd.getColumnName(i));
                                                toColTypeName.add(rsmd.getColumnTypeName(i));
                                                toColPrecision.add(rsmd.getPrecision(i));
                                                toColScale.add(rsmd.getScale(i));
                                                if (destArray.size() != 0) continue;
                                                getAll.append(":" + i + ", ");
                                            }
                                            if (destArray.size() == 0 && getAll.length() != 0) {
                                                getAllString = getAll.substring(0, getAll.lastIndexOf(","));
                                            }
                                        }
                                    }
                                    catch (SQLException e) {
                                        destTableNotExist = true;
                                        errorString = e.getErrorCode() == 904 ? ScriptRunnerDbArb.getString("COPY_COL_NAME_MISMATCH") : ScriptRunnerDbArb.getString("COPY_DESTINATION_DOES_NOT_EXIST");
                                    }
                                    finally {
                                        if (rs != null) {
                                            try {
                                                rs.close();
                                            }
                                            catch (SQLException e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                        if (s != null) {
                                            try {
                                                s.close();
                                            }
                                            catch (SQLException e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                            }
                                        }
                                    }
                                    if (errorString != null) break block353;
                                    s = fromConnection.createStatement();
                                    rs = s.executeQuery(query);
                                    if (fs != null) {
                                        rs.setFetchSize(fs);
                                    }
                                    if ((maxCols = (rsmd = rs.getMetaData()).getColumnCount()) != destArray.size() && destArray.size() != 0) {
                                        errorString = ScriptRunnerDbArb.getString("COPY_NUMBER_OF_COLUMNS_MISMATCH");
                                        break block353;
                                    }
                                    for (int i = 1; i <= maxCols; ++i) {
                                        if (!((String)fromColTypeName.get(i - 1)).toUpperCase().equals("LONG") && !((String)fromColTypeName.get(i - 1)).toUpperCase().equals("LONG RAW") && !((String)fromColTypeName.get(i - 1)).toUpperCase().equals("BLOB") && !((String)fromColTypeName.get(i - 1)).toUpperCase().equals("NCLOB") && !((String)fromColTypeName.get(i - 1)).toUpperCase().equals("CLOB")) continue;
                                        ++longCol;
                                    }
                                    if (destArray.size() == 0 && errorString == null && fromColName.size() > 0 && toColName.size() > 0) {
                                        boolean problem = false;
                                        for (int i = 1; i <= maxCols; ++i) {
                                            if (((String)fromColName.get(i - 1)).equals(toColName.get(i - 1))) continue;
                                            problem = true;
                                            break;
                                        }
                                        if (problem) {
                                            errorString = ScriptRunnerDbArb.getString("COPY_COL_NAME_MISMATCH");
                                        }
                                    }
                                    if (errorString != null) break block353;
                                    String myInsert = "";
                                    myInsert = allColsString.equals("") ? "insert into \"" + destinationTable + "\" values (" + getAllString + ")" : "insert into \"" + destinationTable + "\" (" + allColsString + ") values (" + getAllString + ")";
                                    ps = toConnection.prepareStatement(myInsert);
                                    for (int i = 1; i <= maxCols; ++i) {
                                        if (!((String)fromColTypeName.get(i - 1)).toLowerCase().equals("nvarchar2") && !((String)fromColTypeName.get(i - 1)).toLowerCase().equals("nvarchar") && !((String)fromColTypeName.get(i - 1)).toLowerCase().equals("nchar") && !((String)fromColTypeName.get(i - 1)).toLowerCase().equals("nclob")) continue;
                                        OraclePreparedStatement pstmt = (OraclePreparedStatement)ps;
                                        pstmt.setFormOfUse(i, (short)2);
                                    }
                                    int noOfRows = 0;
                                    int noOfRowsSinceCommit = 0;
                                    int noOfCommittedRows = 0;
                                    int noOfInsertedRows = 0;
                                    int myfs = 200;
                                    if (fs != null) {
                                        myfs = fs;
                                    }
                                    if (longCol > 0 && myfs > 50 / longCol) {
                                        myfs = 50 / longCol;
                                        if (myfs == 0) {
                                            myfs = 1;
                                        }
                                    } else if (myfs > 200) {
                                        myfs = 200;
                                    }
                                    int arrayBinds = 0;
                                    while (rs.next()) {
                                        for (int i = 1; i <= maxCols; ++i) {
                                            int lastRead;
                                            Closeable inp;
                                            Object gotObject = rs.getObject(i);
                                            if (rs.wasNull()) {
                                                ps.setNull(i, (Integer)fromColTypeInt.get(i - 1));
                                                continue;
                                            }
                                            int BUFFERSIZE = 2048;
                                            Object o = gotObject;
                                            if (o instanceof BigInteger) {
                                                NUMBER oNUM = new NUMBER((BigInteger)o);
                                                ((OraclePreparedStatement)ps).setNUMBER(i, oNUM);
                                                continue;
                                            }
                                            if (o instanceof Blob) {
                                                BLOB b = null;
                                                BufferedInputStream bis = null;
                                                FilterOutputStream bos = null;
                                                inp = null;
                                                OutputStream os = null;
                                                try {
                                                    b = BLOB.createTemporary((Connection)toConnection, (boolean)false, (int)10);
                                                    blobs.add((Blob)b);
                                                    b.open(1);
                                                    inp = ((Blob)o).getBinaryStream();
                                                    bis = new BufferedInputStream((InputStream)inp);
                                                    byte[] buffer = new byte[BUFFERSIZE];
                                                    os = b.setBinaryStream(1L);
                                                    lastRead = 0;
                                                    bos = new BufferedOutputStream(os);
                                                    while ((lastRead = bis.read(buffer, 0, buffer.length)) != -1) {
                                                        ((BufferedOutputStream)bos).write(buffer, 0, lastRead);
                                                    }
                                                    ((BufferedOutputStream)bos).flush();
                                                }
                                                catch (IOException io) {
                                                    throw new SQLException(io);
                                                }
                                                finally {
                                                    if (inp != null) {
                                                        try {
                                                            ((InputStream)inp).close();
                                                        }
                                                        catch (IOException iOException) {}
                                                    }
                                                    if (os != null) {
                                                        try {
                                                            os.close();
                                                        }
                                                        catch (IOException iOException) {}
                                                    }
                                                    if (bis != null) {
                                                        try {
                                                            bis.close();
                                                        }
                                                        catch (IOException iOException) {}
                                                    }
                                                    if (bos != null) {
                                                        try {
                                                            bos.close();
                                                        }
                                                        catch (IOException iOException) {}
                                                    }
                                                }
                                                ps.setObject(i, b);
                                                continue;
                                            }
                                            if (o instanceof Clob) {
                                                CLOB c = null;
                                                BufferedReader binp = null;
                                                BufferedWriter bwr = null;
                                                inp = null;
                                                Writer wr = null;
                                                try {
                                                    c = ((String)fromColTypeName.get(i - 1)).toUpperCase().equals("NCLOB") ? CLOB.createTemporary((Connection)toConnection, (boolean)false, (int)10, (short)2) : CLOB.createTemporary((Connection)toConnection, (boolean)false, (int)10);
                                                    clobs.add((Clob)c);
                                                    c.open(1);
                                                    inp = ((Clob)o).getCharacterStream();
                                                    binp = new BufferedReader((Reader)inp);
                                                    char[] myc = new char[BUFFERSIZE];
                                                    wr = c.setCharacterStream(1L);
                                                    lastRead = 0;
                                                    bwr = new BufferedWriter(wr);
                                                    while ((lastRead = binp.read(myc, 0, myc.length)) != -1) {
                                                        bwr.write(myc, 0, lastRead);
                                                    }
                                                    bwr.flush();
                                                }
                                                catch (IOException io) {
                                                    throw new SQLException(io);
                                                }
                                                finally {
                                                    if (inp != null) {
                                                        try {
                                                            ((Reader)inp).close();
                                                        }
                                                        catch (IOException iOException) {}
                                                    }
                                                    if (wr != null) {
                                                        try {
                                                            wr.close();
                                                        }
                                                        catch (IOException iOException) {}
                                                    }
                                                    if (binp != null) {
                                                        try {
                                                            binp.close();
                                                        }
                                                        catch (IOException iOException) {}
                                                    }
                                                    if (bwr != null) {
                                                        try {
                                                            bwr.close();
                                                        }
                                                        catch (IOException iOException) {}
                                                    }
                                                }
                                                ps.setObject(i, c);
                                                continue;
                                            }
                                            ps.setObject(i, gotObject);
                                        }
                                        ++noOfRowsSinceCommit;
                                        ps.addBatch();
                                        if (myfs > 0 && ++noOfRows % myfs == 0) {
                                            ps.executeBatch();
                                            ++arrayBinds;
                                            noOfInsertedRows = noOfRows;
                                            for (Blob b : blobs) {
                                                try {
                                                    ((BLOB)b).freeTemporary();
                                                }
                                                catch (SQLException BUFFERSIZE) {}
                                            }
                                            blobs = new ArrayList();
                                            for (Clob c : clobs) {
                                                try {
                                                    ((CLOB)c).freeTemporary();
                                                }
                                                catch (SQLException BUFFERSIZE) {}
                                            }
                                            clobs = new ArrayList();
                                        }
                                        if (copyCommit == 0 || arrayBinds % copyCommit != 0) continue;
                                        ps.executeBatch();
                                        this.commitIgnoreAutocommitError(toConnection);
                                        noOfCommittedRows += noOfRowsSinceCommit;
                                        noOfRowsSinceCommit = 0;
                                        this.freelobs(blobs, clobs);
                                    }
                                    ps.executeBatch();
                                    noOfInsertedRows = noOfRows;
                                    this.commitIgnoreAutocommitError(toConnection);
                                    noOfCommittedRows += noOfRowsSinceCommit;
                                    copySucceeded = true;
                                    String reportTo = "";
                                    this.freelobs(blobs, clobs);
                                    if (copyTo == null) {
                                        reportTo = ScriptRunnerDbArb.getString("COPY_DEFAULT_HOST");
                                    } else {
                                        ConnectionDetails cd = ScriptUtils.getConnectionDetails("connect " + copyTo);
                                        String unknown = ScriptRunnerDbArb.get("COPY_UNKNOWN");
                                        String name = cd.getConnectName();
                                        String db = cd.getConnectDB();
                                        if (name == null || name.equals("")) {
                                            name = unknown;
                                        }
                                        reportTo = name;
                                        if (db != null && !db.equals("")) {
                                            reportTo = reportTo + "@" + db;
                                        }
                                    }
                                    String reportFrom = "";
                                    if (copyFrom == null) {
                                        reportFrom = ScriptRunnerDbArb.getString("COPY_DEFAULT_HOST");
                                    } else {
                                        ConnectionDetails cd = ScriptUtils.getConnectionDetails("connect " + copyFrom);
                                        String unknown = ScriptRunnerDbArb.get("COPY_UNKNOWN");
                                        String name = cd.getConnectName();
                                        String db = cd.getConnectDB();
                                        if (name == null || name.equals("")) {
                                            name = unknown;
                                        }
                                        reportFrom = name;
                                        if (db != null && !db.equals("")) {
                                            reportFrom = reportFrom + "@" + db;
                                        }
                                    }
                                    String in4Spaces = "    ";
                                    this.report(this.getScriptRunnerContext(), in4Spaces + ScriptRunnerDbArb.format("COPY_ROWS_SELECTED", new Integer(noOfRows).toString(), reportFrom));
                                    this.report(this.getScriptRunnerContext(), in4Spaces + ScriptRunnerDbArb.format("COPY_ROWS_INSERTED", new Integer(noOfInsertedRows).toString(), destinationTable));
                                    this.report(this.getScriptRunnerContext(), in4Spaces + ScriptRunnerDbArb.format("COPY_ROWS_COMMITED_TWO_ARG", new Integer(noOfCommittedRows).toString(), destinationTable, reportTo));
                                }
                                catch (SQLException e) {
                                    errorString = e.getLocalizedMessage();
                                }
                            }
                            finally {
                                try {
                                    this.freelobs(blobs, clobs);
                                    if (s != null) {
                                        try {
                                            s.close();
                                        }
                                        catch (Exception destTableNotExist) {}
                                    }
                                    if (ps != null) {
                                        try {
                                            ps.close();
                                        }
                                        catch (SQLException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                    }
                                    try {
                                        if (errorString != null && commitMade) {
                                            toConnection.rollback();
                                        }
                                    }
                                    catch (SQLException e) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                    }
                                    if (fromToConnection[0] != null) {
                                        try {
                                            fromToConnection[0].close();
                                        }
                                        catch (SQLException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                    }
                                    if (fromToConnection[1] != null) {
                                        try {
                                            fromToConnection[1].close();
                                        }
                                        catch (SQLException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                    }
                                }
                                finally {
                                    if (amILocked) {
                                        try {
                                            LockManager.unlock(this.getScriptRunnerContext().getCurrentConnection());
                                        }
                                        catch (Exception e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (errorString == null && stringArray == null) {
            errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
        }
        if (errorString == null && !copySucceeded) {
            errorString = ScriptRunnerDbArb.getString("COPY_SYNTAX_ERROR");
        }
        if (errorString != null) {
            this.report(this.getScriptRunnerContext(), errorString);
            this.doWhenever(true);
        }
    }

    private void commitIgnoreAutocommitError(Connection conn) throws SQLException {
        if (!conn.getAutoCommit()) {
            conn.commit();
        }
    }

    private void freelobs(ArrayList<Blob> blobs, ArrayList<Clob> clobs) {
        for (Blob b : blobs) {
            try {
                ((BLOB)b).freeTemporary();
            }
            catch (SQLException sQLException) {}
        }
        blobs.clear();
        for (Clob c : clobs) {
            try {
                ((CLOB)c).freeTemporary();
            }
            catch (SQLException sQLException) {}
        }
        clobs.clear();
    }

    private void runSetPlus() {
        this.cmd.setSql(this.cmd.getSql().toLowerCase());
        String[] retVal = this.nextWordAndRest(this.cmd.getSql());
        if (retVal != null) {
            if (this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_UNKNOWN)) {
                StringTokenizer st = new StringTokenizer(this.cmd.getSql());
                if (st.countTokens() >= 2) {
                    st.nextToken();
                    String token = st.nextToken();
                    if (token.length() < 10) {
                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("SQLPLUS_UNKNOWN_SET_COMMAND", token));
                    } else {
                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("SQLPLUS_UNKNOWN_SET_COMMAND_BEGINNING", token.substring(0, 10) + "..."));
                    }
                    this.cmd.setFail();
                }
            } else if (this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_OBSOLETE)) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("SQLPLUS_COMMAND_OBSOLETE", new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig()));
            } else if ((retVal = this.nextWordAndRest(retVal[1])) != null) {
                String command = retVal[0];
                if ((retVal[0].equals("def") || retVal[0].equals("defi") || retVal[0].equals("defin") || retVal[0].equals("define") || retVal[0].equals("verify") || retVal[0].equals("ver") || retVal[0].equals("scan")) && (retVal = this.nextWordAndRest(retVal[1])) != null) {
                    String setChar = retVal[0];
                    boolean quoted = false;
                    String originalSetChar = setChar;
                    if (setChar.startsWith("'") && setChar.endsWith("'") && setChar.length() == 3) {
                        setChar = setChar.substring(1, 2);
                        quoted = true;
                    }
                    if (setChar.startsWith("\"") && setChar.endsWith("\"") && setChar.length() == 3) {
                        setChar = setChar.substring(1, 2);
                        quoted = true;
                    }
                    if (setChar.equals("on")) {
                        if (command.startsWith("def")) {
                            this.getScriptRunnerContext().setSubstitutionOn(true);
                            this.getScriptRunnerContext().setSubstitutionChar('&');
                            return;
                        }
                        this.getScriptRunnerContext().setScanOn(true);
                        return;
                    }
                    if (setChar.equals("off")) {
                        if (command.startsWith("def")) {
                            this.getScriptRunnerContext().setSubstitutionOn(false);
                            return;
                        }
                        this.getScriptRunnerContext().setScanOn(false);
                        return;
                    }
                    if (!(setChar.length() != 1 || Character.isWhitespace(setChar.charAt(0)) || Character.isLetterOrDigit(setChar.charAt(0)) || command.equals("scan") || setChar.charAt(0) == '\"' && !quoted || setChar.charAt(0) == '\'' && !quoted || originalSetChar.equals("\"\"\"") || originalSetChar.equals("'''"))) {
                        this.getScriptRunnerContext().setSubstitutionOn(true);
                        this.getScriptRunnerContext().setSubstitutionChar(setChar.charAt(0));
                        return;
                    }
                    String errorReport = ScriptRunnerDbArb.format("INVALID_NAME_COMMAND", "set " + command);
                    this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), errorReport, this.getScriptRunnerContext()));
                    return;
                }
            }
        }
    }

    private void runColumn() {
    }

    private void runUndefine() {
        this.cmd.setSql(SQLPLUS.removeDashNewline(this.cmd, this.cmd.getSql()));
        String[] stringArray = this.nextWordAndRest(this.cmd.getSql());
        if (!stringArray[1].trim().equals("")) {
            String theRest = stringArray[1].trim();
            Map<String, String> m = this.getScriptRunnerContext().getMap();
            while (!theRest.trim().equals("")) {
                stringArray = this.nextWordAndRest(theRest);
                String localVarName = stringArray[0].toUpperCase();
                theRest = stringArray[1];
                m.remove(localVarName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDefine() {
        String[] stringArray = this.nextWordAndRest(this.cmd.getSql());
        if (stringArray[1].trim().equals("")) {
            for (ScriptRunnerContext.SqlplusVariable valueVar : ScriptRunnerContext.SqlplusVariable.values()) {
                String value = this.getScriptRunnerContext().doPromptReplaceSqlplusVar(valueVar.toString(), valueVar);
                String nextKey = valueVar.toString();
                this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + " =  \"" + value + "\" (CHAR)");
            }
            Map<String, String> m = this.getScriptRunnerContext().getMap();
            Set<String> s = m.keySet();
            Map<String, String> map = m;
            synchronized (map) {
                for (String nextKey : s) {
                    boolean isBF2;
                    boolean printedAlready = true;
                    try {
                        ScriptRunnerContext.SqlplusVariable.valueOf(nextKey.toUpperCase());
                    }
                    catch (IllegalArgumentException iae) {
                        printedAlready = false;
                    }
                    if (printedAlready) continue;
                    String value = m.get(nextKey);
                    boolean isDigit = value.equals("") ? false : Pattern.matches("^\\d*$", value);
                    boolean isBF1 = value.equals("") ? false : Pattern.matches("^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?)([0-9]+)?$|^[+-][iI][nN][fF]$", value);
                    boolean bl = isBF2 = value.equals("") ? false : Pattern.matches("^[-+]?[0-9]*\\.[0-9]+([eE][-+]?[0-9]+)?$|^[+-][iI][nN][fF]$", value);
                    if (isBF1 || isBF2) {
                        this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + " =  " + value + " (BINARY_FLOAT)");
                        continue;
                    }
                    if (isDigit) {
                        this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + " =  " + value + " (NUMBER)");
                        continue;
                    }
                    this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + " =  \"" + value + "\" (CHAR)");
                }
            }
        }
        String localSubName = "";
        if (stringArray[1].indexOf("=") == -1) {
            Map<String, String> m = this.getScriptRunnerContext().getMap();
            String nextKey = stringArray[1].trim().toUpperCase();
            String value = m.get(nextKey);
            Map<String, String> svt = this.getScriptRunnerContext().getSubVarTypeMap();
            String dataType = svt.get(nextKey);
            if (value == null || nextKey.equals(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString()) || nextKey.equals(ScriptRunnerContext.SqlplusVariable._DATE.toString())) {
                boolean found = true;
                ScriptRunnerContext.SqlplusVariable valueVar = null;
                try {
                    valueVar = ScriptRunnerContext.SqlplusVariable.valueOf(nextKey);
                }
                catch (IllegalArgumentException iae) {
                    found = false;
                }
                if (found) {
                    value = this.getScriptRunnerContext().doPromptReplaceSqlplusVar(nextKey.toString(), valueVar);
                }
            }
            if (value == null) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("UNDEFINED_SYMBOL", nextKey.toLowerCase(Locale.US)));
            } else {
                int maxvarlen = 15;
                int keyLen = nextKey.length();
                int pad = 0;
                StringBuffer spacePad = new StringBuffer();
                if (keyLen < maxvarlen) {
                    pad = maxvarlen - keyLen;
                    for (int j = 0; j < pad; ++j) {
                        spacePad.append(" ");
                    }
                } else {
                    spacePad.append("");
                }
                boolean forceChar = false;
                for (ScriptRunnerContext.SqlplusVariable valueVar : ScriptRunnerContext.SqlplusVariable.values()) {
                    if (!valueVar.equals(nextKey.toUpperCase())) continue;
                    forceChar = true;
                    break;
                }
                if (forceChar || nextKey.equals(value) && (nextKey.equals(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString()) || nextKey.equals(ScriptRunnerContext.SqlplusVariable._USER.toString()))) {
                    this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + spacePad.toString() + " = \"\" (CHAR)");
                } else if (dataType != null && dataType.length() > 0) {
                    if (dataType.equalsIgnoreCase("CHAR") || dataType.equalsIgnoreCase("VARCHAR") || dataType.equalsIgnoreCase("VARCHAR2")) {
                        this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + spacePad.toString() + " = \"" + value + "\" (" + dataType + ")");
                    } else {
                        this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + spacePad.toString() + " = " + value + " (" + dataType + ")");
                    }
                } else {
                    this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + spacePad.toString() + " = \"" + value + "\" (CHAR)");
                }
            }
        } else {
            localSubName = stringArray[1].substring(0, stringArray[1].indexOf("=")).trim().toUpperCase();
            String setValue = "";
            boolean errorOut = false;
            if (stringArray[1].indexOf("=") != stringArray[1].length() - 1) {
                setValue = stringArray[1].substring(stringArray[1].indexOf("=") + 1).trim();
                if (setValue.startsWith("\"")) {
                    setValue = this.getDefineValue(Character.valueOf('\"'), setValue);
                } else if (setValue.startsWith("'")) {
                    setValue = this.getDefineValue(Character.valueOf('\''), setValue);
                }
                if (setValue != null) {
                    Map<String, String> map = this.getScriptRunnerContext().getMap();
                    map.put(localSubName, setValue);
                } else {
                    errorOut = true;
                }
            }
            if (errorOut) {
                String errorReport = ScriptRunnerDbArb.getString("DEFINE_REQUIRES_VALUE");
                if (setValue == null) {
                    errorReport = ScriptRunnerDbArb.getString("DEFINE_INVALID");
                }
                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), errorReport, this.getScriptRunnerContext()));
            }
        }
    }

    String getDefineValue(Character specialCharacter, String containsSpecial) {
        int lastEscaped = -1;
        String retString = null;
        String extra = containsSpecial + " ";
        StringBuilder retVal = new StringBuilder("");
        char last = ' ';
        char current = ' ';
        char next = ' ';
        for (int i = 1; i < containsSpecial.length(); ++i) {
            last = current;
            current = containsSpecial.charAt(i);
            next = extra.charAt(i + 1);
            if (!specialCharacter.equals(Character.valueOf(current))) {
                retVal.append(current);
                if (i != containsSpecial.length() - 1) continue;
                retVal = null;
                continue;
            }
            if ((!specialCharacter.equals(Character.valueOf(last)) || lastEscaped == i - 1) && specialCharacter.equals(Character.valueOf(current)) && !specialCharacter.equals(Character.valueOf(next))) break;
            if ((!specialCharacter.equals(Character.valueOf(last)) || lastEscaped == i - 1) && specialCharacter.equals(Character.valueOf(current)) && specialCharacter.equals(Character.valueOf(next))) {
                lastEscaped = i + 1;
                continue;
            }
            if (specialCharacter.equals(Character.valueOf(last)) && specialCharacter.equals(Character.valueOf(current)) && lastEscaped != i - 1) {
                retVal.append(current);
                if (i != containsSpecial.length() - 1) continue;
                retVal = null;
                continue;
            }
            retVal = null;
            break;
        }
        retString = containsSpecial.length() == 1 ? null : (retVal == null ? null : retVal.toString());
        return retString;
    }

    private void runWhenever() {
        boolean showUsage = false;
        String SUCCESS = "SUCCESS";
        String FAILURE = "FAILURE";
        String WARNING = "WARNING";
        String removeComments = this.cmd.getSql().toUpperCase();
        String stripped = ScriptUtils.stripFirstN(removeComments, 9999, this.cmd.getProperty("STRIPPED_CONTINUATION") == null, true, true);
        if (stripped == null) {
            showUsage = true;
        } else {
            removeComments = stripped;
        }
        boolean localMatchFound = false;
        boolean localSqlError = false;
        int localFlags = 0;
        if (!showUsage) {
            String cmdUpper = removeComments;
            if (cmdUpper.length() > 1 && (cmdUpper.endsWith(";") || cmdUpper.endsWith("/"))) {
                cmdUpper = cmdUpper.substring(0, cmdUpper.length() - 1);
            }
            String[] stringArray = this.nextWordAndRest(cmdUpper);
            if (!showUsage && stringArray != null && !stringArray[1].equals("")) {
                String nextWord = stringArray[0];
                String theRest = stringArray[1];
                if ((stringArray = this.nextWordAndRest(theRest)) != null && !stringArray[1].equals("")) {
                    nextWord = stringArray[0];
                    theRest = stringArray[1];
                    if (nextWord.equals("SQLERROR") || nextWord.equals("OSERROR")) {
                        localSqlError = nextWord.equals("SQLERROR");
                        stringArray = this.nextWordAndRest(theRest);
                        if (stringArray != null) {
                            nextWord = stringArray[0];
                            theRest = stringArray[1];
                            if (nextWord.equals("CONTINUE") || nextWord.equals("EXIT")) {
                                localFlags = nextWord.equals("EXIT") ? 4 : 0;
                                if (theRest == null || theRest.equals("")) {
                                    theRest = "";
                                } else {
                                    int value = 1;
                                    boolean wasSQLCODE = false;
                                    try {
                                        stringArray = this.nextWordAndRest(theRest);
                                        if (stringArray != null) {
                                            nextWord = stringArray[0];
                                            if (nextWord.equals("SUCCESS") || nextWord.equals("FAILURE") || nextWord.equals("WARNING")) {
                                                switch (nextWord) {
                                                    case "SUCCESS": {
                                                        value = 0;
                                                        break;
                                                    }
                                                    case "WARNING": {
                                                        value = 1;
                                                        break;
                                                    }
                                                    case "FAILURE": {
                                                        value = 2;
                                                        break;
                                                    }
                                                    default: {
                                                        value = 1;
                                                        break;
                                                    }
                                                }
                                            } else if (nextWord.equals("SQL.SQLCODE")) {
                                                wasSQLCODE = true;
                                                value = 2;
                                            } else {
                                                value = Integer.parseInt(nextWord);
                                            }
                                            theRest = stringArray[1];
                                            if (theRest == null) {
                                                theRest = "";
                                            }
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        value = 1;
                                    }
                                    this.getScriptRunnerContext().putProperty("script.runner.exit_int_whenever", value);
                                    this.getScriptRunnerContext().putProperty("script.runner.exit_int_whenever.wassqlcode", wasSQLCODE);
                                }
                                String action = "NONE";
                                String[] arrayWords = theRest.trim().split("\\s+");
                                if (localFlags == 4) {
                                    action = "COMMIT";
                                }
                                if (arrayWords != null) {
                                    int count = 0;
                                    for (String word : arrayWords) {
                                        if (localFlags != 4) {
                                            if (++count > 1) {
                                                showUsage = true;
                                                break;
                                            }
                                            if (word.equals("NONE")) {
                                                action = word;
                                                break;
                                            }
                                        } else if (++count > 1) {
                                            showUsage = true;
                                            break;
                                        }
                                        if (!word.equals("COMMIT") && !word.equals("ROLLBACK") && !word.equals("NONE")) continue;
                                        action = word;
                                        break;
                                    }
                                }
                                localFlags = action.equals("COMMIT") ? (localFlags |= 1) : (action.equals("ROLLBACK") ? (localFlags |= 2) : (localFlags |= 0));
                                localMatchFound = true;
                            }
                        }
                    }
                }
            }
        }
        if (localMatchFound && !showUsage) {
            if (localSqlError) {
                this.getScriptRunnerContext().setSqlError(localFlags);
            } else {
                this.getScriptRunnerContext().setOsError(localFlags);
            }
        } else {
            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), Messages.getString("WHENEVER"), this.getScriptRunnerContext()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPassword() {
        Boolean haveILocked = false;
        Statement s = null;
        ResultSet rs = null;
        try {
            if (this.getScriptRunnerContext().getBaseConnection() == null) {
                if (this.getScriptRunnerContext() != null && this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
                    this.report(this.getScriptRunnerContext(), Messages.getString("SQLPLUS.18"));
                    this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), Messages.getString("SQLPLUS.18"), this.cmd.getSql());
                    this.report(this.getScriptRunnerContext(), Messages.getString("SQLPLUS.19"));
                    this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), Messages.getString("SQLPLUS.19"), this.cmd.getSql());
                } else {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("FAILED_TO_ALTER_USER"));
                }
                this.doWhenever(true);
            } else {
                if (this.conn == null) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("NOT_CONNECTED"));
                    return;
                }
                haveILocked = LockManager.lock(this.getScriptRunnerContext().getBaseConnection());
                if (haveILocked.booleanValue()) {
                    Pair<String, String> passwords;
                    String splitString = null;
                    String toprocess = this.cmd.getSql().replaceAll("^\\s+", "");
                    if (toprocess.split("\\s+").length > 1) {
                        splitString = toprocess.replaceFirst("^[^\\s]+\\s*", "").trim();
                    }
                    s = this.conn.createStatement();
                    rs = s.executeQuery("Select user from dual");
                    rs.next();
                    String currentUserid = rs.getString(1);
                    rs.close();
                    s.close();
                    String alterUserId = null;
                    if (splitString != null && !splitString.equals("")) {
                        alterUserId = splitString;
                        alterUserId = alterUserId.startsWith("\"") && alterUserId.endsWith("\"") && alterUserId.length() > 2 ? alterUserId.substring(1, alterUserId.length() - 1) : alterUserId.toUpperCase();
                    }
                    if (alterUserId == null) {
                        alterUserId = currentUserid;
                    }
                    if ((passwords = this.getScriptRunnerContext().getPasswordFieldsProvider().passwordGetPassword(this.getScriptRunnerContext(), currentUserid, alterUserId)) != null) {
                        s = this.conn.createStatement();
                        s.execute("alter user \"" + alterUserId + "\" identified by \"" + passwords.first() + "\" replace \"" + passwords.second() + "\"");
                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("PASSWORD_CHANGED"));
                    } else {
                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("FAILED_TO_ALTER_USER"));
                        this.doWhenever(true);
                    }
                }
            }
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 65066) {
                this.report(this.getScriptRunnerContext(), e.getMessage());
            } else {
                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("PDBPASSWORDERROR"));
            }
            this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("FAILED_TO_ALTER_USER"));
            this.doWhenever(true);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException sQLException) {}
            }
            if (haveILocked.booleanValue()) {
                LockManager.unlock(this.getScriptRunnerContext().getBaseConnection());
            }
        }
    }

    private void configureOldConnections(Connection conn) {
        Object jline = this.getScriptRunnerContext().getProperty("script.runner.jline");
        if (jline == null) {
            if (!SQLPLUS.isConnectionClosed(conn)) {
                this.closeOldConnection(conn);
            }
            this.getScriptRunnerContext().setCloseConnection(true);
        } else {
            Boolean doNullBase = this.getScriptRunnerContext().getBaseConnection() != null && conn != null && this.getScriptRunnerContext().getBaseConnection().equals(conn);
            this.getScriptRunnerContext().setCloseConnection(true);
            if (!SQLPLUS.isConnectionClosed(conn)) {
                this.closeOldConnection(conn);
            }
            if (doNullBase.booleanValue()) {
                this.getScriptRunnerContext().setBaseConnection(null);
            }
            this.getScriptRunnerContext().setCloseConnection(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runConnect() {
        block72: {
            this.cmd.setSql(ScriptUtils.checkforContinuationChars(this.cmd.getSql()));
            connectIdent = null;
            urlMessage = new ArrayList<String>();
            localSql = this.cmd.getSql().trim();
            cd = ScriptUtils.getConnectionDetails(localSql);
            if (cd != null && cd.getCallUsage()) {
                inSQLCLLogin = (Boolean)this.getScriptRunnerContext().getProperty("sqlcl.script.ininitialconnect");
                this.report(this.getScriptRunnerContext(), "SP2-0306: Invalid option.");
                toReport = "";
                if (inSQLCLLogin == null || inSQLCLLogin.equals(Boolean.FALSE)) {
                    toReport = oracle.dbtools.raptor.newscriptrunner.Messages.getString("SQLPLUS.1") + "\n" + oracle.dbtools.raptor.newscriptrunner.Messages.getString("SQLPLUS.LOGON_PROXY");
                }
                this.report(this.getScriptRunnerContext(), toReport);
                return;
            }
            myconn = null;
            try {
                cancelPressed = false;
                if (cd != null) {
                    v0 = cancelPressed = this.connectCallDialog(cd) == false;
                }
                if (!this.getScriptRunnerContext().getExited() && cd != null && !cancelPressed) {
                    if (cd.getConnection() != null) {
                        myconn = cd.getConnection();
                        cd.setConnection(null);
                    } else {
                        myconn = this.getConnection(urlMessage, cd.getConnectName(), cd.getConnectPassword(), cd.getConnectDB(), cd.getRole());
                    }
                }
                if (cd == null || cd.getConnection() == null) break block72;
            }
            catch (Throwable var9_23) {
                if (cd != null && cd.getConnection() != null) {
                    try {
                        cd.getConnection().close();
                    }
                    catch (SQLException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    }
                }
                if (myconn != null) {
                    url = (String)this.getScriptRunnerContext().getProperty("cli.conn.url");
                    ScriptUtils.setHttpCon(myconn, this.getScriptRunnerContext(), (String)this.getScriptRunnerContext().getProperty("cli.conn.url") != null && (url.startsWith("http:") != false || url.startsWith("https:") != false));
                    if (cd.getEdition() != null && cd.getEdition().trim().length() > 0) {
                        try {
                            myconn.createStatement().execute(MessageFormat.format("alter session set edition={0}", new Object[]{cd.getEdition()}));
                        }
                        catch (SQLException e) {
                            try {
                                myconn.close();
                                myconn = null;
                            }
                            catch (SQLException e2) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e2.getStackTrace()[0].toString(), e2);
                            }
                            this.getScriptRunnerContext().write(e.getLocalizedMessage() + "\n");
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                        }
                    }
                }
                throw var9_23;
            }
            try {
                cd.getConnection().close();
            }
            catch (SQLException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        if (myconn != null) {
            url = (String)this.getScriptRunnerContext().getProperty("cli.conn.url");
            ScriptUtils.setHttpCon(myconn, this.getScriptRunnerContext(), (String)this.getScriptRunnerContext().getProperty("cli.conn.url") != null && (url.startsWith("http:") != false || url.startsWith("https:") != false));
            if (cd.getEdition() != null && cd.getEdition().trim().length() > 0) {
                try {
                    myconn.createStatement().execute(MessageFormat.format("alter session set edition={0}", new Object[]{cd.getEdition()}));
                }
                catch (SQLException e) {
                    try {
                        myconn.close();
                        myconn = null;
                    }
                    catch (SQLException e2) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e2.getStackTrace()[0].toString(), e2);
                    }
                    this.getScriptRunnerContext().write(e.getLocalizedMessage() + "\n");
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
        if (!this.getScriptRunnerContext().getExited()) {
            if (myconn != null) {
                if (myconn instanceof OracleConnection) {
                    try {
                        pref = 0;
                        try {
                            pref = Integer.valueOf((String)this.getScriptRunnerContext().getProperty("script.runner.arraysize"));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ((OracleConnection)myconn).setDefaultRowPrefetch(Math.max(pref, 50));
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    }
                }
                if ((connectIdent = cd.getConnectDB()) == null || connectIdent.equals("")) {
                    connectIdent = System.getProperty("os.name").startsWith("Windows") != false ? System.getenv("LOCAL") : System.getenv("TWO_TASK");
                }
                if (this.conn != null && this.conn instanceof OracleConnection && this.getScriptRunnerContext().getBaseConnection() != null && this.conn.equals(this.getScriptRunnerContext().getBaseConnection()) && this.getScriptRunnerContext().getMap().get(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString()) != "") {
                    this.getScriptRunnerContext().putProperty("script.runner.connection.id", this.getScriptRunnerContext().doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER));
                }
                if (this.conn != null) {
                    this.commitConnection(this.conn);
                    this.configureOldConnections(this.conn);
                    this.getScriptRunnerContext().setCurrentConnection(myconn);
                } else {
                    if (this.getScriptRunnerContext().getBaseConnection() == null) {
                        this.getScriptRunnerContext().setBaseConnection(myconn);
                    }
                    this.getScriptRunnerContext().setCurrentConnection(myconn);
                }
                cleanRole = cd.getRole();
                if (cleanRole == null) {
                    cleanRole = "NOTSYSDBA";
                }
                if ((cleanRole = cleanRole.trim().toUpperCase()).equals("")) {
                    cleanRole = "NOTSYSDBA";
                }
                this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString(), cleanRole);
                if (connectIdent != null && connectIdent.length() > 1 && connectIdent.length() < 81) {
                    this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), connectIdent);
                } else {
                    this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
                    this.getScriptRunnerContext().doPromptReplaceSqlplusVar(myconn, ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER);
                }
                this.conn = myconn;
                if (this.getScriptRunnerContext().getProperty("script.runner.cmdline.login") != null) {
                    if (this.getScriptRunnerContext().getProperty("script.runner.sqlcl.optionx") == null && this.getScriptRunnerContext().getProperty("script.runner.sqlplus.silent") == null && (this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH") == null || this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH").equals(Boolean.FALSE))) {
                        if (this.getScriptRunnerContext().getProperty("sqlcl.last.login.time") == null && (lastLogin = DBUtil.getInstance(this.getConn()).executeReturnOneCol("select INITCAP(TO_CHAR(last_login ,'DY MON DD YYYY HH24:MI:SS TZH:TZM')) from dba_users where username=USER")) != null) {
                            this.report(this.getScriptRunnerContext(), MessageFormat.format("Last Successful login time: {0}\n", new Object[]{lastLogin}));
                        }
                        x = this.getScriptRunnerContext().doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._O_VERSION.toString(), ScriptRunnerContext.SqlplusVariable._O_VERSION);
                        this.report(this.getScriptRunnerContext(), MessageFormat.format(Messages.getString("SQLPLUS.6"), new Object[]{x}) + "\n");
                    }
                    this.getScriptRunnerContext().getProperties().remove("script.runner.cmdline.login");
                } else if (this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH") != null && this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH").equals(Boolean.FALSE) && this.getScriptRunnerContext().getProperty("script.runner.sqlplus.silent") == null) {
                    this.report(this.getScriptRunnerContext(), MessageFormat.format("{0}.", new Object[]{ScriptRunnerDbArb.getString("CONNECTED")}));
                }
                if (this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH") != null && this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH").equals(Boolean.TRUE) && this.getScriptRunnerContext().getProperty("script.runner.sqlplus.silent") == null) {
                    if (this.getScriptRunnerContext().isSQLPlusClassic()) {
                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("CONNECTIDLECLASSIC"));
                    } else {
                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("CONNECTIDLE"));
                    }
                }
                getCommit = (Boolean)this.getScriptRunnerContext().getProperty("script.runner.autocommit.checkbox");
                try {
                    if (getCommit == null || getCommit.equals(Boolean.FALSE)) {
                        this.conn.setAutoCommit(false);
                    } else {
                        this.conn.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
                oldEcho = this.getScriptRunnerContext().isEchoOn();
                try {
                    this.forceEcho(false, false);
                    resetToDefault = (Boolean)this.getScriptRunnerContext().getProperty("script.runner.commandlineconnect");
                    if (resetToDefault != null && resetToDefault.equals(Boolean.TRUE)) {
                        this.getScriptRunnerContext().putProperty("script.runner.commandlineconnect", Boolean.FALSE);
                        this.getScriptRunnerContext().setSubstitutionOn(true);
                    }
                    if (NLSLang.isNLSLANGSet()) {
                        NLSLang.setupNLSSession(this.getScriptRunnerContext(), this.conn);
                    }
                    this.getScriptRunnerContext().putProperty("script.runner.sqlplus.nolog", false);
                    glogin = this.getScriptRunnerContext().getProperty("DBConfig.GLOGIN");
                    gloginFile = this.getScriptRunnerContext().getProperty("DBConfig.GLOGIN_FILE");
                    if (glogin == null || !((Boolean)glogin).equals(new Boolean("true"))) ** GOTO lbl202
                    this.runGLoginSQL();
                    this.runUserLoginSQL();
                }
                finally {
                    this.forceEcho(oldEcho, true);
                }
            } else {
                failed = "";
                for (String outln : urlMessage) {
                    if (this.getScriptRunnerContext().isSQLPlusClassic()) {
                        if (outln == null || outln.equals("")) continue;
                        failed = outln;
                        break;
                    }
                    failed = failed + outln;
                }
                if (this.getScriptRunnerContext().isCommandLine() && (this.getScriptRunnerContext().getTopLevel() || this.getScriptRunnerContext().isSQLPlusClassic())) {
                    if (!(this.getScriptRunnerContext().getSqlError() != 0 || this.getScriptRunnerContext().getOsError() != 0 || this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue())) {
                        failed = failed.equals("") == false ? failed + "\n" + ScriptRunnerDbArb.getString("NO_LONGER_CONNECTED") : ScriptRunnerDbArb.getString("NO_LONGER_CONNECTED");
                    }
                    this.report(this.getScriptRunnerContext(), failed);
                } else {
                    failed = failed.equals("") == false ? ScriptRunnerDbArb.getString("CONNECTION_FAILED") + "\n" + failed : ScriptRunnerDbArb.getString("CONNECTION_FAILED");
                    this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), "  connect ...", failed, this.getScriptRunnerContext()).trim());
                }
                this.doWhenever(true);
                if (this.conn != null && !SQLPLUS.isConnectionClosed(this.conn) && LockManager.lock(this.conn)) {
                    try {
                        if (this.conn != null) {
                            this.commitConnection(this.conn);
                            this.configureOldConnections(this.conn);
                        } else {
                            if (this.getScriptRunnerContext().getBaseConnection() == null) {
                                this.getScriptRunnerContext().setBaseConnection(myconn);
                            }
                            this.getScriptRunnerContext().setCurrentConnection(myconn);
                        }
                        if (!(this.getScriptRunnerContext().isCommandLine() && this.getScriptRunnerContext().getTopLevel() || this.conn == null || this.getScriptRunnerContext().isSQLPlusClassic())) {
                            this.report(this.getScriptRunnerContext(), "Commit");
                        }
                    }
                    finally {
                        LockManager.unlock(this.conn);
                    }
                }
                this.conn = null;
                this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
                this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._USER.toString(), "");
                this.getScriptRunnerContext().setCurrentConnection(this.conn);
                this.getScriptRunnerContext().putProperty("script.runner.sqlplus.nolog", true);
            }
        }
lbl202:
        // 5 sources

        this.getScriptRunnerContext().putProperty("AUTOTRACE_STATE", false);
        this.getScriptRunnerContext().putProperty("AUTOTRACE_TYPE", "NONE");
    }

    private void forceEcho(boolean newValue, boolean isReset) {
        if (!isReset) {
            this.getScriptRunnerContext().putProperty("script.setecho", Boolean.FALSE);
        } else {
            Boolean prop = (Boolean)this.getScriptRunnerContext().getProperty("script.setecho");
            if (prop != null && prop.equals(Boolean.TRUE)) {
                return;
            }
        }
        this.getScriptRunnerContext().setEcho(newValue);
    }

    private void commitConnection(Connection conn) {
        block5: {
            try {
                if (conn == null || SQLPLUS.isConnectionClosed(conn) || !LockManager.lock(conn)) break block5;
                try {
                    conn.commit();
                }
                finally {
                    LockManager.unlock(conn);
                }
            }
            catch (SQLException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    private static boolean isConnectionClosed(Connection conn) {
        boolean closed;
        block5: {
            closed = false;
            try {
                if (conn == null || !LockManager.lock(conn)) break block5;
                try {
                    closed = conn.isClosed();
                }
                finally {
                    LockManager.unlock(conn);
                }
            }
            catch (SQLException e) {
                Logger.getLogger("SQLPLUS").log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return closed;
    }

    private void closeOldConnection(Connection conn) {
        if (this.getScriptRunnerContext().getCloseConnection()) {
            try {
                conn.close();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    private void runUserLoginSQL() {
        File f;
        ArrayList<String> logins = ShowLogin.getLocations(this.getScriptRunnerContext(), "login.sql", true);
        String loginFile = ShowLogin.firstOrNull(logins);
        if (loginFile != null && (f = new File(loginFile)).exists()) {
            this.getScriptRunnerContext().putProperty("sqlcli.login.sql", Boolean.TRUE);
            if (FileUtils.isFileOnCWD(f, this.getScriptRunnerContext()) && !FileUtils.isFileOnSQLPATH(f, this.getScriptRunnerContext())) {
                this.getScriptRunnerContext().write(Messages.getString("SQLPLUS.24"));
                this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), Messages.getString("SQLPLUS.24"), "");
            }
            this.runLoginSQLFile(f);
            this.getScriptRunnerContext().putProperty("sqlcli.login.sql", Boolean.FALSE);
        }
    }

    private void runGLoginSQL() {
        File file;
        String gloginFile = ShowLogin.firstOrNull(ShowLogin.getLocations(this.getScriptRunnerContext(), "glogin.sql", false));
        if (gloginFile != null && (file = new File(gloginFile)).exists() && file.canRead()) {
            this.getScriptRunnerContext().putProperty("sqlcli.glogin.sql", Boolean.TRUE);
            this.runLoginSQLFile(file);
            this.getScriptRunnerContext().putProperty("sqlcli.glogin.sql", Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoginSQLFile(File file) {
        block23: {
            String directoryRemoved = file.getName();
            String gloginFile = "login.sql";
            try {
                gloginFile = file.getCanonicalPath();
            }
            catch (IOException ioe) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ioe.getStackTrace()[0].toString(), ioe);
            }
            if (FileUtils.isFileOnCWD(file, this.getScriptRunnerContext()) && !FileUtils.isFileOnSQLPATH(file, this.getScriptRunnerContext())) {
                this.getScriptRunnerContext().putProperty("LOGIN_FILE_ON_CWD", Boolean.TRUE);
            }
            String prevFile = this.getScriptRunnerContext().getSourceRef();
            Integer localDepth = 0;
            try {
                localDepth = this.getScriptRunnerContext().getTopLevel() || this.getScriptRunnerContext().getProperty("script.runner.script_depth") == null ? Integer.valueOf(1) : (Integer)this.getScriptRunnerContext().getProperty("script.runner.script_depth");
                int oneOff = 0;
                String theName = "";
                String theGLogin = ShowLogin.firstOrNull(ShowLogin.getLocations(this.getScriptRunnerContext(), "glogin.sql", false));
                if (theGLogin != null) {
                    int bslash;
                    int slash = theGLogin.lastIndexOf("/");
                    if (slash > (bslash = theGLogin.lastIndexOf("\\"))) {
                        bslash = slash;
                    }
                    theName = bslash != -1 ? theGLogin.substring(bslash + 1) : theGLogin;
                }
                if (directoryRemoved != null && directoryRemoved.equals(theName)) {
                    oneOff = 1;
                }
                if (localDepth + oneOff < 20) {
                    this.getScriptRunnerContext().putProperty("sqlplus.login.file", Boolean.TRUE);
                    this._runner = new ScriptExecutor(new FileInputStream(file), this.conn);
                    this.getScriptRunnerContext().putProperty("runner", this._runner);
                    this._runner.setOut(this.out);
                    boolean localTopLevel = this.getScriptRunnerContext().getTopLevel();
                    this.getScriptRunnerContext().setTopLevel(false);
                    this.getScriptRunnerContext().putProperty("script.runner.script_depth", localDepth + 1);
                    this._runner.setScriptRunnerContext(this.getScriptRunnerContext());
                    String pathval = file.getCanonicalPath();
                    this.getScriptRunnerContext().setSourceRef(pathval);
                    int ii = pathval.lastIndexOf(File.separator);
                    pathval = pathval.substring(0, ii);
                    this._runner.setDirectory(pathval);
                    ArrayList scrArrayList = null;
                    try {
                        scrArrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
                        scrArrayList.add(directoryRemoved);
                        this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", scrArrayList);
                        if (scrArrayList.size() != 0) {
                            SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
                        }
                        this._runner.run();
                        break block23;
                    }
                    finally {
                        this.setScriptRunnerContext(this._runner.getScriptRunnerContext());
                        this.getScriptRunnerContext().setTopLevel(localTopLevel);
                        this.setConn(this._runner.getScriptRunnerContext().getCurrentConnection());
                        scrArrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
                        if (scrArrayList.size() != 0) {
                            scrArrayList.remove(scrArrayList.size() - 1);
                        }
                        this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", scrArrayList);
                        if (scrArrayList.size() != 0) {
                            SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
                        } else {
                            SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), PRODUCT_NAME, 0);
                        }
                    }
                }
                if (this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString())) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("MAX_NEST_CLASSIC"));
                } else {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString("MAX_NEST"), this.getScriptRunnerContext()));
                }
            }
            catch (FileNotFoundException e) {
                this.report(this.getScriptRunnerContext(), "No " + gloginFile + " found");
            }
            catch (IOException e) {
                this.report(this.getScriptRunnerContext(), "No " + gloginFile + " found");
            }
            finally {
                this.getScriptRunnerContext().setSourceRef(prevFile);
                this.getScriptRunnerContext().removeProperty("sqlplus.login.file");
                this.getScriptRunnerContext().putProperty("script.runner.script_depth", localDepth);
            }
        }
    }

    private boolean connectCallDialog(ConnectionDetails cd) {
        if (cd != null && cd.getConnectDB() != null && !cd.getConnectDB().equals("")) {
            oracle.dbtools.db.ConnectionDetails cd3 = null;
            try {
                if (!this.hasUrlStub(cd.getConnectDB())) {
                    cd3 = new oracle.dbtools.db.ConnectionDetails(cd.getConnectDB());
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage());
            }
            if (cd3 != null && cd3.getDriver() != null) {
                return true;
            }
        }
        for (int ii = 0; ii < 3; ++ii) {
            if (ii != 0 || cd.getSlash() == -1 || cd.getConnectName() == null || cd.getConnectPassword() == null || cd.getConnectDB() == null) {
                ConnectionDetails threeFields = this.getScriptRunnerContext().getConnectFieldsProvider().get3Fields(this.getScriptRunnerContext(), cd, ii > 0);
                if (threeFields == null) {
                    return false;
                }
                cd.cloneFrom(threeFields);
            }
            String totalErrors = "";
            ArrayList<String> urlMessage = new ArrayList<String>();
            Boolean threeTimes = (Boolean)this.getScriptRunnerContext().getProperty("script.runner.threetimes");
            if (threeTimes == null) {
                threeTimes = Boolean.FALSE;
            }
            if (ii == 2 || threeTimes.equals(Boolean.FALSE)) break;
            Connection myconn = this.getConnection(urlMessage, cd.getConnectName(), cd.getConnectPassword(), cd.getConnectDB(), cd.getRole());
            if (myconn != null) {
                cd.setConnection(myconn);
                myconn = null;
                break;
            }
            for (String outln : urlMessage) {
                if (this.getScriptRunnerContext().isSQLPlusClassic()) {
                    if (outln == null || outln.equals("")) continue;
                    totalErrors = outln;
                    break;
                }
                totalErrors = totalErrors + outln;
            }
            this.doWhenever(true);
            if (this.getScriptRunnerContext().getExited()) break;
            if (this.getScriptRunnerContext().isCommandLine() && this.getScriptRunnerContext().getTopLevel()) {
                this.report(this.getScriptRunnerContext(), ("Z" + totalErrors).trim().substring(1));
                continue;
            }
            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("CONNECTION_FAILED_RETRY_ARG", ("Z" + totalErrors).trim().substring(1)), this.getScriptRunnerContext()).trim());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuit() {
        block60: {
            String[] allExitArgs;
            String localSql;
            block59: {
                localSql = this.cmd.getLoweredTrimmedSQL().toUpperCase();
                if (localSql.endsWith(";")) {
                    localSql = localSql.substring(0, localSql.length() - 1).trim();
                }
                if (this.conn != null && !SQLPLUS.isConnectionClosed(this.conn) && this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH") != null && !((Boolean)this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH")).equals(Boolean.TRUE)) {
                    if (localSql.endsWith("ROLLBACK")) {
                        try {
                            this.conn.rollback();
                        }
                        catch (SQLException e) {
                            if (!(this.conn instanceof OracleConnection) || DBUtil.isOracleConnectionAlive(this.conn)) {
                                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("ERROR_ON", "Rollback"), this.getScriptRunnerContext()));
                            }
                            break block59;
                        }
                    }
                    try {
                        if (this.getScriptRunnerContext().getProperty("script.runner.exitcommit") != null && this.getScriptRunnerContext().getProperty("script.runner.exitcommit").equals("OFF")) {
                            this.conn.rollback();
                        } else {
                            this.conn.commit();
                        }
                    }
                    catch (SQLException e) {
                        if (this.conn instanceof OracleConnection && !DBUtil.isOracleConnectionAlive(this.conn)) break block59;
                        this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("ERROR_ON", "Rollback"), this.getScriptRunnerContext()));
                    }
                }
            }
            this.getScriptRunnerContext().setExited(true);
            String exitArgs = "";
            if (localSql.length() > 2) {
                exitArgs = localSql.substring(4).trim();
                exitArgs = exitArgs.replaceAll("ROLLBACK", "").replaceAll("COMMIT", "");
            }
            if ((allExitArgs = exitArgs.trim().split("\\s+"))[0].toUpperCase().equals("FAILURE")) {
                this.getScriptRunnerContext().putProperty("script.runner.exit_int", 1);
            } else if (allExitArgs.length > 1) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.get("EXIT_JUNK2"));
            } else {
                try {
                    String val;
                    if (allExitArgs[0].startsWith(":")) {
                        String bindName = exitArgs.substring(1).trim();
                        Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
                        Object object = m;
                        synchronized (object) {
                            Bind b = m.get(bindName.toUpperCase());
                            if (b != null) {
                                String value = b.getValue();
                                if (value != null && !value.equals("") && !value.equalsIgnoreCase("infinity") && !value.equalsIgnoreCase("nan") && value.length() > 0 && Character.isDigit(value.charAt(0))) {
                                    allExitArgs[0] = value;
                                } else {
                                    allExitArgs[0] = "1";
                                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.get("INTERNAL_NUMBER_ERROR"));
                                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.get("EXIT_JUNK2"));
                                }
                            } else {
                                allExitArgs[0] = "1";
                                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.get("EXIT_JUNK2"));
                            }
                        }
                    }
                    if (allExitArgs[0] != null && (allExitArgs[0].toUpperCase().equals("SQLCODE") || allExitArgs[0].toUpperCase().equals("SQL.SQLCODE"))) {
                        String sqlCodeString = (String)this.getScriptRunnerContext().getProperty("sqldev.last.err.message.forsqlcode");
                        int codeNum = 0;
                        if (sqlCodeString != null) {
                            try {
                                String firstLine = sqlCodeString.split("\n")[0].trim();
                                codeNum = firstLine.matches("^[^\\-]*\\-[0-9]+.*$") ? Integer.parseInt(firstLine.replaceAll("^[^\\-]*\\-([0-9]+).*$", "$1")) : -1;
                            }
                            catch (NumberFormatException e) {
                                codeNum = -1;
                            }
                            catch (PatternSyntaxException e) {
                                codeNum = -1;
                            }
                        }
                        allExitArgs[0] = String.valueOf(codeNum);
                    }
                    if ((val = allExitArgs[0]) != null) {
                        val = val.trim().toUpperCase();
                    }
                    if (!(allExitArgs[0] == null || val.equals("SUCCESS") || val.equals("FAILURE") || val.equals("WARNING") || val.equals("COMMIT") || val.equals("ROLLBACK") || val.startsWith("/*") || val.startsWith("--") || val.equals(""))) {
                        try {
                            Double.parseDouble(allExitArgs[0]);
                            DecimalFormat format = new DecimalFormat();
                            format.setDecimalSeparatorAlwaysShown(false);
                            Double d = Double.parseDouble(allExitArgs[0]);
                            if (d > 2.147483647E9 || d < 1.0) {
                                this.getScriptRunnerContext().putProperty("script.runner.exit_int", 0);
                                break block60;
                            }
                            int is = new BigDecimal(d).setScale(0, RoundingMode.HALF_DOWN).intValue();
                            this.getScriptRunnerContext().putProperty("script.runner.exit_int", is);
                        }
                        catch (NumberFormatException e) {
                            int i = 0;
                            Map<String, String> m = this.getScriptRunnerContext().getMap();
                            Set<String> s = m.keySet();
                            Map<String, String> map = m;
                            synchronized (map) {
                                Iterator<String> it = s.iterator();
                                boolean found = false;
                                while (it.hasNext()) {
                                    String nextKey = it.next();
                                    if (!val.equals(nextKey)) continue;
                                    try {
                                        String value = m.get(nextKey);
                                        try {
                                            i = Integer.parseInt(value);
                                            found = true;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                        }
                                    }
                                    catch (IllegalArgumentException value) {}
                                }
                                if (val.equalsIgnoreCase("sqlcode") || val.equalsIgnoreCase("sql.sqlcode")) {
                                    String sqlCodeString = (String)this.getScriptRunnerContext().getProperty("sqldev.last.err.message.forsqlcode");
                                    int codeNum = 0;
                                    if (sqlCodeString != null) {
                                        try {
                                            String firstLine = sqlCodeString.split("\n")[0].trim();
                                            codeNum = firstLine.matches("^[^\\-]*\\-[0-9]+.*$") ? Integer.parseInt(firstLine.replaceAll("^[^\\-]*\\-([0-9]+).*$", "$1")) : -1;
                                        }
                                        catch (NumberFormatException e1) {
                                            codeNum = -1;
                                        }
                                        catch (PatternSyntaxException e2) {
                                            codeNum = -1;
                                        }
                                        this.getScriptRunnerContext().putProperty("script.runner.exit_int", codeNum);
                                        found = true;
                                    }
                                }
                                if (!found) {
                                    i = 1;
                                    this.report(this.getScriptRunnerContext(), MessageFormat.format("EXIT_JUNK", exitArgs != null ? exitArgs.trim() : exitArgs));
                                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.get("EXIT_JUNK2"));
                                }
                            }
                            this.getScriptRunnerContext().putProperty("script.runner.exit_int", i);
                        }
                        break block60;
                    }
                    int value = 0;
                    switch (val) {
                        case "WARNING": {
                            value = 2;
                            break;
                        }
                        case "FAILURE": {
                            value = 1;
                            break;
                        }
                    }
                    this.getScriptRunnerContext().putProperty("script.runner.exit_int", value);
                }
                catch (Exception e) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("EXIT_VALUE_NOT_CALCULATED", exitArgs));
                    this.getScriptRunnerContext().putProperty("script.runner.exit_int", 1);
                }
            }
        }
        if (this.getScriptRunnerContext().getProperty("Spool.out.buffer") != null) {
            this.getScriptRunnerContext().stopSpool();
        }
        if (this.conn != null) {
            this.runDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    ExecutePathCheckReturn checkPath(boolean tryUrlAsDir, boolean multiplePath, boolean noPrefix, String prefixString, URL prefixURL, String inputFile, String encodingOverride, PathException lastException) {
        ExecutePathCheckReturn retVal;
        block72: {
            InputStream is;
            BufferedReader reader;
            block68: {
                block69: {
                    retVal = new ExecutePathCheckReturn();
                    reader = null;
                    is = null;
                    int NOPREFIX = 1;
                    int PREFIXSTRING = 2;
                    int PREFIXURL = 3;
                    int state = 0;
                    if (noPrefix) {
                        state = NOPREFIX;
                    } else if (prefixString != null) {
                        state = PREFIXSTRING;
                    } else if (prefixURL != null) {
                        state = PREFIXURL;
                    } else {
                        if (lastException != null) {
                            retVal.setLastException(lastException);
                        }
                        return retVal;
                    }
                    if (state == PREFIXURL) {
                        URL returnURL;
                        if (prefixURL != null && (returnURL = this.joinUrl(tryUrlAsDir, prefixURL, inputFile)) != null) {
                            if (SQLPLUS.haveIBytes(returnURL)) {
                                URLConnection uc = null;
                                InputStream isInner = null;
                                try {
                                    uc = returnURL.openConnection();
                                    isInner = uc.getInputStream();
                                    inputFile = returnURL.toString();
                                }
                                catch (IOException e) {
                                    returnURL = null;
                                }
                                finally {
                                    if (isInner != null) {
                                        try {
                                            isInner.close();
                                        }
                                        catch (IOException e) {}
                                    }
                                }
                                retVal.setUrl(returnURL);
                            }
                        }
                    } else {
                        String setting = null;
                        setting = state == NOPREFIX ? inputFile : prefixString;
                        if (setting != null && !setting.equals("")) {
                            String[] pathArray = new String[]{setting};
                            if (multiplePath) {
                                pathArray = setting.split(File.pathSeparator);
                            }
                            boolean prependHttp = false;
                            boolean prependFtp = false;
                            String matchedInputFile = null;
                            for (String singlePath : pathArray) {
                                if (singlePath == null) continue;
                                if (File.pathSeparator.equals(":")) {
                                    if (prependHttp) {
                                        singlePath = "http:" + singlePath;
                                    }
                                    if (prependFtp) {
                                        singlePath = "ftp:" + singlePath;
                                    }
                                    prependHttp = false;
                                    prependHttp = false;
                                    if (singlePath.toLowerCase().equals("http")) {
                                        prependHttp = true;
                                        continue;
                                    }
                                    if (singlePath.toLowerCase().equals("ftp")) {
                                        prependFtp = true;
                                        continue;
                                    }
                                    prependHttp = false;
                                    prependHttp = false;
                                }
                                if (FileUtils.startsWithHttpOrFtp(singlePath)) {
                                    String path = state != NOPREFIX ? (singlePath.endsWith("\\") || singlePath.endsWith("/") ? singlePath + inputFile : singlePath + "/" + inputFile) : singlePath;
                                    if (FileUtils.haveIBytes(path, this.getScriptRunnerContext())) {
                                        matchedInputFile = path;
                                        break;
                                    }
                                    path = state != NOPREFIX ? (singlePath.endsWith("\\") || singlePath.endsWith("/") ? singlePath + inputFile : singlePath + "\\" + inputFile) : singlePath;
                                    if (!FileUtils.haveIBytesRaw(path)) continue;
                                    matchedInputFile = path.replace("/", "\\");
                                    break;
                                }
                                String combined = null;
                                combined = singlePath.endsWith("\\") || singlePath.endsWith("/") ? singlePath + inputFile : singlePath + "/" + inputFile;
                                if (state == NOPREFIX) {
                                    combined = singlePath;
                                }
                                if (new File(combined.replace("/", "\\")).exists()) {
                                    matchedInputFile = combined.replace("/", "\\");
                                    break;
                                }
                                if (!new File(combined.replace("\\", "/")).exists()) continue;
                                matchedInputFile = combined.replace("\\", "/");
                                break;
                            }
                            if (matchedInputFile != null) {
                                if (FileUtils.startsWithHttpOrFtp(matchedInputFile) && (FileUtils.haveIBytes(matchedInputFile, this.getScriptRunnerContext()) || FileUtils.haveIBytesRaw(matchedInputFile))) {
                                    matchedInputFile.replace("/", "\\");
                                    if (this.getScriptRunnerContext().getProperty("script.runner.hhtp.proxy") != null) {
                                        try {
                                            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getScriptRunnerContext().getProperty("script.runner.hhtp.proxy.host").toString(), Integer.parseInt(this.getScriptRunnerContext().getProperty("script.runner.hhtp.proxy.port").toString())));
                                            HttpURLConnection connection = (HttpURLConnection)new URL(matchedInputFile).openConnection(proxy);
                                            is = connection.getInputStream();
                                        }
                                        catch (Exception e) {
                                            this.write(ScriptRunnerDbArb.getString("SQLPLUS_PROXY_ERROR"));
                                        }
                                    } else {
                                        is = this.getInputStream(matchedInputFile);
                                    }
                                    if (is != null) {
                                        inputFile = matchedInputFile;
                                        reader = new BufferedReader(new InputStreamReader(is, encodingOverride));
                                        retVal.setOutputFile(inputFile);
                                    }
                                } else {
                                    inputFile = matchedInputFile;
                                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), encodingOverride));
                                    retVal.setOutputFile(inputFile);
                                }
                            }
                        }
                    }
                    if (reader != null) break block68;
                    if (is == null) break block69;
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.WARNING, ioe.getStackTrace()[0].toString(), ioe);
                    }
                }
                if (retVal.getLastException() != null) {
                    if (lastException != null) {
                        retVal.setLastException(lastException);
                    } else {
                        retVal.setLastException(new PathException(ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", inputFile)));
                    }
                }
                break block72;
            }
            retVal.setLiveReader(reader);
            break block72;
            catch (Exception e) {
                block70: {
                    block71: {
                        try {
                            retVal.setLastException(new PathException(e));
                            if (reader != null) break block70;
                            if (is == null) break block71;
                        }
                        catch (Throwable throwable) {
                            if (reader == null) {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException ioe) {
                                        LOGGER.log(Level.WARNING, ioe.getStackTrace()[0].toString(), ioe);
                                    }
                                }
                                if (retVal.getLastException() != null) {
                                    if (lastException != null) {
                                        retVal.setLastException(lastException);
                                    } else {
                                        retVal.setLastException(new PathException(ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", inputFile)));
                                    }
                                }
                            } else {
                                retVal.setLiveReader(reader);
                            }
                            throw throwable;
                        }
                        try {
                            is.close();
                        }
                        catch (IOException ioe) {
                            LOGGER.log(Level.WARNING, ioe.getStackTrace()[0].toString(), ioe);
                        }
                    }
                    if (retVal.getLastException() != null) {
                        if (lastException != null) {
                            retVal.setLastException(lastException);
                        } else {
                            retVal.setLastException(new PathException(ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", inputFile)));
                        }
                    }
                }
                retVal.setLiveReader(reader);
            }
        }
        return retVal;
    }

    public ExecutePathCheckReturn checkMultiplePaths(ISQLCommand cmd) {
        this.cmd = cmd;
        return this.checkMultiplePaths();
    }

    public ExecutePathCheckReturn checkMultiplePaths() {
        ExecutePathCheckReturn retVal;
        String arguments;
        String preAppendInputFile;
        block65: {
            String unQuotedFile;
            boolean found;
            int i;
            String localSql;
            URL topURL;
            URL baseURL;
            String encodingOverride;
            block67: {
                block66: {
                    preAppendInputFile = "";
                    arguments = null;
                    retVal = null;
                    encodingOverride = this.getScriptRunnerContext().getEncoding();
                    baseURL = (URL)this.getScriptRunnerContext().getProperty("script.runner.base.url");
                    if (this.getScriptRunnerContext().getTopLevel()) {
                        this.getScriptRunnerContext().putProperty("script.runner.topbase.url", baseURL);
                    }
                    topURL = (URL)this.getScriptRunnerContext().getProperty("script.runner.topbase.url");
                    boolean callFile = false;
                    localSql = "";
                    i = 0;
                    if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_START) {
                        localSql = this.cmd.getSql();
                        if ((localSql = localSql.trim()).toLowerCase().equals("start")) {
                            this.report(this.getScriptRunnerContext(), "");
                        } else {
                            found = false;
                            for (i = 0; i < localSql.length(); ++i) {
                                char nextChar = localSql.charAt(i);
                                if (!Character.isWhitespace(nextChar) && nextChar != '\'' && nextChar != '\"') continue;
                                found = true;
                                break;
                            }
                            if (found) {
                                localSql = localSql.substring(i).trim();
                                callFile = true;
                            }
                        }
                    } else if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_AT) {
                        if (this.cmd.getSql().trim().startsWith("@@")) {
                            this.cmd.setStmtId(SQLCommand.StmtSubType.G_S_ATNESTED);
                        } else {
                            localSql = this.cmd.getSql();
                            if ((localSql = localSql.trim()).length() == 1) {
                                this.report(this.getScriptRunnerContext(), "");
                            } else {
                                if ((localSql = localSql.substring(1).trim()).startsWith("~")) {
                                    localSql = localSql.replaceFirst("~", System.getProperty("user.home"));
                                }
                                callFile = true;
                            }
                        }
                    }
                    if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_ATNESTED) {
                        localSql = this.cmd.getSql();
                        if ((localSql = localSql.trim()).length() != 2) {
                            localSql = localSql.substring(2).trim();
                            callFile = true;
                        }
                    }
                    if (!callFile) break block65;
                    found = false;
                    unQuotedFile = null;
                    String endString = "";
                    if (localSql.length() <= 1 || !localSql.startsWith("\"") && !localSql.startsWith("'")) break block66;
                    endString = new Character(localSql.charAt(0)).toString();
                    int indexOfSecond = localSql.substring(1).indexOf(endString);
                    if (indexOfSecond == -1) break block67;
                    unQuotedFile = localSql.substring(1, indexOfSecond + 1);
                    i = indexOfSecond + 2;
                    break block67;
                }
                for (i = 0; i < localSql.length(); ++i) {
                    if (!Character.isWhitespace(localSql.charAt(i))) continue;
                    found = true;
                    break;
                }
            }
            if (found || localSql.length() != 0) {
                int dot;
                String inputFile = "";
                if (found || unQuotedFile != null) {
                    if (unQuotedFile != null) {
                        inputFile = unQuotedFile;
                        if (localSql.length() > i) {
                            arguments = localSql.substring(i).trim();
                        }
                    } else {
                        inputFile = localSql.substring(0, i);
                        if (localSql.length() > i + 1) {
                            arguments = localSql.substring(i).trim();
                        }
                    }
                } else {
                    inputFile = localSql;
                }
                if (inputFile.contains("$") || inputFile.contains("%")) {
                    inputFile = ScriptUtils.replaceEnvVars(inputFile);
                }
                if (inputFile.startsWith("?") && inputFile.length() > 1) {
                    String OH = System.getenv("ORACLE_HOME");
                    if (OH == null) {
                        OH = "?";
                    }
                    if (OH.endsWith(File.separator)) {
                        OH = OH.substring(0, OH.length() - 1);
                    }
                    inputFile = OH + inputFile.substring(1);
                }
                int filesep = inputFile.lastIndexOf("/");
                int filesepBack = inputFile.lastIndexOf("\\");
                if (filesepBack > filesep) {
                    filesep = filesepBack;
                }
                if ((dot = inputFile.lastIndexOf(46)) <= filesep && !this.getScriptRunnerContext().getProperty("script.runner.file.suffix").equals("")) {
                    inputFile = inputFile + "." + this.getScriptRunnerContext().getProperty("script.runner.file.suffix");
                }
                preAppendInputFile = inputFile;
                boolean prependDirectory = false;
                if (!(FileUtils.startsWithHttpOrFtp(inputFile) || inputFile.startsWith("/") || inputFile.startsWith("\\"))) {
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        if (inputFile.length() <= 3 || (inputFile.charAt(1) != ':' || inputFile.charAt(2) != '/' && inputFile.charAt(2) != '\\') && (inputFile.charAt(0) != '/' || inputFile.charAt(2) != ':' || inputFile.charAt(3) != '/')) {
                            prependDirectory = true;
                        }
                    } else if (!inputFile.startsWith("/") && !inputFile.startsWith("\\")) {
                        prependDirectory = true;
                    }
                }
                if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_ATNESTED) {
                    String uRLString = null;
                    boolean slashCase = false;
                    if (prependDirectory) {
                        String possibleMatch = null;
                        if (this.getDirectory() != null) {
                            possibleMatch = this.getDirectory().endsWith("/") || this.getDirectory().endsWith("\\") ? this.getDirectory() + inputFile : this.getDirectory() + File.separator + inputFile;
                        }
                        if (possibleMatch != null && FileUtils.startsWithHttpOrFtp(possibleMatch)) {
                            if (FileUtils.haveIBytes(possibleMatch, this.getScriptRunnerContext())) {
                                uRLString = possibleMatch.replace("\\", "/");
                            } else if (this.getDirectory().indexOf("\\") != -1 && FileUtils.haveIBytesRaw(possibleMatch.replace("/", "\\"))) {
                                uRLString = possibleMatch.replace("/", "\\");
                            } else {
                                prependDirectory = false;
                                slashCase = true;
                            }
                        } else if (possibleMatch != null && new File(possibleMatch.replace("/", "\\")).exists()) {
                            prependDirectory = true;
                        } else if (possibleMatch != null && new File(possibleMatch.replace("\\", "/")).exists()) {
                            prependDirectory = true;
                        } else {
                            prependDirectory = false;
                            slashCase = true;
                        }
                    }
                    if (uRLString != null) {
                        inputFile = uRLString;
                    } else if (prependDirectory && this.getDirectory() != null && !this.getDirectory().equals("")) {
                        inputFile = this.getDirectory().endsWith("/") || this.getDirectory().endsWith("\\") ? this.getDirectory() + inputFile : this.getDirectory() + File.separator + inputFile;
                    }
                    prependDirectory = false;
                    if (slashCase) {
                        prependDirectory = true;
                    }
                }
                if (prependDirectory) {
                    String encoding = encodingOverride;
                    retVal = this.checkPath(false, false, false, (String)this.getScriptRunnerContext().getProperty("script.runner.cd_command"), null, inputFile, encoding, null);
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(false, false, false, null, baseURL, inputFile, encoding, null);
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(false, false, false, null, topURL, inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(false, false, false, null, this.useIfNotDirectoryOrNotFile(this.getScriptRunnerContext().getLastNodeForDirNameURL()), inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(true, false, false, null, this.useIfDirectoryOrNotFile(this.getScriptRunnerContext().getLastNodeForDirNameURL()), inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(false, false, false, null, this.useIfNotDirectoryOrNotFile(this.getScriptRunnerContext().getLastDirNameURL()), inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(true, false, false, null, this.useIfDirectoryOrNotFile(this.getScriptRunnerContext().getLastDirNameURL()), inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(false, true, false, (String)this.getScriptRunnerContext().getProperty("DBConfig.DEFAULT_PATH"), null, inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null && SQLPLUS.getSqlpathProvider() != null) {
                        retVal = this.checkPath(false, true, false, SQLPLUS.getSqlpathProvider().getSQLPATHsetting(), null, inputFile, encoding, retVal.getLastException());
                    }
                    if (this.getScriptRunnerContext().getProperty("script.runner.jline") != null) {
                        if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                            retVal = this.checkPath(false, false, true, null, null, inputFile, encoding, retVal.getLastException());
                        }
                        if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                            retVal = this.checkPath(false, false, true, null, null, inputFile, encoding, retVal.getLastException());
                        }
                    }
                }
                if (retVal == null) {
                    retVal = this.checkPath(false, false, true, null, null, inputFile, encodingOverride, null);
                }
            }
        }
        if (retVal != null) {
            retVal.setArguments(arguments);
            retVal.setPreAppendInputFile(preAppendInputFile);
        }
        return retVal;
    }

    URL useIfDirectoryOrNotFile(URL inURL) {
        if (inURL == null) {
            return null;
        }
        if (inURL.getProtocol() == null || !inURL.getProtocol().toLowerCase().endsWith("file")) {
            return inURL;
        }
        try {
            if (new File(inURL.getFile()).isDirectory()) {
                return inURL;
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    URL useIfNotDirectoryOrNotFile(URL inURL) {
        if (inURL == null) {
            return null;
        }
        if (inURL.getProtocol() == null || !inURL.getProtocol().toLowerCase().endsWith("file")) {
            return inURL;
        }
        try {
            if (new File(inURL.getFile()).isDirectory()) {
                return null;
            }
            return inURL;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExecuteFile() {
        if (this.getScriptRunnerContext().isStdin()) {
            this.getScriptRunnerContext().putProperty("script.runner.sqlcl.stdin.input.was.on", Boolean.TRUE);
        }
        this.getScriptRunnerContext().putProperty("script.runner.sqlcl.stdin.input", Boolean.FALSE);
        this.getScriptRunnerContext().putProperty("script.runner.sqlcl.execute.file", Boolean.TRUE);
        if (this.getScriptRunnerContext().getRestrictedLevel().getLevel() > 2) {
            this.getScriptRunnerContext().write(MessageFormat.format(Messages.getString("SQLPLUS.9"), "start"));
            this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), MessageFormat.format(Messages.getString("SQLPLUS.9"), "start"), this.cmd.getSql());
            return;
        }
        Integer localDepth = 0;
        boolean localTopLevel = this.getScriptRunnerContext().getTopLevel();
        localDepth = this.getScriptRunnerContext().getTopLevel() || this.getScriptRunnerContext().getProperty("script.runner.script_depth") == null ? Integer.valueOf(1) : (Integer)this.getScriptRunnerContext().getProperty("script.runner.script_depth");
        URL baseURL = (URL)this.getScriptRunnerContext().getProperty("script.runner.base.url");
        String previousInputFile = this.getScriptRunnerContext().getSourceRef();
        ExecutePathCheckReturn retVal = this.checkMultiplePaths(this.cmd);
        if (retVal != null && (retVal.getLiveReader() != null || retVal.getUrl() != null)) {
            try {
                this._runner = retVal.getLiveReader() != null ? new ScriptExecutor(retVal.getLiveReader(), this.conn) : (this.getScriptRunnerContext().getEncoding() != null ? new ScriptExecutor(retVal.getUrl(), this.conn, this.getScriptRunnerContext().getEncoding()) : new ScriptExecutor(retVal.getUrl(), this.conn));
                String[] parserArgs = ScriptUtils.executeArgs(retVal.getArguments());
                if (parserArgs != null) {
                    for (int argCount = 0; argCount < parserArgs.length; ++argCount) {
                        Map<String, String> m = this.getScriptRunnerContext().getMap();
                        m.put(Integer.toString(argCount + 1), parserArgs[argCount]);
                    }
                }
                this._runner.setOut(this.out);
                if (localDepth < 20) {
                    this.getScriptRunnerContext().putProperty("script.runner.script_depth", localDepth + 1);
                    this.getScriptRunnerContext().setTopLevel(false);
                    this._runner.setScriptRunnerContext(this.getScriptRunnerContext());
                    Object pathval = null;
                    String inputFile = retVal.getOutputFile();
                    inputFile = retVal.getUrl() == null ? retVal.getOutputFile() : retVal.getUrl().toString();
                    SQLPLUS.setExecutorPath(this._runner, inputFile, this.getScriptRunnerContext());
                    ArrayList scrArrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
                    scrArrayList.add(retVal.getPreAppendInputFile());
                    this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", scrArrayList);
                    if (scrArrayList.size() != 0) {
                        SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
                    }
                    this._runner.run();
                    this.getScriptRunnerContext().removeProperty("script.runner.sqlcl.execute.file");
                    if (baseURL != null) {
                        this.getScriptRunnerContext().putProperty("script.runner.base.url", baseURL);
                    }
                    if ((scrArrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist")).size() != 0) {
                        scrArrayList.remove(scrArrayList.size() - 1);
                    }
                    this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", scrArrayList);
                    if (scrArrayList.size() != 0) {
                        SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
                    } else {
                        SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), PRODUCT_NAME, 0);
                    }
                    this.setScriptRunnerContext(this._runner.getScriptRunnerContext());
                    this.setConn(this._runner.getScriptRunnerContext().getCurrentConnection());
                }
                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString("MAX_NEST"), this.getScriptRunnerContext()));
            }
            catch (FileNotFoundException fnfe) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", retVal.getPreAppendInputFile()), this.getScriptRunnerContext()));
                this.doWhenever(false);
            }
            catch (IOException ioe) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", retVal.getPreAppendInputFile()), this.getScriptRunnerContext()));
                this.doWhenever(false);
            }
            catch (ArgumentQuoteException aqe) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("QUOTEMISMATCH", aqe.getMessage()), this.getScriptRunnerContext()));
                this.doWhenever(false);
            }
            finally {
                this.getScriptRunnerContext().setTopLevel(localTopLevel);
                this.getScriptRunnerContext().putProperty("script.runner.script_depth", localDepth);
                this.getScriptRunnerContext().setSourceRef(previousInputFile);
                if (retVal != null && retVal.getLiveReader() != null) {
                    try {
                        retVal.getLiveReader().close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    }
                }
            }
        } else if (retVal != null) {
            if (retVal.getLastException() != null) {
                LOGGER.log(Level.FINE, retVal.getLastException().getStackTrace()[0].toString(), retVal.getLastException());
            }
            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", retVal.getPreAppendInputFile()), this.getScriptRunnerContext()));
            this.doWhenever(false);
        } else if (this.cmd.getModifiedSQL().toLowerCase().equals("@@")) {
            this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("INVALID_FILE_NAME"));
        } else {
            this.getScriptRunnerContext().write(ScriptRunnerDbArb.getString("INVALID_ARGUMENTS") + m_lineSeparator);
        }
        this.getScriptRunnerContext().removeProperty("script.runner.sqlcl.execute.file");
    }

    public static void setExecutorPath(ScriptExecutor runner, String inputFileOrUrl, ScriptRunnerContext ctx) throws IOException {
        String inputFile = inputFileOrUrl;
        if (new File(inputFile).exists()) {
            String pathval = new File(inputFile).getCanonicalPath();
            int ii = pathval.lastIndexOf("/");
            int iislash = pathval.lastIndexOf("\\");
            if (iislash > ii) {
                ii = iislash;
            }
            runner.getScriptRunnerContext().setSourceRef(pathval);
            pathval = pathval.substring(0, ii);
            runner.setDirectory(pathval);
        } else if (FileUtils.startsWithHttpOrFtp(inputFile) && FileUtils.haveIBytes(inputFile, ctx)) {
            String localInputFile = inputFile.replace("\\", "/");
            runner.getScriptRunnerContext().setSourceRef(localInputFile);
            int ii = localInputFile.lastIndexOf("/");
            int iib = localInputFile.lastIndexOf("\\");
            if (iib > ii) {
                ii = iib;
            }
            localInputFile = localInputFile.substring(0, ii);
            runner.setDirectory(localInputFile);
        } else if (FileUtils.startsWithHttpOrFtp(inputFile) && FileUtils.haveIBytesRaw(inputFile)) {
            String localInputFile = inputFile.replace("/", "\\");
            runner.getScriptRunnerContext().setSourceRef(localInputFile);
            int ii = localInputFile.lastIndexOf("/");
            int iib = localInputFile.lastIndexOf("\\");
            if (iib > ii) {
                ii = iib;
            }
            localInputFile = localInputFile.substring(0, ii);
            runner.setDirectory(localInputFile);
        } else {
            runner.getScriptRunnerContext().setSourceRef("");
            runner.setDirectory("");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL joinUrl(boolean tryUrlAsDir, URL inURL, String inputf) {
        try {
            if (inURL == null || inputf == null) {
                return null;
            }
            String urlString = inURL.toString();
            int lasts = urlString.lastIndexOf("/");
            int lastbs = urlString.lastIndexOf("\\");
            if (tryUrlAsDir) {
                if (lastbs > lasts) {
                    urlString = urlString + "\\" + inputf.replace("/", "\\");
                    return new URL(urlString);
                } else {
                    if (lasts <= lastbs) return null;
                    urlString = urlString + "/" + inputf.replace("\\", "/");
                }
                return new URL(urlString);
            } else if (lastbs > lasts) {
                urlString = urlString.substring(0, lastbs + 1) + inputf.replace("/", "\\");
                return new URL(urlString);
            } else {
                if (lasts <= lastbs) return null;
                urlString = urlString.substring(0, lasts + 1) + inputf.replace("\\", "/");
            }
            return new URL(urlString);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean haveIBytes(URL tryNextURL) {
        if (tryNextURL != null) {
            InputStream is = null;
            URLConnection c = null;
            try {
                c = tryNextURL.openConnection();
                is = c.getInputStream();
                if (is.read() != -1) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (MalformedURLException e1) {
                boolean bl = false;
                return bl;
            }
            catch (IOException e1) {
                boolean bl = false;
                return bl;
            }
            catch (Exception e2) {
                boolean bl = false;
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return false;
        }
        return false;
    }

    private InputStream getInputStream(String base) {
        if (!FileUtils.startsWithHttpOrFtp(base)) {
            return null;
        }
        InputStream is = null;
        URLConnection c = null;
        try {
            String lower = base.toLowerCase();
            if (FileUtils.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            boolean wasException = false;
            try {
                c = new URL(base.replace("\\", "/")).openConnection();
            }
            catch (MalformedURLException e1) {
                wasException = true;
            }
            catch (IOException e1) {
                wasException = true;
            }
            if (wasException) {
                c = new URL(base.replace("//", "\\")).openConnection();
            }
            is = c.getInputStream();
        }
        catch (MalformedURLException e1) {
            return null;
        }
        catch (IOException e1) {
            return null;
        }
        return is;
    }

    private void runPrompt() {
        String localSql = this.cmd.getSql();
        localSql = localSql.trim();
        boolean found = false;
        int i = 0;
        for (i = 0; i < localSql.length(); ++i) {
            if (!Character.isWhitespace(localSql.charAt(i))) continue;
            found = true;
            break;
        }
        if (found) {
            this.report(this.getScriptRunnerContext(), localSql.substring(i).trim());
        } else {
            this.report(this.getScriptRunnerContext(), "");
        }
    }

    private void runPrint() {
        BindPrinter printer = new BindPrinter(this.getScriptRunnerContext(), this.out, this.getCmd());
        printer.runPrint();
    }

    private int indexOfFirstWhitespace(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isWhitespace(value.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runVariable() {
        String[] stringArray = this.nextWordAndRest(this.cmd.getSql());
        if (stringArray[1].trim().equals("")) {
            Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
            Set<String> s = m.keySet();
            Map<String, Bind> map = m;
            synchronized (map) {
                Iterator<String> i = s.iterator();
                if (i.hasNext()) {
                    while (i.hasNext()) {
                        String nextKey = i.next();
                        Bind bind = m.get(nextKey);
                        String type = bind.getType();
                        String datatypeBracket = bind.getBracket();
                        String type2Show = datatypeBracket != null ? datatypeBracket : type;
                        String msg = "variable {0}\ndatatype {1}\n";
                        msg = MessageFormat.format(msg, bind.getPrintBind(), type2Show);
                        this.report(this.getScriptRunnerContext(), msg);
                    }
                } else {
                    this.report(this.getScriptRunnerContext(), "SP2-0568: No bind variables declared.\n");
                    this.getScriptRunnerContext().errorLog("", "SP2-0568: No bind variables declared.", this.cmd.getSql());
                }
            }
        }
        String localSubName = "";
        if (this.indexOfFirstWhitespace(stringArray[1]) == -1) {
            Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
            Set<String> s = m.keySet();
            Iterator<String> i = s.iterator();
            boolean found = false;
            while (i.hasNext()) {
                String nextKey = i.next();
                if (!stringArray[1].toLowerCase().equals(nextKey.toLowerCase())) continue;
                Bind bind = m.get(nextKey);
                String type = bind.getType();
                String datatypeBracket = bind.getBracket();
                String type2Show = datatypeBracket != null ? datatypeBracket : type;
                String msg = "variable {0}\ndatatype {1}\n";
                msg = MessageFormat.format(msg, bind.getPrintBind(), type2Show);
                this.report(this.getScriptRunnerContext(), msg);
                found = true;
            }
            if (!found) {
                String msg = ScriptRunnerDbArb.format("UNDECLARED_VARIABLE", stringArray[1]);
                this.report(this.getScriptRunnerContext(), msg);
                this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), msg, this.cmd.getSql());
            }
        } else {
            localSubName = stringArray[1].substring(0, this.indexOfFirstWhitespace(stringArray[1])).trim();
            String dataTypeString = "";
            dataTypeString = stringArray[1].substring(this.indexOfFirstWhitespace(stringArray[1]) + 1).trim();
            String[] typeNValue = dataTypeString.split("=");
            String dataType = typeNValue[0];
            String varValue = "";
            if (typeNValue.length > 1) {
                varValue = typeNValue[1];
            }
            String dataTypeBracket = this.validVariableDatatype(dataType, true);
            dataType = this.validVariableDatatype(dataType, false);
            if (Character.isLetter(localSubName.charAt(0))) {
                try {
                    if (dataTypeBracket == null || dataType == null || dataTypeBracket.replace(dataType, "").trim().equals("(0)")) {
                        String msg = ScriptRunnerDbArb.format("ILLEGAL_USAGE", localSubName);
                        this.report(this.getScriptRunnerContext(), msg);
                        this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), msg, this.cmd.getSql());
                        return;
                    }
                    if (dataTypeBracket != null || dataType != null) {
                        String num_dtype = dataTypeBracket.replaceFirst(dataType, "").replace("(", "").replace(")", "").trim();
                        String[] dtype = num_dtype.split(" ");
                        if (dataTypeBracket.indexOf("(") != -1 && dtype.length > 0) {
                            long size = Long.parseLong(dtype[0].trim());
                            if (dtype.length > 1) {
                                String dataTypeLower = dataType.toLowerCase(Locale.US);
                                String second = dtype[1];
                                second = second != null ? second.toLowerCase(Locale.US) : "";
                                if (dtype.length > 2 || !dataTypeLower.equals("char") && !dataTypeLower.equals("varchar2") || !second.equals("byte") && !second.equals("char")) {
                                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("ILLEGAL_USAGE", localSubName));
                                    this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), ScriptRunnerDbArb.format("ILLEGAL_USAGE", localSubName), this.cmd.getSql());
                                    return;
                                }
                                if (dtype[1].trim().equalsIgnoreCase("char") || dtype[1].trim().equalsIgnoreCase("byte")) {
                                    if (size > 2000L) {
                                        this.getScriptRunnerContext().write(ScriptRunnerDbArb.getString("INVALID_VARIABLE_LENGTH") + m_lineSeparator);
                                        return;
                                    }
                                    if (size < 1L) {
                                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("ILLEGAL_USAGE", localSubName));
                                        return;
                                    }
                                }
                            }
                        }
                        if (typeNValue.length > 1) {
                            // empty if block
                        }
                        Bind bind = new Bind(localSubName.toUpperCase(), dataType.toUpperCase(), dataTypeBracket.toUpperCase(), localSubName, typeNValue.length > 1 ? typeNValue[1].replaceAll("^\"|\"$|^'|'$", "") : null, localSubName);
                        bind.setPrintBind(localSubName);
                        Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
                        m.put(localSubName.toUpperCase(), bind);
                    }
                }
                catch (NumberFormatException e) {
                    this.getScriptRunnerContext().write(ScriptRunnerDbArb.getString("INVALID_VARIABLE_LENGTH") + m_lineSeparator);
                }
            } else {
                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("ILLEGAL_VARIABLE", localSubName));
            }
        }
    }

    private boolean containsNoBackSlash(String check) {
        if (Aliases.getInstance().contains(check)) {
            return true;
        }
        String checkNoBSlash = check.replace("\\", "");
        ArrayList<String> aliases = Aliases.getInstance().getAliases();
        for (String curAlias : aliases) {
            if (!curAlias.replace("\\", "").equals(checkNoBSlash)) continue;
            return true;
        }
        return false;
    }

    private Alias getNoBackslash(String check) {
        Alias a = Aliases.getInstance().get(check);
        if (a != null) {
            return a;
        }
        String checkNoBSlash = check.replace("\\", "");
        ArrayList<String> aliases = Aliases.getInstance().getAliases();
        for (String curAlias : aliases) {
            if (!curAlias.replace("\\", "").equals(checkNoBSlash)) continue;
            return Aliases.getInstance().get(curAlias);
        }
        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "SQLPLUS.getNoBackslash:null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runAliases() throws ArgumentQuoteException {
        if (!this.getScriptRunnerContext().isProductNameSQLDeveloper() && !this.getScriptRunnerContext().isProductNameSQLcl()) {
            return false;
        }
        String localSql = this.cmd.getSql().trim();
        String[] tokens = localSql.split("\\s+");
        String command = "";
        String args = "";
        if (tokens.length > 0) {
            Alias textFlag;
            String trim;
            String theText = "";
            boolean theNulls = false;
            if (tokens.length > 1 && this.containsNoBackSlash(tokens[0] + tokens[1])) {
                command = tokens[0] + tokens[1];
                if (tokens.length > 2) {
                    trim = this.cmd.getSql().trim();
                    trim = trim.substring(trim.indexOf(tokens[0]) + tokens[0].length()).trim();
                    args = trim.substring(trim.indexOf(tokens[1]) + tokens[1].length()).trim();
                }
                textFlag = this.getNoBackslash(command);
                theText = textFlag.getQuery();
                theNulls = textFlag.isNullDefaults();
            } else if (this.containsNoBackSlash(tokens[0])) {
                command = tokens[0];
                if (tokens.length > 1) {
                    trim = this.cmd.getSql().trim();
                    args = trim.substring(trim.indexOf(tokens[0]) + tokens[0].length()).trim();
                }
                textFlag = this.getNoBackslash(command);
                theText = textFlag.getQuery();
                theNulls = textFlag.isNullDefaults();
            }
            if (theText != null && !theText.equals("")) {
                ArrayList<String> bindsToBeRemoved = new ArrayList<String>();
                ArrayList<String> bindsSetToNull = new ArrayList<String>();
                String errorMessage = "";
                Integer localDepth = 0;
                String localSourceRef = this.getScriptRunnerContext().getSourceRef();
                boolean localTopLevel = this.getScriptRunnerContext().getTopLevel();
                localDepth = this.getScriptRunnerContext().getTopLevel() || this.getScriptRunnerContext().getProperty("script.runner.script_depth") == null ? Integer.valueOf(1) : (Integer)this.getScriptRunnerContext().getProperty("script.runner.script_depth");
                Boolean lastEOF = (Boolean)this.getScriptRunnerContext().getProperty("sqcl.alias.end_statement_on_eof");
                if (lastEOF == null) {
                    lastEOF = Boolean.FALSE;
                }
                try {
                    String[] parserArgs;
                    this.getScriptRunnerContext().putProperty("sqcl.alias.end_statement_on_eof", Boolean.TRUE);
                    ScriptParser sp = new ScriptParser(theText);
                    if (this.getScriptRunnerContext().isCommandLine()) {
                        sp.setScriptRunnerContext(this.getScriptRunnerContext());
                    }
                    if ((parserArgs = ScriptUtils.executeArgs(args)) == null) {
                        parserArgs = new String[]{};
                    }
                    int nextArg = 0;
                    ISQLCommand icmd = null;
                    String startNoBinds = "";
                    boolean startNoBindsInit = false;
                    if (this.getScriptRunnerContext().getVarMap().containsKey(SPECIALBINDFORALIASNULLS)) {
                        startNoBinds = this.getScriptRunnerContext().getVarMap().get(SPECIALBINDFORALIASNULLS).getValue();
                    } else {
                        startNoBindsInit = true;
                    }
                    while ((icmd = sp.next()) != null) {
                        try {
                            ArrayList<Bind> parserdBinds = Parser.getInstance().getBinds(icmd.getSql(), false);
                            for (Bind bind : parserdBinds) {
                                Bind bind2;
                                if (this.getScriptRunnerContext().getVarMap().containsKey(bind.getName().toUpperCase()) || bind.getName().equals(SPECIALBINDFORALIASNULLS)) continue;
                                if (nextArg < parserArgs.length) {
                                    bind2 = new Bind(bind.getName().toUpperCase(), "VARCHAR2", "VARCHAR2(1000)", bind.getName().toUpperCase(), parserArgs[nextArg], bind.getName().toUpperCase());
                                    ++nextArg;
                                    this.getScriptRunnerContext().getVarMap().put(bind.getName().toUpperCase(), bind2);
                                    bindsToBeRemoved.add(bind.getName().toUpperCase());
                                    continue;
                                }
                                if (!theNulls) {
                                    errorMessage = ScriptRunnerDbArb.getString("ALIASWITHBINDS_NOTENOUGH");
                                    continue;
                                }
                                bind2 = new Bind(bind.getName().toUpperCase(), "VARCHAR2", "VARCHAR2(1000)", bind.getName().toUpperCase(), "", bind.getName().toUpperCase());
                                this.getScriptRunnerContext().getVarMap().put(bind.getName().toUpperCase(), bind2);
                                bindsToBeRemoved.add(bind.getName().toUpperCase());
                                bindsSetToNull.add(bind.getName().toUpperCase());
                            }
                            String special = " ";
                            for (String bindset : bindsSetToNull) {
                                special = special + ":" + bindset + " ";
                            }
                            Bind bind = new Bind(SPECIALBINDFORALIASNULLS, "VARCHAR2", "VARCHAR2(1000)", SPECIALBINDFORALIASNULLS, special, SPECIALBINDFORALIASNULLS);
                            this.getScriptRunnerContext().getVarMap().put(SPECIALBINDFORALIASNULLS, bind);
                        }
                        catch (Throwable t) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, t.getMessage());
                        }
                    }
                    if (nextArg != parserArgs.length) {
                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("ALIASWITHBINDS_TOOMANY"));
                    }
                    if (localDepth > 20) {
                        errorMessage = this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString()) ? ScriptRunnerDbArb.getString("MAX_NEST_CLASSIC") : ScriptRunnerDbArb.getString("MAX_NEST");
                    }
                    if (errorMessage.equals("")) {
                        this.getScriptRunnerContext().putProperty("script.runner.script_depth", localDepth + 1);
                        this.getScriptRunnerContext().setTopLevel(false);
                        this._runner = new ScriptExecutor(theText, this.conn);
                        this._runner.setOut(this.out);
                        this.getScriptRunnerContext().setSourceRef("/ALIAS/" + tokens[0]);
                        this._runner.setScriptRunnerContext(this.getScriptRunnerContext());
                        this._runner.setDirectory(this.getDirectory());
                        this._runner.run();
                        this.setScriptRunnerContext(this._runner.getScriptRunnerContext());
                        this.setConn(this._runner.getScriptRunnerContext().getCurrentConnection());
                    } else {
                        this.report(this.getScriptRunnerContext(), errorMessage);
                        errorMessage = "";
                    }
                    for (String bindName : bindsToBeRemoved) {
                        this.getScriptRunnerContext().getVarMap().remove(bindName);
                    }
                    if (startNoBindsInit) {
                        this.getScriptRunnerContext().getVarMap().remove(SPECIALBINDFORALIASNULLS);
                    } else {
                        Bind bind = new Bind(SPECIALBINDFORALIASNULLS, "VARCHAR2", "VARCHAR2(1000)", SPECIALBINDFORALIASNULLS, startNoBinds, SPECIALBINDFORALIASNULLS);
                        this.getScriptRunnerContext().getVarMap().put(SPECIALBINDFORALIASNULLS, bind);
                    }
                }
                catch (IOException ioe) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ioe.getLocalizedMessage());
                }
                finally {
                    this.getScriptRunnerContext().putProperty("sqcl.alias.end_statement_on_eof", lastEOF);
                    for (String bindName : bindsToBeRemoved) {
                        this.getScriptRunnerContext().getVarMap().remove(bindName);
                    }
                    this.getScriptRunnerContext().setTopLevel(localTopLevel);
                    this.getScriptRunnerContext().putProperty("script.runner.script_depth", localDepth);
                    this.getScriptRunnerContext().setSourceRef(localSourceRef);
                }
                if (errorMessage != null && !errorMessage.equals("")) {
                    this.report(this.getScriptRunnerContext(), errorMessage);
                }
                return true;
            }
        }
        return false;
    }

    private String runCall(ISQLCommand cmd) {
        String theCommand = cmd.getSql().trim();
        List<LexerToken> src = Lexer.parse(theCommand, false);
        int listLength = src.size();
        boolean callFound = false;
        callFound = listLength > 0 && src.get((int)0).content.trim().equalsIgnoreCase("call");
        boolean openBracketFound = false;
        if (callFound) {
            for (int i = 1; i < src.size(); ++i) {
                if (!src.get((int)i).content.trim().equals("(")) continue;
                openBracketFound = true;
                break;
            }
        }
        boolean closedBracket = false;
        if (openBracketFound) {
            int startAt = src.size() - 1;
            if (startAt > 0 && src.get((int)startAt).content.trim().equals(";")) {
                --startAt;
            }
            String bind = null;
            if (startAt - 1 > 0 && src.get((int)(startAt - 1)).content.trim().equals(":") && startAt - 2 > 0 && src.get((int)(startAt - 2)).content.trim().equalsIgnoreCase("INTO") && startAt - 3 > 0 && src.get((int)(startAt - 3)).content.trim().equals(")")) {
                bind = src.get((int)startAt).content.trim();
            }
            boolean noBindMatch = false;
            boolean bl = noBindMatch = startAt > 0 && src.get((int)startAt).content.trim().equals(")");
            if (bind != null || noBindMatch) {
                LexerToken end = src.get(startAt);
                if (bind != null) {
                    end = src.get(startAt - 3);
                }
                LexerToken start = src.get(1);
                StringBuilder buildNew = new StringBuilder("exec ");
                if (bind != null) {
                    buildNew.append(":").append(bind).append(":=");
                }
                buildNew.append(theCommand.substring(start.begin, end.end)).append(";");
                return buildNew.toString();
            }
        }
        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("CALL_COMMAND"));
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExecute() {
        this.cmd.setSql(SQLPLUS.removeDashNewline(this.cmd, this.cmd.getSql()));
        boolean wasCall = false;
        if (this.cmd.getLoweredTrimmedSQL().startsWith("call")) {
            wasCall = true;
            this.cmd.setStmtType(SQLCommand.StmtType.G_C_SQL);
            String converted = this.runCall(this.cmd);
            if (converted.equals("")) {
                return;
            }
            this.cmd.setSql(converted);
        }
        String localSql = this.cmd.getSql();
        localSql = localSql.trim();
        boolean found = false;
        for (int i = 0; i < localSql.length(); ++i) {
            if (!Character.isWhitespace(localSql.charAt(i))) continue;
            found = true;
            localSql = localSql.substring(i);
            break;
        }
        if (found) {
            String anonymousBlock = "BEGIN" + localSql + (localSql.endsWith(";") ? "" : ";") + " END;";
            Literals2Binds bp = null;
            bp = this.getScriptRunnerContext().getProperty("sqlcl.script.secureliterals") == null ? (this.cmd.getEndLine() - this.cmd.getStartLine() < 20 ? Literals2Binds.bindAid(anonymousBlock) : Literals2Binds.Literals2BindsNull(anonymousBlock)) : (this.getScriptRunnerContext().getProperty("sqlcl.script.secureliterals").equals("ON") ? Literals2Binds.bindAid(anonymousBlock) : Literals2Binds.Literals2BindsNull(anonymousBlock));
            this.cmd.setSql(bp.getSql());
            if (!wasCall) {
                this.cmd.setSQLOrig(anonymousBlock);
            }
            PLSQL plsql = new PLSQL(this.cmd, this.out);
            Map<String, String> bindsMap = bp.getBinds();
            for (String bindName : bindsMap.keySet()) {
                Bind b = new Bind();
                b.setName(bindName);
                b.setType("VARCHAR2");
                b.setValue(bindsMap.get(bindName));
                this.getScriptRunnerContext().getVarMap().put(bindName, b);
            }
            plsql.setScriptRunnerContext(this.getScriptRunnerContext());
            plsql.setConn(this.conn);
            try {
                plsql.run();
            }
            finally {
                for (String bindName : bindsMap.keySet()) {
                    this.getScriptRunnerContext().getVarMap().remove(bindName);
                }
                plsql = null;
            }
        } else if (localSql.trim().toLowerCase().equals("exec") || localSql.trim().toLowerCase().equals("execute")) {
            this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("EXEC_COMMAND"));
        } else {
            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("MALFORMED_EXECUTE_CONTENT", this.cmd.getSql()), this.getScriptRunnerContext()));
        }
    }

    protected String validVariableDatatype(String str, boolean withBracket) {
        String dataTypeRegex = null;
        StringBuilder sb = new StringBuilder();
        sb.append("NUMBER");
        sb.append("|CHAR([\\s]*\\([\\s]*\\d+[\\s]*[CHAR|BYTE]*[\\s]*\\))*");
        sb.append("|NCHAR([\\s]*\\([\\s]*\\d+[\\s]*\\))*");
        sb.append("|VARCHAR2([\\s]*\\([\\s]*\\d+[\\s]*[CHAR|BYTE]*[\\s]*\\))*");
        sb.append("|NVARCHAR2([\\s]*\\([\\s]*\\d+[\\s]*\\))*");
        sb.append("|CLOB");
        sb.append("|NCLOB");
        sb.append("|BLOB");
        sb.append("|BFILE");
        sb.append("|REFCURSOR");
        sb.append("|BINARY_FLOAT");
        sb.append("|BINARY_DOUBLE");
        dataTypeRegex = sb.toString();
        Pattern pat = Pattern.compile(dataTypeRegex);
        Matcher matcher = pat.matcher(str.toUpperCase());
        if (matcher.matches()) {
            String ret = matcher.group();
            if (withBracket && ret.indexOf(")") > 0) {
                return ret.substring(0, ret.indexOf(")") + 1).trim().toUpperCase();
            }
            if (ret.indexOf("(") > 0) {
                return ret.substring(0, ret.indexOf("(")).trim().toUpperCase();
            }
            return ret.trim().toUpperCase();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Connection getConnection(ArrayList<String> urlMessage, String connectName, String connectPassword, String connectDB, String role) {
        String successfulAttempt;
        Connection myconn;
        block105: {
            int n;
            String[] stringArray;
            String withDot;
            String noDot;
            Properties props;
            block109: {
                ArrayList<TCPTNSEntry> myTCPEntry;
                String preExpand;
                int match;
                Boolean useOci;
                block108: {
                    String[] both;
                    block107: {
                        block106: {
                            myconn = null;
                            successfulAttempt = null;
                            props = new Properties();
                            props.setProperty("v$session.program", PRODUCT_NAME);
                            if (connectName != null && connectName.length() > 0) {
                                String[] retVal;
                                String altered = connectName;
                                if (role != null && role.length() > 1 && (retVal = this.nextWordAndRest(role))[0].trim().equalsIgnoreCase("as") && !retVal[1].trim().equalsIgnoreCase("sysdba") && !retVal[1].trim().equalsIgnoreCase("sysoper") && !retVal[1].trim().equalsIgnoreCase("sysasm")) {
                                    altered = altered + " as " + retVal[1].trim().toLowerCase();
                                }
                                props.setProperty("user", altered);
                            }
                            if (connectPassword != null && connectPassword.length() > 0) {
                                props.setProperty("password", connectPassword);
                            }
                            String thirdURL = connectDB;
                            if (connectName != null) {
                                thirdURL = connectPassword != null ? "PASSWORD=" + connectPassword + "]" + thirdURL : "PASSWORD=]" + thirdURL;
                                thirdURL = "[USERNAME=" + connectName + "," + thirdURL;
                            }
                            oracle.dbtools.db.ConnectionDetails cd = null;
                            try {
                                if (!this.hasUrlStub(connectDB)) {
                                    cd = new oracle.dbtools.db.ConnectionDetails(thirdURL);
                                }
                            }
                            catch (Exception e) {
                                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage());
                            }
                            if (cd == null || cd.getDriver() == null) break block106;
                            myconn = cd.getConn();
                            break block105;
                        }
                        if (role != null && role.length() > 1) {
                            String[] retVal = this.nextWordAndRest(role);
                            if (retVal[0].trim().equalsIgnoreCase("as") && retVal[1].trim().equalsIgnoreCase("sysdba")) {
                                props.setProperty("internal_logon", "SYSDBA");
                            }
                            if (retVal[0].trim().equalsIgnoreCase("as") && retVal[1].trim().equalsIgnoreCase("sysoper")) {
                                props.setProperty("internal_logon", "SYSOPER");
                            }
                            if (retVal[0].trim().equalsIgnoreCase("as") && retVal[1].trim().equalsIgnoreCase("sysasm")) {
                                props.setProperty("internal_logon", "SYSASM");
                            }
                        }
                        useOci = (Boolean)this.getScriptRunnerContext().getProperty("DBConfig.USE_THICK_DRIVER");
                        if ((connectDB == null || connectDB.equals("")) && this.getScriptRunnerContext().getProperty("script.runner.jline") != null) {
                            String envValue;
                            String envToCheck = "TWO_TASK";
                            if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                                envToCheck = "LOCAL";
                            }
                            if ((envValue = System.getenv(envToCheck)) != null && !envValue.equals("")) {
                                connectDB = envValue;
                            }
                        }
                        if (connectDB != null && !connectDB.equals("")) break block107;
                        try {
                            String url;
                            Connection lastConn = this.getScriptRunnerContext().getBaseConnection();
                            if (this.getScriptRunnerContext().getCurrentConnection() != null) {
                                lastConn = this.getScriptRunnerContext().getCurrentConnection();
                                if (this.getScriptRunnerContext() != null && this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
                                    lastConn = null;
                                }
                                if (lastConn != null && ScriptUtils.isHttpCon(lastConn, this.getScriptRunnerContext())) {
                                    lastConn = null;
                                }
                            }
                            if (!(lastConn == null || this.getScriptRunnerContext().isCommandLine() && this.getScriptRunnerContext().isSQLPlusClassic())) {
                                url = "";
                                if (LockManager.lock(lastConn)) {
                                    try {
                                        url = lastConn.getMetaData().getURL();
                                    }
                                    finally {
                                        LockManager.unlock(lastConn);
                                    }
                                }
                                myconn = this.logConnectionURL(urlMessage, connectName, url, props, true);
                                break block105;
                            }
                            myconn = null;
                            try {
                                if (useOci.booleanValue()) {
                                    url = "jdbc:oracle:oci8:@";
                                    myconn = this.logConnectionURL(urlMessage, connectName, url, props, useOci, true);
                                }
                            }
                            catch (Throwable url2) {
                                // empty catch block
                            }
                            if (myconn == null) {
                                try {
                                    String oracleSid = System.getenv("ORACLE_SID");
                                    if (oracleSid != null && !oracleSid.equals("")) {
                                        String url3 = "jdbc:oracle:thin:@127.0.0.1:1521:" + System.getenv("ORACLE_SID");
                                        myconn = this.logConnectionURL(urlMessage, connectName, url3, props, true);
                                    }
                                }
                                catch (Throwable oracleSid) {
                                    // empty catch block
                                }
                            }
                            if (myconn == null) {
                                try {
                                    url = "jdbc:oracle:thin:@localhost:1521/orcl";
                                    myconn = this.logConnectionURL(urlMessage, connectName, url, props, false);
                                }
                                catch (Throwable url4) {
                                    // empty catch block
                                }
                            }
                            if (myconn != null) break block105;
                            try {
                                url = "jdbc:oracle:thin:@localhost:1521/xe";
                                myconn = this.logConnectionURL(urlMessage, connectName, url, props, false);
                            }
                            catch (Throwable url5) {}
                            break block105;
                        }
                        catch (SQLException e) {
                            this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", e.getMessage());
                            try {
                                if (myconn != null && !myconn.isClosed()) {
                                    myconn.close();
                                }
                            }
                            catch (SQLException url5) {
                                // empty catch block
                            }
                            myconn = null;
                        }
                        catch (Throwable e) {
                            myconn = null;
                        }
                        break block105;
                    }
                    match = -1;
                    myconn = null;
                    String tryLDAP = null;
                    if (this.getScriptRunnerContext().getProperty("script.runner.ldapcon") != null && ((String)this.getScriptRunnerContext().getProperty("script.runner.ldapcon")).contains("#ENTRY#")) {
                        tryLDAP = ((String)this.getScriptRunnerContext().getProperty("script.runner.ldapcon")).replace("#ENTRY#", connectDB);
                    }
                    if (tryLDAP == null && System.getenv("LDAPCON") != null && System.getenv("LDAPCON").contains("#ENTRY#")) {
                        tryLDAP = System.getenv("LDAPCON").replace("#ENTRY#", connectDB);
                    }
                    if (tryLDAP != null) {
                        try {
                            myconn = this.logConnectionURL(urlMessage, connectName, tryLDAP, props, true);
                        }
                        catch (Throwable url3) {
                            // empty catch block
                        }
                    }
                    preExpand = null;
                    myTCPEntry = null;
                    if (myconn == null && (myTCPEntry = TNSHelper.getTNSEntries()) != null) {
                        for (int i = 0; i < myTCPEntry.size(); ++i) {
                            if (!myTCPEntry.get(i).getName().toUpperCase().equals(connectDB.toUpperCase())) continue;
                            preExpand = connectDB;
                            match = i;
                            break;
                        }
                    }
                    if (match == -1 && connectDB.indexOf("/") == -1 && connectDB.indexOf("\\") == -1 && connectDB.indexOf(":") == -1) {
                        String netVal;
                        String connectDBnoDot = connectDB;
                        int indexdot = connectDBnoDot.indexOf(".");
                        if (indexdot != -1) {
                            connectDBnoDot = connectDBnoDot.substring(0, indexdot);
                        }
                        if (myTCPEntry != null) {
                            for (int i = 0; i < myTCPEntry.size(); ++i) {
                                String theEntry = myTCPEntry.get(i).getName();
                                int indexdot2 = theEntry.indexOf(".");
                                if (indexdot2 != -1) {
                                    theEntry = theEntry.substring(0, indexdot2);
                                }
                                if (!theEntry.toUpperCase().equals(connectDBnoDot.toUpperCase())) continue;
                                match = i;
                                break;
                            }
                        }
                        if (match == -1 && this.getScriptRunnerContext().isCommandLine() && (this.getScriptRunnerContext().getProperty("script.runner.setnet") == null || (String)this.getScriptRunnerContext().getProperty("script.runner.setnet") != null && !((String)this.getScriptRunnerContext().getProperty("script.runner.setnet")).equals("OFF")) && (netVal = NetEntries.getInstance().get(connectDB)) != null) {
                            String lookUp = netVal;
                            if (this.hasUrlStub(lookUp)) {
                                try {
                                    myconn = this.logConnectionURL(urlMessage, connectName, lookUp, props, true);
                                }
                                catch (Throwable ee) {
                                    myconn = null;
                                    this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
                                }
                            } else {
                                try {
                                    if (!useOci.booleanValue()) {
                                        throw new Exception();
                                    }
                                    String url = "jdbc:oracle:oci8:@" + SqlnetInstance.expandForInstance(lookUp);
                                    myconn = this.logConnectionURL(urlMessage, connectName, url, props, true);
                                }
                                catch (Throwable e) {
                                    try {
                                        String url = "jdbc:oracle:thin:@" + SqlnetInstance.expandForInstance(lookUp);
                                        myconn = this.logConnectionURL(urlMessage, connectName, url, props, true);
                                    }
                                    catch (Throwable ee) {
                                        myconn = null;
                                        this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
                                    }
                                }
                            }
                        }
                    }
                    if (useOci == null) {
                        useOci = Boolean.FALSE;
                    }
                    if (match != -1 || myconn != null) break block108;
                    if (this.hasUrlStub(connectDB)) {
                        try {
                            myconn = this.logConnectionURL(urlMessage, connectName, connectDB, props, true);
                        }
                        catch (Throwable ee) {
                            myconn = null;
                            this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
                        }
                    } else {
                        try {
                            if (!useOci.booleanValue()) {
                                throw new Exception();
                            }
                            String url = "jdbc:oracle:oci8:@" + SqlnetInstance.expandForInstance(connectDB);
                            myconn = this.logConnectionURL(urlMessage, connectName, url, props, true);
                            successfulAttempt = connectDB;
                        }
                        catch (Throwable e) {
                            try {
                                String url = "jdbc:oracle:thin:@" + SqlnetInstance.expandForInstance(connectDB);
                                myconn = this.logConnectionURL(urlMessage, connectName, url, props, true);
                                successfulAttempt = connectDB;
                            }
                            catch (Throwable ee) {
                                myconn = null;
                                this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
                            }
                        }
                    }
                    if (myconn != null || this.hasUrlStub(connectDB) || connectDB.indexOf("(") != -1) break block105;
                    String startConnectDB = connectDB;
                    if (!connectDB.matches("^[^:]+\\:[0-9]+\\/.*") && connectDB.indexOf("/") != -1 && connectDB.substring(connectDB.indexOf("/") + 1).indexOf("/") == -1) {
                        connectDB = connectDB.replaceAll("/", ":1521/");
                        try {
                            if (!useOci.booleanValue()) {
                                throw new Exception();
                            }
                            String url = "jdbc:oracle:oci8:@" + connectDB;
                            myconn = this.logConnectionURL(urlMessage, connectName, url, props, true);
                            successfulAttempt = connectDB;
                        }
                        catch (Throwable e) {
                            try {
                                String url = "jdbc:oracle:thin:@" + connectDB;
                                myconn = this.logConnectionURL(urlMessage, connectName, url, props, true);
                                successfulAttempt = connectDB;
                            }
                            catch (Throwable ee) {
                                myconn = null;
                            }
                        }
                    }
                    if (myconn != null || startConnectDB.indexOf(":") != -1 && (startConnectDB.endsWith(":") || startConnectDB.substring(startConnectDB.indexOf(":") + 1).indexOf(":") == -1 || startConnectDB.indexOf("/") != -1)) break block105;
                    noDot = null;
                    withDot = null;
                    String startConnectDB2 = null;
                    try {
                        InetAddress addr = InetAddress.getByAddress(InetAddress.getByName(startConnectDB).getAddress());
                        startConnectDB2 = addr.getCanonicalHostName();
                    }
                    catch (UnknownHostException uhe) {
                        startConnectDB2 = null;
                    }
                    stringArray = both = new String[]{startConnectDB, startConnectDB2};
                    n = stringArray.length;
                    break block109;
                }
                if (myconn != null) break block105;
                if (this.hasUrlStub(myTCPEntry.get(match).getSpecUrl())) {
                    try {
                        myconn = this.logConnectionURL(urlMessage, connectName, myTCPEntry.get(match).getSpecUrl(), props, true);
                    }
                    catch (Throwable ee) {
                        myconn = null;
                        this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
                    }
                    break block105;
                } else {
                    try {
                        if (!useOci.booleanValue()) {
                            throw new Exception();
                        }
                        String url = "";
                        url = preExpand == null || preExpand.equals("") ? "jdbc:oracle:oci8:@" + SqlnetInstance.expandForInstance(myTCPEntry.get(match).getSpecUrl()) : "jdbc:oracle:oci8:@" + preExpand;
                        myconn = this.logConnectionURL(urlMessage, connectName, url, props, true);
                    }
                    catch (Throwable e) {
                        try {
                            String url = "";
                            url = preExpand == null || preExpand.equals("") ? "jdbc:oracle:thin:@" + SqlnetInstance.expandForInstance(myTCPEntry.get(match).getSpecUrl()) : "jdbc:oracle:thin:@" + preExpand;
                            myconn = this.logConnectionURL(urlMessage, connectName, url, props, true);
                            break block105;
                        }
                        catch (SQLException e2) {
                            if (useOci.booleanValue()) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ScriptRunnerDbArb.getString("OCI_FAILED_TRYING_THIN"));
                            }
                            this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", e2.getMessage());
                            if (myconn == null) break block105;
                            try {
                                myconn.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            myconn = null;
                            break block105;
                        }
                        catch (Throwable ee) {
                            myconn = null;
                        }
                    }
                }
                break block105;
            }
            for (int i = 0; i < n; ++i) {
                String url;
                String ident = stringArray[i];
                if (ident == null) continue;
                if (myconn != null) break;
                noDot = ident.indexOf(".") == -1 ? ident : ident.substring(0, ident.indexOf("."));
                boolean onlyNumber = true;
                try {
                    Integer.parseInt(noDot);
                }
                catch (NumberFormatException nfe) {
                    onlyNumber = false;
                }
                try {
                    if (!onlyNumber) {
                        url = "jdbc:oracle:thin:@" + ident + ":1521/" + noDot;
                        myconn = this.logConnectionURL(urlMessage, connectName, url, props, false);
                        successfulAttempt = ident + ":1521/" + noDot;
                    }
                }
                catch (Throwable ee) {
                    myconn = null;
                }
                if (myconn != null || ident.indexOf(".") == -1) continue;
                withDot = ident;
                try {
                    if (onlyNumber) continue;
                    url = "jdbc:oracle:thin:@" + ident + ":1521/" + withDot;
                    myconn = this.logConnectionURL(urlMessage, connectName, url, props, false);
                    successfulAttempt = ident + ":1521/" + withDot;
                    continue;
                }
                catch (Throwable ee) {
                    myconn = null;
                }
            }
        }
        Boolean prelim = (Boolean)this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH");
        if (prelim == null || prelim.equals(Boolean.FALSE)) {
            SQLPLUS.setupNLS(myconn, this.getScriptRunnerContext());
        }
        if (myconn != null) {
            if (successfulAttempt != null && this.getScriptRunnerContext().isCommandLine() && (this.getScriptRunnerContext().getProperty("script.runner.setnet") == null || (String)this.getScriptRunnerContext().getProperty("script.runner.setnet") != null && !((String)this.getScriptRunnerContext().getProperty("script.runner.setnet")).equals("READONLY"))) {
                NetCommand.add(this.getScriptRunnerContext(), (String)this.getScriptRunnerContext().getProperty("script.runner.setnetoverwrite"), successfulAttempt, successfulAttempt, false);
            }
            this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", null);
        }
        return myconn;
    }

    private Connection connect(String urlin, Properties props) throws SQLException {
        ScriptRunnerContext ctx;
        String url = urlin;
        if (this.getScriptRunnerContext().getProperty("script.runner.jline") != null && url != null && (url.startsWith("http:") || url.startsWith("https:"))) {
            url = "jdbc:oracle:orest@" + url;
        }
        if (url != null && (url.startsWith("http:") || url.startsWith("https:") || url.startsWith("jdbc:oracle:orest")) && !url.endsWith("/") && url.indexOf(63) == -1) {
            url = url + "/";
        }
        if ((ctx = this.getScriptRunnerContext()) != null) {
            ctx.putProperty("cli.conn.url", url);
            ctx.putProperty("cli.conn.props", props);
        }
        boolean doDebug = false;
        if (url != null && (url.startsWith("http:") || url.startsWith("https:") || url.startsWith("jdbc:oracle:orest"))) {
            doDebug = true;
        }
        if (!doDebug || url.startsWith("jdbc:oracle:orest")) {
            // empty if block
        }
        Connection forReturn = DriverManager.getConnection(url, props);
        if (doDebug) {
            oracle.dbtools.util.Logger.info(this.getClass(), "Connection got, class:" + forReturn.getClass());
        }
        return forReturn;
    }

    private Connection preDebconnect(String url, Properties props) throws SQLException {
        ScriptRunnerContext ctx = this.getScriptRunnerContext();
        if (ctx != null) {
            ctx.putProperty("cli.conn.url", url);
            ctx.putProperty("cli.conn.props", props);
        }
        return DriverManager.getConnection(url, props);
    }

    private Connection logConnectionURL(ArrayList<String> urlMessage, String username, String URLString, Properties props, boolean tryPrelim) throws Throwable {
        return this.logConnectionURL(urlMessage, username, URLString, props, tryPrelim, true);
    }

    private boolean hasUrlStub(String url) {
        if (url != null) {
            for (String stub : new String[]{"jdbc:oracle:thin", "jdbc:oracle:oci", "jdbc:oracle:kprb", "jdbc:default:connection", "jdbc:timesten:direct", "jdbc:timesten:client", "jdbc:oracle:orest", "http:", "https:"}) {
                if (!url.startsWith(stub)) continue;
                return true;
            }
        }
        return false;
    }

    public static Connection prelimAuthTryReopen(Connection preconn, ScriptRunnerContext ctx) {
        block8: {
            try {
                String password;
                Boolean prelim = (Boolean)ctx.getProperty("script.runner.PRELIM_AUTH");
                Integer prelimError = (Integer)ctx.getProperty("script.runner.PRELIM_AUTHPREERROR");
                if (preconn == null || !preconn.isClosed() || prelim == null || !prelim.equals(Boolean.TRUE) || prelimError == null) break block8;
                Properties duplicateProperties = new Properties();
                Properties props = (Properties)ctx.getProperty("cli.conn.props");
                String internalLogin = props.getProperty("internal_logon");
                String userName = props.getProperty("user");
                if (userName != null) {
                    duplicateProperties.setProperty("user", userName);
                }
                if ((password = props.getProperty("password")) != null) {
                    duplicateProperties.setProperty("password", password);
                }
                duplicateProperties.setProperty("prelim_auth", "true");
                duplicateProperties.setProperty("internal_logon", internalLogin);
                try {
                    Connection conn = DriverManager.getConnection((String)ctx.getProperty("cli.conn.url"), duplicateProperties);
                    try {
                        Logger.getLogger("SQLPLUS").log(Level.INFO, "(prelim auth) conn.isClosed()=" + conn.isClosed());
                    }
                    catch (SQLException ee) {
                        Logger.getLogger("SQLPLUS").log(Level.INFO, "(prelim auth) conn.isClosed()_exception", ee);
                    }
                    return conn;
                }
                catch (Throwable t2) {
                    ctx.write(t2.getLocalizedMessage() + "\n");
                }
            }
            catch (Exception e) {
                ctx.write(e.getLocalizedMessage() + "\n");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Connection logConnectionURL(ArrayList<String> urlMessage, String username, String URLString, Properties props, boolean tryPrelim, boolean doLog) throws Throwable {
        String user = "";
        boolean prelimAuthThrown = false;
        Connection conn = null;
        if (doLog) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ScriptRunnerDbArb.format("CONNECTING", URLString));
        }
        String feedback = ScriptRunnerDbArb.getString("NO_ERROR");
        try {
            block31: {
                try {
                    conn = this.connect(URLString, props);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != 28001) throw e;
                    this.report(this.getScriptRunnerContext(), e.getLocalizedMessage());
                    IGetPromptedPasswordFieldsProvider passProvider = this.getScriptRunnerContext().getPasswordFieldsProvider();
                    if (passProvider == null) break block31;
                    Pair<String, String> passPair = passProvider.passwordGetPassword(this.getScriptRunnerContext(), username + "donotdisplay", username);
                    if (passPair == null || passPair.first() == null) throw e;
                    conn = new ResetPasswordHelper().resetAndReconnect(this.getScriptRunnerContext(), username, URLString, props, passPair.first(), e);
                }
            }
            this.getScriptRunnerContext().putProperty("script.runner.PRELIM_AUTH", Boolean.FALSE);
            if (conn == null) return conn;
            try {
                SQLWarning sw = conn.getWarnings();
                if (sw != null) {
                    this.report(this.getScriptRunnerContext(), "ERROR:");
                }
                while (sw != null) {
                    String w = sw.getLocalizedMessage();
                    if (w != null) {
                        this.report(this.getScriptRunnerContext(), w);
                    }
                    sw = sw.getNextWarning();
                }
                conn.clearWarnings();
                return conn;
            }
            catch (SQLException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            return conn;
        }
        catch (Throwable e) {
            block32: {
                feedback = e.getLocalizedMessage();
                if (feedback == null) {
                    feedback = e.getMessage();
                }
                feedback = feedback != null ? feedback.trim() : "";
                user = props.getProperty("user");
                if (user == null) {
                    user = "";
                }
                try {
                    String password;
                    String internalLogin = props.getProperty("internal_logon");
                    if (!tryPrelim || !this.getScriptRunnerContext().isCommandLine() || (!(e instanceof SQLException) || ((SQLException)e).getErrorCode() != 1034 && ((SQLException)e).getErrorCode() != 1090) && (((SQLException)e).getErrorCode() != 1033 || !this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CONNECT) || internalLogin == null || !internalLogin.equalsIgnoreCase("SYSDBA") && !internalLogin.equalsIgnoreCase("SYSOPER") && !internalLogin.equalsIgnoreCase("SYSASM"))) throw e;
                    Properties duplicateProperties = new Properties();
                    String userName = props.getProperty("user");
                    if (userName != null) {
                        duplicateProperties.setProperty("user", userName);
                    }
                    if ((password = props.getProperty("password")) != null) {
                        duplicateProperties.setProperty("password", password);
                    }
                    duplicateProperties.setProperty("prelim_auth", "true");
                    duplicateProperties.setProperty("internal_logon", internalLogin);
                    ScriptRunnerContext ctx = this.getScriptRunnerContext();
                    try {
                        conn = DriverManager.getConnection(URLString, duplicateProperties);
                        try {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "(prelim auth) conn.isClosed()=" + conn.isClosed());
                        }
                        catch (SQLException ee) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "(prelim auth) conn.isClosed()_exception", ee);
                        }
                        this.getScriptRunnerContext().putProperty("script.runner.PRELIM_AUTH", Boolean.TRUE);
                        this.getScriptRunnerContext().putProperty("PRELIMAUTHPREERROR", ((SQLException)e).getErrorCode());
                        if (ctx != null) {
                            ctx.putProperty("cli.conn.url", URLString);
                            ctx.putProperty("cli.conn.props", props);
                        }
                    }
                    catch (Throwable t2) {
                        if (doLog) {
                            if (!this.getScriptRunnerContext().isSQLPlusClassic()) {
                                urlMessage.add(ScriptRunnerDbArb.format("URL_MESSAGE", user, URLString, feedback));
                            } else {
                                SQLPLUS.classicUrlMessageAdd(urlMessage, user, URLString, feedback);
                            }
                        }
                        feedback = "";
                        feedback = t2.getLocalizedMessage();
                        if (feedback == null) {
                            feedback = e.getMessage();
                        }
                        feedback = feedback != null ? feedback.trim() : "";
                        prelimAuthThrown = true;
                        throw t2;
                    }
                    if (feedback == null || feedback.equals("")) return conn;
                    user = props.getProperty("user");
                    if (user == null) {
                        user = "";
                    }
                    if (prelimAuthThrown) {
                        user = user + " prelim_auth";
                    }
                    if (!doLog) return conn;
                    if (this.getScriptRunnerContext().isSQLPlusClassic()) break block32;
                }
                catch (Throwable throwable) {
                    if (feedback == null || feedback.equals("")) throw throwable;
                    user = props.getProperty("user");
                    if (user == null) {
                        user = "";
                    }
                    if (prelimAuthThrown) {
                        user = user + " prelim_auth";
                    }
                    if (!doLog) throw throwable;
                    if (!this.getScriptRunnerContext().isSQLPlusClassic()) {
                        urlMessage.add(ScriptRunnerDbArb.format("URL_MESSAGE", user, URLString, feedback));
                        throw throwable;
                    } else {
                        SQLPLUS.classicUrlMessageAdd(urlMessage, user, URLString, feedback);
                    }
                    throw throwable;
                }
                urlMessage.add(ScriptRunnerDbArb.format("URL_MESSAGE", user, URLString, feedback));
                return conn;
            }
            SQLPLUS.classicUrlMessageAdd(urlMessage, user, URLString, feedback);
            return conn;
        }
    }

    public static void classicUrlMessageAdd(ArrayList<String> urlMessage, String user, String URLString, String feedback) {
        String urlLower;
        if (urlMessage.size() == 0) {
            urlMessage.add("");
            urlMessage.add("");
            urlMessage.add("");
            urlMessage.set(2, ScriptRunnerDbArb.format("URL_MESSAGE_CLASSIC", feedback));
        }
        if (urlMessage.get(1).equals("") && URLString.startsWith("jdbc:oracle:thin")) {
            urlMessage.set(1, ScriptRunnerDbArb.format("URL_MESSAGE_CLASSIC", feedback));
        }
        if ((urlLower = URLString.toLowerCase(Locale.US).replaceAll("\\s+", "")).startsWith("jdbc:oracle:oci") && urlLower.endsWith("@") || urlLower.indexOf("protocol=ipc") != -1) {
            urlMessage.set(0, ScriptRunnerDbArb.format("URL_MESSAGE_CLASSIC", feedback));
        }
        urlMessage.add(ScriptRunnerDbArb.format("URL_MESSAGE_CLASSIC", feedback));
    }

    public static void setupNLS(Connection myconn, ScriptRunnerContext src) {
        Map<String, String> nlsMap = src.getNLSMap();
        if (myconn != null && nlsMap != null && !nlsMap.isEmpty()) {
            OracleNLSProvider provider = null;
            provider = new OracleNLSProvider(myconn);
            ((DefaultNLSProvider)provider).initConnection();
            ((DefaultNLSProvider)provider).updateDefaults(nlsMap);
        }
    }

    private String[] nextWordAndRest(String in) {
        return this.nextWordAndRestOrString(in, null);
    }

    private String[] nextWordAndRestOrString(String in, String extraOne) {
        if ((in = in.trim()).length() == 0) {
            return null;
        }
        int i = 0;
        boolean inQuote = false;
        boolean found = false;
        String rest = "";
        String firstWord = "";
        for (i = 0; i < in.length(); ++i) {
            if (in.charAt(i) == '\"') {
                inQuote = !inQuote;
            }
            if (!Character.isWhitespace(in.charAt(i)) && (extraOne == null || extraOne.indexOf(in.charAt(i)) == -1) || inQuote) continue;
            found = true;
            break;
        }
        if (found) {
            rest = in.substring(i).trim();
            firstWord = in.substring(0, i);
        } else {
            firstWord = in;
        }
        String[] stringArray = new String[]{firstWord, rest};
        return stringArray;
    }

    public static String removeDashNewline(ISQLCommand cmd, String in) {
        if (cmd.getProperty("STRIPPED_CONTINUATION") != null) {
            return in;
        }
        return SQLPLUS.removeDashNewline(in);
    }

    static boolean specialNoContinuation(String s, int match) {
        int index = s.lastIndexOf(10, match);
        if (index != -1) {
            return s.substring(index + 1, match + 1).matches("^\\s*--");
        }
        return false;
    }

    public static String removeDashNewline(String in) {
        int eatWhite;
        StringBuffer op = new StringBuffer();
        int currentlyAt = 0;
        int lastnewlineMatch = -1;
        int newlineMatch = -1;
        do {
            int match;
            if ((match = in.indexOf("-", currentlyAt)) == -1) {
                if (currentlyAt == 0) {
                    return in;
                }
                op.append(in.substring(currentlyAt));
                break;
            }
            eatWhite = match + 1;
            for (eatWhite = match + 1; eatWhite < in.length() && (in.substring(eatWhite, eatWhite + 1).equals(" ") || in.substring(eatWhite, eatWhite + 1).equals("\t")); ++eatWhite) {
            }
            if (eatWhite == in.length() && !SQLPLUS.specialNoContinuation(in, match)) {
                op.append(in.substring(currentlyAt, match));
                break;
            }
            if (eatWhite < in.length() && (in.substring(eatWhite, eatWhite + 1).equals("\r") || in.substring(eatWhite, eatWhite + 1).equals("\n")) && !SQLPLUS.specialNoContinuation(in, match)) {
                op.append(in.substring(currentlyAt, match));
                if (++eatWhite >= in.length() || in.substring(eatWhite, eatWhite + 1).equals("\r") || in.substring(eatWhite, eatWhite + 1).equals("\n")) {
                    // empty if block
                }
                currentlyAt = ++eatWhite;
                continue;
            }
            op.append(in.substring(currentlyAt, eatWhite));
            currentlyAt = eatWhite;
        } while (eatWhite != in.length());
        return op.toString();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public static ProviderForSQLPATH getSqlpathProvider() {
        return sqlpathProvider;
    }

    public static void setSqlpathProvider(ProviderForSQLPATH sqlpathProvder) {
        sqlpathProvider = sqlpathProvder;
    }
}

