/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExport;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExportV1;
import oracle.dbtools.raptor.newscriptrunner.apex.ApexExportInterface;
import oracle.dbtools.raptor.newscriptrunner.apex.AppNotInstalledException;
import oracle.dbtools.raptor.newscriptrunner.apex.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.IListPrinter;
import oracle.dbtools.raptor.utils.ListPrinter;

@Restricted(level=Restricted.Level.R4)
public class ApexCmd
extends CommandListener
implements IHelp {
    private static IListPrinter _listPrinter = new ListPrinter();
    static QueryXMLSupport _queries = null;

    private static synchronized QueryXMLSupport getXMLQueries() {
        if (_queries == null) {
            _queries = QueryXMLSupport.getQueryXMLSupport(new MetaResource(ApexCmd.class.getClassLoader(), "oracle/dbtools/raptor/newscriptrunner/commands/commands.xml"));
        }
        return _queries;
    }

    private static boolean newApexVersion(Connection conn) throws AppNotInstalledException {
        DBUtil dbUtil = DBUtil.getInstance(conn);
        String version = dbUtil.executeReturnOneCol(ApexCmd.getXMLQueries().getQuery("apex.version", conn).getSql());
        if (version == null || version.isEmpty()) {
            throw new AppNotInstalledException();
        }
        Version source = new Version(version);
        return source.compareTo(new Version("19.2")) > 0;
    }

    @Override
    public String getCommand() {
        return "APEX";
    }

    @Override
    public String getHelp() {
        return Messages.getString("ApexCmd.help");
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("apex")) {
            String filter;
            String[] parts = cmd.getSql().trim().split(" ");
            String subCmd = parts.length > 1 && parts[1] != null ? parts[1] : "list";
            String string = filter = parts.length > 2 && parts[2] != null ? parts[2] : null;
            if (subCmd.trim().equalsIgnoreCase("")) {
                subCmd = "list";
            }
            if (conn == null) {
                ctx.write(Messages.getString("ApexCmd.7"));
                ctx.errorLog(ctx.getSourceRef(), Messages.getString("ApexCmd.7"), cmd.getSql());
                return true;
            }
            try {
                ApexCmd.newApexVersion(conn);
            }
            catch (AppNotInstalledException e) {
                ctx.write("APEX is not installed stopping execution.");
                return true;
            }
            String report = null;
            if (subCmd.equalsIgnoreCase("list")) {
                report = "apex.list";
                this.printList(conn, ctx, report);
            } else if (subCmd.equalsIgnoreCase("log")) {
                report = "apex.log";
                this.printList(conn, ctx, report);
            } else if (subCmd.equalsIgnoreCase("export")) {
                try {
                    String[] args = null;
                    ApexExportInterface apexExport = null;
                    apexExport = ApexCmd.newApexVersion(conn) ? new APEXExport() : new APEXExportV1();
                    apexExport.setCWD(FileUtils.getCWD(ctx));
                    apexExport.setConnection(conn);
                    if (parts.length == 2) {
                        if (ApexCmd.newApexVersion(conn)) {
                            APEXExport.usage(ctx.getOutputStream());
                        } else {
                            APEXExportV1.usage(ctx.getOutputStream());
                        }
                        return true;
                    }
                    if (parts.length == 3 && !filter.contentEquals("-h")) {
                        args = new String[]{"-applicationid", filter};
                    } else {
                        args = new String[parts.length - 2];
                        System.arraycopy(parts, 2, args, 0, parts.length - 2);
                    }
                    apexExport.processArgs(args);
                    apexExport.doCapture();
                }
                catch (NumberFormatException e) {
                    ctx.write(Messages.getString("ApexCmd.0"));
                }
                catch (InvalidParameterException e) {
                    if (!e.getMessage().isEmpty()) {
                        ctx.write(Messages.getString("ApexCmd.1"));
                        ctx.write(e.getLocalizedMessage());
                    }
                }
                catch (AppNotInstalledException e) {
                    ctx.write("APEX is not installed stopping execution.");
                }
                catch (Exception e) {
                    ctx.write(Messages.getString("ApexCmd.1"));
                    ctx.write(e.getLocalizedMessage());
                }
            }
            return true;
        }
        return false;
    }

    private void printList(Connection conn, ScriptRunnerContext ctx, String report) {
        Query colSQL = ApexCmd.getXMLQueries().getQuery(report, conn);
        DBUtil dbUtil = DBUtil.getInstance(conn);
        HashMap binds = new HashMap();
        List<List<?>> rows = dbUtil.executeReturnListofList(colSQL.getSql(), binds);
        _listPrinter.printListofList(ctx, rows);
    }

    public String getDDL(Connection conn, String filter) {
        SQLException e;
        DBUtil dbUtil = DBUtil.getInstance(conn);
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("APPLICATION_ID", filter);
        String worspaceId = dbUtil.executeReturnOneCol(ApexCmd.getXMLQueries().getQuery("apex.workspace", conn).getSql(), binds);
        binds.put("WORKSPACE_ID", worspaceId);
        dbUtil.execute(ApexCmd.getXMLQueries().getQuery("apex.owa_init", conn).getSql());
        dbUtil.execute(ApexCmd.getXMLQueries().getQuery("apex.export", conn).getSql(), binds);
        String ret = this.getOWA(conn);
        if (ret != null && ret.indexOf("\n\n") > -1) {
            ret = ret.substring(ret.indexOf("\n\n"));
        }
        if ((e = dbUtil.getLastException()) != null) {
            return "\n" + e.getMessage();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOWA(Connection conn) {
        Statement cs = null;
        String parcialContent = null;
        try {
            cs = conn.prepareCall(ApexCmd.getXMLQueries().getQuery("apex.get_page", conn).getSql());
            cs.registerOutParameter(1, 2005);
            cs.execute();
            Clob clob = cs.getClob(1);
            parcialContent = clob.getSubString(1L, (int)clob.length());
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception exception) {}
            }
        }
        return parcialContent;
    }

    public static void setListPrinter(IListPrinter listprinter) {
        _listPrinter = listprinter;
    }
}

