/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.ddl.DbmsMetadataDDLGenerator;

public class DDLCommand
extends CommandListener
implements IHelp,
Connected {
    protected static final String CMD = "ddl";
    protected static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_DDL;
    protected static final String SAVE_KWD = "SAVE";
    private Connection _conn = null;
    private ScriptRunnerContext _ctx = null;

    protected String help() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        DbmsMetadataDDLGenerator ddlGen = new DbmsMetadataDDLGenerator(conn, ctx);
        try {
            if (conn == null || !conn.isValid(10)) {
                ctx.write(Messages.getString("DDLCommand.71"));
                return true;
            }
            this.setContext(ctx);
        }
        catch (SQLException e) {
            ctx.write(Messages.getString("DDLCommand.72"));
            return true;
        }
        String sql = cmd.getSql();
        ArrayList<String> cmds = new ArrayList<String>();
        this.splitArgs(sql, cmds);
        int length = cmds.size();
        if (length == 1) {
            ctx.write(this.help());
            return true;
        }
        if (conn != null) {
            String resultType;
            this.setConn(conn);
            String filename = null;
            if (length >= 4 && (SAVE_KWD.equalsIgnoreCase(cmds.get(2)) || SAVE_KWD.equalsIgnoreCase(cmds.get(3)))) {
                String suffix;
                filename = cmd.getSql().trim().substring(cmd.getSql().toLowerCase().trim().indexOf(" save ") + 6);
                if (filename != null) {
                    filename = filename.trim().replaceAll("\"", "").replaceAll("'", "");
                }
                if (filename.lastIndexOf(".") == -1 && (suffix = (String)ctx.getProperty("script.runner.file.suffix")).length() > 0) {
                    filename = filename + "." + suffix;
                }
            } else {
                filename = null;
                if (cmds.size() >= 3 && (SAVE_KWD.equalsIgnoreCase(cmds.get(2)) || cmds.size() > 3 && SAVE_KWD.equalsIgnoreCase(cmds.get(3)))) {
                    ctx.write("Invalid option\n");
                    ctx.write(this.help());
                    return true;
                }
            }
            if (filename != null) {
                filename = filename.trim().replaceFirst("^\"", "").replaceFirst("\"$", "");
            }
            if (length >= 3 && !cmds.get(2).equalsIgnoreCase(SAVE_KWD)) {
                StringBuilder sb = new StringBuilder();
                sb.append(cmds.get(2));
                for (int i = 3; i < length; ++i) {
                    sb.append(" ");
                    sb.append(cmds.get(i));
                }
                length = 2;
                resultType = sb.toString();
            } else {
                resultType = null;
            }
            String object = length >= 2 ? cmds.get(1) : null;
            if (object != null) {
                ddlGen.processDDL(object, resultType, filename, false);
                return true;
            }
        }
        this.writeToCtx(MessageFormat.format(Messages.getString("DDL_PARSE_ERROR"), new Object[0]));
        ctx.write(this.help());
        return true;
    }

    protected void setContext(ScriptRunnerContext ctx) {
        this._ctx = ctx;
    }

    protected void setConn(Connection conn) {
        this._conn = conn;
    }

    protected boolean splitArgs(String commandline, ArrayList<String> args) {
        int lineLength = commandline.length();
        int terminalIndex = lineLength - 1;
        boolean nullChar = false;
        StringBuilder arg = new StringBuilder();
        StringBuilder quoted = new StringBuilder();
        char quoteChar = '\u0000';
        for (int i = 0; i < lineLength; ++i) {
            char ch = commandline.charAt(i);
            if (quoteChar != '\u0000') {
                quoted.append(ch);
                if (ch == quoteChar) {
                    arg.append((CharSequence)quoted);
                    quoted = new StringBuilder();
                    quoteChar = '\u0000';
                }
            } else if (ch == '\"' || ch == '\'') {
                quoted.append(ch);
                quoteChar = ch;
            } else if (Character.isWhitespace(ch)) {
                if (arg.length() > 0) {
                    args.add(arg.toString());
                    arg = new StringBuilder();
                }
            } else {
                arg.append(ch);
            }
            if (i != terminalIndex || quoteChar == '\u0000') continue;
            arg.append(quoteChar);
            i -= quoted.length() - 1;
            quoted = new StringBuilder();
            quoteChar = '\u0000';
        }
        if (arg.length() > 0) {
            args.add(arg.toString());
        }
        return true;
    }

    protected void writeToCtx(String message, BufferedWriter bw) throws IOException {
        if (message != null && bw == null) {
            this._ctx.write(message);
            this._ctx.write("\n");
        }
        if (message != null && bw != null) {
            bw.write(message);
            bw.newLine();
        }
    }

    protected void writeToCtx(String message) {
        try {
            this.writeToCtx(message, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return "DDL";
    }

    @Override
    public String getHelp() {
        return this.help();
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean needsConnection() {
        return true;
    }
}

