/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.SQLPLUSCmdFormatter;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.JSONWrapBufferedOutputStream;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.SetServerOutput;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.ResolvedDBObject;
import oracle.dbtools.util.Closeables;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.sql.Datum;

public class DescribePrep
extends CommandListener {
    private Connection _conn;
    private ScriptRunnerContext m_ctx;
    private static final String DESCRIBE = "(?i:desc(?:|r|ri|rib|ribe))";
    private static final String JAVAREGEX = "[^#|\"][\\w|\\$#]+|[\\w|\\$]+|[\\w]+[.][\\w|\\$]+|[^#|\"][\\w|\\$#]+[.][^#|\"][\\w|\\$#]+|\\\"[\\w]+\\\"[.][\\w|\\$]+|\\\"[\\w]+\\\"[.]\\\"[\\w|\\$]+\\\"|[\\w]+[.]\\\"[\\w|\\$]+\\\"|[\\w]+[.]\\\"[\\w\\s]+\\\"|\\\"[\\w\\s]+\\\"[.]\\\"[\\w\\s]+\\\"|\\\"[\\w]+\\\"[.]\\\"[\\w|\\$]+\\\"@\\w+|[\\w]+\\\"[\\w\\s]+\\\"|\\\"[\\w\\s]+\\\"|\\\"[\\w]+[.][\\w\\s]+\\\"||[\\w]+[.][\\w]+@\\w+|\\\"[\\w\\s]+\\\"@\\w+|[\\w]+@\\w+|\\\"[\\w\\s]+[.][\\w\\s]+\\\"@\\w+|\\\"[\\w\\s]+\\\"[.]\\w+@\\w+";
    private static final String OBJECTNAME = "(?i:desc(?:|r|ri|rib|ribe))\\s+[^#|\"][\\w|\\$#]+|[\\w|\\$]+|[\\w]+[.][\\w|\\$]+|[^#|\"][\\w|\\$#]+[.][^#|\"][\\w|\\$#]+|\\\"[\\w]+\\\"[.][\\w|\\$]+|\\\"[\\w]+\\\"[.]\\\"[\\w|\\$]+\\\"|[\\w]+[.]\\\"[\\w|\\$]+\\\"|[\\w]+[.]\\\"[\\w\\s]+\\\"|\\\"[\\w\\s]+\\\"[.]\\\"[\\w\\s]+\\\"|\\\"[\\w]+\\\"[.]\\\"[\\w|\\$]+\\\"@\\w+|[\\w]+\\\"[\\w\\s]+\\\"|\\\"[\\w\\s]+\\\"|\\\"[\\w]+[.][\\w\\s]+\\\"||[\\w]+[.][\\w]+@\\w+|\\\"[\\w\\s]+\\\"@\\w+|[\\w]+@\\w+|\\\"[\\w\\s]+[.][\\w\\s]+\\\"@\\w+|\\\"[\\w\\s]+\\\"[.]\\w+@\\w+";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private QueryXMLSupport m_xml = QueryXMLSupport.getQueryXMLSupport("oracle/dbtools/raptor/newscriptrunner/ScriptParserQueries.xml");
    private boolean m_isTypeMethods = false;
    private int m_numberOfMethods = 0;
    private ArrayList<String> m_typeMethodNames = new ArrayList();
    private ArrayList<Integer> m_typeSelfMethods = new ArrayList();
    private String[] m_typeName = new String[2];
    private Object[] m_formatArgs = new Object[6];
    private final String UNDEFINED_OBJECT_TYPE = "UNDEFINED_OBJECT_TYPE";
    private String m_setNull;
    private boolean m_isSetNullChanged = false;
    private String m_objectName = null;
    private String m_ownerName = null;
    private String m_dblinkName = null;
    private String owner_view_status_compile = "DECLARE" + LINE_SEPARATOR + "  var_count NUMBER;" + LINE_SEPARATOR + "BEGIN" + LINE_SEPARATOR + "FOR v_rec IN ( select owner, object_name from all_objects<db_link> where owner = '<owner>' and object_name = '<object_name>' and object_type = 'VIEW' and status <> 'VALID')" + LINE_SEPARATOR + "LOOP" + LINE_SEPARATOR + "    SELECT COUNT(*) INTO var_count FROM \"<owner>\".\"<object_name>\"<db_link> WHERE 2 = 1;" + LINE_SEPARATOR + "  END LOOP;" + LINE_SEPARATOR + " END;";
    private String view_status_compile = "DECLARE" + LINE_SEPARATOR + "  var_count NUMBER;" + LINE_SEPARATOR + "BEGIN" + LINE_SEPARATOR + "FOR v_rec IN ( select object_name from user_objects<db_link> where object_name = '<object_name>' and object_type = 'VIEW' and status <> 'VALID')" + LINE_SEPARATOR + "  LOOP" + LINE_SEPARATOR + "    SELECT COUNT(*) INTO var_count FROM \"<object_name>\"<db_link> WHERE 2 = 1;" + LINE_SEPARATOR + "  END LOOP;" + LINE_SEPARATOR + " END;";
    private String owner_view_status = "select status from all_objects<db_link> where owner = '<owner>' and object_name = '<object_name>' and object_type = 'VIEW'";
    private String view_status = "select status from user_objects<db_link> where object_name = '<object_name>' and object_type = 'VIEW'";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (this.m_isTypeMethods) {
            this.describeTypeMethods(conn, ctx, cmd);
        }
        this.clearColumnFormats(ctx);
        if (this.m_isSetNullChanged) {
            ctx.putProperty("script.runner.setnull", this.m_setNull);
            this.m_isSetNullChanged = false;
            this.m_setNull = null;
        }
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean usage = false;
        if (cmd.getStmtClass().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS) && cmd.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_DESCRIBE) && (conn == null || conn instanceof OracleConnection)) {
            this._conn = conn;
            this.setScriptRunnerContext(ctx);
            this.parseDescribe(ctx, cmd, conn);
        }
        usage = ctx.getProperties().get("descr.usage") != null ? (Boolean)ctx.getProperties().get("descr.usage") : Boolean.FALSE;
        if (DescribePrep.matches("describe", cmd.getSql()) && usage) {
            ctx.write(ScriptRunnerDbArb.getString("DESCR_USAGE") + LINE_SEPARATOR);
            return true;
        }
        return false;
    }

    public void parseDescribe(ScriptRunnerContext ctx, ISQLCommand cmd, Connection conn) {
        String[] res = new String[]{"", "unknown_table"};
        boolean ownerNotSpecified = false;
        String describePtrn = "(?i:desc(?:|r|ri|rib|ribe)\\b\\s*)";
        String rawName = cmd.getSql().replaceFirst(describePtrn, "").trim();
        if ("".equals(rawName)) {
            ctx.putProperty("descr.usage", Boolean.TRUE);
            return;
        }
        if (!Pattern.compile(JAVAREGEX, 256).matcher(rawName).matches()) {
            if (!this.validateRawObjectName(ctx, rawName)) {
                ctx.putProperty("descr.usage", Boolean.FALSE);
                return;
            }
            ctx.putProperty("descr.usage", Boolean.TRUE);
            return;
        }
        if (!this.isValidDBLinkConnection(ctx, rawName)) {
            return;
        }
        this.m_setNull = (String)ctx.getProperty("script.runner.setnull");
        ctx.removeProperty("script.runner.setnull");
        ctx.putProperty("script.runner.setnull", "");
        this.m_isSetNullChanged = true;
        String filter = null;
        SetServerOutput.coreEndWatcher(conn, ctx, cmd);
        ResolvedDBObject dbObj = ResolvedDBObject.resolveDBObject(conn, rawName, filter);
        if (dbObj == null || dbObj != null && dbObj.isBad()) {
            if (conn == null) {
                ctx.write(LINE_SEPARATOR + ScriptRunnerDbArb.getString("NOT_CONNECTED") + LINE_SEPARATOR);
                return;
            }
            if (!this.checkObjectExists(rawName)) {
                ctx.write(LINE_SEPARATOR + ScriptRunnerDbArb.format("DESCR_NO_OBJECT", rawName) + LINE_SEPARATOR);
                ctx.putProperty("descr.usage", Boolean.FALSE);
                if (ctx.getOutputStream() instanceof JSONWrapBufferedOutputStream) {
                    Integer sqlcode = 4043;
                    String jdbcErrorMessage = JSONWrapBufferedOutputStream.quote(ScriptRunnerDbArb.format("DESCR_NO_OBJECT", rawName), true);
                    String errorInfo = MessageFormat.format("JSON_COMMAND_ERR", 0 + sqlcode, cmd.getStartLine() + 1, 0, jdbcErrorMessage);
                    ((JSONWrapBufferedOutputStream)ctx.getOutputStream()).addStmtInfo(errorInfo);
                }
                return;
            }
        }
        if (cmd.getSql().contains(".")) {
            StringTokenizer st = new StringTokenizer(cmd.getSql(), "\\.");
            StringTokenizer st2 = new StringTokenizer(st.nextToken(), "\\ ");
            st2.nextToken();
            res[0] = st2.nextToken();
            res[1] = st.nextToken();
        } else {
            String regex = "\"([^\"]*)\"|(\\S+)";
            Matcher m = Pattern.compile(regex).matcher(cmd.getSql());
            m.find();
            while (m.find()) {
                res[1] = m.group();
            }
            ownerNotSpecified = true;
        }
        res[1] = res[1].replaceAll("\n", "");
        res[1] = res[1].replaceAll("\r", "");
        String orgName = res[1];
        String objType = this.getObjType(res[1], res[0]);
        String viewType = "all";
        if ((objType == null || objType.length() == 0 && res[1] != null && res[1].length() > 0) && (objType = this.getObjTypeDBA(res[1], res[0])) != null && objType.length() > 0) {
            viewType = "dba";
        }
        if (objType.indexOf("\n") > -1) {
            objType = objType.contains("SYNONYM") && objType.contains("TABLE") ? "SYNONYM" : objType.split("\n")[0];
        }
        if (objType.equals("SYNONYM")) {
            String[] details = this.getBaseSynonymObjectRecursive(res[1], res[0]);
            if (details == null) {
                return;
            }
            objType = details[2];
            if ("UNDEFINED_OBJECT_TYPE".equals(objType)) {
                String object = "";
                if (details[0] != null && !"".equals(details[0])) {
                    object = "\"" + details[0] + "\".";
                }
                if (details[1] != null && !"".equals(details[1])) {
                    object = object + "\"" + details[1].replaceAll("\"|'", "") + "\"";
                }
                ctx.write(LINE_SEPARATOR + ScriptRunnerDbArb.format("DESCR_NO_OBJECT", object) + LINE_SEPARATOR);
                ctx.putProperty("descr.usage", Boolean.FALSE);
                return;
            }
            if (objType.indexOf("\n") > -1) {
                objType = objType.split("\n")[0];
            }
            res[0] = details[0];
            res[1] = "'" + details[1] + "'";
        }
        String displayName = ScriptRunnerDbArb.getString("DISPLAY_NAME");
        String displayNull = ScriptRunnerDbArb.getString("DISPLAY_NULL");
        String displayType = ScriptRunnerDbArb.getString("DISPLAY_TYPE");
        String displayArgumentName = ScriptRunnerDbArb.getString("DISPLAY_ARGUMENT_NAME");
        String displayInOut = ScriptRunnerDbArb.getString("DISPLAY_IN_OUT");
        String displayDefault = ScriptRunnerDbArb.getString("DISPLAY_DEFAULT");
        String displayDimName = ScriptRunnerDbArb.getString("DISPLAY_DIM_NAME");
        String displayHierName = ScriptRunnerDbArb.getString("DISPLAY_HIER_NAME");
        String displayRole = ScriptRunnerDbArb.getString("DISPLAY_ROLE");
        res[0] = res[0].indexOf("\"") > -1 || res[0].indexOf("'") > -1 ? res[0].replaceAll("\"|'", "") : this.upperCaseLocaleUS(ctx, res[0].replaceAll("\"|'", ""));
        res[1] = res[1].indexOf("\"") > -1 || res[1].indexOf("'") > -1 ? res[1].replaceAll("\"|'", "") : this.upperCaseLocaleUS(ctx, res[1].replaceAll("\"|'", ""));
        if (objType == null) {
            objType = this.getObjType(res[1], res[0]);
        }
        if (objType == null || objType.length() == 0 && res[1] != null && res[1].length() > 0) {
            objType = this.getObjTypeDBA(res[1], res[0]);
        }
        String dbLinkName = "";
        String[] dbLink = DBUtil.resolveDBLink(res[1]);
        if (dbLink != null) {
            dbLinkName = "@" + dbLink[1];
            if (res[0].equals("")) {
                res[0] = this.getDBLinkOwner(res[1], "");
            }
            res[1] = dbLink[0];
        }
        Query q = null;
        String sql = null;
        String owner = null;
        boolean knownObject = true;
        Object[] formatArgs = null;
        String sqlQuery = null;
        if (objType.equals("TABLE") || objType.equals("VIEW") || objType.endsWith("MATERIALIZED VIEW")) {
            sqlQuery = objType.equals("TABLE") && this.isTableXMLType(res[1], res[0]) ? "DESC_XMLTYPE_TABLE" : "DESC_TABLE_VIEW";
            if (!dbLinkName.equals("") && ownerNotSpecified) {
                sqlQuery = sqlQuery + "_NO_OWNER";
            }
            String hidden = "'YES'";
            if (Boolean.parseBoolean(ctx.getProperty("sqlcl.set.colinvisible").toString())) {
                hidden = "'SHOW_ALL'";
            }
            formatArgs = new Object[]{dbLinkName, displayName, displayNull, displayType, viewType, hidden, owner};
            if (objType.equals("VIEW") && !this.compileViewIfRequired(ctx, conn, dbLinkName, res, ownerNotSpecified)) {
                ctx.write(ScriptRunnerDbArb.getString("DESCRIBE_INVALID_OBJECT") + LINE_SEPARATOR);
                return;
            }
            this.addColumnFormatForTableView(conn, ctx);
        } else {
            if (objType.startsWith("PACKAGE")) {
                sqlQuery = this.isDefaultDetailsAvailable(dbLinkName) ? "DESC_PACKAGE_WITH_ARGS_DEFAULTS" : "DESC_PACKAGE_WITHOUT_ARGS_DEFAULTS";
                if (!dbLinkName.equals("") && ownerNotSpecified) {
                    sqlQuery = sqlQuery + "_NO_OWNER";
                }
                formatArgs = new Object[]{dbLinkName, displayArgumentName, displayType, displayInOut, displayDefault, owner};
                try {
                    q = this.m_xml.getQuery(sqlQuery, conn);
                    sql = q.getSql().replaceAll("'", "''");
                    owner = !res[0].equals("") ? ":1" : "sys_context('USERENV', 'CURRENT_USER')";
                    formatArgs[formatArgs.length - 1] = owner;
                    sql = MessageFormat.format(sql, formatArgs);
                    cmd.setSql(sql);
                    if (!res[0].equals("") && !sqlQuery.endsWith("_NO_OWNER")) {
                        cmd.addBind(res[0]);
                        cmd.addBind(res[1]);
                    } else {
                        cmd.addBind(res[1]);
                    }
                    this.describePackage(conn, ctx, formatArgs, res, cmd.getModifiedSQL());
                }
                catch (Exception ex) {
                    ExceptionHandler.handleException(ex);
                }
                return;
            }
            if (objType.equals("FUNCTION") || objType.equals("PROCEDURE")) {
                if (!this.isObjectStatusValid(conn, res, objType)) {
                    ctx.write(ScriptRunnerDbArb.getString("DESCRIBE_INVALID_OBJECT") + LINE_SEPARATOR);
                    return;
                }
                sqlQuery = this.isDefaultDetailsAvailable(dbLinkName) ? "DESC_PROC_FUNC_WITH_ARGS_DEFAULTS" : "DESC_PROC_FUNC_WITHOUT_ARGS_DEFAULTS";
                if (!dbLinkName.equals("") && ownerNotSpecified) {
                    sqlQuery = sqlQuery + "_NO_OWNER";
                }
                if (objType.equals("PROCEDURE")) {
                    this.writeOutputHeader(rawName, objType, ctx, null);
                }
                if (objType.equals("FUNCTION")) {
                    this.writeOutputHeader(rawName, objType, ctx, this.getFunctionReturnType(dbLinkName, orgName));
                }
                formatArgs = new Object[]{dbLinkName, displayArgumentName, displayType, displayDefault, owner};
                this.addColumnFormatForStoreProcedures(conn, ctx);
            } else if (objType.startsWith("TYPE")) {
                Object[] typeFormatArgs = null;
                if (!res[0].equals("")) {
                    formatArgs = new Object[]{dbLinkName, displayName, displayNull, displayType, " UPPER(owner)= UPPER(:1) and "};
                    typeFormatArgs = new Object[]{dbLinkName, displayArgumentName, displayType, displayInOut, displayDefault, " UPPER(owner)= UPPER(:1) and "};
                } else {
                    formatArgs = new Object[]{dbLinkName, displayName, displayNull, displayType, ""};
                    typeFormatArgs = new Object[]{dbLinkName, displayArgumentName, displayType, displayInOut, displayDefault, "sys_context('USERENV', 'CURRENT_USER')"};
                }
                if (!this.isUserDefinedTypeCollection(dbLinkName, orgName)) {
                    sqlQuery = "DESC_TYPE";
                    try {
                        this.m_isTypeMethods = this.isTypeMethodsExists(conn, ctx, res, typeFormatArgs);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handleException(ex);
                    }
                } else {
                    sqlQuery = "DESC_TYPE_COLLECTION";
                    String CurrUser = this.getCurrentUser();
                    String[] refType = this.getReferencedType(dbLinkName, orgName);
                    if (refType != null) {
                        if (refType[0] == null || refType[0].equalsIgnoreCase(CurrUser)) {
                            this.writeTypeOutputHeader(rawName, objType, ctx, dbLinkName, null);
                        } else {
                            res[0] = refType[0];
                            this.writeTypeOutputHeader(rawName, objType, ctx, dbLinkName, refType[0]);
                        }
                    }
                    while (!refType[1].equals("")) {
                        String[] refType2 = this.getReferencedType(dbLinkName, refType[1]);
                        if (!refType2[1].equals("") && refType2[0] != null) {
                            res[0] = refType2[0];
                        }
                        this.writeTypeOutputHeader(refType[1], objType, ctx, dbLinkName, refType[0]);
                        sqlQuery = "DESC_TYPE";
                        res[1] = refType[1];
                        refType[1] = refType2[1];
                    }
                    if (sqlQuery.equals("DESC_TYPE")) {
                        ctx.write(LINE_SEPARATOR);
                    }
                }
                if (!dbLinkName.equals("") && ownerNotSpecified) {
                    sqlQuery = sqlQuery + "_NO_OWNER";
                }
                this.addColumnFormatForTableView(conn, ctx);
            } else if (objType.equals("HIERARCHY")) {
                sqlQuery = "DESC_HIERARCHY";
                formatArgs = new Object[]{dbLinkName, displayName, displayRole, displayType, viewType, owner};
            } else if (objType.equals("ANALYTIC VIEW")) {
                sqlQuery = "DESC_ANALYTIC_VIEW";
                formatArgs = new Object[]{dbLinkName, displayName, displayDimName, displayHierName, displayRole, displayType, viewType, owner};
            } else {
                if (objType.equalsIgnoreCase("INDEXTYPE")) {
                    ctx.write(ScriptRunnerDbArb.getString("DESCRIBE_INVALID_OBJECTTYPE") + LINE_SEPARATOR);
                    return;
                }
                if (objType.equals("")) {
                    ctx.write(LINE_SEPARATOR + ScriptRunnerDbArb.format("DESCR_NO_OBJECT", rawName) + LINE_SEPARATOR);
                    return;
                }
                cmd.setSql("select '" + ScriptRunnerDbArb.format("CANNOT_DESCRIBE_ERROR", res[1]) + "' \"ERROR:\"  from dual");
                knownObject = false;
            }
        }
        if (knownObject) {
            q = this.m_xml.getQuery(sqlQuery, conn);
            sql = q.getSql().replaceAll("'", "''");
            owner = !res[0].equals("") ? ":1" : "sys_context('USERENV', 'CURRENT_USER')";
            formatArgs[formatArgs.length - 1] = owner;
            sql = MessageFormat.format(sql, formatArgs);
            cmd.setSql(sql);
            if (!res[0].equals("") && !sqlQuery.endsWith("_NO_OWNER")) {
                cmd.addBind(res[0]);
                cmd.addBind(res[1]);
            } else {
                cmd.addBind(res[1]);
            }
        }
        cmd.setStmtClass(SQLCommand.StmtType.G_C_SQL);
        cmd.setResultsType(SQLCommand.StmtResultType.G_R_QUERY);
    }

    private boolean validateRawObjectName(ScriptRunnerContext ctx, String rawName) {
        if (!this.isValidDBLinkConnection(ctx, rawName)) {
            return false;
        }
        if (rawName.contains(".")) {
            StringTokenizer st = new StringTokenizer(rawName, "\\.");
            String schemaName = st.nextToken();
            String objectName = st.nextToken();
            if (schemaName.startsWith("\"") && !schemaName.endsWith("\"") || objectName.startsWith("\"") && !objectName.endsWith("\"")) {
                ctx.write(ScriptRunnerDbArb.getString("DESC_SP2_0312") + LINE_SEPARATOR);
                return false;
            }
            if (schemaName.endsWith("\"") && !schemaName.startsWith("\"") || objectName.endsWith("\"") && !objectName.startsWith("\"")) {
                ctx.write(ScriptRunnerDbArb.getString("DESC_SP2_0565") + LINE_SEPARATOR);
                return false;
            }
            if (schemaName.contains("-") || objectName.contains("-")) {
                ctx.write(ScriptRunnerDbArb.getString("DESC_SP2_0565") + LINE_SEPARATOR);
                return false;
            }
        } else {
            if (rawName.startsWith("\"") && !rawName.endsWith("\"")) {
                ctx.write(ScriptRunnerDbArb.getString("DESC_SP2_0312") + LINE_SEPARATOR);
                return false;
            }
            if (rawName.endsWith("\"") && !rawName.startsWith("\"")) {
                ctx.write(ScriptRunnerDbArb.getString("DESC_SP2_0565") + LINE_SEPARATOR);
                return false;
            }
            if (rawName.contains("-")) {
                ctx.write(ScriptRunnerDbArb.getString("DESC_SP2_0565") + LINE_SEPARATOR);
                return false;
            }
        }
        return true;
    }

    private void clearColumnFormats(ScriptRunnerContext ctx) {
        this.clearColumnFormatForStoreProcedures(ctx);
        this.clearColumnFormatForTableViews(ctx);
    }

    private void addColumnFormatForStoreProcedures(Connection conn, ScriptRunnerContext ctx) {
        HashMap<String, ArrayList<String>> storedColumns = ctx.getStoredFormatCmds();
        ArrayList<String> cmdlist = new ArrayList<String>();
        cmdlist.add("format a30");
        storedColumns.put("argument name", cmdlist);
        cmdlist = new ArrayList();
        cmdlist.add("format a23");
        storedColumns.put("type", cmdlist);
        cmdlist = new ArrayList();
        cmdlist.add("format a6");
        storedColumns.put("in/out", cmdlist);
        cmdlist = new ArrayList();
        cmdlist.add("format a8");
        storedColumns.put("default?", cmdlist);
    }

    private void addColumnFormatForTableView(Connection conn, ScriptRunnerContext ctx) {
        HashMap<String, ArrayList<String>> storedColumns = ctx.getStoredFormatCmds();
        int linesize = (Integer)ctx.getProperty("script.runner.setlinesize");
        int nameWidth = 41;
        int nullWidth = 8;
        int typeWidth = 28;
        double ratio = 1.0;
        if (linesize <= 40) {
            nameWidth = 17;
            typeWidth = 12;
        } else if (linesize > 80) {
            ratio = 1.46 + ((double)linesize - 80.0) / 2000.0;
            typeWidth = (int)Math.round(((double)linesize - 10.0) / (1.0 + ratio));
            nameWidth = linesize - typeWidth - 10;
        }
        ArrayList<String> cmdlist = new ArrayList<String>();
        cmdlist.add("format a" + nameWidth);
        storedColumns.put("name", cmdlist);
        cmdlist = new ArrayList();
        cmdlist.add("format a8");
        storedColumns.put("null?", cmdlist);
        cmdlist = new ArrayList();
        cmdlist.add("format a" + typeWidth);
        storedColumns.put("type", cmdlist);
    }

    private void clearColumnFormatForStoreProcedures(ScriptRunnerContext ctx) {
        HashMap<String, ArrayList<String>> storedColumns = ctx.getStoredFormatCmds();
        storedColumns.remove("argument name");
        storedColumns.remove("type");
        storedColumns.remove("in/out");
        storedColumns.remove("default?");
    }

    private void clearColumnFormatForTableViews(ScriptRunnerContext ctx) {
        HashMap<String, ArrayList<String>> storedColumns = ctx.getStoredFormatCmds();
        storedColumns.remove("name");
        storedColumns.remove("null?");
        storedColumns.remove("type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describePackage(Connection conn, ScriptRunnerContext ctx, Object[] formatArgs, String[] objectName, String sqlQuery) throws SQLException {
        String outScript = "SELECT subprogram_id, subprogram_type, procedure_name,  data_type FROM \n(\n  SELECT p.object_name, p.procedure_name,\n         CASE WHEN a.object_id IS NULL THEN 'PROCEDURE' ELSE 'FUNCTION' END AS subprogram_type, p.subprogram_id, a.data_type\n  FROM all_procedures p\n  LEFT JOIN all_arguments a ON ( a.object_id = p.object_id\n                             AND a.subprogram_id = p.subprogram_id AND a.position = 0 )\n  WHERE p.owner = UPPER(:0)\n)\nwhere object_name = :1\nand procedure_name is not NULL\norder by procedure_name, subprogram_id";
        outScript = !objectName[0].equals("") ? outScript.replace(":0", "'" + objectName[0] + "'") : outScript.replace(":0", "sys_context('USERENV', 'CURRENT_USER')");
        outScript = outScript.replace(":1", "'" + objectName[1] + "'");
        ResultSet rsOuter = null;
        if (conn != null && LockManager.lock(conn)) {
            try {
                DBUtil dbUtil = DBUtil.getInstance(conn);
                rsOuter = dbUtil.executeOracleQuery(outScript, null);
                this.addColumnFormatForStoreProcedures(conn, ctx);
                ResultSetMetaData rmeta = rsOuter.getMetaData();
                int count = rmeta.getColumnCount();
                boolean rowCount = false;
                while (rsOuter.next()) {
                    Object[] obj = new Object[count + 1];
                    String headerString = "";
                    String colValue = "";
                    String subproId = "";
                    for (int i = 1; i < count + 1; ++i) {
                        String columnName = "";
                        if (rsOuter instanceof OracleResultSet) {
                            try {
                                columnName = rmeta.getColumnName(i);
                                Datum rObj = ((OracleResultSet)rsOuter).getOracleObject(i);
                                colValue = DataTypesUtil.stringValue(rObj, conn);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (columnName.equalsIgnoreCase("subprogram_type")) {
                            headerString = headerString + colValue;
                            continue;
                        }
                        if (columnName.equalsIgnoreCase("procedure_name")) {
                            headerString = headerString + " " + colValue;
                            continue;
                        }
                        if (columnName.equalsIgnoreCase("data_type") && colValue != null) {
                            headerString = headerString + " RETURNS " + colValue;
                            continue;
                        }
                        if (!columnName.equalsIgnoreCase("subprogram_id")) continue;
                        subproId = colValue;
                    }
                    ctx.write(headerString);
                    this.packageArgumentsDisplay(conn, ctx, subproId, formatArgs, objectName, sqlQuery);
                    ctx.write(LINE_SEPARATOR);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rsOuter != null) {
                        DBUtil.closeResultSet(rsOuter);
                    }
                    LockManager.unlock(conn);
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                }
                throw throwable;
            }
            try {
                if (rsOuter != null) {
                    DBUtil.closeResultSet(rsOuter);
                }
                LockManager.unlock(conn);
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e);
            }
        }
        ctx.write(LINE_SEPARATOR);
        this.clearColumnFormatForStoreProcedures(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void packageArgumentsDisplay(Connection conn, ScriptRunnerContext ctx, String subprogId, Object[] formatArgs, String[] objectName, String sqlQuery) throws SQLException {
        block14: {
            sqlQuery = !objectName[0].equals("") ? sqlQuery.replace(":1", "'" + objectName[0] + "'") : sqlQuery.replace(":1", "sys_context('USERENV', 'CURRENT_USER')");
            sqlQuery = sqlQuery.replaceAll(":2", "'" + objectName[1] + "'");
            sqlQuery = sqlQuery.replace(":3", "'" + subprogId + "'");
            ResultSet rsOuter = null;
            if (conn != null && LockManager.lock(conn)) {
                DBUtil dbUtil = DBUtil.getInstance(conn);
                rsOuter = dbUtil.executeOracleQuery(sqlQuery, null);
                SQLPLUSCmdFormatter rFormat = new SQLPLUSCmdFormatter(ctx);
                rFormat.formatResults((BufferedOutputStream)ctx.getOutputStream(), rsOuter, sqlQuery);
                rsOuter.close();
                try {
                    if (rsOuter != null) {
                        DBUtil.closeResultSet(rsOuter);
                    }
                    LockManager.unlock(conn);
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                }
                break block14;
                catch (IOException e) {
                    try {
                        if (rsOuter != null) {
                            DBUtil.closeResultSet(rsOuter);
                        }
                        LockManager.unlock(conn);
                    }
                    catch (Exception e2) {
                        ExceptionHandler.handleException(e2);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (rsOuter != null) {
                                DBUtil.closeResultSet(rsOuter);
                            }
                            LockManager.unlock(conn);
                        }
                        catch (Exception e3) {
                            ExceptionHandler.handleException(e3);
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    private String getDBLinkOwner(String objName, String ownerName) {
        String[] dbLink = DBUtil.resolveDBLink(objName);
        if (ownerName.equals("")) {
            String dresult = null;
            String result = null;
            String mod_dblink = dbLink[1];
            String domain = "select value from v$parameter where name IN ('db_domain')";
            dresult = this.executeQuery(domain);
            if (dresult != null && !dresult.equals("")) {
                mod_dblink = dbLink[1] + "." + dresult;
            }
            String sql = "select username from all_db_links where db_link=UPPER('" + mod_dblink + "') AND username IS NOT null";
            String aa = DBUtil.getInstance(this._conn).executeOracleReturnOneCol("select username from all_db_links where db_link=UPPER('mydblink.us.oracle.com') AND username IS NOT null", new HashMap());
            result = this.executeQuery(sql);
            if (result != null && !result.equals("")) {
                return result;
            }
        }
        return ownerName;
    }

    private String getDBLinkOwner(String dbLink) {
        String sql = "select username from all_db_links where db_link=UPPER('" + dbLink + "') AND username IS NOT null";
        String result = this.executeQuery(sql);
        if (result != null && !result.equals("")) {
            return result;
        }
        return null;
    }

    private String getObjType(String objName, String ownerName) {
        String sql = null;
        String result = null;
        String modifiedOwner = null;
        String modifiedObjectName = null;
        boolean noOwnerDatabaseLink = false;
        String[] dbLink = DBUtil.resolveDBLink(objName);
        if (dbLink != null) {
            if (ownerName.equals("")) {
                noOwnerDatabaseLink = true;
                ownerName = this.getDBLinkOwner(objName, ownerName);
            }
            objName = dbLink[0];
            sql = noOwnerDatabaseLink ? "select distinct object_type  from sys.user_objects@" + dbLink[1] : "select distinct object_type  from sys.all_objects@" + dbLink[1];
        } else {
            sql = "select distinct object_type  from sys.all_objects ";
        }
        if (ownerName != null && !ownerName.equals("")) {
            String dblnk = null;
            if (dbLink != null && dbLink[1].length() > 0) {
                dblnk = dbLink[1];
            }
            if (!this.ownerExists(dblnk, ownerName)) {
                String name = "\"" + ownerName.toUpperCase().replaceAll("\"|'", "") + "\".\"" + objName.toUpperCase().replaceAll("\"|'", "") + "\"";
                this.getScriptRunnerContext().write(LINE_SEPARATOR + ScriptRunnerDbArb.format("DESCR_NO_OBJECT", name) + LINE_SEPARATOR);
                return null;
            }
        }
        String strippedObjName = objName.replaceAll("\"|'", "");
        if (objName.startsWith("\"")) {
            modifiedObjectName = "'" + strippedObjName + "'";
            sql = sql + " where object_name ='" + strippedObjName + "'";
        } else {
            modifiedObjectName = "UPPER('" + strippedObjName + "')";
            sql = sql + " where UPPER(object_name) =UPPER('" + strippedObjName + "')";
        }
        String query = "";
        if (noOwnerDatabaseLink) {
            query = sql;
        } else if (ownerName.equals("")) {
            modifiedOwner = "UPPER(sys_context('USERENV', 'CURRENT_USER'))";
            query = sql + " and UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_USER'))";
        } else {
            String strippedOwnerName = ownerName.replaceAll("\"|'", "");
            modifiedOwner = "UPPER('" + strippedOwnerName + "')";
            query = sql + " and UPPER(owner)= UPPER('" + strippedOwnerName + "')";
        }
        query = query + " and object_type != 'INDEX' ";
        query = query + " and object_type != 'TABLE PARTITION' ";
        query = query + " and object_type != 'TABLE SUBPARTITION' ";
        result = this.executeQuery(query);
        if (result == null) {
            result = "";
        }
        if (ownerName.equals("") && result.trim().equals("")) {
            query = sql + "and OBJECT_TYPE ='SYNONYM'";
            result = this.executeQuery(query);
            if (result == null) {
                result = "";
            } else if (!result.trim().equals("")) {
                result = "SYNONYM";
            }
        } else if (result.trim().equals("") && !ownerName.equals("")) {
            String dblink = null;
            if (dbLink != null) {
                dblink = dbLink[1];
            }
            result = !this.checkObjectExists(strippedObjName, modifiedOwner, dblink) && !this.checkObjectExists(strippedObjName, "'PUBLIC'", dblink) ? "UNDEFINED_OBJECT_TYPE" : "SYNONYM";
        }
        if (result.indexOf("TABLE PARTITION") != -1 || result.indexOf("TABLE\nINDEX") != -1) {
            result = "TABLE";
        }
        return result;
    }

    private boolean isTableXMLType(String objName, String ownerName) {
        String sql = null;
        String result = null;
        String modifiedOwner = null;
        String modifiedObjectName = null;
        boolean noOwnerDatabaseLink = false;
        String[] dbLink = DBUtil.resolveDBLink(objName);
        if (dbLink != null) {
            if (ownerName.equals("")) {
                noOwnerDatabaseLink = true;
                ownerName = this.getDBLinkOwner(objName, ownerName);
            }
            objName = dbLink[0];
            sql = noOwnerDatabaseLink ? "select distinct table_name  from sys.user_xml_tables@" + dbLink[1] : "select distinct table_name  from sys.all_xml_tables@" + dbLink[1];
            this.setDblinkName(dbLink[1]);
        } else {
            sql = "select distinct table_name  from sys.all_xml_tables ";
            this.setDblinkName(null);
        }
        if (ownerName != null && !ownerName.equals("")) {
            String dblnk = null;
            if (dbLink != null && dbLink[1].length() > 0) {
                dblnk = dbLink[1];
            }
            if (!this.ownerExists(dblnk, ownerName)) {
                String name = "\"" + ownerName.toUpperCase().replaceAll("\"|'", "") + "\".\"" + objName.toUpperCase().replaceAll("\"|'", "") + "\"";
                this.getScriptRunnerContext().write(LINE_SEPARATOR + ScriptRunnerDbArb.format("DESCR_NO_OBJECT", name) + LINE_SEPARATOR);
                return false;
            }
        }
        String strippedObjName = objName.replaceAll("\"|'", "");
        if (objName.startsWith("\"")) {
            modifiedObjectName = "'" + strippedObjName + "'";
            sql = sql + " where table_name ='" + strippedObjName + "'";
        } else {
            modifiedObjectName = "UPPER('" + strippedObjName + "')";
            sql = sql + " where UPPER(table_name) =UPPER('" + strippedObjName + "')";
        }
        this.setObjectName(modifiedObjectName);
        String query = "";
        if (noOwnerDatabaseLink) {
            query = sql;
        } else if (ownerName.equals("")) {
            this.setOwnerName(ownerName);
            modifiedOwner = "UPPER(sys_context('USERENV', 'CURRENT_USER'))";
            query = sql + " and UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_USER'))";
        } else {
            String strippedOwnerName = ownerName.replaceAll("\"|'", "");
            this.setOwnerName(strippedOwnerName);
            modifiedOwner = "UPPER('" + strippedOwnerName + "')";
            query = sql + " and UPPER(owner)= UPPER('" + strippedOwnerName + "')";
        }
        query = query + " and rownum < 100";
        result = this.executeQuery(query);
        return result != null && result.length() > 0;
    }

    private String getObjTypeDBA(String objName, String ownerName) {
        String sql = null;
        String[] dbLink = DBUtil.resolveDBLink(objName);
        boolean noOwnerDatabaseLink = false;
        if (dbLink != null) {
            if (ownerName.equals("")) {
                noOwnerDatabaseLink = true;
                ownerName = this.getDBLinkOwner(objName, ownerName);
            }
            objName = dbLink[0];
            sql = noOwnerDatabaseLink ? "select distinct object_type  from sys.user_objects@" + dbLink[1] : "select distinct object_type  from sys.dba_objects@" + dbLink[1];
        } else {
            sql = "select distinct object_type  from sys.dba_objects ";
        }
        String strippedObjName = objName.replaceAll("\"|'", "");
        String strippedOwnerName = ownerName.replaceAll("\"|'", "");
        sql = objName.startsWith("\"") ? sql + " where object_name = '" + strippedObjName + "'" : sql + " where UPPER(object_name) = UPPER('" + strippedObjName + "')";
        sql = ownerName.startsWith("\"") ? sql + " and owner = '" + strippedOwnerName + "'" : sql + " and UPPER(owner) = UPPER('" + strippedOwnerName + "')";
        String query = sql;
        query = query + " and object_type != 'INDEX' ";
        query = query + " and rownum < 100";
        String result = this.executeQuery(query);
        if (result == null) {
            result = "";
        }
        if (result.indexOf("TABLE PARTITION") != -1 || result.indexOf("TABLE\nINDEX") != -1) {
            result = "TABLE";
        }
        return result;
    }

    private boolean isDefaultDetailsAvailable(String dblink) {
        String sql = "select 'available' from sys.argument$" + dblink + " where rownum <=1";
        String result = this.executeQuery(sql);
        return result.equals("available");
    }

    private boolean isUserDefinedTypeCollection(String dblink, String objName) {
        String sql = !dblink.equals("") ? "select typecode from sys.all_types@" + dblink + " where type_name=" : "select typecode from sys.all_types where type_name=";
        sql = objName.startsWith("\"") ? sql + "'" + objName.replaceAll("\"|'", "") + "'" : sql + "UPPER('" + objName + "')";
        String result = this.executeQuery(sql = sql + " and UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_USER'))");
        return result.equals("COLLECTION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String executeQuery(String sql) {
        String result;
        block17: {
            result = "";
            Statement stmt = null;
            ResultSet rs = null;
            if (this._conn != null && LockManager.lock(this._conn)) {
                int i;
                stmt = this._conn.createStatement();
                rs = stmt.executeQuery(sql);
                rs.next();
                ResultSetMetaData rsmd = rs.getMetaData();
                int numCols = rsmd.getColumnCount();
                if (numCols == 1) {
                    result = result + rs.getString(1);
                } else {
                    for (i = 1; i <= numCols; ++i) {
                        result = result + rs.getString(i) + ":";
                    }
                }
                while (rs.next()) {
                    result = result + "\n";
                    if (numCols == 1) {
                        result = result + rs.getString(1);
                        continue;
                    }
                    for (i = 1; i <= numCols; ++i) {
                        result = result + rs.getString(i) + ":";
                    }
                }
                Closeables.close(stmt, rs);
                try {
                    LockManager.unlock(this._conn);
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                }
                break block17;
                catch (SQLException e) {
                    Closeables.close(stmt, rs);
                    try {
                        LockManager.unlock(this._conn);
                    }
                    catch (Exception e2) {
                        ExceptionHandler.handleException(e2);
                    }
                    catch (Throwable throwable) {
                        Closeables.close(stmt, rs);
                        try {
                            LockManager.unlock(this._conn);
                        }
                        catch (Exception e3) {
                            ExceptionHandler.handleException(e3);
                        }
                        throw throwable;
                    }
                }
            }
        }
        return result;
    }

    private String[] getBaseSynonymObj(String synonymName, String synonymOwner) {
        String synonymOwnerTrim;
        String sqlPrivate = null;
        String sqlPublic = null;
        String result = null;
        String sql = "select table_owner ,table_name, db_link from all_synonyms where  synonym_name = ";
        String strippedSynonymName = synonymName.replaceAll("\"", "");
        sql = synonymName.startsWith("\"") ? sql + "'" + strippedSynonymName + "'" : sql + "UPPER('" + strippedSynonymName + "')";
        String string = synonymOwnerTrim = synonymOwner == null ? "" : synonymOwner.trim();
        if (synonymOwnerTrim.length() > 2 && synonymOwnerTrim.startsWith("\"") && synonymOwnerTrim.endsWith("\"")) {
            synonymOwnerTrim = synonymOwnerTrim.substring(1, synonymOwnerTrim.length() - 1);
        }
        if ((result = this.executeQuery(sqlPrivate = !synonymOwnerTrim.equals("") && !synonymOwnerTrim.equalsIgnoreCase("SYS") ? sql + " and owner =UPPER('" + synonymOwnerTrim + "')" : sql + " and (UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_USER')) )")) == null || result.trim().equals("")) {
            sqlPublic = sql + " and ( owner = 'PUBLIC')";
            result = this.executeQuery(sqlPublic);
        }
        String table_owner = "";
        String table_name = "";
        String db_link = "";
        String obj_type = "";
        if (result == null || result.trim().equals("")) {
            result = "";
        } else {
            List<String> items = Arrays.asList(result.split("\\s*:\\s*"));
            table_owner = items.get(0);
            table_name = items.get(1);
            db_link = items.get(2);
            if (table_owner.equals("null") && !db_link.equals("null")) {
                table_owner = this.getDBLinkOwner(db_link);
            }
            table_name = '\"' + table_name + '\"';
            if (db_link != null) {
                if (!db_link.equalsIgnoreCase("null")) {
                    table_name = table_name + "@" + db_link;
                    obj_type = this.getObjType(table_name, table_owner);
                } else {
                    obj_type = this.getObjType(table_name, table_owner);
                }
            } else {
                obj_type = this.getObjType(table_name, table_owner);
            }
        }
        String[] res = new String[]{table_owner, table_name, obj_type};
        return res;
    }

    private String[] getBaseSynonymObjectRecursive(String synonymName, String synonymOwner) {
        String[] details;
        ArrayList<String> synonymList = new ArrayList<String>();
        String[] dbLink = DBUtil.resolveDBLink(synonymName);
        if (dbLink != null) {
            synonymName = this.getObjectName(dbLink[0]).replaceAll("\"|'", "");
        }
        if ((details = this.getBaseSynonymObj(synonymName, synonymOwner))[2] == null) {
            return null;
        }
        if (details[2] != null && details[2].equals("")) {
            this.getScriptRunnerContext().write(LINE_SEPARATOR + ScriptRunnerDbArb.format("DESCR_NO_BASE_OBJECT", "\"" + synonymName + "\"") + LINE_SEPARATOR);
            return null;
        }
        if (details[2].equals("SYNONYM")) {
            if ("".equals(details[0])) {
                synonymList.add(details[1]);
            } else {
                synonymList.add(details[0] + "." + details[1]);
            }
            boolean exists = false;
            do {
                if ((details = this.getBaseSynonymObj(details[1], details[0]))[2] == null) {
                    return null;
                }
                exists = "".equals(details[0]) ? synonymList.contains(details[0]) : synonymList.contains(details[0] + "." + details[1]);
                if (exists) {
                    this.getScriptRunnerContext().write(LINE_SEPARATOR + ScriptRunnerDbArb.format("DESCR_NO_BASE_OBJECT", "\"" + synonymName + "\"") + LINE_SEPARATOR);
                    return null;
                }
                if ("".equals(details[0])) {
                    synonymList.add(details[1]);
                    continue;
                }
                synonymList.add(details[0] + "." + details[1]);
            } while (details[2].equals("SYNONYM"));
        }
        String[] objectDetails = new String[]{details[0], "'" + details[1] + "'", details[2]};
        return objectDetails;
    }

    public String upperCaseLocaleUS(ScriptRunnerContext ctx, String lower) {
        String retVal = null;
        retVal = lower == null || lower.equals("") ? lower : lower.toUpperCase(Locale.US);
        return retVal;
    }

    private void writeOutputHeader(String objectName, String objectType, ScriptRunnerContext ctx, String datatype) {
        if (objectType.equals("PROCEDURE")) {
            ctx.write(LINE_SEPARATOR + objectType + " " + objectName + LINE_SEPARATOR);
        } else if (objectType.equals("FUNCTION")) {
            ctx.write(LINE_SEPARATOR + objectType + " " + objectName + " RETURNS " + datatype + LINE_SEPARATOR);
        }
    }

    private void writeTypeOutputHeader(String objName, String objectType, ScriptRunnerContext ctx, String dblink, String owner) {
        String sql = null;
        sql = owner == null ? "select case when t.upper_bound is null then t.COLL_TYPE\n    \telse decode (t.COLL_TYPE, 'VARYING ARRAY', 'VARRAY') ||'('||t.upper_bound||')'     \n   end || ' OF ' || d.referenced_name from sys.all_coll_types t, sys.all_dependencies d \n   where d.referenced_name != 'STANDARD' and t.owner=d.owner and t.type_name = d.name\n   and t.type_name = " : "select case when t.upper_bound is null then t.COLL_TYPE\n    \telse decode (t.COLL_TYPE, 'VARYING ARRAY', 'VARRAY') ||'('||t.upper_bound||')'     \n   end || ' OF ' || d.referenced_owner || '.' ||d.referenced_name from sys.all_coll_types t, sys.all_dependencies d \n   where d.referenced_name != 'STANDARD' and t.owner=d.owner and t.type_name = d.name\n   and t.type_name = ";
        sql = objName.startsWith("\"") ? sql + "'" + objName.replaceAll("\"|'", "") + "'" : sql + "UPPER('" + objName + "')";
        String result = this.executeQuery(sql = sql + " and UPPER(t.owner)= UPPER(sys_context('USERENV', 'CURRENT_USER'))");
        if (result != null && !result.equals("")) {
            ctx.write(LINE_SEPARATOR + objName + " " + result);
        }
    }

    private String getFunctionReturnType(String dblink, String objName) {
        String sql = !dblink.equals("") ? "select data_type from sys.all_arguments@" + dblink + " where object_name=" : "select data_type from sys.all_arguments where object_name=";
        sql = objName.startsWith("\"") ? sql + "'" + objName.replaceAll("\"|'", "") + "'" : sql + "UPPER('" + objName + "')";
        sql = sql + " and UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_USER')) and argument_name is NULL";
        String result = this.executeQuery(sql);
        return result;
    }

    private String[] getReferencedType(String dblink, String objName) {
        String[] res = new String[3];
        String sql = !dblink.equals("") ? "select data_type from sys.all_arguments@" + dblink + " where object_name=" : "select referenced_owner, referenced_name, referenced_type FROM sys.all_dependencies where referenced_name != 'STANDARD' and name=";
        sql = objName.startsWith("\"") ? sql + "'" + objName.replaceAll("\"|'", "") + "'" : sql + "UPPER('" + objName + "')";
        String result = this.executeQuery(sql = sql + " and UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_USER')) ");
        if (result == null || result.trim().equals("")) {
            res[0] = null;
            res[1] = "";
            res[2] = null;
        } else {
            List<String> items = Arrays.asList(result.split("\\s*:\\s*"));
            res[0] = items.get(0);
            res[1] = items.get(1);
            res[2] = items.get(2);
        }
        return res;
    }

    private boolean ownerExists(String dblink, String ownerName) {
        if ((ownerName = ownerName.replaceAll("\"|'", "")).equalsIgnoreCase("public") || ownerName.equalsIgnoreCase("sys")) {
            return true;
        }
        String sql = dblink != null && !dblink.equals("") ? "select username from sys.all_users@" + dblink + " where username=" : "select username from sys.all_users where username=";
        String result = this.executeQuery(sql = sql + "UPPER('" + ownerName + "')");
        return result != null && !result.equals("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkObjectExists(String rawName) {
        block24: {
            if (this._conn == null) {
                return false;
            }
            String sqlScript = "";
            String objName = "";
            String ownerName = "";
            String[] dbLink = DBUtil.resolveDBLink(rawName);
            if (dbLink != null) {
                objName = dbLink[0];
                sqlScript = "select count(*) from sys.all_objects@" + dbLink[1];
                objName = this.getObjectName(objName).replaceAll("\"|'", "");
            } else {
                sqlScript = "select count(*) from sys.all_objects ";
                objName = this.getObjectName(rawName).replaceAll("\"|'", "");
            }
            sqlScript = sqlScript + " where object_name = UPPER('" + objName + "')";
            ownerName = this.getObjectOwner(rawName);
            String objectType = ownerName == null ? this.getObjType(objName, "") : this.getObjType(objName, ownerName);
            if (objectType == null || objectType.equals("UNDEFINED_OBJECT_TYPE")) {
                return false;
            }
            ResultSet rset = null;
            if (this._conn != null && LockManager.lock(this._conn)) {
                block23: {
                    if (objectType != null && !objectType.equalsIgnoreCase("SYNONYM") && ownerName != null) {
                        ownerName = "UPPER('" + ownerName.replaceAll("\"|'", "") + "')";
                        sqlScript = sqlScript + " and owner = " + ownerName;
                    }
                    PreparedStatement checkStmt = this._conn.prepareStatement(sqlScript);
                    rset = checkStmt.executeQuery();
                    rset.next();
                    if (rset.getInt(1) != 0) break block23;
                    boolean bl = false;
                    try {
                        if (rset != null) {
                            DBUtil.closeResultSet(rset);
                        }
                        LockManager.unlock(this._conn);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handleException(e);
                    }
                    return bl;
                }
                boolean bl = true;
                try {
                    if (rset != null) {
                        DBUtil.closeResultSet(rset);
                    }
                    LockManager.unlock(this._conn);
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                }
                return bl;
                catch (SQLException checkStmt) {
                    try {
                        if (rset != null) {
                            DBUtil.closeResultSet(rset);
                        }
                        LockManager.unlock(this._conn);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handleException(e);
                    }
                    break block24;
                    catch (Throwable throwable) {
                        try {
                            if (rset != null) {
                                DBUtil.closeResultSet(rset);
                            }
                            LockManager.unlock(this._conn);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handleException(e);
                        }
                        throw throwable;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkObjectExists(String objName, String ownerName, String dblink) {
        block21: {
            if (this._conn == null) {
                return false;
            }
            String sqlScript = "";
            sqlScript = dblink != null ? "select count(*) from sys.all_objects@" + dblink : "select count(*) from sys.all_objects ";
            objName = "UPPER('" + this.getObjectName(objName).replaceAll("\"|'", "") + "')";
            sqlScript = sqlScript + " where object_name = " + objName;
            if (ownerName != null || !ownerName.equals("")) {
                sqlScript = sqlScript + " and owner = " + ownerName;
            }
            ResultSet rset = null;
            if (this._conn != null && LockManager.lock(this._conn)) {
                block20: {
                    PreparedStatement checkStmt = this._conn.prepareStatement(sqlScript);
                    rset = checkStmt.executeQuery();
                    rset.next();
                    if (rset.getInt(1) != 0) break block20;
                    boolean bl = false;
                    try {
                        if (rset != null) {
                            DBUtil.closeResultSet(rset);
                        }
                        LockManager.unlock(this._conn);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handleException(e);
                    }
                    return bl;
                }
                boolean bl = true;
                try {
                    if (rset != null) {
                        DBUtil.closeResultSet(rset);
                    }
                    LockManager.unlock(this._conn);
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                }
                return bl;
                catch (SQLException checkStmt) {
                    try {
                        if (rset != null) {
                            DBUtil.closeResultSet(rset);
                        }
                        LockManager.unlock(this._conn);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handleException(e);
                    }
                    break block21;
                    catch (Throwable throwable) {
                        try {
                            if (rset != null) {
                                DBUtil.closeResultSet(rset);
                            }
                            LockManager.unlock(this._conn);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handleException(e);
                        }
                        throw throwable;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileViewIfRequired(ScriptRunnerContext ctx, Connection conn, String dbLinkName, String[] res, boolean ownerNotSpecified) {
        DBUtil dbUtil = DBUtil.getInstance(conn);
        ResultSet rset = null;
        if (conn != null && LockManager.lock(conn)) {
            try {
                String statusScript;
                String sqlScript;
                String viewName;
                if (!ownerNotSpecified) {
                    viewName = res[0] + "." + res[1];
                    sqlScript = this.owner_view_status_compile.replaceAll("<db_link>", dbLinkName).replaceAll("<owner>", this.escapeMetaCharacters(res[0])).replaceAll("<object_name>", this.escapeMetaCharacters(res[1]));
                    statusScript = this.owner_view_status.replaceAll("<db_link>", dbLinkName).replaceAll("<owner>", this.escapeMetaCharacters(res[0])).replaceAll("<object_name>", this.escapeMetaCharacters(res[1]));
                } else {
                    viewName = res[1];
                    sqlScript = this.view_status_compile.replaceAll("<db_link>", this.escapeMetaCharacters(dbLinkName)).replaceAll("<object_name>", this.escapeMetaCharacters(res[1]));
                    statusScript = this.view_status.replaceAll("<db_link>", dbLinkName).replaceAll("<object_name>", this.escapeMetaCharacters(res[1]));
                }
                if ("".equals(viewName)) {
                    boolean bl = false;
                    return bl;
                }
                dbUtil.executeOracleQuery(sqlScript, null);
                PreparedStatement checkStmt = conn.prepareStatement(statusScript);
                rset = checkStmt.executeQuery();
                rset.next();
                if (rset.getString(1).equalsIgnoreCase("INVALID")) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (SQLException checkStmt) {
            }
            finally {
                try {
                    LockManager.unlock(conn);
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                }
            }
        }
        return true;
    }

    public String escapeMetaCharacters(String inputString) {
        String[] metaCharacters = new String[]{"\\", "^", "$", "{", "}", "[", "]", "(", ")", ".", "*", "+", "?", "|", "<", ">", "-", "&", "%", "#"};
        for (int i = 0; i < metaCharacters.length; ++i) {
            if (!inputString.contains(metaCharacters[i])) continue;
            inputString = inputString.replace(metaCharacters[i], "\\" + metaCharacters[i]);
        }
        return inputString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isObjectStatusValid(Connection conn, String[] res, String objectType) {
        block28: {
            if (conn == null) {
                return false;
            }
            if ("".equals(res[1])) {
                return false;
            }
            String sqlScript = "";
            String objName = "";
            String ownerName = "";
            boolean isValidObject = false;
            String valString = "";
            String[] dbLink = DBUtil.resolveDBLink(res[1]);
            if (dbLink != null) {
                objName = dbLink[0];
                sqlScript = "select status from sys.all_objects@" + dbLink[1];
                objName = "UPPER('" + this.getObjectName(objName).replaceAll("\"|'", "") + "')";
            } else {
                sqlScript = "select status from sys.all_objects ";
                objName = "UPPER('" + this.getObjectName(res[1]).replaceAll("\"|'", "") + "')";
            }
            sqlScript = sqlScript + " where object_name = " + objName;
            ownerName = res[0];
            ResultSet rset = null;
            if (conn != null && LockManager.lock(conn)) {
                block26: {
                    block27: {
                        if (ownerName != null && !ownerName.equals("")) {
                            ownerName = "UPPER('" + ownerName.replaceAll("\"|'", "") + "')";
                            sqlScript = sqlScript + " and owner = " + ownerName;
                            valString = res[0] + ".";
                        }
                        valString = valString + res[1];
                        PreparedStatement checkStmt = conn.prepareStatement(sqlScript);
                        rset = checkStmt.executeQuery();
                        rset.next();
                        isValidObject = !rset.getString(1).equalsIgnoreCase("INVALID");
                        if (isValidObject) break block26;
                        String sqlstmt = "ALTER " + objectType + " " + valString + " COMPILE";
                        Statement stmt = conn.createStatement();
                        stmt.executeQuery(sqlstmt);
                        checkStmt = conn.prepareStatement(sqlScript);
                        rset = checkStmt.executeQuery();
                        rset.next();
                        if (!rset.getString(1).equalsIgnoreCase("INVALID")) break block27;
                        boolean bl = false;
                        try {
                            if (rset != null) {
                                DBUtil.closeResultSet(rset);
                            }
                            LockManager.unlock(conn);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handleException(e);
                        }
                        return bl;
                    }
                    boolean bl = true;
                    try {
                        if (rset != null) {
                            DBUtil.closeResultSet(rset);
                        }
                        LockManager.unlock(conn);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handleException(e);
                    }
                    return bl;
                }
                try {
                    if (rset != null) {
                        DBUtil.closeResultSet(rset);
                    }
                    LockManager.unlock(conn);
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                }
                break block28;
                catch (SQLException e) {
                    try {
                        if (rset != null) {
                            DBUtil.closeResultSet(rset);
                        }
                        LockManager.unlock(conn);
                    }
                    catch (Exception e2) {
                        ExceptionHandler.handleException(e2);
                    }
                    break block28;
                    catch (Throwable throwable) {
                        try {
                            if (rset != null) {
                                DBUtil.closeResultSet(rset);
                            }
                            LockManager.unlock(conn);
                        }
                        catch (Exception e3) {
                            ExceptionHandler.handleException(e3);
                        }
                        throw throwable;
                    }
                }
            }
        }
        return true;
    }

    private boolean isValidDBLinkConnection(ScriptRunnerContext ctx, String rawName) {
        if (!rawName.contains("@")) {
            return true;
        }
        String sqlScript = "";
        String[] dbLink = rawName.split("@");
        if (dbLink != null) {
            if (dbLink.length == 2) {
                sqlScript = "select * from dual@" + dbLink[1];
            } else if (dbLink.length > 2) {
                String newDBlink = rawName.substring(rawName.indexOf("@"), rawName.length());
                sqlScript = "select * from dual" + newDBlink;
            }
        } else {
            return true;
        }
        String result = this.executeQuery(sqlScript);
        if (result != null && result.equalsIgnoreCase("X")) {
            return true;
        }
        ctx.write(ScriptRunnerDbArb.getString("DESCRIBE_INVALID_DBLINK") + LINE_SEPARATOR);
        ctx.putProperty("descr.usage", Boolean.FALSE);
        return false;
    }

    private String getObjectName(String object) {
        String[] names = object.split("\\.");
        if (names.length == 1) {
            return names[0];
        }
        if (names.length == 2) {
            return names[1];
        }
        return object;
    }

    private String getObjectOwner(String object) {
        String[] names = object.split("\\.");
        if (names.length == 1) {
            return null;
        }
        if (names.length == 2) {
            return names[0];
        }
        return null;
    }

    private ScriptRunnerContext getScriptRunnerContext() {
        return this.m_ctx;
    }

    private void setScriptRunnerContext(ScriptRunnerContext ctx) {
        this.m_ctx = ctx;
    }

    private String getCurrentUser() {
        return DBUtil.getInstance(this._conn).executeOracleReturnOneCol("select USER from dual", new HashMap());
    }

    private void describeTypeMethods(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        cmd.setStmtClass(SQLCommand.StmtType.G_C_SQL);
        cmd.setResultsType(SQLCommand.StmtResultType.G_R_QUERY);
        this.addColumnFormatForStoreProcedures(conn, ctx);
        for (int i = 1; i <= this.m_numberOfMethods; ++i) {
            ctx.write(LINE_SEPARATOR);
            ctx.write("METHOD" + LINE_SEPARATOR);
            ctx.write("------" + LINE_SEPARATOR);
            this.getTypeMethodsSignature(conn, ctx, i, this.m_typeMethodNames.get(i - 1));
            this.writeTypeMethodArguments(conn, ctx, i);
        }
        this.clearColumnFormatForStoreProcedures(ctx);
        ctx.write(LINE_SEPARATOR);
        this.reclaimTypeMethodStorage();
    }

    private boolean getTypeMethodsSignature(Connection conn, ScriptRunnerContext ctx, int method_no, String method_name) {
        Query q = null;
        String sqlQuery = null;
        q = this.m_xml.getQuery("DESC_TYPE_METHOD_SIGNATURE", conn);
        sqlQuery = q.getSql();
        sqlQuery = sqlQuery.replace(":1", this.m_typeName[0]);
        sqlQuery = sqlQuery.replace(":2", "'" + this.m_typeName[1] + "'");
        sqlQuery = sqlQuery.replace(":3", "'" + method_name + "'");
        String dresult = this.executeQuery(sqlQuery = sqlQuery.replace(":4", Integer.toString(method_no)));
        if (dresult != null && !dresult.equals("")) {
            if (this.m_typeSelfMethods.contains(method_no)) {
                dresult = dresult.replace("STATIC", "MEMBER");
            }
            ctx.write(dresult);
        }
        return true;
    }

    private boolean writeTypeMethodArguments(Connection conn, ScriptRunnerContext ctx, int method_no) {
        Query q = null;
        String sqlQuery = null;
        q = this.m_xml.getQuery("DESC_TYPE_METHOD_ARGUMENTS", conn);
        sqlQuery = q.getSql().replaceAll("'", "''");
        sqlQuery = MessageFormat.format(sqlQuery, this.m_formatArgs);
        try {
            this.packageArgumentsDisplay(conn, ctx, Integer.toString(method_no), this.m_formatArgs, this.m_typeName, sqlQuery);
        }
        catch (Exception ex) {
            ExceptionHandler.handleException(ex);
        }
        return true;
    }

    private boolean isTypeMethodsExists(Connection conn, ScriptRunnerContext ctx, String[] objectName, Object[] formatArgs) throws SQLException {
        this.initializeTypeMethodStorage();
        String ownerName = !objectName[0].equals("") ? "UPPER('" + objectName[0] + "')" : "UPPER(sys_context('USERENV', 'CURRENT_USER'))";
        formatArgs[formatArgs.length - 1] = ownerName;
        String objName = objectName[1];
        String sqlScript = "select count(*) from all_type_methods where type_name = UPPER('" + objName + "') and UPPER(owner) = " + ownerName;
        String listMethods = "select method_name from all_type_methods where type_name = UPPER('" + objName + "') and UPPER(owner) = " + ownerName + " order by method_no";
        String selfMethods = "select distinct tm.method_no from all_arguments aa, all_type_methods tm where \naa.owner = tm.owner and aa.package_name = tm.type_name and aa.object_name = tm.method_name and aa.argument_name = 'SELF'\nand tm.final != 'YES' and tm.method_type = 'PUBLIC' and UPPER(tm.owner) = " + ownerName + " and tm.type_name = UPPER('" + objName + "')\norder by tm.method_no";
        String dresult = this.executeQuery(sqlScript);
        if (dresult != null && !dresult.equals("")) {
            this.m_numberOfMethods = Integer.parseInt(dresult);
            if (this.m_numberOfMethods > 0) {
                String rSelf;
                String rList = this.executeQuery(listMethods);
                if (rList != null && !rList.equals("")) {
                    this.m_typeMethodNames = new ArrayList<String>(Arrays.asList(rList.split("\\n")));
                }
                if ((rSelf = this.executeQuery(selfMethods)) != null && !rSelf.equals("")) {
                    this.m_typeSelfMethods = this.getIntegerArrayFromStringArray(new ArrayList<String>(Arrays.asList(rSelf.split("\\n"))));
                }
                this.m_typeName[0] = ownerName;
                this.m_typeName[1] = objName;
                this.m_formatArgs = formatArgs;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    private ArrayList<Integer> getIntegerArrayFromStringArray(ArrayList<String> stringArray) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String stringValue : stringArray) {
            try {
                result.add(Integer.parseInt(stringValue));
            }
            catch (NumberFormatException nfe) {
                ExceptionHandler.handleException(nfe);
            }
        }
        return result;
    }

    private void initializeTypeMethodStorage() {
        this.m_isTypeMethods = false;
        this.m_numberOfMethods = 0;
        this.m_typeMethodNames = new ArrayList();
        this.m_typeSelfMethods = new ArrayList();
        this.m_typeName = new String[2];
        this.m_formatArgs = new Object[6];
    }

    private void reclaimTypeMethodStorage() {
        this.m_isTypeMethods = false;
        this.m_numberOfMethods = 0;
        this.m_typeMethodNames = null;
        this.m_typeSelfMethods = null;
        this.m_typeName = null;
        this.m_formatArgs = null;
    }

    public String getObjectName() {
        return this.m_objectName;
    }

    public void setObjectName(String objectName) {
        this.m_objectName = objectName;
    }

    public String getOwnerName() {
        return this.m_ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.m_ownerName = ownerName;
    }

    public String getDblinkName() {
        return this.m_dblinkName;
    }

    public void setDblinkName(String dblinkName) {
        this.m_dblinkName = dblinkName;
    }
}

