/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.soda.OracleCollection;
import oracle.soda.OracleCursor;
import oracle.soda.OracleDatabase;
import oracle.soda.OracleDocument;
import oracle.soda.rdbms.OracleRDBMSClient;

@Restricted(level=Restricted.Level.NONE)
public class SODACommand
extends CommandListener
implements IHelp {
    private ScriptRunnerContext _ctx;
    private static Logger LOGGER = Logger.getLogger(SODACommand.class.getName());

    @Override
    public String getCommand() {
        return "SODA";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        this._ctx = ctx;
        if (!cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("soda")) {
            return false;
        }
        String soda_cmd = cmd.getSql().trim();
        String[] cmdParts = soda_cmd.split(" ");
        int len = cmdParts.length;
        boolean replace_success = false;
        boolean insert_success = false;
        ArrayList<String> commands = new ArrayList<String>(){
            {
                this.add("create");
                this.add("insert");
                this.add("list");
                this.add("get");
                this.add("drop");
                this.add("find");
                this.add("count");
                this.add("remove");
                this.add("replace");
                this.add("help");
            }
        };
        if (SODACommand.matches("soda", cmdParts[0])) {
            block152: {
                if (len < 2) {
                    ctx.write(this.getHelp());
                } else if (commands.contains(cmdParts[1])) {
                    try {
                        OracleRDBMSClient cl = new OracleRDBMSClient();
                        OracleDatabase db = cl.getDatabase(conn);
                        if (cmdParts[1].equalsIgnoreCase("help")) {
                            if (len <= 2) {
                                ctx.write(this.getHelp());
                            } else if (len > 2 && cmdParts[2].equalsIgnoreCase("create")) {
                                ctx.write(Messages.getString("SODA_HELP_CREATE"));
                            } else if (len > 2 && cmdParts[2].equalsIgnoreCase("list")) {
                                ctx.write(Messages.getString("SODA_HELP_LIST"));
                            } else if (len > 2 && cmdParts[2].equalsIgnoreCase("find")) {
                                ctx.write(Messages.getString("SODA_HELP_FIND"));
                            } else if (len > 2 && cmdParts[2].equalsIgnoreCase("get")) {
                                ctx.write(Messages.getString("SODA_HELP_GET"));
                            } else if (len > 2 && cmdParts[2].equalsIgnoreCase("drop")) {
                                ctx.write(Messages.getString("SODA_HELP_DROP"));
                            } else if (len > 2 && cmdParts[2].equalsIgnoreCase("count")) {
                                ctx.write(Messages.getString("SODA_HELP_COUNT"));
                            } else if (len > 2 && cmdParts[2].equalsIgnoreCase("insert")) {
                                ctx.write(Messages.getString("SODA_HELP_INSERT"));
                            } else if (len > 2 && cmdParts[2].equalsIgnoreCase("replace")) {
                                ctx.write(Messages.getString("SODA_HELP_REPLACE"));
                            } else if (len > 2 && cmdParts[2].equalsIgnoreCase("remove")) {
                                ctx.write(Messages.getString("SODA_HELP_REMOVE"));
                            } else {
                                ctx.write(Messages.getString("UNRECOGNIZED_COMMAND"));
                                ctx.write(this.getHelp());
                            }
                            break block152;
                        }
                        if (cmdParts[1].equalsIgnoreCase("create")) {
                            try {
                                List coll_names = db.admin().getCollectionNames();
                                if (coll_names.contains(cmdParts[2])) {
                                    ctx.write(MessageFormat.format(Messages.getString("COLLECTION_EXISTS"), cmdParts[2]) + "\n");
                                    break block152;
                                }
                                OracleCollection col = db.admin().createCollection(cmdParts[2]);
                                ctx.write(MessageFormat.format(Messages.getString("NEW_COLLECTION_SUCCESS"), cmdParts[2]) + "\n\n");
                            }
                            catch (Exception e) {
                                if (len < 3) {
                                    ctx.write(Messages.getString("MISSING_COLLECTION_NAME") + "\n");
                                    ctx.write(Messages.getString("SODA_HELP_CREATE") + "\n\n");
                                    break block152;
                                }
                                ctx.write(MessageFormat.format(Messages.getString("COMMAND_FAILED"), soda_cmd) + "\n");
                            }
                            break block152;
                        }
                        if (cmdParts[1].equalsIgnoreCase("list")) {
                            try {
                                List coll_names = db.admin().getCollectionNames();
                                if (coll_names.isEmpty()) {
                                    ctx.write(Messages.getString("NO_EXISTING_COLLECTIONS") + "\n\n");
                                    break block152;
                                }
                                ctx.write(Messages.getString("COLLECTION_LIST") + "\n\n");
                                for (String name : db.admin().getCollectionNames()) {
                                    ctx.write(MessageFormat.format(Messages.getString("SIMPLE_OUTPUT"), name) + "\n");
                                }
                                ctx.write("\n");
                            }
                            catch (Exception e) {
                                if (e.getCause() instanceof SQLException) {
                                    ctx.write(e.getCause().getMessage() + "\n");
                                }
                                ctx.write(MessageFormat.format(Messages.getString("COMMAND_FAILED"), soda_cmd) + "\n");
                            }
                            break block152;
                        }
                        if (cmdParts[1].equalsIgnoreCase("insert") || cmdParts[1].equalsIgnoreCase("replace")) {
                            try {
                                int arglen = 0;
                                if (cmdParts[1].equalsIgnoreCase("insert")) {
                                    arglen = 3;
                                } else if (cmdParts[1].equalsIgnoreCase("replace")) {
                                    arglen = 4;
                                }
                                String json_str = SODACommand.formQBE(cmdParts, soda_cmd, arglen);
                                String json_filename = "";
                                boolean json_file = false;
                                if (!json_str.startsWith("{") || !json_str.endsWith("}")) {
                                    json_file = true;
                                    json_filename = json_str;
                                    json_str = SODACommand.readFile(json_filename);
                                }
                                OracleCollection ocol = db.openCollection(cmdParts[2]);
                                OracleDocument doc = db.createDocumentFromString(json_str);
                                if (cmdParts[1].equalsIgnoreCase("insert")) {
                                    OracleDocument insertedDoc = ocol.insertAndGet(doc);
                                    String key = insertedDoc.getKey();
                                    ctx.write(Messages.getString("JSON_STR_INSERT_SUCCESS") + "\n\n");
                                    insert_success = true;
                                    if (json_file) {
                                        ctx.write(MessageFormat.format(Messages.getString("JSON_DOC_INSERT_SUCCESS"), json_filename) + "\n\n");
                                    }
                                } else if (cmdParts[1].equalsIgnoreCase("replace")) {
                                    OracleDocument resultDoc = ocol.find().key(cmdParts[3]).replaceOneAndGet(doc);
                                    String key_ex = resultDoc.getKey();
                                    System.out.println(key_ex);
                                    if (resultDoc != null) {
                                        String key = resultDoc.getKey();
                                        String createdOn = resultDoc.getCreatedOn();
                                        ctx.write(Messages.getString("JSON_STR_REPLACE_SUCCESS") + "\n\n");
                                        replace_success = true;
                                        if (json_file) {
                                            ctx.write(MessageFormat.format(Messages.getString("JSON_DOC_REPLACE_SUCCESS"), json_filename) + "\n\n");
                                        }
                                    }
                                }
                                break block152;
                            }
                            catch (NoSuchFileException nofile_e) {
                                int cmd_pos = 0;
                                if (cmdParts[1].equalsIgnoreCase("insert")) {
                                    cmd_pos = 3;
                                } else if (cmdParts[1].equalsIgnoreCase("replace")) {
                                    cmd_pos = 4;
                                }
                                String input_str = soda_cmd.split(" ", 5)[4];
                                ctx.write(MessageFormat.format(Messages.getString("INVALID_JSON"), input_str));
                            }
                            catch (Exception e) {
                                String exception_class = e.getClass().toString();
                                String exception_type = exception_class.substring(exception_class.lastIndexOf(".") + 1);
                                if (cmdParts[1].equalsIgnoreCase("insert") && len < 4) {
                                    ctx.write(Messages.getString("SODA_INSERT_USAGE") + "\n");
                                    break block152;
                                }
                                if (cmdParts[1].equalsIgnoreCase("replace") && len < 5) {
                                    ctx.write(Messages.getString("NOT_ENOUGH_ARGS") + "\n");
                                    ctx.write(Messages.getString("SODA_HELP_REPLACE") + "\n");
                                    break block152;
                                }
                                if (!SODACommand.isExistingColl(cmdParts[2], db)) {
                                    ctx.write(MessageFormat.format(Messages.getString("COLLECTION_NON_EXISTANT"), cmdParts[2]));
                                    break block152;
                                }
                                if (cmdParts[1].equalsIgnoreCase("replace") && exception_type.equals("NullPointerException")) {
                                    ctx.write(MessageFormat.format(Messages.getString("INVALID_KEY"), cmdParts[3]));
                                    break block152;
                                }
                                String message = null;
                                String cause_str = null;
                                message = e.getMessage();
                                ctx.write(MessageFormat.format(Messages.getString("COMMAND_FAILED"), soda_cmd) + "\n");
                                if (message != null) {
                                    ctx.write(MessageFormat.format(Messages.getString("ERR_MSG"), message) + "\n");
                                    break block152;
                                }
                                try {
                                    Throwable cause = e.getCause();
                                    cause_str = cause.toString();
                                    if (cause_str != null) {
                                        ctx.write(MessageFormat.format(Messages.getString("ERR_MSG"), cause_str) + "\n");
                                    }
                                    break block152;
                                }
                                catch (Exception el) {
                                    ctx.write(MessageFormat.format(Messages.getString("COMMAND_FAILED"), soda_cmd) + "\n");
                                }
                            }
                            break block152;
                        }
                        if (cmdParts[1].equalsIgnoreCase("get") || cmdParts[1].equalsIgnoreCase("find")) {
                            try (OracleCursor c = null;){
                                OracleCollection ocol = db.openCollection(cmdParts[2]);
                                if (cmdParts[3].equalsIgnoreCase("-all")) {
                                    c = ocol.find().getCursor();
                                    long cnt = ocol.find().count();
                                    if (cnt > 0L) {
                                        String key_header = Messages.getString("HEADER_GET_COLLECTION_KEY");
                                        String coll_header = Messages.getString("HEADER_GET_COLLECTION_DATE");
                                        key_header = this.underLine(key_header.replace("", ""));
                                        coll_header = this.underLine(coll_header.replace("", ""));
                                        ctx.write(MessageFormat.format(Messages.getString("SIMPLE_OUTPUT"), key_header));
                                        ctx.write("\t\t\t\t\t" + MessageFormat.format(Messages.getString("SIMPLE_OUTPUT"), coll_header) + "\n\n");
                                        while (c.hasNext()) {
                                            OracleDocument resultDoc = c.next();
                                            String key = resultDoc.getKey();
                                            String createdon = resultDoc.getCreatedOn();
                                            ctx.write(MessageFormat.format(Messages.getString("SIMPLE_OUTPUT"), key));
                                            ctx.write("\t" + MessageFormat.format(Messages.getString("SIMPLE_OUTPUT"), createdon) + "\n");
                                        }
                                    }
                                    String msg = "RECORD_COUNT_GET";
                                    SODACommand.printCountMessage(cnt, msg, ctx);
                                } else if (cmdParts[3].equalsIgnoreCase("-f")) {
                                    int arglen = 4;
                                    String qbe = SODACommand.formQBE(cmdParts, soda_cmd, arglen);
                                    OracleDocument doc = db.createDocumentFromString(qbe);
                                    c = ocol.find().filter(doc).getCursor();
                                    long cnt = ocol.find().filter(doc).count();
                                    if (cnt > 0L) {
                                        while (c.hasNext()) {
                                            OracleDocument resultDoc = c.next();
                                            ctx.write("\n" + MessageFormat.format(Messages.getString("GET_KEY"), resultDoc.getKey()) + "\n");
                                            ctx.write(MessageFormat.format(Messages.getString("GET_CONTENT"), resultDoc.getContentAsString()) + "\n");
                                            ctx.write(Messages.getString("SEPARATOR"));
                                        }
                                    }
                                    String msg = "RECORD_COUNT_GET";
                                    SODACommand.printCountMessage(cnt, msg, ctx);
                                } else if (cmdParts[3].equalsIgnoreCase("-k")) {
                                    OracleDocument resultDoc = ocol.find().key(cmdParts[4]).getOne();
                                    ctx.write("\n" + MessageFormat.format(Messages.getString("GET_KEY"), resultDoc.getKey()) + "\n");
                                    ctx.write(MessageFormat.format(Messages.getString("GET_CONTENT"), resultDoc.getContentAsString()) + "\n");
                                    ctx.write(Messages.getString("SEPARATOR"));
                                    long cnt = ocol.find().key(cmdParts[4]).count();
                                    String msg = "RECORD_COUNT_GET";
                                    SODACommand.printCountMessage(cnt, msg, ctx);
                                } else if (cmdParts[3].equalsIgnoreCase("-klist")) {
                                    HashSet<String> keySet = new HashSet<String>();
                                    HashSet existing_keys = new HashSet();
                                    HashSet<String> invalid_keys = new HashSet<String>();
                                    existing_keys = SODACommand.findKeys(db, cmdParts, ctx);
                                    for (int i = 4; i < len; ++i) {
                                        keySet.add(cmdParts[i]);
                                        if (existing_keys.contains(cmdParts[i])) continue;
                                        invalid_keys.add(cmdParts[i]);
                                    }
                                    c = ocol.find().keys(keySet).getCursor();
                                    long cnt = ocol.find().keys(keySet).count();
                                    while (c.hasNext()) {
                                        OracleDocument resultDoc = c.next();
                                        ctx.write("\n" + MessageFormat.format(Messages.getString("GET_KEY"), resultDoc.getKey()) + "\n");
                                        ctx.write(MessageFormat.format(Messages.getString("GET_CONTENT"), resultDoc.getContentAsString()) + "\n");
                                        ctx.write(Messages.getString("SEPARATOR"));
                                    }
                                    String msg = "RECORD_COUNT_GET";
                                    SODACommand.printCountMessage(cnt, msg, ctx);
                                    if (!invalid_keys.isEmpty()) {
                                        for (String s : invalid_keys) {
                                            ctx.write(MessageFormat.format(Messages.getString("INVALID_KEY"), s));
                                        }
                                    }
                                }
                                break block152;
                            }
                        }
                        if (cmdParts[1].equalsIgnoreCase("drop")) {
                            try {
                                OracleCollection ocol = db.openCollection(cmdParts[2]);
                                ocol.admin().drop();
                                ctx.write(MessageFormat.format(Messages.getString("DROPPED_COLLECTION"), cmdParts[2]) + "\n\n");
                            }
                            catch (Exception e) {
                                if (len < 3) {
                                    ctx.write(Messages.getString("SODA_DROP_USAGE") + "\n");
                                } else {
                                    ctx.write(Messages.getString("FAILED_DROP") + "\n");
                                    String message = e.getMessage();
                                    if (message != null) {
                                        ctx.write(MessageFormat.format(Messages.getString("ERR_MSG"), message) + "\n\n");
                                    }
                                }
                                break block152;
                            }
                        }
                        if (cmdParts[1].equalsIgnoreCase("count")) {
                            try {
                                OracleCollection ocol = db.openCollection(cmdParts[2]);
                                if (len == 3) {
                                    if (SODACommand.isExistingColl(cmdParts[2], db)) {
                                        long cnt = ocol.find().count();
                                        String msg = "RECORD_COUNT_GET";
                                        SODACommand.printCountMessage(cnt, msg, ctx);
                                    } else {
                                        ctx.write(MessageFormat.format(Messages.getString("COLLECTION_NON_EXISTANT"), cmdParts[2]) + "\n");
                                    }
                                    break block152;
                                }
                                if (len != 4) break block152;
                                int arglen = 3;
                                String qbe = SODACommand.formQBE(cmdParts, soda_cmd, arglen);
                                if (SODACommand.isExistingColl(cmdParts[2], db)) {
                                    OracleDocument doc = db.createDocumentFromString(qbe);
                                    long cnt = ocol.find().filter(doc).count();
                                    String msg = "RECORD_COUNT_GET";
                                    SODACommand.printCountMessage(cnt, msg, ctx);
                                    break block152;
                                }
                                ctx.write(MessageFormat.format(Messages.getString("COLLECTION_NON_EXISTANT"), cmdParts[2]) + "\n");
                            }
                            catch (Exception e) {
                                if (len < 3) {
                                    ctx.write(Messages.getString("SODA_COUNT_USAGE") + "\n");
                                } else {
                                    ctx.write(Messages.getString("FAILED_COUNT") + "\n");
                                    String message = e.getMessage();
                                    if (message != null) {
                                        ctx.write(MessageFormat.format(Messages.getString("ERR_MSG"), message) + "\n\n");
                                    }
                                }
                                break block152;
                            }
                        }
                        if (!cmdParts[1].equalsIgnoreCase("remove")) break block152;
                        try {
                            OracleCollection ocol = db.openCollection(cmdParts[2]);
                            if (cmdParts[3].equalsIgnoreCase("-k")) {
                                long cnt = ocol.find().key(cmdParts[4]).remove();
                                String msg = "SUCCESS_REMOVE";
                                SODACommand.printCountMessage(cnt, msg, ctx);
                            } else if (cmdParts[3].equalsIgnoreCase("-klist")) {
                                HashSet<String> keySet = new HashSet<String>();
                                HashSet<String> invalid_keys = new HashSet<String>();
                                HashSet existing_keys = new HashSet();
                                existing_keys = SODACommand.findKeys(db, cmdParts, ctx);
                                for (int i = 4; i < len; ++i) {
                                    keySet.add(cmdParts[i]);
                                    if (existing_keys.contains(cmdParts[i])) continue;
                                    invalid_keys.add(cmdParts[i]);
                                }
                                long cnt = ocol.find().keys(keySet).remove();
                                String msg = "SUCCESS_REMOVE";
                                SODACommand.printCountMessage(cnt, msg, ctx);
                                if (!invalid_keys.isEmpty()) {
                                    for (String s : invalid_keys) {
                                        ctx.write(MessageFormat.format(Messages.getString("INVALID_KEY"), s));
                                    }
                                }
                            } else if (cmdParts[3].equalsIgnoreCase("-f")) {
                                int arglen = 4;
                                String qbe = SODACommand.formQBE(cmdParts, soda_cmd, arglen);
                                OracleDocument doc = db.createDocumentFromString(qbe);
                                int cnt = ocol.find().filter(doc).remove();
                                String msg = "SUCCESS_REMOVE";
                                SODACommand.printCountMessage(cnt, msg, ctx);
                            } else {
                                ctx.write(MessageFormat.format(Messages.getString("UNRECOGNIZED_OPT"), cmdParts[3]) + "\n");
                            }
                        }
                        catch (Exception e) {
                            if (len < 4) {
                                ctx.write(Messages.getString("SODA_REMOVE_USAGE") + "\n");
                            } else if (!SODACommand.isExistingColl(cmdParts[2], db)) {
                                ctx.write(MessageFormat.format(Messages.getString("COLLECTION_NON_EXISTANT"), cmdParts[2]) + "\n");
                            } else {
                                ctx.write(Messages.getString("SUCCESS_REMOVE_NONE") + "\n");
                                String message = e.getMessage();
                                if (message != null) {
                                    ctx.write(MessageFormat.format(Messages.getString("ERR_MSG"), message) + "\n\n");
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        ctx.write(MessageFormat.format(Messages.getString("COMMAND_FAILED"), soda_cmd) + "\n");
                        String message = e.getMessage();
                        if (message != null) {
                            ctx.write(MessageFormat.format(Messages.getString("ERR_MSG"), message) + "\n\n");
                            break block152;
                        }
                        try {
                            String cause_str = null;
                            Throwable cause = e.getCause();
                            cause_str = cause.toString();
                            if (cause_str != null) {
                                ctx.write(MessageFormat.format(Messages.getString("ERR_MSG"), cause_str) + "\n");
                            }
                        }
                        catch (Exception el) {
                            ctx.write(MessageFormat.format(Messages.getString("COMMAND_FAILED"), soda_cmd) + "\n");
                        }
                    }
                } else {
                    ctx.write(this.getHelp());
                }
            }
            return true;
        }
        return false;
    }

    public String underLine(String text) {
        return text;
    }

    public static String readFile(String inpath) throws IOException {
        byte[] contents = Files.readAllBytes(Paths.get(inpath, new String[0]));
        return new String(contents);
    }

    public static boolean isExistingColl(String coll_name, OracleDatabase db) {
        try {
            List collections = db.admin().getCollectionNames();
            return collections.contains(coll_name);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String formQBE(String[] cmdParts, String soda_cmd, int arglen) {
        String sub_command = "";
        for (int i = 0; i < arglen; ++i) {
            sub_command = sub_command + cmdParts[i];
        }
        int sub_command_len = sub_command.length() + arglen;
        String qbe = soda_cmd.substring(sub_command_len);
        return qbe;
    }

    public static void printCountMessage(long cnt, String msg, ScriptRunnerContext ctx) {
        if (cnt < 2L && cnt != 0L) {
            msg = msg + "_SING";
            ctx.write(MessageFormat.format(Messages.getString(msg), cnt) + "\n");
        } else if (cnt >= 2L) {
            msg = msg + "_PLUR";
            ctx.write(MessageFormat.format(Messages.getString(msg), cnt) + "\n");
        } else if (cnt == 0L) {
            msg = msg + "_NONE";
            ctx.write(Messages.getString(msg) + "\n");
        }
    }

    public static HashSet findKeys(OracleDatabase db, String[] cmdParts, ScriptRunnerContext ctx) {
        OracleCursor c = null;
        HashSet<String> keys = new HashSet<String>();
        String key = null;
        try {
            OracleCollection col = db.openCollection(cmdParts[2]);
            c = col.find().getCursor();
            while (c.hasNext()) {
                OracleDocument resultDoc = c.next();
                key = resultDoc.getKey();
                keys.add(key);
            }
            return keys;
        }
        catch (Exception e) {
            ctx.write(Messages.getString("FIND_ALL_KEYS_ERR") + "\n");
            return keys;
        }
    }
}

