/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IEndOfShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetLoad
extends CommandListener
implements IShowCommand,
IEndOfShowCommand {
    public static final Integer METHOD_INSERT = 0;
    public static final Integer METHOD_DBMS_CLOUD = 1;
    private static final String INSERT = "insert";
    private static final String DBMS_CLOUD = "dbms_cloud";
    private static final String DBMSCLOUD = "dbmscloud";
    private static final String BATCH_ROWS = "batch_rows";
    private static final String BATCHROWS = "batchrows";
    private static final String BATCHES_PER_COMMIT = "batches_per_commit";
    private static final String BATCHESPERCOMMIT = "batchespercommit";
    private static final String COMMIT = "commit";
    private static final String DATE_FORMAT = "date_format";
    private static final String DATEFORMAT = "dateformat";
    private static final String DATE = "date";
    private static final String ERRORS = "errors";
    private static final String LOCALE = "locale";
    private static final String MAP_COLUMN_NAMES = "map_column_names";
    private static final String MAPCOLUMNNAMES = "mapcolumnnames";
    private static final String RESPONSE_FORMAT = "response_format";
    private static final String RESPONSEFORMAT = "responseformat";
    private static final String RESPONSE_LOCALES = "response_locales";
    private static final String RESPONSELOCALES = "responselocales";
    private static final String UNKNOWN_COLUMNS_FAIL = "unknown_columns_fail";
    private static final String UNKNOWNCOLUMNSFAIL = "unknowncolumnsfail";
    private static final String BLANK_COLUMNS_NULL = "blank_columns_null";
    private static final String BLANKCOLUMNSNULL = "blankcolumns_null";
    private static final String BLANK_LINES = "blank_lines";
    private static final String BLANKLINES = "blanklines";
    private static final String CHARACTER_SET = "character_set";
    private static final String CHARACTERSET = "characterset";
    private static final String COMPRESSION = "compression";
    private static final String CONVERSION_ERRORS = "conversion_errors";
    private static final String CONVERSIONERRORS = "conversionerrors";
    private static final String COPY_BAD = "copy_bad";
    private static final String COPYBAD = "copybad";
    private static final String COPY_LOG = "copy_log";
    private static final String COPYLOG = "copylog";
    private static final String CREDENTIAL = "credential";
    private static final String ESCAPE = "escape";
    private static final String LOCATION = "location";
    private static final String METHOD = "method";
    private static final String MISSING_END_FIELDS = "missing_end_fields";
    private static final String MISSINGENDFIELDS = "missingendfields";
    private static final String NUMERIC_CHARACTERS = "numeric_characters";
    private static final String NUMERICCHARACTERS = "numericcharacters";
    private static final String NUMBER_FORMAT = "number_format";
    private static final String NUMBERFORMAT = "numberformat";
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMESTAMP_FORMAT = "timestamp_format";
    private static final String TIMESTAMPFORMAT = "timestampformat";
    private static final String TIMESTAMPTZ = "timestamptz";
    private static final String TIMESTAMPTZ_FORMAT = "timestamptz_format";
    private static final String TIMESTAMPTZFORMAT = "timestamptzformat";
    private static final String TRIM = "trim";
    private static final String TRIM_SPACES = "trim_spaces";
    private static final String TRIMSPACES = "trimspaces";
    private static final String TRUNCATE = "truncate";
    private static final String TRUNCATE_TABLE = "truncate_table";
    private static final String TRUNCATETABLE = "truncatetable";
    private static final String TRUNCATE_COLUMNS = "truncate_columns";
    private static final String TRUNCATECOLUMNS = "truncatecolumns";
    private static final String DEFAULT = "default";
    private static final String UDEFAULT = "DEFAULT";
    private static final String DQUOTE = "\"";
    private static final String ON = "on";
    private static final String UON = "ON";
    private static final String OFF = "off";
    private static final String UOFF = "OFF";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private static final String SQUOTE = "'";
    private static final String UNLIMITED = "unlimited";
    private Integer _loadMethod = METHOD_INSERT;
    private LoadParmsAPI.Builder _loadParmsBuilder;
    private boolean _isValid = true;

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setload") && !cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setloadformat")) {
            String line;
            String[] parts = cmd.getSQLOrig().split(SPACE);
            if (parts.length < 3) {
                return true;
            }
            if (parts.length == 3 && parts[2].equalsIgnoreCase(DEFAULT)) {
                ctx.write(Messages.getString("LOADCLEARED"));
                ctx.putProperty("load.method.insert", null);
                ctx.putProperty("load.method.dbms_cloud", null);
                ctx.putProperty("load.method", METHOD_INSERT);
                return true;
            }
            if (parts.length == 4 && parts[2].equalsIgnoreCase(INSERT) && parts[3].equalsIgnoreCase(DEFAULT)) {
                ctx.write(Messages.getString("LOADCLEARED"));
                ctx.putProperty("load.method.insert", null);
                ctx.putProperty("load.method", METHOD_INSERT);
                return true;
            }
            this._loadParmsBuilder = (LoadParmsAPI.Builder)ctx.getProperty("load.method.insert");
            if (this._loadParmsBuilder == null) {
                this._loadParmsBuilder = new LoadParmsAPI.Builder(LoadParmsAPI.SERVICE_METHOD.JDBC_BATCH);
                this._loadParmsBuilder.doCommit(true);
                ctx.putProperty("load.method.insert", this._loadParmsBuilder);
            }
            this._loadMethod = (Integer)ctx.getProperty("load.method");
            if (this._loadMethod == null) {
                this._loadMethod = METHOD_INSERT;
            }
            String[] bits = this.split((line = (String)cmd.getProperty("ORIG_LINE")) != null ? line : cmd.getSQLOrig());
            int skip = 2;
            while (bits != null && bits.length > 0) {
                String str = "";
                int i = skip;
                String opt = bits[skip].toLowerCase();
                try {
                    switch (bits[skip].toLowerCase()) {
                        case "batch_rows": 
                        case "batchrows": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (this.validateOption(ctx, opt)) {
                                try {
                                    this.getBuilder().batchRows(new Integer(bits[skip + 1]));
                                    this.putBuilder(ctx);
                                }
                                catch (Exception e) {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return false;
                                }
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "batches_per_commit": 
                        case "batchespercommit": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (this.validateOption(ctx, opt)) {
                                try {
                                    int batches = new Integer(bits[skip + 1]);
                                    this.getBuilder().batchesPerCommit(batches);
                                    this.getBuilder().doCommit(batches > 0);
                                    this.putBuilder(ctx);
                                }
                                catch (Exception e) {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return false;
                                }
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "commit": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(ON) && !bits[skip + 1].equalsIgnoreCase(OFF)) {
                                this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return false;
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().doCommit(bits[skip + 1].equalsIgnoreCase(ON));
                                this.putBuilder(ctx);
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "errors": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (this.validateOption(ctx, opt)) {
                                try {
                                    if (bits[skip + 1].equalsIgnoreCase(UNLIMITED)) {
                                        this.getBuilder().errors(-1);
                                    } else {
                                        this.getBuilder().errors(new Integer(bits[skip + 1]));
                                    }
                                    this.putBuilder(ctx);
                                }
                                catch (Exception e) {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return false;
                                }
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "date_format": 
                        case "dateformat": 
                        case "date": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[2]);
                                return false;
                            }
                            ++i;
                            String space = "";
                            while (i < bits.length && !this.isOption(bits[i])) {
                                str = str + space + bits[i];
                                space = SPACE;
                                ++i;
                            }
                            if (str.isEmpty()) {
                                this.writeMethodMissing(ctx, bits[0]);
                                return false;
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().dateFormat(this.unQuote(str));
                                this.putBuilder(ctx);
                            }
                            bits = this.nextBits(bits, i);
                            break;
                        }
                        case "locale": {
                            Locale locale = null;
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (bits.length == skip + 3) {
                                locale = new Locale(bits[skip + 1], bits[skip + 2]);
                                bits = this.nextBits(bits, skip + 3);
                            } else if (bits[skip + 1].equals("\"\"")) {
                                locale = null;
                                bits = this.nextBits(bits, skip + 2);
                            } else {
                                locale = new Locale(bits[skip + 1]);
                                bits = this.nextBits(bits, skip + 2);
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().locale(locale);
                                this.putBuilder(ctx);
                            }
                            break;
                        }
                        case "map_column_names": 
                        case "mapcolumnnames": 
                        case "method": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(INSERT)) {
                                this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return false;
                            }
                            ctx.putProperty("load.method.insert", this._loadParmsBuilder);
                            this._loadMethod = METHOD_INSERT;
                            ctx.putProperty("load.method", METHOD_INSERT);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "response_format": 
                        case "responseformat": {
                            break;
                        }
                        case "response_locales": 
                        case "responselocales": {
                            break;
                        }
                        case "timestamp": 
                        case "timestamp_format": 
                        case "timestampformat": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[2]);
                                return false;
                            }
                            ++i;
                            String space = "";
                            while (i < bits.length && !this.isOption(bits[i])) {
                                str = str + space + bits[i];
                                space = SPACE;
                                ++i;
                            }
                            if (str.isEmpty()) {
                                this.writeMethodMissing(ctx, bits[0]);
                                return false;
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().timestampFormat(this.unQuote(str));
                                this.putBuilder(ctx);
                            }
                            bits = this.nextBits(bits, i);
                            break;
                        }
                        case "timestamptz": 
                        case "timestamptz_format": 
                        case "timestamptzformat": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[2]);
                                return false;
                            }
                            ++i;
                            String space = "";
                            while (i < bits.length && !this.isOption(bits[i])) {
                                str = str + space + bits[i];
                                space = SPACE;
                                ++i;
                            }
                            if (str.isEmpty()) {
                                this.writeMethodMissing(ctx, bits[0]);
                                return false;
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().timestampTZFormat(this.unQuote(str));
                                this.putBuilder(ctx);
                            }
                            bits = this.nextBits(bits, i);
                            break;
                        }
                        case "truncate": 
                        case "truncate_table": 
                        case "truncatetable": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(ON) && !bits[skip + 1].equalsIgnoreCase(OFF)) {
                                this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return false;
                            }
                            this.getBuilder().deleteRows(bits[skip + 1].equalsIgnoreCase(ON) ? LoadParmsAPI.DELETE_ROWS.TRUE : LoadParmsAPI.DELETE_ROWS.FALSE);
                            this.putBuilder(ctx);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "unknown_columns_fail": 
                        case "unknowncolumnsfail": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(ON) && !bits[skip + 1].equalsIgnoreCase(OFF)) {
                                this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return false;
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().unknownColumnsFail(bits[skip + 1].equalsIgnoreCase(ON));
                                this.putBuilder(ctx);
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        default: {
                            ctx.write(MessageFormat.format(Messages.getString("LOADOPTIONINVALID"), bits[skip].toLowerCase()) + NL);
                            return false;
                        }
                    }
                }
                catch (Exception e) {
                    this.writeMethodBad(ctx, bits.length > skip ? bits[skip] : "");
                    return false;
                }
                skip = 0;
            }
            return true;
        }
        return false;
    }

    private LoadParmsAPI.Builder getBuilder() {
        return this._loadParmsBuilder;
    }

    private void putBuilder(ScriptRunnerContext ctx) {
        ctx.putProperty("load.method.insert", this._loadParmsBuilder);
    }

    private String[] split(String cmd) {
        if (!cmd.contains(SQUOTE) && !cmd.contains(DQUOTE)) {
            return cmd.split("\\s+");
        }
        String c = null;
        String word = "";
        ArrayList<String> words = new ArrayList<String>();
        for (int i = 0; i < cmd.length(); ++i) {
            int end;
            word = "";
            c = cmd.substring(i, i + 1);
            if (c.equals(DQUOTE) && i + 1 < cmd.length()) {
                end = cmd.indexOf(DQUOTE, i + 1);
                if (end != -1) {
                    words.add(cmd.substring(i, end + 1));
                    i = end + 1;
                    continue;
                }
                word = word + c;
                while (++i < cmd.length() && !cmd.substring(i, i + 1).equals(SPACE)) {
                    word = word + cmd.substring(i, i + 1);
                }
                words.add(word);
                continue;
            }
            if (c.equals(SQUOTE) && i + 1 < cmd.length()) {
                end = cmd.indexOf(SQUOTE, i + 1);
                if (end != -1) {
                    words.add(cmd.substring(i, end + 1));
                    i = end + 1;
                    continue;
                }
                word = word + c;
                while (++i < cmd.length() && !cmd.substring(i, i + 1).equals(SPACE)) {
                    word = word + cmd.substring(i, i + 1);
                }
                words.add(word);
                continue;
            }
            if (c.equals(SPACE)) continue;
            word = word + c;
            while (++i < cmd.length() && !cmd.substring(i, i + 1).equals(SPACE)) {
                word = word + cmd.substring(i, i + 1);
            }
            words.add(word);
        }
        return words.toArray(new String[words.size()]);
    }

    private void writeMethodMissing(ScriptRunnerContext ctx, String option) {
        ctx.write(MessageFormat.format(Messages.getString("LOADMISSINGVALUE"), option) + NL);
    }

    private void writeMethodBad(ScriptRunnerContext ctx, String option) {
        ctx.write(MessageFormat.format(Messages.getString("LOADBADVALUE"), option) + NL);
    }

    private boolean validateOption(ScriptRunnerContext ctx, String word) {
        if (this.isAnyOption(word, true)) {
            return true;
        }
        ctx.write(MessageFormat.format(Messages.getString("LOADBADOPTION"), word, this.getMethodName()) + NL);
        this._isValid = false;
        return false;
    }

    private boolean isOption(String word) {
        return this.isAnyOption(word, false);
    }

    private boolean isAnyOption(String word, boolean isLoadMethodOption) {
        if (!isLoadMethodOption || this._loadMethod == METHOD_INSERT) {
            try {
                switch (word) {
                    case "insert": 
                    case "batch_rows": 
                    case "batchrows": 
                    case "batches_per_commit": 
                    case "batchespercommit": 
                    case "commit": 
                    case "errors": 
                    case "locale": 
                    case "map_column_names": 
                    case "mapcolumnnames": 
                    case "response_format": 
                    case "responseformat": 
                    case "response_locales": 
                    case "responselocales": 
                    case "date": 
                    case "date_format": 
                    case "dateformat": 
                    case "timestamp": 
                    case "timestamp_format": 
                    case "timestampformat": 
                    case "timestamptz": 
                    case "timestamptz_format": 
                    case "timestamptzformat": 
                    case "truncate": 
                    case "unknown_columns_fail": 
                    case "unknowncolumnsfail": {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        if (!isLoadMethodOption || this._loadMethod == METHOD_DBMS_CLOUD) {
            try {
                switch (word) {
                    case "blank_columns_null": 
                    case "blankcolumns_null": 
                    case "blank_lines": 
                    case "blanklines": 
                    case "character_set": 
                    case "characterset": 
                    case "compression": 
                    case "conversion_errors": 
                    case "conversionerrors": 
                    case "copy_bad": 
                    case "copybad": 
                    case "copy_log": 
                    case "copylog": 
                    case "credential": 
                    case "dbms_cloud": 
                    case "dbmscloud": 
                    case "escape": 
                    case "date": 
                    case "date_format": 
                    case "dateformat": 
                    case "timestamp": 
                    case "timestamp_format": 
                    case "timestampformat": 
                    case "timestamptz": 
                    case "timestamptz_format": 
                    case "timestamptzformat": 
                    case "errors": 
                    case "locale": 
                    case "location": 
                    case "map_column_names": 
                    case "mapcolumnnames": 
                    case "missing_end_fields": 
                    case "missingendfields": 
                    case "numeric_characters": 
                    case "numericcharacters": 
                    case "number_format": 
                    case "numberformat": 
                    case "response_format": 
                    case "responseformat": 
                    case "response_locales": 
                    case "responselocales": 
                    case "trim_spaces": 
                    case "trimspaces": 
                    case "truncate": 
                    case "truncate_columns": 
                    case "truncatecolumns": 
                    case "unknown_columns_fail": 
                    case "unknowncolumnsfail": {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private String getMethodName() {
        return this._loadMethod == METHOD_INSERT ? INSERT : DBMS_CLOUD;
    }

    private boolean isMethodName(String word) {
        return word == INSERT || word == DBMS_CLOUD;
    }

    private String unQuote(String word) {
        if (word.startsWith(SQUOTE) && word.endsWith(SQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        if (word.startsWith(DQUOTE) && word.endsWith(DQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        return word;
    }

    private String[] nextBits(String[] bits, int skip) {
        if (bits.length > skip) {
            String[] rtn = new String[bits.length - skip];
            for (int j = 0; rtn.length > j; ++j) {
                rtn[j] = bits[j + skip];
            }
            return rtn;
        }
        return null;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("showload")) {
            this._loadMethod = METHOD_INSERT;
            if (ctx.getProperties().containsKey("load.method") && ctx.getProperties().get("load.method") != null) {
                this._loadMethod = (Integer)ctx.getProperty("load.method");
                if (this._loadMethod == null) {
                    this._loadMethod = METHOD_INSERT;
                }
            }
            LoadParmsAPI.Builder loadParmsBuilder = null;
            loadParmsBuilder = ctx.getProperties().containsKey("load.method.insert") && ctx.getProperties().get("load.method.insert") != null ? (LoadParmsAPI.Builder)ctx.getProperty("load.method.insert") : new LoadParmsAPI.Builder(LoadParmsAPI.SERVICE_METHOD.JDBC_BATCH);
            LoadParmsAPI loadParms = loadParmsBuilder.build();
            SetLoad.showParms(ctx, loadParms);
            return true;
        }
        return false;
    }

    public static void showParms(ScriptRunnerContext ctx, LoadParmsAPI loadParms) {
        String method = NL;
        method = method + "batch_rows " + new Integer(loadParms.getBatchRows()).toString() + NL;
        method = method + "batches_per_commit " + new Integer(loadParms.getBatchesPerCommit()).toString() + NL;
        method = method + "commit " + (loadParms.isDoCommit() ? ON : OFF) + NL;
        method = method + "date_format " + loadParms.getDataFormat() + NL;
        method = method + "errors " + (loadParms.getErrorsLimit() == -1 ? UNLIMITED : new Integer(loadParms.getErrorsLimit()).toString()) + NL;
        method = method + "method insert\n";
        method = method + "timestamp_format " + loadParms.getTimestampFormat() + NL;
        method = method + "timestamptz_format " + loadParms.getTimestampTZFormat() + NL;
        method = loadParms.getLocale() != null ? method + "locale " + loadParms.getLocale().getDisplayName() + NL : method + "locale \n";
        method = method + "truncate " + (loadParms.getDeleteRows() == LoadParmsAPI.DELETE_ROWS.TRUE ? ON : OFF) + NL;
        ctx.write(method);
        ctx.write("");
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"load"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }
}

