/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.data.readservice.ReadParmsDelimitedAPI;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetLoadFormat
extends CommandListener
implements IShowCommand {
    private static final String CSV = "csv";
    private static final String DSV = "dsv";
    private static final String DELIMITED = "delimited";
    private static final String DELIMITER = "delimiter";
    private static final String DELIM = "delim";
    private static final String ENCLOSURE_LEFT = "enclosure_left";
    private static final String ENCLOSURELEFT = "enclosureleft";
    private static final String LEFT = "left";
    private static final String ENCLOSURE_RIGHT = "enclosure_right";
    private static final String ENCLOSURERIGHT = "enclosureright";
    private static final String RIGHT = "right";
    private static final String ENCLOSURES = "enclosures";
    private static final String ENCODING = "encoding";
    private static final String ROW_LIMIT = "row_limit";
    private static final String ROWLIMIT = "rowlimit";
    private static final String LIMIT = "limit";
    private static final String FORMAT = "format";
    private static final String HEADER = "column_names";
    private static final String HEADER_ALIAS = "columnnames";
    private static final String HEAD = "names";
    private static final String HEADER_AFTER = "skip_before_names";
    private static final String HEADERAFTER = "skipbeforenames";
    private static final String HEADER_BEFORE = "skip_after_names";
    private static final String HEADERBEFORE = "skipafternames";
    private static final String AFTER = "after";
    private static final String BEFORE = "before";
    private static final String IS_ROW_LIMIT = "is_row_limit";
    private static final String ISROWLIMIT = "isrowlimit";
    private static final String ISLIMIT = "islimit";
    private static final String TERM = "term";
    private static final String LINE_TERMINATOR = "row_terminator";
    private static final String LINETERMINATOR = "rowterminator";
    private static final String MAX_LENGTH = "max_length";
    private static final String MAXLENGTH = "maxlength";
    private static final String SKIP_ROWS = "skip_rows";
    private static final String SKIPROWS = "skiprows";
    private static final String SKIP = "skip";
    private static final String DEFAULT = "default";
    private static final String DQUOTE = "\"";
    private static final String SQUOTE = "'";
    private static final String ON = "on";
    private static final String OFF = "off";
    private static final String NL = "\n";
    private static final String CR = "\r";
    private static final String SPACE = " ";

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setloadformat")) {
            String[] parts = cmd.getSQLOrig().split(SPACE);
            if (parts.length < 3 || parts.length == 3 && parts[2].equalsIgnoreCase(DEFAULT)) {
                ctx.write(Messages.getString("LOADFORMATCLEARED"));
                ctx.putProperty("load.format", null);
                return true;
            }
            ReadParmsDelimitedAPI.Builder delimParmsBuilder = (ReadParmsDelimitedAPI.Builder)ctx.getProperty("load.format");
            if (delimParmsBuilder == null) {
                delimParmsBuilder = new ReadParmsDelimitedAPI.Builder();
            }
            String[] bits = cmd.getSql().split("\\s+");
            int skip = 2;
            while (bits != null && bits.length > 0) {
                try {
                    switch (bits[skip].toLowerCase()) {
                        case "csv": 
                        case "dsv": 
                        case "delimited": {
                            ctx.putProperty("load.format", delimParmsBuilder);
                            bits = this.nextBits(bits, skip + 1);
                            break;
                        }
                        case "delimiter": 
                        case "delim": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[2]);
                                return false;
                            }
                            delimParmsBuilder.delimiter(bits[skip + 1]);
                            ctx.putProperty("load.format", delimParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "enclosure_left": 
                        case "enclosureleft": 
                        case "left": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                                delimParmsBuilder.enclosureLeft(null);
                            } else {
                                delimParmsBuilder.enclosureLeft(bits[skip + 1]);
                            }
                            ctx.putProperty("load.format", delimParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "enclosure_right": 
                        case "enclosureright": 
                        case "right": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                                delimParmsBuilder.enclosureRight(null);
                            } else {
                                delimParmsBuilder.enclosureRight(bits[skip + 1]);
                            }
                            ctx.putProperty("load.format", delimParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "enclosures": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                                delimParmsBuilder.enclosures(null);
                            } else if (bits[skip + 1].length() == 1) {
                                delimParmsBuilder.enclosureLeft(bits[skip + 1]);
                                delimParmsBuilder.enclosureRight(bits[skip + 2]);
                            } else {
                                delimParmsBuilder.enclosureLeft(bits[skip + 1].substring(0, 1));
                                delimParmsBuilder.enclosureRight(bits[skip + 1].substring(1, 2));
                            }
                            ctx.putProperty("load.format", delimParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "encoding": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (bits[skip + 1].equals("\"\"")) {
                                delimParmsBuilder.encoding(null);
                            } else if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                                delimParmsBuilder.encoding(null);
                            } else {
                                delimParmsBuilder.encoding(bits[skip + 1]);
                            }
                            ctx.putProperty("load.format", delimParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "row_limit": 
                        case "rowlimit": 
                        case "limit": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return false;
                            }
                            try {
                                if (bits[skip + 1].equals("\"\"")) {
                                    delimParmsBuilder.limitRows(new Integer(-1));
                                } else if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                                    delimParmsBuilder.limitRows(new Integer(-1));
                                } else {
                                    delimParmsBuilder.limitRows(new Integer(bits[skip + 1]));
                                }
                                ctx.putProperty("load.format", delimParmsBuilder);
                            }
                            catch (Exception e) {
                                this.writeFormatBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return false;
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "column_names": 
                        case "columnnames": 
                        case "names": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(ON) && !bits[skip + 1].equalsIgnoreCase(OFF)) {
                                this.writeFormatBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return false;
                            }
                            delimParmsBuilder.header(bits[skip + 1].equalsIgnoreCase(ON));
                            ctx.putProperty("load.format", delimParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "skip_after_names": 
                        case "skipafternames": 
                        case "after": {
                            delimParmsBuilder.headerBeforeSkip(true);
                            ctx.putProperty("load.format", delimParmsBuilder);
                            bits = this.nextBits(bits, skip + 1);
                            break;
                        }
                        case "skip_before_names": 
                        case "skipbeforenames": 
                        case "before": {
                            delimParmsBuilder.headerBeforeSkip(false);
                            ctx.putProperty("load.format", delimParmsBuilder);
                            bits = this.nextBits(bits, skip + 1);
                            break;
                        }
                        case "row_terminator": 
                        case "rowterminator": 
                        case "term": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return false;
                            }
                            if (bits[skip + 1].equals("\"\"")) {
                                delimParmsBuilder.lineEnd("");
                            } else {
                                String str = bits[skip + 1];
                                str.replace("\\r", CR);
                                str.replace("\\n", NL);
                                delimParmsBuilder.lineEnd(this.unQuote(str));
                            }
                            ctx.putProperty("load.format", delimParmsBuilder);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "max_length": 
                        case "maxlength": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return false;
                            }
                            try {
                                delimParmsBuilder.lineMax(new Integer(bits[skip + 1]));
                                ctx.putProperty("load.format", delimParmsBuilder);
                            }
                            catch (Exception e) {
                                this.writeFormatBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return false;
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "skip_rows": 
                        case "skiprows": 
                        case "skip": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return false;
                            }
                            try {
                                if (bits[skip + 1].equals("\"\"")) {
                                    delimParmsBuilder.skipRows(0);
                                } else if (bits[skip + 1].equalsIgnoreCase(OFF)) {
                                    delimParmsBuilder.skipRows(0);
                                } else {
                                    delimParmsBuilder.skipRows(new Integer(bits[skip + 1]));
                                }
                                ctx.putProperty("load.format", delimParmsBuilder);
                            }
                            catch (Exception e) {
                                this.writeFormatBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return false;
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        default: {
                            ctx.write(MessageFormat.format(Messages.getString("LOADOPTIONINVALID"), bits[skip].toLowerCase()) + NL);
                            return false;
                        }
                    }
                }
                catch (Exception e) {
                    this.writeFormatBad(ctx, bits.length > 0 ? bits[skip] : "");
                    return false;
                }
                skip = 0;
            }
            return true;
        }
        return false;
    }

    private void writeFormatMissing(ScriptRunnerContext ctx, String option) {
        ctx.write(MessageFormat.format(Messages.getString("LOADMISSINGVALUE"), option) + NL);
    }

    private void writeFormatBad(ScriptRunnerContext ctx, String option) {
        ctx.write(MessageFormat.format(Messages.getString("LOADFORMATBAD"), option) + NL);
    }

    private String unQuote(String word) {
        if (word.startsWith(SQUOTE) && word.endsWith(SQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        if (word.startsWith(DQUOTE) && word.endsWith(DQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        return word;
    }

    private String[] nextBits(String[] bits, int skip) {
        if (bits.length > skip) {
            String[] rtn = new String[bits.length - skip];
            for (int j = 0; rtn.length > j; ++j) {
                rtn[j] = bits[j + skip];
            }
            return rtn;
        }
        return null;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("showloadformat")) {
            ReadParmsDelimitedAPI.Builder delimParmsBuilder = null;
            if (ctx.getProperties().containsKey("load.format") && ctx.getProperties().get("load.format") != null) {
                delimParmsBuilder = (ReadParmsDelimitedAPI.Builder)ctx.getProperty("load.format");
            } else {
                ctx.write("default\n");
                delimParmsBuilder = new ReadParmsDelimitedAPI.Builder();
            }
            ReadParmsDelimitedAPI delimParms = delimParmsBuilder.build();
            SetLoadFormat.showParms(ctx, delimParms);
            return true;
        }
        return false;
    }

    public static void showParms(ScriptRunnerContext ctx, ReadParmsDelimitedAPI delimParms) {
        String format = "\nformat " + (Object)((Object)delimParms.getServiceType()) + NL;
        format = format + "column_names " + (delimParms.isHeader() ? ON : OFF) + NL;
        format = format + "delimiter " + delimParms.getDelimiter() + NL;
        format = format + "enclosure_left " + (delimParms.getEnclosureLeft() == null || delimParms.getEnclosureLeft().equals("") ? OFF : delimParms.getEnclosureLeft()) + NL;
        format = format + "enclosure_right " + (delimParms.getEnclosureRight() == null || delimParms.getEnclosureRight().equals("") ? OFF : delimParms.getEnclosureRight()) + NL;
        format = format + "encoding " + delimParms.getEncoding() + NL;
        format = format + "row_limit " + (delimParms.getLimitRows() == -1 ? OFF : new Integer(delimParms.getLimitRows()).toString()) + NL;
        format = format + "row_terminator " + (delimParms.getTerminator() == null ? "" : delimParms.getTerminator()) + NL;
        format = format + "skip_rows " + new Integer(delimParms.getSkipRows()).toString() + NL;
        format = delimParms.isHeaderBeforeSkip() ? format + "skip_after_names\n" : format + "skip_before_names\n";
        ctx.write(format);
        ctx.write("");
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"loadformat"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }
}

