/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.Locale;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.query.Bind;

public class ToSub
extends CommandListener
implements IHelp {
    @Override
    public String getCommand() {
        return "TOSUB";
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_TOSUB)) return true;
        String start = cmd.getSql().trim();
        if (start.length() > 5 && start.toUpperCase(Locale.US).matches("TOSUB[ \t][^=][^=]*=:[^:][^:]*$")) {
            String[] subBind = start.substring(5).trim().split("=");
            Bind b = ctx.getVarMap().get(subBind[1].substring(1).toUpperCase(Locale.US));
            if (b != null && b.getType().toUpperCase().indexOf("CHAR") > -1) {
                String val = b.getValue();
                if (val == null) {
                    val = "";
                }
                ctx.getMap().put(subBind[0].toUpperCase(Locale.US), val);
                ctx.getSubVarTypeMap().put(subBind[0].toUpperCase(Locale.US), "VARCHAR2");
                return true;
            }
            ctx.write(this.getHelp());
            return true;
        }
        ctx.write(this.getHelp());
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

