/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class Alias {
    private static final int MINVERSION = 0;
    private String name = null;
    private String desc = null;
    private HashMap<Integer, String> queries = new HashMap();
    private boolean _system = false;
    private boolean _nullDefaults = false;
    private Map<String, String> _map = new ConcurrentHashMap<String, String>(new HashMap());
    private String _group = null;
    protected static Logger LOGGER = Logger.getLogger(Alias.class.getName());
    private static final String NULLDEFAULTS = "nulldefaults";
    private static final String GROUP = "group";
    private static final String ID = "ID";
    private static final String NAME = "name";

    public Alias(String aliasName, String query, String description) {
        this(aliasName, query, description, (HashMap<String, String>)null);
    }

    public Alias(String aliasName, String query, String description, HashMap<String, String> map) {
        this(aliasName, query, description, 0, map);
    }

    public Alias(String aliasName, String query, String description, int version, boolean systemAlias) {
        this(aliasName, query, description, version, systemAlias, null);
    }

    public Alias(String aliasName, String query, String description, int version, boolean systemAlias, HashMap<String, String> map) {
        this(aliasName, query, description, String.valueOf(0), map);
        this._system = systemAlias;
    }

    public Alias(String aliasName, String query, String description, int version) {
        this(aliasName, query, description, version, (HashMap<String, String>)null);
    }

    public Alias(String aliasName, String query, String description, int version, HashMap<String, String> map) {
        this(aliasName, query, description, String.valueOf(0), map);
    }

    public Alias(String aliasName, String description, HashMap<Integer, String> preBuiltQueries, boolean systemAlias) {
        this(aliasName, description, preBuiltQueries, systemAlias, (HashMap<String, String>)null);
    }

    public Alias(String aliasName, String description, HashMap<Integer, String> preBuiltQueries, boolean systemAlias, HashMap<String, String> map) {
        this.name = aliasName;
        this.desc = description;
        this.queries = preBuiltQueries;
        this._system = systemAlias;
        this.setMap(map);
    }

    public Alias(String aliasName, String description, HashMap<Integer, String> preBuiltQueries) {
        this(aliasName, description, preBuiltQueries, (HashMap<String, String>)null);
    }

    public Alias(String aliasName, String description, HashMap<Integer, String> preBuiltQueries, HashMap<String, String> map) {
        this.name = aliasName;
        this.desc = description;
        this.queries = preBuiltQueries;
        this.setMap(map);
    }

    public Alias(String aliasName, String query, String description, String version) {
        this(aliasName, query, description, version, (HashMap<String, String>)null);
    }

    public Alias(String aliasName, String query, String description, String version, HashMap<String, String> map) {
        this.name = aliasName;
        this.desc = description;
        this.setMap(map);
        try {
            if (version != null && Integer.parseInt(version) >= 0) {
                this.queries.put(Integer.parseInt(version), query);
            } else {
                this.queries.put(8, query);
            }
        }
        catch (NumberFormatException nfe) {
            LOGGER.warning(MessageFormat.format("{0}:{1}", Alias.class.getName(), nfe.getMessage()));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public HashMap<Integer, String> getQueries() {
        return this.queries;
    }

    public String getQuery() {
        int minimum = 99;
        for (Map.Entry<Integer, String> entry : this.queries.entrySet()) {
            if (entry.getKey() >= minimum) continue;
            minimum = entry.getKey();
        }
        return this.queries.get(minimum);
    }

    public String getQuery(String version) {
        int closest = Integer.parseInt(version);
        for (Map.Entry<Integer, String> entry : this.queries.entrySet()) {
            if (entry.getKey() >= Integer.parseInt(version) || closest >= entry.getKey()) continue;
            closest = entry.getKey();
        }
        return this.queries.get(closest);
    }

    public void setQueries(HashMap<Integer, String> queries) {
        this.queries = queries;
    }

    public void addQuery(int version, String query) {
        this.queries.put(version, query);
    }

    public int getVersion() {
        int minimum = 99;
        for (Map.Entry<Integer, String> entry : this.queries.entrySet()) {
            if (entry.getKey() >= minimum) continue;
            minimum = entry.getKey();
        }
        return minimum;
    }

    public boolean isSystem() {
        return this._system;
    }

    public boolean isNullDefaults() {
        return this._nullDefaults;
    }

    public void setNullDefaults(boolean nullDefaults) {
        this._nullDefaults = nullDefaults;
    }

    public String getGroup() {
        return this._group;
    }

    public void setGroup(String group) {
        this._group = group;
    }

    public Map<String, String> getMap() {
        return this._map;
    }

    private void setMap(Map<String, String> map) {
        ((ConcurrentHashMap)this._map).clear();
        if (map != null) {
            this._map.putAll(map);
        }
        this.mapToProps();
    }

    public void mapToProps() {
        if (this._map != null) {
            this.setGroup(this._map.get(GROUP));
            String nulldef = this._map.get(NULLDEFAULTS);
            this.setNullDefaults(nulldef != null && nulldef.equals("true"));
            this._map.remove(ID);
            this._map.remove(NAME);
        }
    }

    public void propsToMap() {
        String group = this.getGroup();
        boolean nullDef = this.isNullDefaults();
        String nullString = null;
        if (nullDef) {
            nullString = "true";
        }
        this._map.remove(GROUP);
        this._map.remove(NULLDEFAULTS);
        if (group != null) {
            this._map.put(GROUP, group);
        }
        if (nullString != null) {
            this._map.put(NULLDEFAULTS, nullString);
        }
    }
}

