/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.File;
import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowJava
implements IShowCommand {
    @Override
    public String[] getShowAliases() {
        return new String[]{"java"};
    }

    private void print(ScriptRunnerContext ctx, String val) {
        ctx.write(ScriptUtils.wordwrapNotXml(1, (Integer)ctx.getProperty("script.runner.setlinesize"), new StringBuffer(val)).toString());
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] arr;
        String pad = new String(new char[11]).replace('\u0000', '-');
        ctx.write("Java Detail\n" + pad + "\n");
        this.print(ctx, "java.home= " + System.getProperty("java.home") + "\n");
        this.print(ctx, "java.vendor= " + System.getProperty("java.vendor") + "\n");
        this.print(ctx, "java.vendor.url= " + System.getProperty("java.vendor.url") + "\n");
        this.print(ctx, "java.version= " + System.getProperty("java.version") + "\n");
        int ls = (Integer)ctx.getProperty("script.runner.setlinesize");
        pad = new String(new char[ls]).replace('\u0000', '-');
        ctx.write(pad + "\n");
        this.print(ctx, "os.arch= " + System.getProperty("os.arch") + "\n");
        this.print(ctx, "os.name= " + System.getProperty("os.name") + "\n");
        this.print(ctx, "os.version= " + System.getProperty("os.version") + "\n");
        this.print(ctx, "path.separator= " + System.getProperty("path.separator") + "\n");
        this.print(ctx, "file.separator= " + System.getProperty("file.separator") + "\n");
        this.print(ctx, "line.separator= " + System.getProperty("line.separator") + "\n");
        this.print(ctx, "user.dir= " + System.getProperty("user.dir") + "\n");
        this.print(ctx, "user.home= " + System.getProperty("user.home") + "\n");
        this.print(ctx, "user.name= " + System.getProperty("user.name") + "\n");
        this.print(ctx, "user.language= " + System.getProperty("user.language") + "\n");
        this.print(ctx, "user.region= " + System.getProperty("user.region") + "\n");
        this.print(ctx, "file.encoding= " + System.getProperty("file.encoding") + "\n");
        ctx.write(pad + "\n");
        String sqlhome = System.getenv("SQL_HOME");
        this.print(ctx, "SQL_HOME=" + sqlhome + "\n");
        if (ctx.getProperty("script.runner.hhtp.proxy.host") != null && !ctx.getProperty("script.runner.hhtp.proxy.host").equals("")) {
            ctx.write(pad + "\n");
            this.print(ctx, "proxy host=" + ctx.getProperty("script.runner.hhtp.proxy.host") + "\n");
            this.print(ctx, "proxy port=" + ctx.getProperty("script.runner.hhtp.proxy.port") + "\n");
            ctx.write(pad + "\n");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Classpath\n");
        String cp = System.getProperty("java.class.path");
        for (String s : arr = cp.split(File.pathSeparator)) {
            if (s.contains(System.getProperty("java.version")) || sqlhome == null) continue;
            if (s.contains(sqlhome)) {
                s = "$SQL_HOME" + s.substring(sqlhome.length());
            }
            sb.append(s + "\n");
        }
        this.print(ctx, sb.toString() + "\n");
        ctx.write(pad + "\n");
        ctx.write(System.getenv("SQL_HOME") + "\n");
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

