/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowNls
implements IShowCommand,
IShowPrefixNameNewline {
    private static final String[] SHOWNLS = new String[]{"nls"};

    @Override
    public String[] getShowAliases() {
        return SHOWNLS;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowNls(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowNls(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            if (DBUtil.isOracleConnectionAlive(conn)) {
                if (ctx.getProperty("NLS_LANG") != null) {
                    ctx.write("NLS_LANG " + ctx.getProperty("NLS_LANG") + "\n");
                }
                List<List<?>> l = DBUtil.getInstance(conn).executeReturnListofList("select name, value, upper(name) namesort from (select parameter name,value from nls_session_parameters union all SELECT 'DB_TIMEZONE' name, DBTIMEZONE  value FROM DUAL union all SELECT 'SESSION_TIMEZONE' name, SESSIONTIMEZONE value FROM DUAL union all SELECT 'SESSION_TIMEZONE_OFFSET' name, TZ_OFFSET(SESSIONTIMEZONE) value from DUAL union all SELECT parameter name, value FROM nls_database_parameters WHERE parameter='NLS_CHARACTERSET') viewname order by namesort", null);
                boolean firstRow = true;
                for (List<?> row : l) {
                    if (!firstRow) {
                        ctx.write(row.get(0).toString() + " " + row.get(1).toString() + "\n");
                    }
                    firstRow = false;
                }
            } else {
                ctx.write("No Live Oracle Connection.\n");
            }
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }
}

