/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowPrelim
implements IShowCommand {
    private static final String[] SHOWPRELIM = new String[]{"_PRELIM", "_prelim"};

    @Override
    public String[] getShowAliases() {
        return SHOWPRELIM;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowPrelim(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    public boolean doShowPrelim(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String onoroff = (String)ctx.getProperty("script.runner.setprelim");
        String str = "";
        if (onoroff != null && onoroff.matches("(?i:on|off)")) {
            str = onoroff.equalsIgnoreCase("ON") ? Messages.getString("PRELIM_ON") + Show.m_lineSeparator : Messages.getString("PRELIM_OFF") + Show.m_lineSeparator;
            ctx.write(str);
        } else {
            str = Messages.getString("PRELIM_OFF") + Show.m_lineSeparator;
            ctx.write(str);
        }
        return true;
    }
}

