/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IParsedShow;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.NONE)
public class ShowRecyclebin
implements IShowCommand,
IParsedShow {
    private static final String[] SHOWRECYCLE = new String[]{"recyc", "recycl", "recycle", "recycleb", "recyclebi", "recyclebin"};

    @Override
    public String[] getShowAliases() {
        return SHOWRECYCLE;
    }

    @Override
    public String handleShowRemainder(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowRecyclebin(conn, ctx, cmd);
        }
        return null;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doShowRecyclebin(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String shoAndShow;
        block62: {
            String arg;
            boolean quoted = false;
            shoAndShow = ScriptUtils.eatOneWord(ScriptUtils.eatOneWord(cmd.getSql()).trim()).trim();
            boolean noexit = true;
            int charAt = -1;
            int end = shoAndShow.length();
            boolean indquote = false;
            boolean insquote = false;
            while (noexit) {
                if (++charAt == end) {
                    noexit = false;
                    break;
                }
                String next = shoAndShow.substring(charAt, charAt + 1);
                if (next.equals("\"")) {
                    if (insquote) continue;
                    if (!indquote) {
                        indquote = true;
                        continue;
                    }
                    indquote = false;
                    continue;
                }
                if (next.equals("'")) {
                    if (indquote) continue;
                    if (!insquote) {
                        insquote = true;
                        continue;
                    }
                    insquote = false;
                    continue;
                }
                if (!next.matches("\\s") || indquote || insquote) continue;
                noexit = false;
                break;
            }
            String arg_orig = arg = shoAndShow.substring(0, charAt).trim();
            if (arg.startsWith("\"") && arg.endsWith("\"") && arg.length() > 1) {
                quoted = true;
                arg = arg.substring(1, arg.length() - 1);
            } else if (arg.startsWith("'") && arg.endsWith("'") && arg.length() > 1) {
                quoted = true;
            }
            shoAndShow = charAt == end ? "" : shoAndShow.substring(charAt).trim();
            if (VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(conn)).compareTo(new Version("10.0")) < 0) {
                ctx.write(Messages.getString("SERVER_VERSION_TOO_LOW"));
                return shoAndShow;
            }
            boolean amILocked = false;
            Statement s = null;
            ResultSet rs = null;
            try {
                String nonDbaQuery;
                String extraWhere;
                String querySql;
                boolean tryNonDba;
                block63: {
                    amILocked = LockManager.lock(ctx.getBaseConnection());
                    if (!amILocked) break block62;
                    tryNonDba = false;
                    querySql = null;
                    extraWhere = " original_name = :INPUT";
                    String dbaQuery = "select original_name \"ORIGINAL NAME\", object_name \"RECYCLEBIN NAME\", type \"OBJECT TYPE\", droptime  \"DROP TIME\"   from dba_recyclebin r where owner = USER";
                    nonDbaQuery = "select original_name \"ORIGINAL NAME\", object_name \"RECYCLEBIN NAME\", type \"OBJECT TYPE\", droptime  \"DROP TIME\"  from recyclebin r";
                    try {
                        if (!arg.equals("")) {
                            querySql = dbaQuery + " and " + extraWhere;
                            s = conn.prepareStatement(querySql);
                            HashMap<String, String> binds = new HashMap<String, String>();
                            if (quoted) {
                                binds.put("INPUT", arg);
                            } else {
                                binds.put("INPUT", arg.toUpperCase());
                            }
                            DBUtil.bind((PreparedStatement)s, binds);
                        } else {
                            querySql = dbaQuery;
                            s = conn.prepareStatement(querySql);
                        }
                        rs = s.executeQuery();
                    }
                    catch (SQLException e) {
                        tryNonDba = true;
                        if (s == null) break block63;
                        try {
                            s.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                if (tryNonDba) {
                    if (!arg.equals("")) {
                        querySql = nonDbaQuery + " where " + extraWhere;
                        s = conn.prepareStatement(querySql);
                        s.setString(1, arg);
                    } else {
                        querySql = nonDbaQuery;
                        s = conn.prepareStatement(querySql);
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    rs = s.executeQuery();
                }
                if (rs.next()) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (!arg.equals("")) {
                        s = conn.prepareStatement(querySql);
                        if (quoted) {
                            s.setString(1, arg);
                        } else {
                            s.setString(1, arg.toUpperCase());
                        }
                    } else {
                        s = conn.prepareStatement(querySql);
                    }
                    rs = s.executeQuery();
                    ResultSetFormatter rFormat = new ResultSetFormatter(ctx);
                    rFormat.setProgressUpdater(ctx.getTaskProgressUpdater());
                    int n = rFormat.rset2sqlplusShrinkToSize(rs, conn, ctx.getOutputStream());
                    break block62;
                }
                if (!ctx.isSQLPlusClassic()) {
                    ctx.write(MessageFormat.format(Messages.getString("ShowRecyclebin.RECYCLEBIN_INVALID_KEY"), arg_orig));
                }
            }
            catch (IOException e) {
                ctx.write(e.getLocalizedMessage());
            }
            catch (SQLException e) {
                ctx.putProperty("sqldev.last.err.message.forsqlcode", e.getMessage());
                ctx.write(e.getLocalizedMessage());
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException e) {}
                }
                if (amILocked) {
                    LockManager.unlock(ctx.getBaseConnection());
                }
            }
        }
        return shoAndShow;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }
}

