/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.regex.PatternSyntaxException;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.NONE)
public class ShowSqlcode
implements IShowCommand {
    private static final String[] SHOWSQLCODE = new String[]{"sqlcode"};

    @Override
    public String[] getShowAliases() {
        return SHOWSQLCODE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowSqlcode(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowSqlcode(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        int codeNum = ShowSqlcode.getCodeNum(ctx);
        ctx.write("sqlcode " + codeNum + "\n");
        return true;
    }

    public static int getCodeNum(ScriptRunnerContext ctx) {
        String sqlCodeString = (String)ctx.getProperty("sqldev.last.err.message.forsqlcode");
        int codeNum = 0;
        if (sqlCodeString != null) {
            try {
                String firstLine = sqlCodeString.split("\n")[0].trim();
                codeNum = firstLine.matches("^[^\\-]*\\-[0-9]+.*$") ? Integer.parseInt(firstLine.replaceAll("^[^\\-]*\\-([0-9]+).*$", "$1")) : -1;
            }
            catch (NumberFormatException e) {
                codeNum = -1;
            }
            catch (PatternSyntaxException e) {
                codeNum = -1;
            }
        }
        return codeNum;
    }
}

