/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraINTERVALDSFormat;
import oracle.dbtools.raptor.nls.OraINTERVALYMFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPLTZFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.i18n.util.OraLocaleInfo;
import oracle.jdbc.OracleConnection;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleNLSProvider
extends DefaultNLSProvider {
    private static final String NLS_COMP = "NLS_COMP";
    private static final String NLS_SORT = "NLS_SORT";
    private static final String NLS_LENGTH_SEMANTICS = "NLS_LENGTH_SEMANTICS";
    private static final String NLS_ISO_CURRENCY = "NLS_ISO_CURRENCY";
    private static final String NLS_CURRENCY = "NLS_CURRENCY";
    private static final String NLS_DATE_LANGUAGE = "NLS_DATE_LANGUAGE";
    private static final String SESSION_TIMEZONE_OFFSET = "SESSION_TIMEZONE_OFFSET";
    private static final String SESSION_TIMEZONE = "SESSION_TIMEZONE";
    private static final String NLS_DATE_FORMAT = "NLS_DATE_FORMAT";
    private static final String NLS_NUMERIC_CHARACTERS = "NLS_NUMERIC_CHARACTERS";
    private static final String NLS_CHARACTERSET = "NLS_CHARACTERSET";
    private static final String NLS_TIMESTAMP_TZ_FORMAT = "NLS_TIMESTAMP_TZ_FORMAT";
    private static final String DB_TIMEZONE = "DB_TIMEZONE";
    private static final String NLS_TERRITORY = "NLS_TERRITORY";
    private static final String NLS_LANGUAGE = "NLS_LANGUAGE";
    private static final String NLS_TIMESTAMP_FORMAT = "NLS_TIMESTAMP_FORMAT";
    private static final String GENERIC_TIMESTAMP_TZ_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF TZR";
    private static final String GENERIC_TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF";
    private static final String GENERIC_DATE_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    private static final String LOADER_TIMESTAMP_TZ_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF TZH:TZM";
    private static final String LOADER_TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF";
    private static final String LOADER_DATE_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    private static final String REST_DATE_FORMAT = "YYYY-MM-DD\"T\"HH24:MI:SS\"Z\"";
    private static final String REST_TIMESTAMP_FORMAT = "YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"";
    private static final String REST_TIMESTAMP_TZ_FORMAT = "YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"";
    private static final String REST_TIMESTAMP_LTZ_FORMAT = "YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"";
    private static final String ALTER_SESSION = "alter session set {0}=''{1}''";
    private static final Logger LOGGER = Logger.getLogger(OracleNLSProvider.class.getName());
    private Map<String, String> nlsMappings = null;
    private Map<String, String> s_defaults = new HashMap<String, String>();
    private static final Map<String, Object> NO_BINDS = Collections.emptyMap();

    public OracleNLSProvider(Connection conn) {
        super(conn);
    }

    private char convertToChar(String s) {
        if (s == null || s.length() == 0) {
            return '\u0000';
        }
        return s.charAt(0);
    }

    @Override
    public String format(Object obj) {
        String ret;
        String nullDisplay = this.yieldNullDisplay(obj);
        if (nullDisplay != null) {
            ret = nullDisplay;
        } else if (obj instanceof BigDecimal) {
            ret = this.formatBigDecimal((BigDecimal)obj);
        } else if (obj instanceof DATE) {
            ret = this.formatDate((DATE)obj);
        } else if (obj instanceof java.util.Date) {
            try {
                obj = new DATE(obj);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            ret = this.formatDate((DATE)obj);
        } else {
            ret = obj instanceof NUMBER ? this.formatNUMBER((NUMBER)obj) : (obj instanceof BINARY_DOUBLE ? this.formatBINARY_DOUBLE((BINARY_DOUBLE)obj) : (obj instanceof BINARY_FLOAT ? this.formatBINARY_FLOAT((BINARY_FLOAT)obj) : (obj instanceof TIMESTAMP ? this.formatTIMESTAMP((TIMESTAMP)obj) : (obj instanceof TIMESTAMPLTZ ? this.formatTIMESTAMPLTZ((TIMESTAMPLTZ)obj) : (obj instanceof TIMESTAMPTZ ? this.formatTIMESTAMPTZ((TIMESTAMPTZ)obj) : (obj instanceof INTERVALYM ? this.formatINTERVALYM((INTERVALYM)obj) : (obj instanceof INTERVALDS ? this.formatINTERVALDS((INTERVALDS)obj) : (DataTypesUtil.isXMLType(obj) ? DataTypesUtil.stringValue(obj, super.getConnection()) : super.format(obj)))))))));
        }
        return ret;
    }

    private String formatBigDecimal(BigDecimal bd) {
        String ret = this.yieldNullDisplay(bd);
        if (ret == null && (ret = bd.toPlainString()).indexOf(46) != -1) {
            char decimalSeparator = this.getDecimalSeparator();
            ret = bd.toPlainString();
            if (decimalSeparator != '.') {
                ret = ret.replace('.', decimalSeparator);
            }
        }
        return ret;
    }

    public String formatDate(DATE date) {
        String ret = this.yieldNullDisplay(date);
        if (ret == null) {
            OraDATEFormat formatDate;
            try {
                formatDate = this.getOraDATEFormat();
            }
            catch (ParseException pe) {
                formatDate = null;
            }
            ret = formatDate == null ? date.stringValue() : formatDate.format(date);
        }
        return ret;
    }

    private String formatNUMBER(NUMBER num) {
        String ret = this.yieldNullDisplay(num);
        if (ret == null && (ret = num.stringValue()).indexOf(46) != -1) {
            try {
                ret = this.formatBigDecimal(num.bigDecimalValue());
            }
            catch (SQLException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return ret;
    }

    private String formatBINARY_DOUBLE(BINARY_DOUBLE num) {
        String ret = this.yieldNullDisplay(num);
        if (ret == null && (ret = num.stringValue()).indexOf(46) != -1) {
            try {
                ret = this.formatBigDecimal(this.getBigDecimal(num));
            }
            catch (SQLException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return ret;
    }

    private String formatBINARY_FLOAT(BINARY_FLOAT num) {
        String ret = this.yieldNullDisplay(num);
        if (ret == null && (ret = num.stringValue()).indexOf(46) != -1) {
            try {
                ret = this.formatBigDecimal(this.getBigDecimal(num));
            }
            catch (SQLException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return ret;
    }

    private BigDecimal getBigDecimal(BINARY_FLOAT num) throws SQLException {
        return num != null ? new BigDecimal(num.stringValue()) : null;
    }

    private BigDecimal getBigDecimal(BINARY_DOUBLE num) throws SQLException {
        return num != null ? new BigDecimal(num.stringValue()) : null;
    }

    private String formatTIMESTAMP(TIMESTAMP time) {
        String ret = this.yieldNullDisplay(time);
        if (ret == null) {
            try {
                OraTIMESTAMPFormat formatTimestamp = this.getOraTIMESTAMPFormat();
                ret = formatTimestamp.format(time);
            }
            catch (ParseException e) {
                Map<String, String> nlsMap = this.getNLSMap();
                LOGGER.severe(Messages.getString("OracleNLSProvider.18") + nlsMap.get(NLS_TIMESTAMP_FORMAT));
            }
        }
        return ret;
    }

    private String formatTIMESTAMPLTZ(TIMESTAMPLTZ time) {
        String ret = null;
        try {
            OraTIMESTAMPLTZFormat formatTimestamp = this.getOraTIMESTAMPLTZFormat();
            ret = formatTimestamp.format(time);
        }
        catch (ParseException e) {
            Map<String, String> nlsMap = this.getNLSMap();
            LOGGER.severe(Messages.getString("OracleNLSProvider.19") + nlsMap.get(NLS_TIMESTAMP_FORMAT));
        }
        return ret;
    }

    private String formatTIMESTAMPTZ(TIMESTAMPTZ time) {
        String ret = this.yieldNullDisplay(time);
        if (ret == null) {
            try {
                OraTIMESTAMPTZFormat formatTimestampTZ = this.getOraTIMESTAMPTZFormat();
                ret = formatTimestampTZ.format(time);
            }
            catch (ParseException e) {
                Map<String, String> nlsMap = this.getNLSMap();
                LOGGER.severe(Messages.getString("OracleNLSProvider.20") + nlsMap.get(NLS_TIMESTAMP_TZ_FORMAT));
            }
        }
        return ret;
    }

    private String formatLoaderDATE(DATE time) {
        String ret = this.yieldNullDisplay(time);
        if (ret == null) {
            try {
                OraDATEFormat formatDate = this.getOraDATEFormat(this.getDateFormat(FormatType.LOADER));
                ret = formatDate.format(time);
            }
            catch (ParseException e) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + "YYYY-MM-DD HH24:MI:SS");
            }
        }
        return ret;
    }

    private String formatLoaderTIMESTAMP(TIMESTAMP time) {
        String ret = this.yieldNullDisplay(time);
        if (ret == null) {
            try {
                OraTIMESTAMPFormat formatTimestamp = this.getOraTIMESTAMPFormat(this.getTimeStampFormat(FormatType.LOADER));
                ret = formatTimestamp.format(time);
            }
            catch (ParseException e) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + "YYYY-MM-DD HH24:MI:SS.FF");
            }
        }
        return ret;
    }

    private String formatLoaderTIMESTAMPTZ(TIMESTAMPTZ time) {
        String ret = this.yieldNullDisplay(time);
        if (ret == null) {
            try {
                OraTIMESTAMPTZFormat formatTimestamp = this.getOraTIMESTAMPTZFormat(this.getTimeStampWithTimeZoneFormat(FormatType.LOADER));
                ret = formatTimestamp.format(time);
            }
            catch (ParseException e) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + LOADER_TIMESTAMP_TZ_FORMAT);
            }
        }
        return ret;
    }

    private String formatLoaderTIMESTAMPLTZ(TIMESTAMPLTZ time) {
        String ret = this.yieldNullDisplay(time);
        if (ret == null) {
            try {
                OraTIMESTAMPLTZFormat formatTimestamp = this.getOraTIMESTAMPLTZFormat(this.getTimeStampWithTimeZoneFormat(FormatType.LOADER));
                ret = formatTimestamp.format(time);
            }
            catch (ParseException e) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + LOADER_TIMESTAMP_TZ_FORMAT);
            }
        }
        return ret;
    }

    private String formatRestDATE(DATE time) {
        String ret = this.yieldNullDisplay(time);
        if (ret == null) {
            try {
                OraDATEFormat formatDate = this.getOraDATEFormat(this.getDateFormat(FormatType.REST));
                ret = formatDate.format(time);
            }
            catch (ParseException e) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + REST_DATE_FORMAT);
            }
        }
        return ret;
    }

    private String formatRestTIMESTAMP(TIMESTAMP time) {
        String ret = this.yieldNullDisplay(time);
        if (ret == null) {
            try {
                OraTIMESTAMPFormat formatTimestamp = this.getOraTIMESTAMPFormat(this.getTimeStampFormat(FormatType.REST));
                ret = formatTimestamp.format(time);
            }
            catch (ParseException e) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + "YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"");
            }
        }
        return ret;
    }

    private String formatRestTIMESTAMPTZ(TIMESTAMPTZ time) {
        String ret = this.yieldNullDisplay(time);
        if (ret == null) {
            try {
                OraTIMESTAMPTZFormat formatTimestamp = this.getOraTIMESTAMPTZFormat(this.getTimeStampWithTimeZoneFormat(FormatType.REST));
                ret = formatTimestamp.format(time);
            }
            catch (ParseException e) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + "YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"");
            }
        }
        return ret;
    }

    private String formatRestTIMESTAMPLTZ(TIMESTAMPLTZ time) {
        String ret = this.yieldNullDisplay(time);
        if (ret == null) {
            try {
                OraTIMESTAMPLTZFormat formatTimestamp = this.getOraTIMESTAMPLTZFormat(this.getTimeStampWithLocalTimeZoneFormat(FormatType.REST));
                ret = formatTimestamp.format(time);
            }
            catch (ParseException e) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + "YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"");
            }
        }
        return ret;
    }

    private String formatINTERVALYM(INTERVALYM interval) {
        String ret = this.yieldNullDisplay(interval);
        if (ret == null) {
            try {
                OraINTERVALYMFormat formatInterval = this.getOraINTERVALYMFormat();
                ret = formatInterval.format(interval);
            }
            catch (ParseException e) {
                Map<String, String> nlsMap = this.getNLSMap();
                LOGGER.severe(Messages.getString("OracleNLSProvider.22") + nlsMap.get(NLS_TIMESTAMP_TZ_FORMAT));
            }
        }
        return ret;
    }

    private String formatINTERVALDS(INTERVALDS interval) {
        String ret = this.yieldNullDisplay(interval);
        if (ret == null) {
            try {
                OraINTERVALDSFormat formatInterval = this.getOraINTERVALDSFormat();
                ret = formatInterval.format(interval);
            }
            catch (ParseException e) {
                Map<String, String> nlsMap = this.getNLSMap();
                LOGGER.severe(Messages.getString("OracleNLSProvider.23") + nlsMap.get(NLS_TIMESTAMP_TZ_FORMAT));
            }
        }
        return ret;
    }

    public Number parseNumber(String s) {
        Number ret = null;
        if (s != null) {
            char decimalSeparator = this.getDecimalSeparator();
            ret = s.indexOf(decimalSeparator) != -1 ? new BigDecimal(s.replace(decimalSeparator, '.')) : new BigInteger(s);
        }
        return ret;
    }

    @Override
    public String getDBCharset() {
        return this.getNLSMap().get(NLS_CHARACTERSET);
    }

    public String getDBLanguage() {
        return this.getNLSMap().get(NLS_LANGUAGE);
    }

    public String getDBTerritory() {
        return this.getNLSMap().get(NLS_TERRITORY);
    }

    public String getDBTimeZone() {
        return this.getNLSMap().get(DB_TIMEZONE);
    }

    @Override
    public char getDecimalSeparator() {
        if (this.getNLSMap() == null || this.getNLSMap().get(NLS_NUMERIC_CHARACTERS) == null) {
            return '.';
        }
        String s = this.getNLSMap().get(NLS_NUMERIC_CHARACTERS);
        return s.substring(0, 1).charAt(0);
    }

    @Override
    public char getGroupSeparator() {
        String s = this.getNLSMap().get(NLS_NUMERIC_CHARACTERS);
        return s.substring(1, 2).charAt(0);
    }

    @Override
    public String getDateFormat(FormatType formatType) {
        switch (formatType) {
            case PREFERRED: {
                return this.getNLSMap().get(NLS_DATE_FORMAT);
            }
            case GENERIC: {
                return "YYYY-MM-DD HH24:MI:SS";
            }
            case LOADER: {
                return "YYYY-MM-DD HH24:MI:SS";
            }
            case REST: {
                return REST_DATE_FORMAT;
            }
        }
        return super.getDateFormat(formatType);
    }

    @Override
    public String getTimeStampWithTimeZoneFormat(FormatType formatType) {
        switch (formatType) {
            case PREFERRED: {
                return this.getNLSMap().get(NLS_TIMESTAMP_TZ_FORMAT);
            }
            case GENERIC: {
                return GENERIC_TIMESTAMP_TZ_FORMAT;
            }
            case LOADER: {
                return LOADER_TIMESTAMP_TZ_FORMAT;
            }
            case REST: {
                return "YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"";
            }
        }
        return super.getTimeStampWithTimeZoneFormat(formatType);
    }

    @Override
    public String getTimeStampWithLocalTimeZoneFormat(FormatType formatType) {
        switch (formatType) {
            case REST: {
                return "YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"";
            }
        }
        return super.getTimeStampWithLocalTimeZoneFormat(formatType);
    }

    @Override
    public String getTimeStampFormat(FormatType formatType) {
        switch (formatType) {
            case PREFERRED: {
                return this.getNLSMap().get(NLS_TIMESTAMP_FORMAT);
            }
            case GENERIC: {
                return "YYYY-MM-DD HH24:MI:SS.FF";
            }
            case LOADER: {
                return "YYYY-MM-DD HH24:MI:SS.FF";
            }
            case REST: {
                return "YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"";
            }
        }
        return super.getTimeStampFormat(formatType);
    }

    public String getDBDateLanguage() {
        return this.getNLSMap().get(NLS_DATE_LANGUAGE);
    }

    private synchronized Map<String, String> getNLSMap() {
        if (this.nlsMappings == null) {
            this.populateNLS();
        }
        return this.nlsMappings;
    }

    public OraDATEFormat getOraDATEFormat(String format) throws ParseException {
        Map<String, String> nlsMap = this.getNLSMap();
        return new OraDATEFormat(format, OraLocaleInfo.getInstance((String)nlsMap.get(NLS_DATE_LANGUAGE), (String)nlsMap.get(NLS_TERRITORY)));
    }

    public OraTIMESTAMPFormat getOraTIMESTAMPFormat(String format) throws ParseException {
        Map<String, String> nlsMap = this.getNLSMap();
        return new OraTIMESTAMPFormat(format, OraLocaleInfo.getInstance((String)nlsMap.get(NLS_DATE_LANGUAGE), (String)nlsMap.get(NLS_TERRITORY)));
    }

    public OraTIMESTAMPLTZFormat getOraTIMESTAMPLTZFormat(String format) throws ParseException {
        Map<String, String> nlsMap = this.getNLSMap();
        return new OraTIMESTAMPLTZFormat(format, OraLocaleInfo.getInstance((String)nlsMap.get(NLS_DATE_LANGUAGE), (String)nlsMap.get(NLS_TERRITORY)), this.getTimeZone(nlsMap.get(DB_TIMEZONE)), this.getSessionTimeZone());
    }

    public OraTIMESTAMPTZFormat getOraTIMESTAMPTZFormat(String format) throws ParseException {
        Map<String, String> nlsMap = this.getNLSMap();
        return new OraTIMESTAMPTZFormat(format, OraLocaleInfo.getInstance((String)nlsMap.get(NLS_DATE_LANGUAGE), (String)nlsMap.get(NLS_TERRITORY)));
    }

    public OraDATEFormat getOraDATEFormat(FormatType format) throws ParseException {
        return this.getOraDATEFormat(this.getDateFormat(format));
    }

    public OraTIMESTAMPFormat getOraTIMESTAMPFormat(FormatType format) throws ParseException {
        return this.getOraTIMESTAMPFormat(this.getTimeStampFormat(format));
    }

    public OraTIMESTAMPLTZFormat getOraTIMESTAMPLTZFormat(FormatType format) throws ParseException {
        return this.getOraTIMESTAMPLTZFormat(this.getTimeStampWithLocalTimeZoneFormat(format));
    }

    public OraTIMESTAMPTZFormat getOraTIMESTAMPTZFormat(FormatType format) throws ParseException {
        return this.getOraTIMESTAMPTZFormat(this.getTimeStampWithTimeZoneFormat(format));
    }

    public OraINTERVALYMFormat getOraINTERVALYMFormat(FormatType format) throws ParseException {
        Map<String, String> nlsMap = this.getNLSMap();
        return new OraINTERVALYMFormat(OraLocaleInfo.getInstance((String)nlsMap.get(NLS_LANGUAGE), (String)nlsMap.get(NLS_TERRITORY)));
    }

    public OraINTERVALDSFormat getOraINTERVALDSFormat(FormatType format) throws ParseException {
        Map<String, String> nlsMap = this.getNLSMap();
        return new OraINTERVALDSFormat(OraLocaleInfo.getInstance((String)nlsMap.get(NLS_LANGUAGE), (String)nlsMap.get(NLS_TERRITORY)));
    }

    public OraDATEFormat getOraDATEFormat() throws ParseException {
        return this.getOraDATEFormat(FormatType.PREFERRED);
    }

    public OraTIMESTAMPFormat getOraTIMESTAMPFormat() throws ParseException {
        return this.getOraTIMESTAMPFormat(FormatType.PREFERRED);
    }

    public OraTIMESTAMPLTZFormat getOraTIMESTAMPLTZFormat() throws ParseException {
        return this.getOraTIMESTAMPLTZFormat(FormatType.PREFERRED);
    }

    public OraTIMESTAMPTZFormat getOraTIMESTAMPTZFormat() throws ParseException {
        return this.getOraTIMESTAMPTZFormat(FormatType.PREFERRED);
    }

    public OraINTERVALYMFormat getOraINTERVALYMFormat() throws ParseException {
        return this.getOraINTERVALYMFormat(FormatType.PREFERRED);
    }

    public OraINTERVALDSFormat getOraINTERVALDSFormat() throws ParseException {
        return this.getOraINTERVALDSFormat(FormatType.PREFERRED);
    }

    public TimeZone getTimeZone(String tzId) throws ParseException {
        TimeZone timeZone;
        if (tzId != null) {
            if (tzId.charAt(0) == '+' || tzId.charAt(0) == '-') {
                timeZone = TimeZone.getTimeZone("GMT" + tzId);
                if (timeZone == null) {
                    throw new ParseException(Messages.getString("OracleNLSProvider.48") + tzId + "", 0);
                }
            } else {
                timeZone = TimeZone.getTimeZone(tzId);
                if (timeZone == null) {
                    throw new ParseException(Messages.getString("OracleNLSProvider.49") + tzId + "", 0);
                }
            }
        } else {
            timeZone = null;
        }
        return timeZone;
    }

    @Override
    public TimeZone getDatabaseTimeZone() {
        try {
            return this.getTimeZone(this.getDBTimeZone());
        }
        catch (ParseException pe) {
            return null;
        }
    }

    @Override
    public TimeZone getSessionTimeZone() {
        TimeZone sessionTimeZone = null;
        Map<String, String> nlsMap = this.getNLSMap();
        String sessionTimeZoneID = nlsMap.get(SESSION_TIMEZONE);
        if (sessionTimeZoneID != null) {
            if (sessionTimeZoneID.charAt(0) == '+' || sessionTimeZoneID.charAt(0) == '-') {
                sessionTimeZoneID = "GMT" + sessionTimeZoneID;
            }
            if ((sessionTimeZone = TimeZone.getTimeZone(sessionTimeZoneID)).getID().equals("GMT") && !sessionTimeZoneID.equals("GMT")) {
                String sessionTimeZoneOffset = "GMT" + nlsMap.get(SESSION_TIMEZONE_OFFSET);
                byte[] bytes = sessionTimeZoneOffset.getBytes();
                if (bytes[bytes.length - 1] == 0) {
                    sessionTimeZoneOffset = sessionTimeZoneOffset.substring(0, sessionTimeZoneOffset.length() - 1);
                }
                sessionTimeZone = TimeZone.getTimeZone(sessionTimeZoneOffset);
            }
        } else {
            sessionTimeZone = TimeZone.getDefault();
        }
        return sessionTimeZone;
    }

    @Override
    @Deprecated
    public String getSQL(Object obj) {
        return obj.toString();
    }

    @Override
    public Format getFormat(int sqlType, FormatType formatType) {
        try {
            switch (sqlType) {
                case 91: {
                    return this.getOraDATEFormat(formatType);
                }
                case 93: {
                    return this.getOraTIMESTAMPFormat(formatType);
                }
                case -101: {
                    return this.getOraTIMESTAMPTZFormat(formatType);
                }
                case -102: {
                    return this.getOraTIMESTAMPLTZFormat(formatType);
                }
                case -103: {
                    return this.getOraINTERVALYMFormat(formatType);
                }
                case -104: {
                    return this.getOraINTERVALDSFormat(formatType);
                }
            }
        }
        catch (ParseException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return null;
    }

    @Override
    public Object getValue(Object obj, FormatType formatType) {
        Object retVal;
        String nullDisplay = this.yieldNullDisplay(obj);
        try {
            if (nullDisplay != null) {
                retVal = nullDisplay;
            } else if (obj instanceof Clob) {
                retVal = ((Clob)obj).getSubString(1L, (int)((Clob)obj).length());
            } else if (obj instanceof OPAQUE) {
                retVal = ((OPAQUE)obj).getSQLTypeName().trim();
            } else if (obj instanceof Timestamp) {
                retVal = this.formatTIMESTAMP(new TIMESTAMP((Timestamp)obj));
            } else if (obj instanceof TIMESTAMP) {
                retVal = formatType == FormatType.LOADER ? this.formatLoaderTIMESTAMP((TIMESTAMP)obj) : (formatType == FormatType.REST ? this.formatRestTIMESTAMP((TIMESTAMP)obj) : this.formatTIMESTAMP((TIMESTAMP)obj));
            } else if (obj instanceof TIMESTAMPTZ) {
                if (formatType == FormatType.LOADER) {
                    retVal = this.formatLoaderTIMESTAMPTZ((TIMESTAMPTZ)obj);
                }
                retVal = formatType == FormatType.REST ? this.formatRestTIMESTAMPTZ((TIMESTAMPTZ)obj) : this.formatTIMESTAMPTZ((TIMESTAMPTZ)obj);
            } else {
                retVal = obj instanceof TIMESTAMPLTZ ? (formatType == FormatType.LOADER ? this.formatLoaderTIMESTAMPLTZ((TIMESTAMPLTZ)obj) : (formatType == FormatType.REST ? this.formatRestTIMESTAMPLTZ((TIMESTAMPLTZ)obj) : this.formatTIMESTAMPLTZ((TIMESTAMPLTZ)obj))) : (obj instanceof DATE ? (formatType == FormatType.LOADER ? this.formatLoaderDATE((DATE)obj) : (formatType == FormatType.REST ? this.formatRestDATE((DATE)obj) : this.formatDate((DATE)obj))) : (obj instanceof Date ? this.formatDate(new DATE((Date)obj)) : (obj instanceof NUMBER ? this.formatNUMBER((NUMBER)obj) : (obj instanceof BINARY_DOUBLE ? this.formatBINARY_DOUBLE((BINARY_DOUBLE)obj) : (obj instanceof BINARY_FLOAT ? this.formatBINARY_FLOAT((BINARY_FLOAT)obj) : (obj instanceof BigDecimal ? this.formatBigDecimal((BigDecimal)obj) : (obj instanceof INTERVALDS ? this.formatINTERVALDS((INTERVALDS)obj) : (obj instanceof INTERVALYM ? this.formatINTERVALYM((INTERVALYM)obj) : (obj instanceof Datum ? ((Datum)obj).stringValue() : super.getValue(obj, formatType))))))))));
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            retVal = "";
        }
        return retVal;
    }

    private String getDefault(String key) {
        return this.s_defaults.get(key);
    }

    @Override
    public Object parse(String str) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object parse(String str, Object base) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initConnection() {
        if (!this.setNlsFromPrefsCore()) {
            this.populateNLS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateNLS() {
        Statement stmt = null;
        ResultSet rset = null;
        try {
            QueryXMLSupport xml = QueryXMLSupport.getQueryXMLSupport(new MetaResource(this.getClass().getClassLoader(), "oracle/dbtools/raptor/utils/loadNLS.xml"));
            Query q = xml.getQuery("loadnls", this.getConnection());
            if (this.nlsMappings == null) {
                this.nlsMappings = new HashMap<String, String>();
            }
            stmt = this.getConnection().prepareStatement(q.getSql());
            rset = stmt.executeQuery();
            while (rset.next()) {
                this.nlsMappings.put(rset.getString(1), rset.getString(2));
                LOGGER.fine(Messages.getString("OracleNLSProvider.28") + rset.getString(1) + "=" + rset.getString(2));
            }
        }
        catch (Exception e) {
            LOGGER.fine(Messages.getString("OracleNLSProvider.30") + e.getMessage());
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private boolean requiresSetting(String setting, String prefName) {
        String pref = this.getDefault(setting);
        String existing = this.getNLSMap().get(prefName);
        if (prefName != null && pref != null && existing != null) {
            LOGGER.fine(Messages.getString("OracleNLSProvider.31") + prefName + ":" + pref + ":" + existing);
        }
        return pref != null && !pref.equals("") && !pref.equals(existing);
    }

    @Override
    public void setNlsFromPrefs() {
        this.setNlsFromPrefsCore();
    }

    private boolean setNlsFromPrefsCore() {
        String query = "";
        String skip = this.getDefault("NLS_SKIP");
        if (Boolean.parseBoolean(skip)) {
            return false;
        }
        Connection conn = this.getConnection();
        SettingsApplicator applicator = new SettingsApplicator(conn);
        Version ver = VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(conn));
        Map<String, String> map = this.getNLSMap();
        boolean appliedSomething = applicator.apply("NLS_LANG", NLS_LANGUAGE);
        boolean territoryChanged = applicator.apply("NLS_TERR", NLS_TERRITORY);
        appliedSomething |= territoryChanged;
        appliedSomething |= applicator.apply(NLS_SORT, NLS_SORT);
        if (this.requiresSetting(NLS_COMP, NLS_COMP)) {
            if (ver.compareTo(new Version("9")) < 0) {
                LOGGER.log(Level.INFO, NLS_COMP + Messages.getString("OracleNLSProvider.38"));
            } else if (ver.compareTo(new Version("10.2")) < 0) {
                query = this.getAlterSession(NLS_COMP, "ANSI");
                LOGGER.log(Level.INFO, NLS_COMP + Messages.getString("OracleNLSProvider.41"));
            } else {
                String pref = this.getDefault(NLS_COMP);
                query = this.getAlterSession(NLS_COMP, pref);
            }
            applicator.getUtil().execute(query, NO_BINDS);
            appliedSomething = true;
        }
        appliedSomething |= applicator.apply("NLS_DATE_LANG", NLS_DATE_LANGUAGE);
        appliedSomething |= applicator.apply("NLS_DATE_FORM", NLS_DATE_FORMAT);
        appliedSomething |= applicator.apply("NLS_TS_FORM", NLS_TIMESTAMP_FORMAT);
        if (this.requiresSetting("NLS_TS_TZ_FORM", NLS_TIMESTAMP_TZ_FORMAT)) {
            query = this.getAlterSession(NLS_TIMESTAMP_TZ_FORMAT, this.getDefault("NLS_TS_TZ_FORM"));
            if (ver.compareTo(new Version("9")) < 0) {
                LOGGER.log(Level.INFO, NLS_TIMESTAMP_TZ_FORMAT + Messages.getString("OracleNLSProvider.43"));
            } else {
                applicator.getUtil().execute(query, NO_BINDS);
                appliedSomething = true;
            }
        }
        String dbPref = map.get(NLS_NUMERIC_CHARACTERS);
        char decPref = this.convertToChar(this.getDefault("NLS_DEC_SEP"));
        char sepPref = this.convertToChar(this.getDefault("NLS_GRP_SEP"));
        if (decPref != '\u0000' && sepPref != '\u0000' && decPref != sepPref) {
            String value = "" + decPref + sepPref;
            if (territoryChanged || !value.equals(dbPref)) {
                query = this.getAlterSession(NLS_NUMERIC_CHARACTERS, value);
                applicator.getUtil().execute(query, NO_BINDS);
                appliedSomething = true;
            }
        }
        appliedSomething |= applicator.apply("NLS_CURR", NLS_CURRENCY);
        appliedSomething |= applicator.apply("NLS_ISO_CURR", NLS_ISO_CURRENCY);
        if (this.requiresSetting("NLS_LENGTH", NLS_LENGTH_SEMANTICS)) {
            query = this.getAlterSession(NLS_LENGTH_SEMANTICS, this.getDefault("NLS_LENGTH"));
            if (ver.compareTo(new Version("9")) < 0) {
                LOGGER.log(Level.INFO, NLS_COMP + Messages.getString("OracleNLSProvider.47"));
            } else {
                applicator.getUtil().execute(query, NO_BINDS);
                appliedSomething = true;
            }
        }
        if (appliedSomething |= applicator.apply(this.getSessionTimeZone())) {
            this.populateNLS();
            return true;
        }
        return false;
    }

    @Override
    public void updateDefaults(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.s_defaults.put(key, map.get(key));
            }
        }
    }

    private String getAlterSession(String param, String value) {
        if (value != null) {
            value = value.replaceAll("'", "''");
        }
        return MessageFormat.format(ALTER_SESSION, param, value);
    }

    private final class SettingsApplicator {
        final DBUtil mUtil;
        final Connection mConn;

        SettingsApplicator(Connection conn) {
            this.mConn = conn;
            this.mUtil = DBUtil.getInstance(conn);
        }

        private boolean apply(String setting, String param) {
            boolean appliedSomething = false;
            String pref = OracleNLSProvider.this.getDefault(setting);
            if (OracleNLSProvider.this.requiresSetting(setting, param)) {
                String q = OracleNLSProvider.this.getAlterSession(param, pref);
                this.mUtil.execute(q, NO_BINDS);
                appliedSomething = true;
            }
            return appliedSomething;
        }

        private boolean apply(TimeZone timezone) {
            try {
                String tz = timezone.getID();
                if (tz != null) {
                    if (tz.length() > 3 && (tz.startsWith("GMT+") || tz.startsWith("GMT-"))) {
                        tz = tz.substring(3);
                    }
                    ((OracleConnection)this.mConn).setSessionTimeZone(tz);
                    return true;
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            return false;
        }

        DBUtil getUtil() {
            return this.mUtil;
        }
    }
}

