/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.jdbc.OracleDriver;

public class SQLPlusScriptUtils {
    public static String runAsScript(String in, String connName) {
        return SQLPlusScriptUtils.runAsScript(new StringReader(in), connName, false);
    }

    public static void runAsScript(FileInputStream in, String connName, ScriptRunnerContext ctx) {
        SQLPlusScriptUtils.runAsScript(new InputStreamReader(in), connName, false, ctx);
    }

    public static String runAsScript(InputStream in, String connName) {
        return SQLPlusScriptUtils.runAsScript(new InputStreamReader(in), connName, false);
    }

    public static String runAsScript(Reader rdr, String connName, Boolean useSystemOut) {
        return SQLPlusScriptUtils.runAsScript(rdr, connName, useSystemOut, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runAsScript(Reader rdr, String connName, Boolean useSystemOut, ScriptRunnerContext inCtx) {
        block12: {
            if (connName != null) {
                Connection conn;
                block11: {
                    block10: {
                        conn = null;
                        try {
                            conn = SQLPlusScriptUtils.resolveConnectionName(connName);
                        }
                        catch (Exception ex) {
                            if (!(ex instanceof SQLException)) break block10;
                            throw (SQLException)ex;
                        }
                    }
                    if (conn != null) break block11;
                    String ex = null;
                    return ex;
                }
                try {
                    ScriptExecutor runner = new ScriptExecutor(rdr, conn);
                    ScriptRunnerContext src = null;
                    src = inCtx != null ? inCtx : new ScriptRunnerContext();
                    src.setCurrentConnection(conn);
                    src.setBaseConnection(conn);
                    src.setTopLevel(true);
                    runner.setScriptRunnerContext(src);
                    if (!useSystemOut.booleanValue()) {
                        PipedInputStream runnerIn = new PipedInputStream();
                        BufferedOutputStream out = new BufferedOutputStream(new PipedOutputStream(runnerIn));
                        runner.setOut(out);
                        runner.run();
                        break block12;
                    }
                    runner.run();
                }
                catch (SQLException e) {
                    Logger.getLogger(SQLPlusScriptUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
                catch (IOException e) {
                    Logger.getLogger(SQLPlusScriptUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
        return connName;
    }

    public static String runSqlReturnResult(String sql, Connection conn) {
        try {
            String encoding = ScriptRunnerContext.getOutputEncoding();
            StringReader rdr = new StringReader(sql);
            ScriptExecutor runner = new ScriptExecutor(rdr, conn);
            ScriptRunnerContext ctx = new ScriptRunnerContext();
            ctx.putProperty("script.runner.using.systemout", true);
            runner.setScriptRunnerContext(ctx);
            ByteArrayOutputStream BaS = new ByteArrayOutputStream();
            BufferedOutputStream BoS = new BufferedOutputStream(BaS);
            runner.setOut(BoS);
            runner.run();
            BoS.flush();
            return BaS.toString(encoding);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static Connection resolveConnectionName(String connName) throws Exception {
        return ConnectionResolver.getConnection(connName);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("");
            System.err.println("");
            System.err.println("Usage: java oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils username/password@tns @klr.sql define1 define2 define3 ...");
            System.err.println("");
            System.err.println("");
            System.exit(1);
        }
        String username = args[0].substring(0, args[0].indexOf("/"));
        String password = args[0].substring(args[0].indexOf("/") + 1, args[0].indexOf("@"));
        String tns = args[0].substring(args[0].indexOf("@") + 1);
        String url = "jdbc:oracle:thin:@" + tns;
        String fileName = null;
        fileName = args[1].indexOf("@") == 0 ? args[1].substring(1) : args[1];
        File f = new File(fileName);
        if (!f.exists() && fileName.indexOf(".") == -1) {
            fileName = fileName + ".sql";
        }
        if (!f.exists() && fileName.indexOf(".") == -1) {
            fileName = fileName + ".sql";
        }
        ScriptRunnerContext ctx = new ScriptRunnerContext();
        for (int i = 2; i < args.length; ++i) {
            ctx.getMap().put("" + (i - 1), args[i]);
        }
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection conn = DriverManager.getConnection(url, username, password);
        conn.setAutoCommit(false);
        ScriptExecutor runner = new ScriptExecutor(new FileInputStream(fileName), conn);
        runner.setScriptRunnerContext(ctx);
        runner.run();
    }
}

