/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.util.Random;

public class GuidGen {
    private static byte[] m_arrIeee = null;
    private static int m_nClockSeq = 0;
    private static char[] m_arrHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final int GUID_LENGTH = 16;
    private static String m_lastUuid = null;

    public static synchronized byte[] uuidCreate() {
        byte[] uuid = GuidGen.uuidCreateImpl().toByteArray();
        m_lastUuid = GuidGen.toString(uuid);
        return uuid;
    }

    private static synchronized ByteArrayOutputStream uuidCreateImpl() {
        long nTime = System.currentTimeMillis();
        byte[] ieeeAddr = GuidGen.getIeeeNodeIdentifier();
        if (ieeeAddr == null) {
            return null;
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream(16);
        int nTimeLow = (int)(nTime & 0xFFFFFFFFFFFFFFFFL);
        short nTimeMid = (short)(nTime >> 32 & 0xFFFFL);
        short nTimeHiVersion = (short)((nTime >> 32 & 0xFFF0000L) >> 16);
        nTimeHiVersion = (short)(nTimeHiVersion | 0x1000);
        byte nClockSeqLow = (byte)(m_nClockSeq & 0xFF);
        byte nClockSeqHiReserved = (byte)((m_nClockSeq & 0x3F00) >> 8);
        nClockSeqHiReserved = (byte)(nClockSeqHiReserved | 0x80);
        s.write(nTimeLow >> 24 & 0xFF);
        s.write(nTimeLow >> 16 & 0xFF);
        s.write(nTimeLow >> 8 & 0xFF);
        s.write(nTimeLow & 0xFF);
        s.write(nTimeMid >> 8 & 0xFF);
        s.write(nTimeMid & 0xFF);
        s.write(nTimeHiVersion >> 8 & 0xFF);
        s.write(nTimeHiVersion & 0xFF);
        s.write(nClockSeqHiReserved);
        s.write(nClockSeqLow);
        s.write(ieeeAddr, 0, 6);
        ++m_nClockSeq;
        if (m_lastUuid != null && m_lastUuid.equals(GuidGen.toString(s.toByteArray()))) {
            s = GuidGen.uuidCreateImpl();
        }
        return s;
    }

    public static String toString(byte[] uuidRaw) {
        if (uuidRaw.length != 16) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        for (int nIdx = 0; nIdx < 16; ++nIdx) {
            GuidGen.byteToHex(strBuffer, uuidRaw[nIdx]);
            if (nIdx != 3 && nIdx != 5 && nIdx != 7 && nIdx != 9) continue;
            strBuffer.append('-');
        }
        return strBuffer.toString();
    }

    public static byte[] toRaw(String strUUID) {
        if (strUUID == null || strUUID.length() != 36 || strUUID.charAt(8) != '-' || strUUID.charAt(13) != '-' || strUUID.charAt(18) != '-' || strUUID.charAt(23) != '-') {
            return null;
        }
        byte[] arrUuid = new byte[16];
        int nArr = 0;
        for (int nIdx = 0; nIdx < strUUID.length(); nIdx += 2) {
            if (nIdx == 8 || nIdx == 13 || nIdx == 18 || nIdx == 23) {
                ++nIdx;
            }
            String strByte = strUUID.substring(nIdx, nIdx + 2);
            arrUuid[nArr++] = (byte)Short.parseShort(strByte, 16);
        }
        return arrUuid;
    }

    public static void byteToHex(StringBuffer buff, byte byteVal) {
        buff.append(m_arrHex[byteVal >> 4 & 0xF]);
        buff.append(m_arrHex[byteVal & 0xF]);
    }

    private static byte[] getIeeeNodeIdentifier() {
        if (m_arrIeee != null) {
            return m_arrIeee;
        }
        Random rndTmp = new Random(System.currentTimeMillis() + (long)m_nClockSeq++);
        m_arrIeee = new byte[6];
        byte[] arrInet = null;
        try {
            arrInet = InetAddress.getLocalHost().getAddress();
            if (arrInet.length != 4) {
                throw new Exception("IP address != 4 bytes!!");
            }
            byte[] arrRand = new byte[2];
            rndTmp.nextBytes(arrRand);
            GuidGen.m_arrIeee[0] = arrInet[0];
            GuidGen.m_arrIeee[1] = arrInet[1];
            GuidGen.m_arrIeee[2] = arrInet[2];
            GuidGen.m_arrIeee[3] = arrInet[3];
            GuidGen.m_arrIeee[4] = arrRand[0];
            GuidGen.m_arrIeee[5] = arrRand[1];
        }
        catch (Exception e) {
            GuidGen.TRACE("getIeeeNodeIdentifier() - " + e);
            rndTmp.nextBytes(m_arrIeee);
        }
        return m_arrIeee;
    }

    private static void TRACE(String strMessage) {
        System.out.println("GuidGen." + strMessage);
    }

    static void main(String[] args) {
        byte[] uuid = null;
        String strUuid = null;
        try {
            for (int n = 0; n < 100; ++n) {
                uuid = GuidGen.uuidCreate();
                strUuid = GuidGen.toString(uuid);
                GuidGen.TRACE("UUID = " + strUuid);
            }
            uuid = GuidGen.uuidCreate();
            strUuid = GuidGen.toString(uuid);
            byte[] uuidRaw = GuidGen.toRaw(strUuid);
            String strUuidRaw = GuidGen.toString(uuidRaw);
            GuidGen.TRACE("----------------------------------------------------------");
            GuidGen.TRACE("SRC - " + strUuid);
            GuidGen.TRACE("DST - " + strUuidRaw);
        }
        catch (Exception e) {
            GuidGen.TRACE(e.toString());
        }
    }
}

