/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class WindowsUtility {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_READ32 = 131353;
    private static final int KEY_READ64 = 131097;
    private static final int KEY_WOW64_64KEY = 256;
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Method regDeleteKey = null;
    private static Method regDeleteValue = null;
    private static boolean jdk11Style = false;

    private WindowsUtility() {
    }

    public static Object[] toJdk11(Object[] inParams) {
        if (inParams == null) {
            return null;
        }
        if (!jdk11Style) {
            if (inParams[0] instanceof Long) {
                inParams[0] = new Integer(((Long)inParams[0]).intValue());
            }
            return inParams;
        }
        if (inParams[0] instanceof Integer) {
            inParams[0] = new Long(((Integer)inParams[0]).intValue());
        }
        return inParams;
    }

    public static Long[] longArrayToInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof int[]) {
            ArrayList<Long> allL = new ArrayList<Long>();
            int[] nArray = (int[])o;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                long l = nArray[i];
                allL.add(new Long(l));
            }
            return allL.toArray(new Long[allL.size()]);
        }
        if (o instanceof long[]) {
            ArrayList<Long> allL = new ArrayList<Long>();
            for (long l : (long[])o) {
                allL.add(new Long(l));
            }
            return allL.toArray(new Long[allL.size()]);
        }
        new Exception().printStackTrace();
        return null;
    }

    public static String readString(int hkey, String key, String valueName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WindowsUtility.readString(systemRoot, hkey, key, valueName);
        }
        if (hkey == -2147483647) {
            return WindowsUtility.readString(userRoot, hkey, key, valueName);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    public static Map<String, String> readStringValues(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WindowsUtility.readStringValues(systemRoot, hkey, key);
        }
        if (hkey == -2147483647) {
            return WindowsUtility.readStringValues(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    public static List<String> readStringSubKeys(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WindowsUtility.readStringSubKeys(systemRoot, hkey, key);
        }
        if (hkey == -2147483647) {
            return WindowsUtility.readStringSubKeys(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    public static void createKey(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Long[] ret;
        if (hkey == -2147483646) {
            ret = WindowsUtility.longArrayToInt(WindowsUtility.createKey(systemRoot, hkey, key));
            regCloseKey.invoke((Object)systemRoot, WindowsUtility.toJdk11(new Object[]{new Long(ret[0])}));
        } else if (hkey == -2147483647) {
            ret = WindowsUtility.longArrayToInt(WindowsUtility.createKey(userRoot, hkey, key));
            regCloseKey.invoke((Object)userRoot, WindowsUtility.toJdk11(new Object[]{new Long(ret[0])}));
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
        if (ret[1] != 0L) {
            throw new IllegalArgumentException("rc=" + ret[1] + "  key=" + key);
        }
    }

    public static void writeStringValue(int hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            WindowsUtility.writeStringValue(systemRoot, hkey, key, valueName, value);
        } else if (hkey == -2147483647) {
            WindowsUtility.writeStringValue(userRoot, hkey, key, valueName, value);
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
    }

    public static void deleteKey(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = -1;
        if (hkey == -2147483646) {
            rc = WindowsUtility.deleteKey(systemRoot, hkey, key);
        } else if (hkey == -2147483647) {
            rc = WindowsUtility.deleteKey(userRoot, hkey, key);
        }
        if (rc != 0) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key);
        }
    }

    public static void deleteValue(int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Long rc = -1L;
        if (hkey == -2147483646) {
            rc = WindowsUtility.deleteValue(systemRoot, hkey, key, value);
        } else if (hkey == -2147483647) {
            rc = WindowsUtility.deleteValue(userRoot, hkey, key, value);
        }
        if (rc != 0L) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key + "  value=" + value);
        }
    }

    private static long deleteValue(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Long[] handles = WindowsUtility.longArrayToInt(regOpenKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(hkey), WindowsUtility.toCstr(key), new Integer(983103)})));
        if (handles[1] != 0L) {
            return handles[1];
        }
        Long rc = (long)((Long)regDeleteValue.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0]), WindowsUtility.toCstr(value)})));
        regCloseKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0])}));
        return rc;
    }

    private static int deleteKey(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = (Integer)regDeleteKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(hkey), WindowsUtility.toCstr(key)}));
        return rc;
    }

    private static String readString(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Long[] handles = WindowsUtility.longArrayToInt(regOpenKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(hkey), WindowsUtility.toCstr(key), new Integer(131353)})));
        if (handles[1] != 0L && (handles = WindowsUtility.longArrayToInt(regOpenKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(hkey), WindowsUtility.toCstr(key), new Integer(131097)}))))[1] != 0L) {
            return null;
        }
        byte[] valb = (byte[])regQueryValueEx.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0]), WindowsUtility.toCstr(value)}));
        regCloseKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0])}));
        return valb != null ? new String(valb).trim() : null;
    }

    private static Map<String, String> readStringValues(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> results = new HashMap<String, String>();
        Long[] handles = WindowsUtility.longArrayToInt(regOpenKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(hkey), WindowsUtility.toCstr(key), new Integer(131353)})));
        if (handles[1] != 0L && (handles = WindowsUtility.longArrayToInt(regOpenKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(hkey), WindowsUtility.toCstr(key), new Integer(131097)}))))[1] != 0L) {
            return null;
        }
        Long[] info = WindowsUtility.longArrayToInt(regQueryInfoKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0])})));
        long count = info[0];
        long maxlen = info[3];
        int index = 0;
        while ((long)index < count) {
            byte[] name = (byte[])regEnumValue.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0]), new Integer(index), new Integer(new Long(maxlen + 1L).intValue())}));
            String value = WindowsUtility.readString(hkey, key, new String(name));
            results.put(new String(name).trim(), value);
            ++index;
        }
        regCloseKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0])}));
        return results;
    }

    private static List<String> readStringSubKeys(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        Long[] handles1 = WindowsUtility.longArrayToInt(regOpenKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(hkey), WindowsUtility.toCstr(key), new Integer(131353)})));
        Long[] handles2 = WindowsUtility.longArrayToInt(regOpenKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(hkey), WindowsUtility.toCstr(key), new Integer(131097)})));
        if (handles1[1] != 0L && handles2[1] != 0L) {
            return null;
        }
        results.addAll(WindowsUtility.getResults(root, handles1));
        results.addAll(WindowsUtility.getResults(root, handles2));
        return results;
    }

    private static List<String> getResults(Preferences root, Long[] handles) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        Long[] info = WindowsUtility.longArrayToInt(regQueryInfoKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0])})));
        long count = info[0];
        long maxlen = info[3];
        int index = 0;
        while ((long)index < count) {
            byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0]), new Integer(index), new Integer(new Long(maxlen + 1L).intValue())}));
            results.add(new String(name).trim());
            ++index;
        }
        regCloseKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0])}));
        return results;
    }

    private static int[] createKey(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (int[])regCreateKeyEx.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(hkey), WindowsUtility.toCstr(key)}));
    }

    private static void writeStringValue(Preferences root, int hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regOpenKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(hkey), WindowsUtility.toCstr(key), new Integer(983103)}));
        regSetValueEx.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0]), WindowsUtility.toCstr(valueName), WindowsUtility.toCstr(value)}));
        regCloseKey.invoke((Object)root, WindowsUtility.toJdk11(new Object[]{new Long(handles[0])}));
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    public static void main(String[] args) {
        try {
            String key = "SOFTWARE\\ORACLE";
            List<String> oracle_keys = WindowsUtility.readStringSubKeys(-2147483646, key);
            for (String oracle_key : oracle_keys) {
                System.out.println(oracle_key);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        Class<Number> hkeyType = Integer.TYPE;
        try {
            try {
                regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", hkeyType, byte[].class, Integer.TYPE);
            }
            catch (NoSuchMethodException ex) {
                hkeyType = Long.TYPE;
                jdk11Style = true;
                regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", hkeyType, byte[].class, Integer.TYPE);
            }
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", hkeyType);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", hkeyType, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", hkeyType, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", hkeyType);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", hkeyType, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", hkeyType, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", hkeyType, byte[].class, byte[].class);
            regSetValueEx.setAccessible(true);
            regDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", hkeyType, byte[].class);
            regDeleteValue.setAccessible(true);
            regDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", hkeyType, byte[].class);
            regDeleteKey.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

