/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.generators;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.data.common.NullOrEmpty;
import oracle.dbtools.rest.generators.RestCodeGenerator;
import oracle.dbtools.rest.model.RestHandlerParameter;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestSchema;
import oracle.dbtools.rest.model.RestTemplate;

public class RestCodeGenResults {
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final int DEFAULT_DB_VERSION = 12;
    private static final int MAX_STRING_LIMIT = 4000;
    private static final int MAX_STRING_SIZE = 3800;
    private static final int MAX_BUF_LIMIT = 200;
    private static final String SINGLE_QUOTE = "'";
    private static final String CONCAT_OPERATOR = "|| ";
    private static final String AUTO_REST_AUTH = "autoRestAuth";
    private static final String ACCESS_METHOD = "accessMethod";
    private static final String BASEPATH = "basePath";
    private static final String BIND_VAR_NAME = "bindVarName";
    private static final String COMMENTS = "comments";
    private static final String COMMIT = "commit";
    private static final String DATE_TIME = "dateTime";
    private static final String DESCRIPTION = "description";
    private static final String ETAG_QUERY = "etagQuery";
    private static final String ETAG_TYPE = "etagType";
    private static final String ITEMS_PER_PAGE = "itemsPerPage";
    private static final String LABEL = "label";
    private static final String METHOD = "method";
    private static final String MIMES_ALLOWED = "mimesAllowed";
    private static final String MODULE_NAME = "moduleName";
    private static final String NAME = "name";
    private static final String NEW_NAME = "newName";
    private static final String ORDS_SCHEMA_VER = "ordsSchemaVer";
    private static final String ORIGINS_ALLOWED = "originsAllowed";
    private static final String PARAM_TYPE = "paramType";
    private static final String PATTERN = "pattern";
    private static final String PRIORITY = "priority";
    private static final String SCHEMA_NAME = "schemaName";
    private static final String SCHEMA_STATUS = "schemaStatus";
    private static final String SOURCE = "source";
    private static final String SOURCE_TYPE = "sourceType";
    private static final String SQLDEV_PROD_NAME = "sqldevProdName";
    private static final String SQLDEV_PROD_VER = "sqldevProdVer";
    private static final String STATEMENTS = "statements";
    private static final String STATUS = "status";
    private static final String URL_MAPPING_PATTERN = "urlMappingPattern";
    private static final String URL_MAPPING_TYPE = "urlMappingType";
    private static final String EXPORT_COMMENT_HEADER = "export_comment_header";
    private static final String ENABLE_SCHEMA = "enable_schema";
    private static final String DEFINE_MODULE = "define_module";
    private static final String DELETE_MODULE = "delete_module";
    private static final String RENAME_MODULE = "rename_module";
    private static final String SET_MODULE_ORIGINS_ALLOWED = "set_module_origins_allowed";
    private static final String SET_PUBLISH_MODULE = "set_publish_module";
    private static final String DEFINE_TEMPLATE = "define_template";
    private static final String DEFINE_HANDLER = "define_handler";
    private static final String DEFINE_PARAMETER = "define_parameter";
    private static final String BEGIN_STATEMENTS_END = "begin_statements_end";
    private static final String DEFINE_PRIVILEGE = "define_privilege";
    private static final String RENAME_PRIVILEGE = "rename_privilege";
    private static final String DELETE_PRIVILEGE = "delete_privilege";
    private static final String CREATE_ROLE = "create_role";
    private static final String RENAME_ROLE = "rename_role";
    private static final String DELETE_ROLE = "delete_role";
    private static final String ROLE_ARRAY = "privilege_role_array";
    private static final String MODULE_ARRAY = "privilege_module_array";
    private static final String PATTERN_ARRAY = "privilege_pattern_array";
    private static final String DELETE_ELEMENTS = "privilege_delete_array_elements";
    private static final String PRIV_BEGIN_END = "privilege_begin_statements_end";
    private static final String ENABLED = "ENABLED";
    private static final String EMPTY = "";
    private static final String DATA_TYPE_INT = "INT";
    private static final String NOT_PUBLISHED = "NOT_PUBLISHED";
    private static final String PUBLISHED = "PUBLISHED";
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private static final String INDEX = "index";
    private static final String VALUE = "value";
    private String m_productName = "";
    private String m_productVersion = "";
    private int m_dbVersion = 12;
    private boolean m_backwardsCompatible;

    public RestCodeGenResults() {
    }

    public RestCodeGenResults(String dbVer) {
        if (!NullOrEmpty.nullOrEmpty(dbVer)) {
            if (dbVer.startsWith("11")) {
                this.m_dbVersion = 11;
            } else if (dbVer.startsWith("12")) {
                this.m_dbVersion = 12;
            }
        }
    }

    public RestCodeGenResults(int dbVer) {
        this.m_dbVersion = dbVer;
    }

    public RestCodeGenResults(String productName, String productVersion) {
        this(productName, productVersion, 12);
    }

    public RestCodeGenResults(String productName, String productVersion, int dbVersion) {
        this.m_productName = productName;
        this.m_productVersion = productVersion;
        this.m_dbVersion = dbVersion;
    }

    public String generateModuleTemplateHandler(RestModule module, RestTemplate template, RestResourceHandler handler, boolean commit) {
        StringBuilder sb = new StringBuilder();
        String moduleGen = this.getDefineModule(module);
        if (moduleGen != null) {
            sb.append(moduleGen).append(NEWLINE);
            String templateGen = this.getDefineTemplate(module.getName(), template);
            if (templateGen != null) {
                sb.append(templateGen).append(NEWLINE);
                String handlerGen = this.getDefineHandler(module.getName(), template.getURIPattern(), handler);
                if (handlerGen != null) {
                    sb.append(handlerGen).append(NEWLINE);
                }
            }
            if (sb.length() > 0) {
                return this.getBeginStatementsEnd(sb.toString(), commit);
            }
        }
        return null;
    }

    public String generateModuleTemplatesHandlers(RestModule module, boolean commit) {
        return this.generateModuleTemplatesHandlers(module, commit, true);
    }

    public String generateModuleTemplatesHandlers(RestModule module, boolean commit, boolean includeBeginEnd) {
        StringBuilder sb = new StringBuilder();
        String moduleGen = this.getDefineModule(module);
        if (moduleGen != null) {
            sb.append(moduleGen).append(NEWLINE);
            String templateGen = this.getDefineTemplates(module, true);
            if (templateGen != null) {
                sb.append(templateGen).append(NEWLINE);
            }
            if (sb.length() > 0) {
                if (includeBeginEnd) {
                    return this.getBeginStatementsEnd(sb.toString(), commit);
                }
                return sb.toString();
            }
        }
        return null;
    }

    public String generateTemplateHandlers(String moduleName, RestTemplate template, boolean commit) {
        StringBuilder sb = new StringBuilder();
        String templateGen = this.getDefineTemplate(moduleName, template);
        if (templateGen != null) {
            sb.append(templateGen).append(NEWLINE);
            String handlerGen = this.getDefineHandlers(moduleName, template, true);
            if (handlerGen != null) {
                sb.append(handlerGen).append(NEWLINE);
            }
            if (sb.length() > 0) {
                return this.getBeginStatementsEnd(sb.toString(), commit);
            }
        }
        return null;
    }

    public String generateModuleTemplate(RestModule module, RestTemplate template, boolean commit) {
        return this.generateModuleTemplateHandler(module, template, null, commit);
    }

    public String generateTemplate(String moduleName, RestTemplate template, boolean commit) {
        String templateGen = this.getDefineTemplate(moduleName, template);
        if (templateGen != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(templateGen).append(NEWLINE);
            return this.getBeginStatementsEnd(sb.toString(), commit);
        }
        return null;
    }

    public String generateHandler(String moduleName, String uriTemplate, RestResourceHandler handler, boolean commit) {
        String handlerGen = this.getDefineHandler(moduleName, uriTemplate, handler);
        if (handlerGen != null) {
            StringBuilder codeGen = new StringBuilder();
            codeGen.append(handlerGen).append(NEWLINE);
            String paramsGen = this.getDefineParameters(moduleName, uriTemplate, handler);
            if (paramsGen != null) {
                codeGen.append(paramsGen).append(NEWLINE);
            }
            return this.getBeginStatementsEnd(codeGen.toString(), commit);
        }
        return null;
    }

    public String generatePrivilege(RestPrivilege privilege, boolean commit) {
        String privilegeGen = this.getDefinePrivilege(privilege, commit, true);
        return privilegeGen;
    }

    public String generateEnableSchema(RestSchema schema) {
        String schemaName = schema.getSchemaName();
        String schemaStatus = schema.getSchemaStatus();
        String urlMappingType = schema.getUrlMappingType();
        String urlMappingPattern = schema.getPattern();
        String autoRestAuth = schema.getAutoRestAuth();
        return this.getEnableSchema(schemaName, schemaStatus, urlMappingType, urlMappingPattern, autoRestAuth) + NEWLINE;
    }

    public String getEnableSchema(String schemaName, String schemaStatus, String urlMappingType, String urlMappingPattern, String autoRestAuth) {
        if (!NullOrEmpty.nullOrEmpty(schemaName) && !NullOrEmpty.nullOrEmpty(schemaStatus)) {
            String schemaEnabled = schemaStatus.equalsIgnoreCase(ENABLED) ? TRUE : FALSE;
            String autoRestStatus = autoRestAuth != null && autoRestAuth.equalsIgnoreCase(ENABLED) ? TRUE : FALSE;
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(SCHEMA_NAME, schemaName);
            prop.put(SCHEMA_STATUS, schemaEnabled);
            prop.put(URL_MAPPING_TYPE, urlMappingType);
            prop.put(URL_MAPPING_PATTERN, urlMappingPattern);
            prop.put(AUTO_REST_AUTH, autoRestStatus);
            return RestCodeGenerator.getInstance().getTemplate(ENABLE_SCHEMA, prop);
        }
        return null;
    }

    public String getDefineModule(RestModule module) {
        if (module != null) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, module.getName());
            prop.put(BASEPATH, module.getURIPrefix());
            prop.put(ITEMS_PER_PAGE, (int)module.getPaginationSize());
            prop.put(STATUS, this.getPublished(module.isPublished()));
            prop.put(COMMENTS, this.comments(module.getComments()));
            String moduleGen = RestCodeGenerator.getInstance().getTemplate(DEFINE_MODULE, prop);
            StringBuilder sb = new StringBuilder();
            if (moduleGen != null) {
                String originsGen;
                sb.append(moduleGen);
                if (module.getOrigins() != null && module.getOrigins().size() > 0 && (originsGen = this.getModuleOriginsAllowed(module)) != null) {
                    sb.append(NEWLINE).append(originsGen);
                }
                if (sb.length() > 0) {
                    return sb.toString();
                }
            }
        }
        return null;
    }

    public String getDeleteModule(RestModule module) {
        if (module != null) {
            return this.getDeleteModule(module.getName());
        }
        return null;
    }

    public String getDeleteModule(String moduleName, boolean commit) {
        if (!NullOrEmpty.nullOrEmpty(moduleName)) {
            String modGen = this.getDeleteModule(moduleName);
            StringBuilder sb = new StringBuilder();
            sb.append(modGen).append(NEWLINE);
            return this.getBeginStatementsEnd(sb.toString(), commit);
        }
        return null;
    }

    public String getRenameModule(String moduleName, String newName, String newUriPrefix, boolean commit) {
        if (!NullOrEmpty.nullOrEmpty(moduleName)) {
            String modGen = this.getRenameModule(moduleName, newName, newUriPrefix);
            StringBuilder sb = new StringBuilder();
            sb.append(modGen).append(NEWLINE);
            return this.getBeginStatementsEnd(sb.toString(), commit);
        }
        return null;
    }

    public String getRenamePrivilege(String oldName, String newName, boolean commit) {
        if (!NullOrEmpty.nullOrEmpty(oldName) && !NullOrEmpty.nullOrEmpty(newName)) {
            String privGen = this.getRenamePrivilege(oldName, newName);
            StringBuilder sb = new StringBuilder();
            sb.append(privGen).append(NEWLINE);
            return this.getBeginStatementsEnd(sb.toString(), commit);
        }
        return null;
    }

    public String getDeletePrivilege(String privilegeName, boolean commit) {
        if (!NullOrEmpty.nullOrEmpty(privilegeName)) {
            String privGen = this.getDeletePrivilege(privilegeName);
            StringBuilder sb = new StringBuilder();
            sb.append(privGen).append(NEWLINE);
            return this.getBeginStatementsEnd(sb.toString(), commit);
        }
        return null;
    }

    public String getCreateRole(String roleName, boolean commit) {
        if (!NullOrEmpty.nullOrEmpty(roleName)) {
            String roleGen = this.getCreateRole(roleName);
            StringBuilder sb = new StringBuilder();
            sb.append(roleGen).append(NEWLINE);
            return this.getBeginStatementsEnd(sb.toString(), commit);
        }
        return null;
    }

    public String getCreateRoles(List<String> roles, boolean commit) {
        return this.getCreateRoles(roles, true, true);
    }

    public String getCreateRoles(List<String> roles, boolean commit, boolean includeBeginEnd) {
        if (roles != null && !roles.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String roleName : roles) {
                String roleGen = this.getCreateRole(roleName);
                sb.append(roleGen).append(NEWLINE);
            }
            if (includeBeginEnd) {
                return this.getBeginStatementsEnd(sb.toString(), commit);
            }
            return sb.toString();
        }
        return null;
    }

    public String getRenameRole(String oldName, String newName, boolean commit) {
        if (!NullOrEmpty.nullOrEmpty(oldName) && !NullOrEmpty.nullOrEmpty(newName)) {
            String roleGen = this.getRenameRole(oldName, newName);
            StringBuilder sb = new StringBuilder();
            sb.append(roleGen).append(NEWLINE);
            return this.getBeginStatementsEnd(sb.toString(), commit);
        }
        return null;
    }

    public String getDeleteRole(String roleName, boolean commit) {
        if (!NullOrEmpty.nullOrEmpty(roleName)) {
            String roleGen = this.getDeleteRole(roleName);
            StringBuilder sb = new StringBuilder();
            sb.append(roleGen).append(NEWLINE);
            return this.getBeginStatementsEnd(sb.toString(), commit);
        }
        return null;
    }

    public String getDeleteModule(String moduleName) {
        if (!NullOrEmpty.nullOrEmpty(moduleName)) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, moduleName);
            return RestCodeGenerator.getInstance().getTemplate(DELETE_MODULE, prop);
        }
        return null;
    }

    public String getRenameModule(String moduleName, String newName, String newUriPrefix) {
        if (!NullOrEmpty.nullOrEmpty(moduleName)) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, moduleName);
            prop.put(NEW_NAME, newName);
            prop.put(BASEPATH, newUriPrefix);
            return RestCodeGenerator.getInstance().getTemplate(RENAME_MODULE, prop);
        }
        return null;
    }

    public String getModuleOriginsAllowed(RestModule module) {
        if (module != null) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, module.getName());
            prop.put(ORIGINS_ALLOWED, this.formatCommaDelimited(module.getOrigins()));
            return RestCodeGenerator.getInstance().getTemplate(SET_MODULE_ORIGINS_ALLOWED, prop);
        }
        return null;
    }

    public String getPublishedModule(RestModule module) {
        if (module != null) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, module.getName());
            prop.put(STATUS, this.getPublished(module.isPublished()));
            return RestCodeGenerator.getInstance().getTemplate(SET_PUBLISH_MODULE, prop);
        }
        return null;
    }

    public String getDefineTemplates(RestModule module, boolean includeHandlers) {
        if (module != null && module.getTemplates() != null && !module.getTemplates().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (RestTemplate template : module.getTemplates()) {
                String handlerGen;
                String templateGen = this.getDefineTemplate(module.getName(), template);
                if (templateGen == null) continue;
                sb.append(templateGen).append(NEWLINE);
                if (!includeHandlers || (handlerGen = this.getDefineHandlers(module.getName(), template, true)) == null) continue;
                sb.append(handlerGen);
            }
            return sb.toString();
        }
        return null;
    }

    public String getDefineTemplate(String moduleName, RestTemplate template) {
        if (!NullOrEmpty.nullOrEmpty(moduleName) && template != null) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, moduleName);
            prop.put(PATTERN, template.getURIPattern());
            prop.put(PRIORITY, template.getPriority());
            prop.put(ETAG_TYPE, this.getEntityTag(template.getEntityTag()));
            prop.put(ETAG_QUERY, template.getEntityTagQuery());
            prop.put(COMMENTS, this.comments(template.getComments()));
            return RestCodeGenerator.getInstance().getTemplate(DEFINE_TEMPLATE, prop);
        }
        return null;
    }

    public String getDefineHandlers(String moduleName, RestTemplate template, boolean includeParams) {
        HashMap<RestResourceHandler.HTTP_METHOD_TYPE, RestResourceHandler> handlers;
        if (!(NullOrEmpty.nullOrEmpty(moduleName) || template == null || NullOrEmpty.nullOrEmpty(template.getURIPattern()) || (handlers = template.getResourceHandlers()) == null || handlers.isEmpty())) {
            StringBuilder sb = new StringBuilder();
            for (RestResourceHandler.HTTP_METHOD_TYPE key : handlers.keySet()) {
                String paramGen;
                RestResourceHandler handler = (RestResourceHandler)handlers.get((Object)key);
                String handlerGen = this.getDefineHandler(moduleName, template.getURIPattern(), handler);
                if (handlerGen == null) continue;
                sb.append(handlerGen).append(NEWLINE);
                if (!includeParams || (paramGen = this.getDefineParameters(moduleName, template.getURIPattern(), handler)) == null) continue;
                sb.append(paramGen);
            }
            return sb.toString();
        }
        return null;
    }

    public String getDefineHandler(String moduleName, String templatePattern, RestResourceHandler handler) {
        if (!NullOrEmpty.nullOrEmpty(moduleName) && !NullOrEmpty.nullOrEmpty(templatePattern) && handler != null) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, moduleName);
            prop.put(PATTERN, templatePattern);
            prop.put(METHOD, handler.getMethodType().getType().toUpperCase());
            prop.put(SOURCE_TYPE, handler.getSourceTypeGenerator());
            String source = this.getSqlSource(handler.getSQL());
            prop.put(SOURCE, source);
            prop.put(ITEMS_PER_PAGE, (int)handler.getPaginationSize());
            prop.put(MIMES_ALLOWED, this.formatCommaDelimited(handler.getMimeTypes()));
            prop.put(COMMENTS, this.comments(handler.getComments()));
            return RestCodeGenerator.getInstance().getTemplate(DEFINE_HANDLER, prop);
        }
        return null;
    }

    private String getSqlSource(String sql) {
        if (sql == null || sql.isEmpty() || sql.trim().isEmpty()) {
            return EMPTY;
        }
        String source = sql;
        source = source.replace(SINGLE_QUOTE, "''");
        StringBuilder sb = new StringBuilder();
        if (source.length() <= 4000 || this.m_dbVersion >= 12 && !this.m_backwardsCompatible) {
            sb.append(SINGLE_QUOTE).append(source).append(SINGLE_QUOTE);
            return sb.toString();
        }
        int strSize = source.length();
        int loopNum = strSize / 3800;
        int begNdx = 0;
        int endNdx = 0;
        for (int i = 0; i < loopNum; ++i) {
            endNdx += 3800;
            int cnt = 0;
            int tmpNdx = 0;
            boolean found = false;
            String val = EMPTY;
            while (!found && cnt <= 200 && endNdx + cnt < strSize) {
                tmpNdx = endNdx + cnt;
                val = source.substring(tmpNdx, tmpNdx + 1);
                if (val.equals(SINGLE_QUOTE)) {
                    ++cnt;
                    continue;
                }
                found = true;
            }
            if (found) {
                endNdx += cnt;
            }
            sb.append(SINGLE_QUOTE).append(source.substring(begNdx, endNdx)).append(SINGLE_QUOTE);
            if (endNdx < strSize) {
                sb.append(NEWLINE).append(CONCAT_OPERATOR);
            }
            begNdx = endNdx;
        }
        if (endNdx < strSize) {
            sb.append(SINGLE_QUOTE).append(source.substring(begNdx, strSize)).append(SINGLE_QUOTE);
        }
        return sb.toString();
    }

    public String getDefineParameters(String moduleName, String templatePattern, RestResourceHandler handler) {
        if (!NullOrEmpty.nullOrEmpty(moduleName) && !NullOrEmpty.nullOrEmpty(templatePattern) && handler != null) {
            String method = handler.getMethodType().getType();
            List<RestHandlerParameter> parameters = handler.getParameters();
            if (method != null && parameters != null && !parameters.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (RestHandlerParameter param : parameters) {
                    sb.append(this.getDefineParameter(moduleName, templatePattern, method, param)).append(NEWLINE);
                }
                return sb.toString();
            }
        }
        return null;
    }

    public String getDefineParameter(String moduleName, String templatePattern, String method, RestHandlerParameter parameter) {
        if (!(NullOrEmpty.nullOrEmpty(moduleName) || NullOrEmpty.nullOrEmpty(templatePattern) || NullOrEmpty.nullOrEmpty(method) || parameter == null)) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(MODULE_NAME, moduleName);
            prop.put(PATTERN, templatePattern);
            prop.put(METHOD, method.toUpperCase());
            prop.put(NAME, parameter.getName());
            prop.put(BIND_VAR_NAME, parameter.getBindVariable());
            prop.put(SOURCE_TYPE, this.getSourceType(parameter.getSourceType()));
            prop.put(PARAM_TYPE, this.getDataType(parameter.getDataType()));
            prop.put(ACCESS_METHOD, this.getAccessMethod(parameter.getAccessMethod()));
            prop.put(COMMENTS, this.comments(parameter.getComments()));
            return RestCodeGenerator.getInstance().getTemplate(DEFINE_PARAMETER, prop);
        }
        return null;
    }

    public String getDefinePrivilege(RestPrivilege privilege, boolean commit, boolean includeBeginEnd) {
        if (privilege != null) {
            ArrayList<RestPrivilege> privs = new ArrayList<RestPrivilege>();
            privs.add(privilege);
            return this.getDefinePrivileges(privs, commit, includeBeginEnd);
        }
        return null;
    }

    public String getDefinePrivileges(List<RestPrivilege> privileges, boolean commit) {
        return this.getDefinePrivileges(privileges, commit, true);
    }

    public String getDefinePrivileges(List<RestPrivilege> privileges, boolean commit, boolean includeBeginEnd) {
        if (privileges != null && !privileges.isEmpty()) {
            StringBuilder sbArray = new StringBuilder();
            HashMap<String, Object> prop = new HashMap<String, Object>();
            String code = EMPTY;
            for (int p = 0; p < privileges.size(); ++p) {
                int i;
                RestPrivilege privilege = privileges.get(p);
                if (p != 0 && privileges.size() > 1) {
                    prop.clear();
                    code = RestCodeGenerator.getInstance().getTemplate(DELETE_ELEMENTS, prop);
                    sbArray.append(code).append(NEWLINE);
                }
                if (privilege.getRoles() != null && !privilege.getRoles().isEmpty()) {
                    prop.clear();
                    List<String> roles = privilege.getRoles();
                    for (i = 0; i < roles.size(); ++i) {
                        prop.put(INDEX, i + 1);
                        prop.put(VALUE, roles.get(i));
                        code = RestCodeGenerator.getInstance().getTemplate(ROLE_ARRAY, prop);
                        sbArray.append(code).append(NEWLINE);
                    }
                }
                if (privilege.getModules() != null && !privilege.getModules().isEmpty()) {
                    prop.clear();
                    List<String> modules = privilege.getModules();
                    for (i = 0; i < modules.size(); ++i) {
                        prop.put(INDEX, i + 1);
                        prop.put(VALUE, modules.get(i));
                        code = RestCodeGenerator.getInstance().getTemplate(MODULE_ARRAY, prop);
                        sbArray.append(code).append(NEWLINE);
                    }
                }
                if (privilege.getURIPatterns() != null && !privilege.getURIPatterns().isEmpty()) {
                    prop.clear();
                    List<String> patterns = privilege.getURIPatterns();
                    for (i = 0; i < patterns.size(); ++i) {
                        prop.put(INDEX, i + 1);
                        prop.put(VALUE, patterns.get(i));
                        code = RestCodeGenerator.getInstance().getTemplate(PATTERN_ARRAY, prop);
                        sbArray.append(code).append(NEWLINE);
                    }
                }
                prop.clear();
                prop.put(NAME, privilege.getName());
                prop.put(LABEL, privilege.getTitle());
                prop.put(DESCRIPTION, privilege.getDescription());
                prop.put(COMMENTS, this.comments(privilege.getComments()));
                code = RestCodeGenerator.getInstance().getTemplate(DEFINE_PRIVILEGE, prop);
                sbArray.append(code).append(NEWLINE);
            }
            if (includeBeginEnd) {
                return this.getPrivilegeBeginEnd(sbArray.toString(), commit) + NEWLINE;
            }
            return sbArray.toString();
        }
        return null;
    }

    public String getPrivilegeBeginEnd(String statements, boolean commit) {
        if (!NullOrEmpty.nullOrEmpty(statements)) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(STATEMENTS, statements);
            prop.put(COMMIT, commit);
            return RestCodeGenerator.getInstance().getTemplate(PRIV_BEGIN_END, prop);
        }
        return null;
    }

    public String getRenamePrivilege(String name, String newName) {
        if (!NullOrEmpty.nullOrEmpty(name) && !NullOrEmpty.nullOrEmpty(newName)) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, name);
            prop.put(NEW_NAME, newName);
            return RestCodeGenerator.getInstance().getTemplate(RENAME_PRIVILEGE, prop);
        }
        return null;
    }

    public String getDeletePrivilege(String privilegeName) {
        if (!NullOrEmpty.nullOrEmpty(privilegeName)) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, privilegeName);
            return RestCodeGenerator.getInstance().getTemplate(DELETE_PRIVILEGE, prop);
        }
        return null;
    }

    public String getCreateRole(String roleName) {
        if (!NullOrEmpty.nullOrEmpty(roleName)) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, roleName);
            return RestCodeGenerator.getInstance().getTemplate(CREATE_ROLE, prop);
        }
        return null;
    }

    public String getRenameRole(String name, String newName) {
        if (!NullOrEmpty.nullOrEmpty(name) && !NullOrEmpty.nullOrEmpty(newName)) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, name);
            prop.put(NEW_NAME, newName);
            return RestCodeGenerator.getInstance().getTemplate(RENAME_ROLE, prop);
        }
        return null;
    }

    public String getDeleteRole(String roleName) {
        if (!NullOrEmpty.nullOrEmpty(roleName)) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(NAME, roleName);
            return RestCodeGenerator.getInstance().getTemplate(DELETE_ROLE, prop);
        }
        return null;
    }

    public String getBeginStatementsEnd(String code, boolean commit) {
        if (code != null) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(STATEMENTS, code);
            prop.put(COMMIT, commit);
            return RestCodeGenerator.getInstance().getTemplate(BEGIN_STATEMENTS_END, prop);
        }
        return null;
    }

    public String getCommentHeader(String pSchema, String pOrdsSchemaVer) {
        String schema = !NullOrEmpty.nullOrEmpty(pSchema) ? pSchema : EMPTY;
        String ordsSchemaVer = !NullOrEmpty.nullOrEmpty(pOrdsSchemaVer) ? pOrdsSchemaVer : EMPTY;
        HashMap<String, Object> prop = new HashMap<String, Object>();
        prop.put(SQLDEV_PROD_NAME, this.getProductName());
        prop.put(SQLDEV_PROD_VER, this.getProductVersion());
        prop.put(DATE_TIME, Calendar.getInstance().getTime());
        prop.put(SCHEMA_NAME, schema);
        prop.put(ORDS_SCHEMA_VER, ordsSchemaVer);
        return RestCodeGenerator.getInstance().getTemplate(EXPORT_COMMENT_HEADER, prop);
    }

    public void setProductName(String productName) {
        this.m_productName = productName;
    }

    public String getProductName() {
        return !NullOrEmpty.nullOrEmpty(this.m_productName) ? this.m_productName : EMPTY;
    }

    public void setProductVersion(String productVersion) {
        this.m_productVersion = productVersion;
    }

    public String getProductVersion() {
        return !NullOrEmpty.nullOrEmpty(this.m_productVersion) ? this.m_productVersion : EMPTY;
    }

    private String comments(String txt) {
        if (txt == null) {
            return txt;
        }
        String text = txt.replace(SINGLE_QUOTE, "''");
        return text;
    }

    private String getEntityTag(RestTemplate.ENTITY_TAG_TYPE entityTag) {
        String value = "HASH";
        if (entityTag != null && entityTag != RestTemplate.ENTITY_TAG_TYPE.SECURE_HASH) {
            value = entityTag.getType();
        }
        return value.toUpperCase();
    }

    private String getSourceType(RestHandlerParameter.SOURCE_TYPE sourceType) {
        String value = "header";
        if (sourceType != null && sourceType != RestHandlerParameter.SOURCE_TYPE.HTTP_HEADER) {
            value = sourceType.getType();
        }
        return value.toUpperCase();
    }

    private String getDataType(RestHandlerParameter.DATA_TYPE dataType) {
        String value = "String";
        if (dataType != null && dataType != RestHandlerParameter.DATA_TYPE.STRING) {
            value = dataType == RestHandlerParameter.DATA_TYPE.INTEGER ? DATA_TYPE_INT : dataType.getType();
        }
        return value.toUpperCase();
    }

    private String getAccessMethod(RestHandlerParameter.ACCESS_METHOD_TYPE accessMethod) {
        String value = "IN";
        if (accessMethod != null && accessMethod != RestHandlerParameter.ACCESS_METHOD_TYPE.IN) {
            value = accessMethod.getType();
        }
        return value.toUpperCase();
    }

    private String getPublished(boolean published) {
        if (published) {
            return PUBLISHED;
        }
        return NOT_PUBLISHED;
    }

    private String formatCommaDelimited(List<String> values) {
        if (values != null && !values.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < values.size(); ++i) {
                if (i == 0) {
                    sb.append(values.get(i));
                    continue;
                }
                sb.append(",").append(values.get(i));
            }
            return sb.toString();
        }
        return EMPTY;
    }

    public void setBackwardsCompatible(boolean indicator) {
        this.m_backwardsCompatible = indicator;
    }
}

