/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.explorer;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.bali.xml.gui.jdev.explorer.AbstractAsynchronousXmlExplorer;
import oracle.bali.xml.gui.jdev.util.AsynchronousXmlGuiUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.editor.Editor;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.resource.ExplorerArb;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.util.SwingUtils;

public abstract class AsynchronousXmlExplorer
extends AbstractAsynchronousXmlExplorer {
    protected static final int UNSET_STATE = -1;
    private static final int REFRESH_DELAY = Integer.getInteger("structure.refresh.delay", 250);
    protected int refreshDelay = REFRESH_DELAY;
    protected ProgressTrackedTask xmlContextGetterTask;
    private RefreshTimer refreshTimer;
    private int state = -1;
    private Context delayedContext;
    private Node _defaultStructureIdeContextNode;
    private final Element LABEL_ELEMENT = new DefaultElement(){
        private String _label = ExplorerArb.getString((int)5);
        private Icon _icon = null;

        public String getShortLabel() {
            return this._label;
        }

        public Icon getIcon() {
            if (this._icon == null) {
                this._icon = ExplorerArb.getIcon((int)6);
            }
            return this._icon;
        }
    };
    private static final int DEFAULT_MULTI_CLICK_INTERVAL = 400;

    public AsynchronousXmlExplorer() {
        this.setUpRefreshTimer();
    }

    private void setUpRefreshTimer() {
        this.refreshTimer = new RefreshTimer(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Assert.println((String)("Refreshing SP using delay of " + AsynchronousXmlExplorer.this.refreshTimer.getInitialDelay() + " ms"));
                AsynchronousXmlExplorer.this.report("Refresh timer action with delay of " + AsynchronousXmlExplorer.this.refreshTimer.getInitialDelay() + " ms");
                ProgressTrackedTask nextTask = AsynchronousXmlExplorer.this.xmlContextGetterTask;
                AsynchronousXmlExplorer.this.xmlContextGetterTask = null;
                if (nextTask != null) {
                    AsynchronousXmlExplorer.this.scheduleTask(nextTask);
                }
            }
        });
        this.refreshTimer.setInitialDelay(REFRESH_DELAY);
        this.refreshTimer.setRepeats(false);
    }

    protected void scheduleTask(ProgressTrackedTask task) {
        ProgressTracker progressTracker = Ide.getStatusBar().getProgressTracker();
        progressTracker.addTask(task);
    }

    protected void setTimerDelayForView(Object view) {
        int delay = REFRESH_DELAY;
        boolean useDoubleClickTime = true;
        delay = useDoubleClickTime ? AsynchronousXmlExplorer._getMultiClickInterval() : (view instanceof Editor ? REFRESH_DELAY : REFRESH_DELAY * 2);
        this.refreshTimer.setInitialDelay(delay);
        this.refreshDelay = delay;
    }

    @Override
    public void setContext(Context ideContext) {
        this.report("context set");
        this.setTimerDelayForView(ideContext == null ? null : ideContext.getView());
        Context currentContext = this.getContext();
        if (ideContext == null || ideContext.getNode() == null) {
            this.updateContextImpl(ideContext);
        } else if (currentContext != null && currentContext.getNode() == ideContext.getNode()) {
            if (this.delayedContext == null) {
                this.updateContextImpl(ideContext);
            } else {
                this.rescheduleXmlContextFetch();
            }
        } else if (ideContext == null || ideContext.getNode() == null) {
            this.updateContextImpl(ideContext);
        } else {
            Context context = new Context(ideContext);
            context.setView((View)this);
            context.setWorkspace(ideContext.getWorkspace());
            context.setProject(ideContext.getProject());
            context.setNode(ideContext.getNode());
            this.delayContextSet(context);
        }
    }

    public void close() {
        super.close();
        this.cancelXmlContextFetch();
        this.report("closed");
    }

    @Override
    public void stateChanged(int state) {
        this.state = state;
        super.stateChanged(state);
        switch (state) {
            case 0: {
                this.report("shown");
                this.rescheduleXmlContextFetch();
                break;
            }
            case 1: 
            case 2: {
                this.report("hidden");
                this.cancelXmlContextFetch();
            }
        }
    }

    private void delayContextSet(Context ideContext) {
        ideContext.setView((View)this);
        this.createDefaultStructure(ideContext);
        this.superSetContext(ideContext);
        this.xmlContextGetterTask = this.getNewProgressTrackedTask(ideContext);
        this.delayedContext = ideContext;
        if (this.state == 0) {
            this.rescheduleXmlContextFetch();
        }
    }

    private ProgressTrackedTask getNewProgressTrackedTask(final Context ideContext) {
        final Runnable xmlContextRunnable = this.getXmlContextGetter(ideContext);
        ProgressTrackedTask task = new ProgressTrackedTask(){

            public int getCurrentValue() {
                return 0;
            }

            public int getMinimum() {
                return 0;
            }

            public int getMaximum() {
                return 0;
            }

            public boolean isIndeterminate() {
                return true;
            }

            public String getCurrentText() {
                if (ideContext.getNode() == null) {
                    if (AsynchronousXmlExplorer.this._defaultStructureIdeContextNode == null) {
                        return "Loading ...";
                    }
                    return "Loading " + AsynchronousXmlExplorer.this._defaultStructureIdeContextNode.getShortLabel();
                }
                return "Loading " + ideContext.getNode().getShortLabel();
            }

            public String getTaskDescription() {
                return this.getCurrentText();
            }

            public void run() {
                try {
                    xmlContextRunnable.run();
                }
                finally {
                    if (AsynchronousXmlExplorer.this.xmlContextGetterTask == this) {
                        AsynchronousXmlExplorer.this.xmlContextGetterTask = null;
                    }
                }
            }
        };
        return task;
    }

    protected Runnable getXmlContextGetter(final Context ideContext) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (AsynchronousXmlExplorer.this.continueProcessing(ideContext)) {
                    AsynchronousXmlExplorer.this.report("get XmlContext");
                    try {
                        AsynchronousXmlGuiUtils.getXmlContextAndInitialize(ideContext);
                    }
                    catch (Throwable throwable) {
                        AsynchronousXmlExplorer._invokeLaterAfterRepaint(new Runnable(){

                            @Override
                            public void run() {
                                AsynchronousXmlExplorer.this.setDelayedContext(ideContext);
                            }
                        });
                        throw throwable;
                    }
                    AsynchronousXmlExplorer._invokeLaterAfterRepaint(new /* invalid duplicate definition of identical inner class */);
                }
            }
        };
        return runnable;
    }

    protected final void setDelayedContext(Context ideContext) {
        if (this.continueProcessing(ideContext)) {
            this.report("set delayed Context");
            this.updateContextImpl(ideContext);
            if (this.state == 0) {
                this.stateChanged(this.state);
            }
        }
    }

    private void updateContextImpl(Context ideContext) {
        this.delayedContext = null;
        super.setContext(ideContext);
    }

    protected final void rescheduleXmlContextFetch() {
        boolean showing = this.getScrollPane().isShowing();
        boolean displayable = this.getScrollPane().isDisplayable();
        boolean visible = this.getScrollPane().isVisible();
        this.report("timer stoped " + (showing && visible));
        this.cancelXmlContextFetch();
        AsynchronousXmlExplorer._invokeLaterAfterRepaint(new Runnable(){

            @Override
            public void run() {
                AsynchronousXmlExplorer.this.report("timer started");
                AsynchronousXmlExplorer.this._scheduleXmlContextFetch();
            }
        });
    }

    protected void cancelXmlContextFetch() {
        this.refreshTimer.stop();
    }

    private void _scheduleXmlContextFetch() {
        this.cancelXmlContextFetch();
        if (this.continueProcessing()) {
            if (this.xmlContextGetterTask == null) {
                this.xmlContextGetterTask = this.getNewProgressTrackedTask(this.delayedContext);
            }
            this.scheduleXmlContextFetch(this.delayedContext);
        }
    }

    protected void scheduleXmlContextFetch(Context delayedContext) {
        this.refreshTimer.restart();
    }

    protected boolean continueProcessing(Context ideContext) {
        Context savedDelayedContext = this.delayedContext;
        return this.continueProcessing() && savedDelayedContext.getNode() == ideContext.getNode();
    }

    protected boolean continueProcessing() {
        return this.state == 0 && this.delayedContext != null;
    }

    protected String getDefaultRootName(Context ideContext) {
        if (ideContext.getNode() == null) {
            if (this._defaultStructureIdeContextNode == null) {
                return "";
            }
            return this._defaultStructureIdeContextNode.getShortLabel();
        }
        return ideContext.getNode().getShortLabel();
    }

    protected Icon getDefaultRootIcon(Context ideContext) {
        if (ideContext.getNode() == null) {
            if (this._defaultStructureIdeContextNode == null) {
                return null;
            }
            return this._defaultStructureIdeContextNode.getIcon();
        }
        return ideContext.getNode().getIcon();
    }

    private void createDefaultStructure(final Context ideContext) {
        this._defaultStructureIdeContextNode = ideContext.getNode();
        DefaultFolder rootElement = new DefaultFolder();
        DefaultFolder fakeElement = new DefaultFolder(){

            public String getShortLabel() {
                return AsynchronousXmlExplorer.this.getDefaultRootName(ideContext);
            }

            public Icon getIcon() {
                return AsynchronousXmlExplorer.this.getDefaultRootIcon(ideContext);
            }
        };
        rootElement.add((Element)fakeElement);
        fakeElement.add(this.LABEL_ELEMENT);
        TreeExplorer _delegate = ExplorerManager.getExplorerManager().createTreeExplorer((Folder)rootElement);
        TNode fakeNode = _delegate.findTNode((Element)fakeElement, _delegate.getRoot());
        if (fakeNode != null) {
            _delegate.expand(fakeNode, false, false);
        }
        JTree jTree = _delegate.getJTree();
        this.getScrollPane().setViewportView(jTree);
    }

    private void removeDefaultStructure() {
        this.getScrollPane().setViewportView(null);
    }

    protected void report(String message) {
    }

    private static int _getMultiClickInterval() {
        Object interval = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        if (interval instanceof Integer) {
            return (Integer)interval;
        }
        return 400;
    }

    private static void _invokeLaterAfterRepaint(final Runnable runnable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtils.invokeAfterRepaint((Runnable)runnable);
            }
        });
    }

    private class RefreshTimer
    extends Timer {
        public RefreshTimer(ActionListener al) {
            super(REFRESH_DELAY, al);
        }
    }
}

