/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent;

import java.awt.Component;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.jdev.overviewEditor.AbstractOverviewEditorXmlGui;
import oracle.bali.xml.gui.jdev.xmlComponent.AbstractXmlPanelWrapper;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelWrapper;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.NonValidatingTransactionTask;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.ide.view.View;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlPanelGui
extends XmlGui
implements JDevViewHostedGui,
ComponentXmlGui<Component> {
    private View _view;
    private XmlPanelWrapper _panelWrapper;
    private AbstractOverviewEditorXmlGui _overviewEditorXmlGui;

    public XmlPanelGui(XmlView view) {
        super(view);
    }

    public Component getComponent() {
        return this._panelWrapper.getPanel();
    }

    public XmlPanelWrapper getPanelWrapper() {
        return this._panelWrapper;
    }

    public XmlPanelGui setPanelWrapper(XmlPanelWrapper panelWrapper) {
        this._panelWrapper = panelWrapper;
        return this;
    }

    public AbstractOverviewEditorXmlGui getOverviewEditorXmlGui() {
        return this._overviewEditorXmlGui;
    }

    public void setOverviewEditorXmlGui(AbstractOverviewEditorXmlGui overviewEditorXmlGui) {
        this._overviewEditorXmlGui = overviewEditorXmlGui;
    }

    protected void handleModelInvalidateEvent(XmlModelEvent event) {
        Node changeRoot;
        Set removed;
        if (!event.isDomTreeChanged()) {
            return;
        }
        if (event.isDomDocumentChanged()) {
            this.getPanelWrapper().invalidateXmlComponents();
            return;
        }
        if (((AbstractXmlPanelWrapper)this.getPanelWrapper()).getUpdating()) {
            return;
        }
        NodeChangeDetails details = event.getNodeChangeDetails();
        if (details != null && details != NodeChangeDetails.NO_DETAILS_AVAILABLE && (removed = details.getRemovedNodes()).size() > 0) {
            Iterator iter = removed.iterator();
            Node deletedNode = null;
            while (iter.hasNext()) {
                deletedNode = (Node)iter.next();
                if (deletedNode.getLocalName() == null) continue;
                Set nodes = DomUtils.getNodesInSubtree((TreeTraversal)DocumentTreeTraversal.INSTANCE, (Node)deletedNode);
                for (Node node : nodes) {
                    for (Map.Entry<Component, XmlComponentWrapper> entries : this.getPanelWrapper().getXmlComponentWrapperMap().getComponentWrapperMap().entrySet()) {
                        XmlComponentWrapper xmlComponentWrapper = entries.getValue();
                        if (!xmlComponentWrapper.getXmlComponentModel().getXmlKey().getLocalName().equals(node.getLocalName()) || !xmlComponentWrapper.getXmlComponentModel().getXmlKey().getNamespace().equals(node.getNamespaceURI())) continue;
                        xmlComponentWrapper.invalidateXmlComponent();
                    }
                }
            }
        }
        if ((changeRoot = event.getChangeRoot()) != null) {
            for (Map.Entry<Component, XmlComponentWrapper> entries : this.getPanelWrapper().getXmlComponentWrapperMap().getComponentWrapperMap().entrySet()) {
                XmlComponentWrapper xmlComponentWrapper = entries.getValue();
                if (!xmlComponentWrapper.getXmlComponentModel().isNodeOrDescendant(changeRoot)) continue;
                xmlComponentWrapper.invalidateXmlComponent();
            }
        }
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        Node changeRoot;
        Set removed;
        super.handleModelChangeEvent(event);
        if (event.getReadOnlyPropertyChange() != null) {
            this.handleReadOnlyPropertyChange();
        }
        if (!this.isShown()) {
            return;
        }
        if (event.getIssueListPropertyChange() != null) {
            for (Map.Entry<Component, XmlComponentWrapper> entries : this.getPanelWrapper().getXmlComponentWrapperMap().getComponentWrapperMap().entrySet()) {
                entries.getValue().highlightErrorOrWarning();
            }
        }
        if (!event.isDomTreeChanged()) {
            return;
        }
        if (event.isDomDocumentChanged()) {
            this.handleDomDocumentChanged();
            return;
        }
        if (((AbstractXmlPanelWrapper)this.getPanelWrapper()).getUpdating()) {
            return;
        }
        NodeChangeDetails details = event.getNodeChangeDetails();
        if (details != null && details != NodeChangeDetails.NO_DETAILS_AVAILABLE && (removed = details.getRemovedNodes()).size() > 0) {
            Iterator iter = removed.iterator();
            Node deletedNode = null;
            while (iter.hasNext()) {
                deletedNode = (Node)iter.next();
                Set nodes = DomUtils.getNodesInSubtree((TreeTraversal)DocumentTreeTraversal.INSTANCE, (Node)deletedNode);
                for (Node node : nodes) {
                    this.handleDeletedNode(node);
                }
            }
        }
        if ((changeRoot = event.getChangeRoot()) != null) {
            this.handleChangeRoot(changeRoot);
        }
    }

    protected void handleDeletedNode(Node deletedNode) {
        this.getPanelWrapper().getXmlComponentWrapperMap().updateDeletedNode(deletedNode);
    }

    protected void handleDomDocumentChanged() {
        if (!this._rootNodeExists()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XmlPanelGui.this.ensureRootNodeExists();
                    XmlPanelGui.this.getPanelWrapper().dispose();
                    XmlPanelGui.this.getPanelWrapper().createXmlComponents();
                    XmlPanelGui.this.getPanelWrapper().updateXmlComponentsFromModel();
                }
            });
        } else {
            this.getPanelWrapper().updateXmlComponentsFromModel();
        }
    }

    protected void handleReadOnlyPropertyChange() {
        this.getPanelWrapper().dispose();
        this.getPanelWrapper().createXmlComponents();
        this.getPanelWrapper().updateXmlComponentsFromModel();
    }

    protected void handleChangeRoot(Node changeRoot) {
        this.getPanelWrapper().getXmlComponentWrapperMap().updateNodeOrDescendant(changeRoot);
    }

    protected void handleShown() {
        super.handleShown();
        if (!this._rootNodeExists()) {
            this.ensureRootNodeExists();
            this.getPanelWrapper().dispose();
            this.getPanelWrapper().createXmlComponents();
            this.getPanelWrapper().updateXmlComponentsFromModel();
        }
    }

    @Override
    public void setOwningJDevView(View view) {
        this._view = view;
    }

    @Override
    public View getOwningJDevView() {
        return this._view;
    }

    private boolean _rootNodeExists() {
        return (Boolean)new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                if (model.getDocument().getDocumentElement() == null) {
                    return false;
                }
                return true;
            }
        }.run((AbstractModel)this.getView());
    }

    public void ensureRootNodeExists() {
        new NonValidatingTransactionTask(){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                if (model.getDocument().getDocumentElement() == null) {
                    Element rootNode = model.getDocument().createElementNS(XmlPanelGui.this.getPanelWrapper().getXmlPanelRootXmlKey().getNamespace(), XmlPanelGui.this.getPanelWrapper().getXmlPanelRootXmlKey().getLocalName());
                    model.getDocument().appendChild(rootNode);
                }
            }

            protected String computeTransactionName(AbstractModel model) {
                return "Insert Root Node";
            }
        }.run((AbstractModel)this.getView());
    }
}

