/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.applet.AppletContext;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import oracle.help.CustomProtocolHandler;
import oracle.help.DefaultNavigatorPanel;
import oracle.help.WindowManager;
import oracle.help.common.Topic;
import oracle.help.htmlBrowser.NativeBrowser;
import oracle.help.library.Library;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.topicDisplay.BrowserTopicDisplay;
import oracle.help.topicDisplay.TopicDisplayException;

public class AppletWindowManager
implements WindowManager {
    private DefaultNavigatorPanel _navigatorPanel;
    private AppletContext _appletContext;
    private BrowserTopicDisplay _nativeBrowserDisplay;
    private Library _library;
    private FavoritesModel _favoritesModel;

    public AppletWindowManager(AppletContext appletContext, String targetFrame, DefaultNavigatorPanel navigatorPanel, Library library) {
        this._appletContext = appletContext;
        this._navigatorPanel = navigatorPanel;
        this._navigatorPanel.setWindowManager(this);
        this._library = library;
        try {
            NativeBrowser nBrowser = new NativeBrowser(appletContext, targetFrame);
            this._nativeBrowserDisplay = new BrowserTopicDisplay(nBrowser, this._library);
        }
        catch (Exception e) {
            System.err.println("Failed to create AppletContext based TopicDisplay");
            this._nativeBrowserDisplay = null;
        }
    }

    @Override
    public void displayTopic(Topic aTopic, boolean newWindow, Point location, Dimension size) throws TopicDisplayException {
        if (this._nativeBrowserDisplay != null) {
            this._nativeBrowserDisplay.displayTopic(aTopic);
        }
    }

    public AppletContext getAppletContext() {
        return this._appletContext;
    }

    @Override
    public void showNavigatorWindow() {
        Window navWindow = this._navigatorPanel.getCurrentNavigatorWindow();
        if (navWindow == null) {
            navWindow = this._navigatorPanel.createNavigatorFrame();
        }
        navWindow.setVisible(true);
        this._ensureNotMinimized(navWindow);
        navWindow.toFront();
    }

    @Override
    public void hideNavigatorWindow() {
        Window navWindow = this._navigatorPanel.getCurrentNavigatorWindow();
        if (navWindow != null) {
            navWindow.setVisible(false);
        }
    }

    @Override
    public void hideAllWindows() {
        this.hideNavigatorWindow();
    }

    @Override
    public boolean isNewWindowSupported() {
        return false;
    }

    @Override
    public boolean isPrintingSupported() {
        return false;
    }

    @Override
    public void printTopics(Topic[] topics) {
    }

    @Override
    public synchronized void dispose() {
        this._navigatorPanel.dispose();
        this._nativeBrowserDisplay.dispose();
        this._appletContext = null;
    }

    @Override
    public void registerCustomProtocolHandler(String customProtocol, CustomProtocolHandler handler) {
    }

    @Override
    public void setFavoritesModel(FavoritesModel favoritesModel) {
        this._favoritesModel = favoritesModel;
    }

    @Override
    public FavoritesModel getFavoritesModel() {
        return this._favoritesModel;
    }

    private void _ensureNotMinimized(Window aWindow) {
        Frame windowFrame;
        if (aWindow instanceof Frame && (windowFrame = (Frame)aWindow).getState() == 1) {
            windowFrame.setState(0);
        }
    }
}

