/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.config.Preferences;
import oracle.ide.webbrowser.InternetFilesOptions;
import oracle.javatools.data.PropertyStorage;

public class InternetFilesManager {
    private static InternetFilesManager _instance;
    private CookieManager _cookieManager;
    private CookiePolicy _cookiePolicy;

    private InternetFilesManager() {
    }

    public static synchronized InternetFilesManager getInstance() {
        if (_instance == null) {
            _instance = new InternetFilesManager();
        }
        return _instance;
    }

    public void initialize() {
        Preferences prefs = Preferences.getPreferences();
        final InternetFilesOptions internetFilesOptions = InternetFilesOptions.getInstance((PropertyStorage)prefs);
        this.setNewCookieManager(internetFilesOptions);
        internetFilesOptions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InternetFilesManager.this.setCookiePolicy(internetFilesOptions);
                InternetFilesManager.this.clearAllCookies();
            }
        });
    }

    public void enableAllCookies() {
        this._cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
    }

    public void enableOriginalServerCookies() {
        this._cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
    }

    public void disableAllCookies() {
        this._cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_NONE);
    }

    public void clearAllCookies() {
        this._cookieManager.getCookieStore().removeAll();
    }

    private void setNewCookieManager(InternetFilesOptions internetFilesOptions) {
        this._cookieManager = new CookieManager();
        this.setCookiePolicy(internetFilesOptions);
        CookieHandler.setDefault(this._cookieManager);
    }

    private void setCookiePolicy(InternetFilesOptions internetFilesOptions) {
        this._cookiePolicy = internetFilesOptions.getEnableCookies() ? CookiePolicy.ACCEPT_ALL : CookiePolicy.ACCEPT_NONE;
        this._cookieManager.setCookiePolicy(this._cookiePolicy);
    }
}

