/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.shell;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.aurora.util.tools.ToolException;

public class MessageTool {
    private ResourceBundle bundle;
    public static final String LOCAL_BUNDLE_NAME = "Message";
    public static final String DEFAULT_MESSAGE_BUNDLE = "oracle.aurora.server.tools.shell.Message";
    private static final Hashtable toolsBundles = new Hashtable();

    public String description() throws ToolException {
        return this.msg(this.getClass().getName() + ".description");
    }

    protected void error(String message) throws ToolException {
        throw new ToolException(message);
    }

    protected String getMessage(String key) {
        try {
            return this.msg(key, null);
        }
        catch (ToolException e) {
            System.out.println(e.getMessage());
            return "No Message Found";
        }
    }

    protected String getMessage1(String key, String info) {
        Object[] args = new Object[]{info == null ? "null" : info};
        try {
            return this.msg(key, args);
        }
        catch (ToolException e) {
            System.out.println(e.getMessage());
            return "No Message Found";
        }
    }

    protected String getMessage2(String key, String info, String info2) {
        Object[] args = new Object[]{info == null ? "null" : info, info2 == null ? "null" : info2};
        try {
            return this.msg(key, args);
        }
        catch (ToolException e) {
            System.out.println(e.getMessage());
            return "No Message Found";
        }
    }

    protected String getMessage3(String key, String info, String info2, String info3) {
        Object[] args = new Object[]{info == null ? "null" : info, info2 == null ? "null" : info2, info3 == null ? "null" : info3};
        try {
            return this.msg(key, args);
        }
        catch (ToolException e) {
            System.out.println(e.getMessage());
            return "No Message Found";
        }
    }

    protected void fail0(String key) throws ToolException {
        String message = this.msg(key, null);
        throw new ToolException(message);
    }

    protected void fail1(String key, String info) throws ToolException {
        Object[] args = new Object[]{info == null ? "null" : info};
        String message = this.msg(key, args);
        throw new ToolException(message);
    }

    protected void fail2(String key, String info, String info2) throws ToolException {
        Object[] args = new Object[]{info == null ? "null" : info, info2 == null ? "null" : info2};
        String message = this.msg(key, args);
        throw new ToolException(message);
    }

    protected void fail3(String key, String info, String info2, String info3) throws ToolException {
        Object[] args = new Object[]{info == null ? "null" : info, info2 == null ? "null" : info2, info3 == null ? "null" : info3};
        String message = this.msg(key, args);
        throw new ToolException(message);
    }

    protected ResourceBundle getBundle() throws ToolException {
        if (this.bundle == null) {
            try {
                this.bundle = this.getBundle(this.getBundleName());
            }
            catch (Exception e1) {
                try {
                    this.bundle = this.getBundle(DEFAULT_MESSAGE_BUNDLE);
                }
                catch (Exception e) {
                    throw new ToolException("Tools default bundle 'oracle.aurora.server.tools.shell.Message' is missing.");
                }
            }
        }
        return this.bundle;
    }

    private ResourceBundle getBundle(String name) throws Exception {
        ResourceBundle b = (ResourceBundle)toolsBundles.get(name);
        if (b == null) {
            b = ResourceBundle.getBundle(name);
            toolsBundles.put(name, b);
        }
        return b;
    }

    protected String getBundleName() throws ToolException {
        int pkgPos = this.getClass().getName().lastIndexOf(46);
        return this.getClass().getName().substring(0, pkgPos + 1) + LOCAL_BUNDLE_NAME;
    }

    String get_property(String key) throws ToolException {
        return this.getBundle().getString(key);
    }

    public String help() throws ToolException {
        return this.msg(this.getClass().getName() + ".help");
    }

    protected String msg(String key) throws ToolException {
        return this.msg(key, null);
    }

    protected String msg(String key, Object[] args) throws ToolException {
        try {
            return MessageFormat.format(this.getBundle().getString(key), args);
        }
        catch (MissingResourceException mre) {
            String msg = "Message [" + mre.getKey() + "] " + mre.getMessage() + " from " + mre.getClassName();
            if (args != null) {
                msg = msg + ":";
                for (int i = 0; i < args.length; ++i) {
                    msg = msg + " {" + args[i] + "}";
                }
            }
            return msg;
        }
    }

    public String usage() throws ToolException {
        return this.msg(this.getClass().getName() + ".usage");
    }

    public String version() throws ToolException {
        return this.msg(this.getClass().getName() + ".version");
    }
}

