/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import oracle.aurora.util.QExternalizable;

public class QObjectInputStream
extends DataInputStream {
    protected byte[] buf;
    protected ByteArrayInputStream bais;
    protected DataInputStream din;
    protected byte[] sizeBytes;
    public static final int DEF_INIT_BUF_SIZE = 1024;

    public QObjectInputStream(InputStream in) {
        this(in, 1024);
    }

    public QObjectInputStream(InputStream in, int initialBufSize) {
        super(in);
        this.buf = new byte[initialBufSize];
        this.bais = new ByteArrayInputStream(this.buf);
        this.din = new DataInputStream(this.bais);
        this.sizeBytes = new byte[4];
    }

    public void setBuf(byte[] buf, int bStart, int bLength) {
        this.bais = new ByteArrayInputStream(buf, bStart, bLength);
    }

    protected void readAll(byte[] buf, int bLength) throws IOException {
        int justRead;
        for (int read = 0; read < bLength; read += justRead) {
            justRead = this.in.read(buf, read, bLength - read);
            if (justRead != -1) continue;
            throw new EOFException();
        }
    }

    public static final int decodeInt(byte[] bytes, int idx) {
        return ((bytes[idx] & 0xFF) << 24) + ((bytes[idx + 1] & 0xFF) << 16) + ((bytes[idx + 2] & 0xFF) << 8) + ((bytes[idx + 3] & 0xFF) << 0);
    }

    protected final int qReadInt() throws IOException {
        this.readAll(this.sizeBytes, 4);
        return QObjectInputStream.decodeInt(this.sizeBytes, 0);
    }

    public QExternalizable readObject(QExternalizable obj) throws IOException {
        int nBytes = this.qReadInt();
        if (nBytes > this.buf.length) {
            this.buf = new byte[nBytes];
            this.bais = new ByteArrayInputStream(this.buf);
        }
        this.readAll(this.buf, nBytes);
        this.bais.reset();
        obj.qRead(this.din);
        return obj;
    }
}

