/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLConstants;
import oracle.dbtools.crest.exports.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.exports.ddl.DDLGenerationStatus;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SSBErrorHandler;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;

public abstract class SQLStatementBuilder
implements DDLConstants {
    public static String NEWLINE = System.getProperty("line.separator");
    public static final String TAB = "    ";
    public final char FINISH_STATEMENT = (char)59;
    public final int LINE_SIZE = 80;
    protected static final SQLStatementBuilder LAST_ERROR_HANDLER = SSBErrorHandler.getInstance();
    private SQLStatementBuilder successor = LAST_ERROR_HANDLER;
    private DDLGenerator ddlGenerator = null;
    private StorageDesign storageDesign = null;
    private DDLGenerationStatus status = null;

    public void append(SQLStatementBuilder ssb) {
        if (this.isLast()) {
            this.setSuccessor(ssb);
        } else {
            this.getSuccessor().append(ssb);
        }
    }

    public boolean isLast() {
        return this.successor == LAST_ERROR_HANDLER;
    }

    public StorageDesign getStorageDesign(Object object) {
        if (object instanceof StorageObject) {
            return ((StorageObject)object).getStorageDesign();
        }
        if (this.storageDesign != null) {
            return this.storageDesign;
        }
        if (object instanceof ModelObject) {
            ModelObject mo = (ModelObject)object;
            return mo.getDesign().getStorageDesign(mo.getSelectedRDBMSSite());
        }
        return null;
    }

    public final void appendTo(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (this.canHandle(object)) {
            this.doAppend(buffer, object, prettyPrint);
        } else {
            this.getSuccessor().appendTo(buffer, object, prettyPrint);
        }
    }

    protected abstract void doAppend(StringBuffer var1, Object var2, boolean var3);

    public void setSuccessor(SQLStatementBuilder successor) {
        this.successor = successor;
    }

    public SQLStatementBuilder getSuccessor() {
        return this.successor;
    }

    public DDLGenerator getDDLGenerator() {
        return this.ddlGenerator;
    }

    public void setDDLGenerator(DDLGenerator ddlGenerator) {
        this.ddlGenerator = ddlGenerator;
    }

    public abstract boolean canHandle(Object var1);

    protected void appendComment(StringBuffer buffer, ModelIDObject object) {
        if (this.isIncludeComments() && !"".equals(object.getComment())) {
            StringTokenizer stok = new StringTokenizer(object.getComment(), "\n");
            if (!this.endsWithNewline(buffer)) {
                buffer.append(NEWLINE);
            }
            while (stok.hasMoreTokens()) {
                String line = stok.nextToken();
                while (line.length() > 76) {
                    int ind = 76;
                    if (line.indexOf(76) != 32 && line.indexOf(76) != 9 && line.indexOf(76) != 10) {
                        ind = line.substring(0, 76).lastIndexOf(32);
                        int ind2 = line.substring(0, 76).lastIndexOf(9);
                        int ind3 = line.substring(0, 76).lastIndexOf(10);
                        if (ind2 > ind) {
                            ind = ind2;
                        }
                        if (ind3 > ind) {
                            ind = ind3;
                        }
                        if (ind == -1) {
                            ind = 76;
                        }
                    }
                    buffer.append("--  ").append(line.substring(0, ind)).append(NEWLINE);
                    line = line.substring(ind + 1);
                }
                buffer.append("--  ").append(line).append(NEWLINE);
            }
        }
    }

    protected boolean endsWithNewline(StringBuffer buffer) {
        return buffer.lastIndexOf(NEWLINE) + NEWLINE.length() == buffer.length();
    }

    protected boolean isNotEmpty(String string) {
        return string != null && !"".equals(string) && !"".equals(string.trim());
    }

    protected void appendUnaltered(StringBuffer buffer, StorageObject object) {
        buffer.append("-- ").append(object.getObjectTypeName().toUpperCase(Locale.ROOT)).append(": ").append(object.getLongName()).append(" IS UNALTERED");
    }

    public static void appendNewLine(StringBuffer buffer, boolean prettyPrint, int indent) {
        if (prettyPrint) {
            buffer.append(NEWLINE);
            for (int i = 0; i < indent; ++i) {
                buffer.append(TAB);
            }
        } else {
            buffer.append(' ');
        }
    }

    public static void appendSpace(StringBuffer buffer) {
        buffer.append(' ');
    }

    public void appendComma(StringBuffer buffer) {
        buffer.append(',');
        SQLStatementBuilder.appendSpace(buffer);
    }

    public String addQuotes(String string, boolean singleQuotes) {
        String quotes;
        StringBuffer buffer = new StringBuffer();
        String string2 = quotes = singleQuotes ? "'" : "\"";
        if (!string.startsWith(quotes)) {
            buffer.append(quotes);
        }
        buffer.append(string);
        if (!string.endsWith(quotes)) {
            buffer.append(quotes);
        }
        return buffer.toString();
    }

    public static void appendLineFinisher(StringBuffer buffer, boolean prettyPrint) {
        buffer.append(';');
        SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
    }

    public void appendCreate(StringBuffer buffer) {
        buffer.append("CREATE");
        SQLStatementBuilder.appendSpace(buffer);
    }

    public void appendDrop(StringBuffer buffer) {
        buffer.append("DROP");
        SQLStatementBuilder.appendSpace(buffer);
    }

    public void appendCreateOrReplace(StringBuffer buffer) {
        buffer.append("CREATE");
        SQLStatementBuilder.appendSpace(buffer);
        buffer.append("OR");
        SQLStatementBuilder.appendSpace(buffer);
        buffer.append("REPLACE");
        SQLStatementBuilder.appendSpace(buffer);
    }

    public void appendCreateOrReplace(StringBuffer buffer, StorageObject storageObject) {
        this.appendCreateOrReplace(buffer);
        SQLStatementBuilder.appendStringWithSpace(buffer, storageObject.getObjectTypeName());
        SQLStatementBuilder.appendStringWithSpace(buffer, storageObject.getStorageDesign().getFormatedLongNameDDL(storageObject));
    }

    public void appendString(StringBuffer buffer, Object object) {
        buffer.append(object.toString());
    }

    public static void appendString(StringBuffer buffer, String string) {
        buffer.append(string);
    }

    public static void appendString(StringBuffer buffer, char character) {
        String characterString = String.valueOf(character);
        buffer.append(characterString);
    }

    public static void appendString(StringBuffer buffer, int number) {
        String integerString = String.valueOf(number);
        buffer.append(integerString);
    }

    public static void appendString(StringBuffer buffer, long number) {
        String integerString = String.valueOf(number);
        buffer.append(integerString);
    }

    public void appendString(StringBuffer buffer, float number) {
        String floatString = String.valueOf(number);
        buffer.append(floatString);
    }

    public static void appendStringWithSpace(StringBuffer buffer, String string) {
        SQLStatementBuilder.appendString(buffer, string);
        SQLStatementBuilder.appendSpace(buffer);
    }

    public void appendStringWithSpace(StringBuffer buffer, String string, int count) {
        SQLStatementBuilder.appendString(buffer, string);
        for (int i = 0; i < count; ++i) {
            SQLStatementBuilder.appendSpace(buffer);
        }
    }

    public void appendStringWithSpace(StringBuffer buffer, Object object) {
        this.appendString(buffer, object);
        SQLStatementBuilder.appendSpace(buffer);
    }

    public static void appendStringWithSpace(StringBuffer buffer, char character) {
        SQLStatementBuilder.appendString(buffer, character);
        SQLStatementBuilder.appendSpace(buffer);
    }

    public void appendStringWithSpace(StringBuffer buffer, char character, int count) {
        SQLStatementBuilder.appendString(buffer, character);
        for (int i = 0; i < count; ++i) {
            SQLStatementBuilder.appendSpace(buffer);
        }
    }

    public static void appendStringWithSpace(StringBuffer buffer, int number) {
        SQLStatementBuilder.appendString(buffer, number);
        SQLStatementBuilder.appendSpace(buffer);
    }

    public static void appendStringWithSpace(StringBuffer buffer, long number) {
        SQLStatementBuilder.appendString(buffer, number);
        SQLStatementBuilder.appendSpace(buffer);
    }

    public void appendStringWithSpace(StringBuffer buffer, float number) {
        this.appendString(buffer, number);
        SQLStatementBuilder.appendSpace(buffer);
    }

    public void appendOnOffWithSpace(StringBuffer buffer, boolean booleanValue) {
        if (booleanValue) {
            SQLStatementBuilder.appendString(buffer, "ON");
        } else {
            SQLStatementBuilder.appendString(buffer, "OFF");
        }
        SQLStatementBuilder.appendSpace(buffer);
    }

    public void appendYesNoWithSpace(StringBuffer buffer, boolean booleanValue) {
        if (booleanValue) {
            SQLStatementBuilder.appendString(buffer, "YES");
        } else {
            SQLStatementBuilder.appendString(buffer, "NO");
        }
        SQLStatementBuilder.appendSpace(buffer);
    }

    public void appendAllowDisallowWithSpace(StringBuffer buffer, boolean booleanValue) {
        if (booleanValue) {
            SQLStatementBuilder.appendString(buffer, "ALLOW");
        } else {
            SQLStatementBuilder.appendString(buffer, "DISALLOW");
        }
        SQLStatementBuilder.appendSpace(buffer);
    }

    public void appendNotWithSpace(StringBuffer buffer, boolean booleanValue) {
        if (!booleanValue) {
            SQLStatementBuilder.appendString(buffer, "NOT");
            SQLStatementBuilder.appendSpace(buffer);
        }
    }

    public void appendTab(StringBuffer buffer, boolean prettyPrint, int indent) {
        if (prettyPrint) {
            for (int i = 0; i < indent; ++i) {
                buffer.append(TAB);
            }
        }
    }

    public boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getName(String name) {
        if (name.indexOf(32) > -1) {
            return "\"" + name + "\"";
        }
        return name;
    }

    private String getLongName(String name) {
        if (name.indexOf(32) > -1) {
            if (name.indexOf(46) > -1) {
                String firstPart = name.substring(0, name.lastIndexOf(46));
                String secondPart = name.substring(name.lastIndexOf(46) + 1);
                return this.getName(firstPart) + "." + this.getName(secondPart);
            }
            return this.getName(name);
        }
        return name;
    }

    private String getLongName(String name, String tablePrefix) {
        if (name.indexOf(32) > -1) {
            if (name.indexOf(46) > -1) {
                String firstPart = name.substring(0, name.lastIndexOf(46));
                String secondPart = name.substring(name.lastIndexOf(46) + 1);
                return firstPart + '.' + this.getName(tablePrefix + secondPart);
            }
            return this.getName(tablePrefix + name);
        }
        if (name.indexOf(46) > -1) {
            String firstPart = name.substring(0, name.lastIndexOf(46));
            String secondPart = name.substring(name.lastIndexOf(46) + 1);
            return firstPart + '.' + tablePrefix + secondPart;
        }
        return this.getName(tablePrefix + name);
    }

    public void appendName(StringBuffer buffer, String name) {
        buffer.append(this.getName(name));
    }

    public void appendLongName(StringBuffer buffer, String name) {
        buffer.append(this.getLongName(name)).append(' ');
    }

    public void appendLongName(StringBuffer buffer, String name, String tablePrefix) {
        buffer.append(this.getLongName(name, tablePrefix)).append(' ');
    }

    protected void appendBeforeDropScript(StringBuffer oldbuffer, boolean prettyPrint, ContainerObject object) {
        if (object.getShouldGenerateScript() && this.isNotEmpty(object.getBeforeDrop())) {
            this.appendScript(oldbuffer, object.getBeforeDrop(), prettyPrint, object);
        }
    }

    protected void appendBeforeCreateScript(StringBuffer oldbuffer, boolean prettyPrint, ContainerObject object) {
        if (object.getShouldGenerateScript() && this.isNotEmpty(object.getBeforeCreate())) {
            SQLStatementBuilder.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendScript(oldbuffer, object.getBeforeCreate(), prettyPrint, object);
        }
    }

    private void appendScript(StringBuffer oldbuffer, String script, boolean prettyPrint, ContainerObject object) {
        if (script.indexOf(123) > -1) {
            String objectName = object.getName();
            if (object instanceof Table) {
                Table table = (Table)object;
                String abbreviation = table.getAbbreviation();
                if (abbreviation.length() == 0) {
                    abbreviation = objectName;
                }
                script = this.replaceVariable(script, "{table}", objectName);
                script = this.replaceVariable(script, "{table abbr}", abbreviation);
                script = this.replaceVariable(script, "{pk name}", table.getPKName());
            } else if (object instanceof TableView) {
                script = this.replaceVariable(script, "{view}", objectName);
            }
            script = this.replaceVariable(script, "{schema}", object.getSchema());
            script = this.replaceVariable(script, "{long name}", object.getLongName());
        }
        String trimmedScript = script.trim();
        boolean endsWithComment = false;
        boolean endsWithSlash = false;
        if (trimmedScript.endsWith("*/")) {
            endsWithComment = true;
        } else {
            String lastLine;
            int indexR = trimmedScript.lastIndexOf(13);
            int indexN = trimmedScript.lastIndexOf(10);
            if (indexN < indexR) {
                indexN = indexR;
            }
            if ((lastLine = trimmedScript.substring(indexN + 1)).indexOf("--") > -1) {
                endsWithComment = true;
            } else if (lastLine.trim().equals("/")) {
                endsWithSlash = true;
            }
        }
        if (endsWithSlash || trimmedScript.endsWith(";") && !endsWithComment) {
            trimmedScript = trimmedScript.substring(0, trimmedScript.length() - 1).trim();
        }
        if (this.isNotEmpty(trimmedScript)) {
            StringBuffer buffer = new StringBuffer();
            SQLStatementBuilder.appendString(buffer, trimmedScript);
            String advancedComment = trimmedScript;
            if (advancedComment.length() > 80) {
                advancedComment = advancedComment.substring(0, 80);
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
            if (!endsWithComment && !endsWithSlash) {
                SQLStatementBuilder.appendLineFinisher(buffer, prettyPrint);
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            if (endsWithSlash) {
                SQLStatementBuilder.appendNewLine(oldbuffer, prettyPrint, 0);
                SQLStatementBuilder.appendString(oldbuffer, "/");
            }
            SQLStatementBuilder.appendNewLine(oldbuffer, prettyPrint, 0);
        }
    }

    private String replaceVariable(String script, String variable, String replacement) {
        int varIndex = script.indexOf(variable);
        while (varIndex > -1) {
            script = script.substring(0, varIndex) + replacement + script.substring(varIndex + variable.length());
            varIndex = script.indexOf(variable, varIndex + replacement.length());
        }
        return script;
    }

    protected void appendAfterCreateScript(StringBuffer oldbuffer, boolean prettyPrint, ContainerObject object) {
        if (object.getShouldGenerateScript() && this.isNotEmpty(object.getAfterCreate())) {
            this.appendScript(oldbuffer, object.getAfterCreate(), prettyPrint, object);
        }
    }

    protected void appendBeforeAlterScript(StringBuffer oldbuffer, boolean prettyPrint, ContainerObject object) {
    }

    protected void appendAfterAlterScript(StringBuffer oldbuffer, boolean prettyPrint, ContainerObject object) {
    }

    protected void appendEndScript(StringBuffer oldbuffer, boolean prettyPrint, ContainerObject object) {
        if (object.getShouldGenerateScript() && this.isNotEmpty(object.getEndOfScript())) {
            this.appendScript(oldbuffer, object.getEndOfScript(), prettyPrint, object);
        }
    }

    public void appendToBuffer(StringBuffer toBuffer, StringBuffer fromBuffer, String comment) {
        if (this.canAppendBuffer(fromBuffer)) {
            if (this.getddlAdvancedGenenerator() != null) {
                if (this.isNotLineFinisher(fromBuffer.toString())) {
                    toBuffer.append("-- Step").append(this.getAdvancedStep());
                    this.appendFormatedBuffer(toBuffer, fromBuffer, comment, this.getAdvancedStep(), true);
                    this.incrementAdvancedStep();
                }
            } else {
                toBuffer.append(fromBuffer);
            }
            fromBuffer.setLength(0);
        }
    }

    protected void appendBlockDefinitionToBuffer(StringBuffer toBuffer, StringBuffer fromBuffer, String comment, String blockFinisher) {
        if (this.canAppendBuffer(fromBuffer)) {
            if (this.getddlAdvancedGenenerator() != null) {
                toBuffer.append("-- Step").append(this.getAdvancedStep());
                this.appendFormatedBuffer(toBuffer, fromBuffer, comment, this.getAdvancedStep(), true);
                this.incrementAdvancedStep();
            } else {
                toBuffer.append(fromBuffer);
                SQLStatementBuilder.appendNewLine(toBuffer, true, 0);
                toBuffer.append(blockFinisher);
            }
            fromBuffer.setLength(0);
        }
    }

    protected boolean canAppendBuffer(StringBuffer fromBuffer) {
        return fromBuffer.length() > 0 && !fromBuffer.toString().equals(NEWLINE);
    }

    protected void appendFormatedBuffer(StringBuffer toBuffer, StringBuffer fromBuffer, String comment, int step, boolean prettyPrint) {
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 0);
        SQLStatementBuilder.appendString(toBuffer, "declare");
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 1);
        SQLStatementBuilder.appendString(toBuffer, "statement varchar2(32000);");
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 1);
        SQLStatementBuilder.appendString(toBuffer, "comments varchar2(200);");
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 0);
        SQLStatementBuilder.appendString(toBuffer, "begin");
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 0);
        SQLStatementBuilder.appendString(toBuffer, "statement :=");
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 1);
        SQLStatementBuilder.appendString(toBuffer, '\'');
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 1);
        toBuffer.append(this.replaceSingleQuote(fromBuffer.toString()));
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 1);
        SQLStatementBuilder.appendString(toBuffer, '\'');
        SQLStatementBuilder.appendString(toBuffer, ';');
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 0);
        SQLStatementBuilder.appendString(toBuffer, "comments := ");
        SQLStatementBuilder.appendString(toBuffer, '\'');
        if (comment.length() > 80) {
            comment = comment.substring(0, 80);
        }
        SQLStatementBuilder.appendString(toBuffer, this.replaceSingleQuote(comment));
        SQLStatementBuilder.appendString(toBuffer, '\'');
        SQLStatementBuilder.appendString(toBuffer, ';');
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 0);
        SQLStatementBuilder.appendString(toBuffer, "adv_scripting.EXEC_STATEMENT(");
        SQLStatementBuilder.appendString(toBuffer, step);
        SQLStatementBuilder.appendString(toBuffer, ",statement,comments);");
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 0);
        SQLStatementBuilder.appendString(toBuffer, "end;");
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 0);
        SQLStatementBuilder.appendString(toBuffer, "/");
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 0);
        SQLStatementBuilder.appendString(toBuffer, "-- end Step");
        SQLStatementBuilder.appendString(toBuffer, step);
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 0);
        SQLStatementBuilder.appendNewLine(toBuffer, prettyPrint, 0);
    }

    public String replaceSingleQuote(String fromBuffer) {
        return fromBuffer.replaceAll("\\'", "\\'\\'");
    }

    protected boolean isNotLineFinisher(String str) {
        String trimmed = str.trim();
        if (trimmed.startsWith(";")) {
            if (trimmed.equals(";")) {
                return false;
            }
            if (trimmed.substring(1).trim().equals("/")) {
                return false;
            }
        }
        return true;
    }

    protected boolean hasToBeBackup() {
        return false;
    }

    public void appendLineFinisherWithSlash(StringBuffer buffer, boolean prettyPrint) {
        buffer.append(';').append(NEWLINE).append("/");
        SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
        SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
    }

    public String getStringWithMaxLength(String in_str, int length) {
        if (in_str.length() <= length) {
            return in_str;
        }
        return in_str.substring(0, length);
    }

    public List getColumnsWithOneRestrictedSubType(Table table) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column column : table.getElementsCollection()) {
            if (!(column.getDataType() instanceof StructuredType) || column.isReference() || !column.isAllowSubtypeSubstitution() || !column.isRestrictedTypeSubstitution() || column.getPermittedSubTypes().size() != 1) continue;
            list.add(column);
        }
        return list;
    }

    public List getColumnsWithManyRestrictedSubType(Table table) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column column : table.getElementsCollection()) {
            if (!(column.getDataType() instanceof StructuredType) || !column.isAllowSubtypeSubstitution() || !column.isRestrictedTypeSubstitution() || column.getPermittedSubTypes().size() <= 1 && (!column.isReference() || column.getPermittedSubTypes().size() != 1)) continue;
            list.add(column);
        }
        return list;
    }

    public List getColumnsWithRestrictedSubType(Table table) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column column : table.getElementsCollection()) {
            if (!(column.getDataType() instanceof StructuredType) || column.isReference() && column.getScope() == null) continue;
            if (column.isAllowSubtypeSubstitution() && column.isRestrictedTypeSubstitution()) {
                if (column.getPermittedSubTypes().size() <= 0) continue;
                list.add(column);
                continue;
            }
            if (column.isAllowSubtypeSubstitution()) continue;
            list.add(column);
        }
        return list;
    }

    protected String addQuotesToDefault(String dataType, String defaultValue) {
        String df = defaultValue.trim();
        if (!(dataType.toUpperCase(Locale.ROOT).indexOf("CHAR") <= -1 && dataType.toUpperCase(Locale.ROOT).indexOf("DATE") <= -1 && dataType.toUpperCase(Locale.ROOT).indexOf("TIME") <= -1 || Token.hasCloseAndOpenBrackets(defaultValue))) {
            if (df.endsWith("'") && df.length() > 1 && (df.startsWith("'") || df.toUpperCase(Locale.ROOT).startsWith("N'") || df.toUpperCase(Locale.ROOT).startsWith("Q'") || df.toUpperCase(Locale.ROOT).startsWith("NQ'"))) {
                return df;
            }
            if (df.indexOf(39) > -1) {
                df = df.replaceAll("'", "''");
            }
            df = "'" + df + "'";
        }
        return df;
    }

    public void clearTemporaryObjects() {
    }

    public void doOnFinish(StringBuffer buffer) {
    }

    private String replaceSpecialChars(String text) {
        return text.replaceAll("\\$", "\\\\\\$");
    }

    protected String appendOwner(String text, String name, String owner) {
        name = this.replaceSpecialChars(name);
        owner = this.replaceSpecialChars(owner);
        return text.replaceFirst(name, owner + '.' + name);
    }

    protected String replaceName(String text, String name, String newName) {
        name = this.replaceSpecialChars(name);
        newName = this.replaceSpecialChars(newName);
        return text.replaceFirst(name, newName);
    }

    protected void appendCommentOn(StringBuffer buffer, StorageObject object, boolean prettyPrint) {
        this.appendCommentOn(buffer, object, prettyPrint, true, false);
    }

    protected void appendCommentOn(StringBuffer buffer, StorageObject object, boolean prettyPrint, boolean checkForEmptyComment, boolean snapshot) {
        String tableCommentOn = "";
        if (object instanceof TableProxy) {
            TableProxy tableProxy = (TableProxy)object;
            Table table = (Table)tableProxy.getObject();
            if (!table.isMaterializedQueryTable() || snapshot) {
                tableCommentOn = tableProxy.isCommentInRDBMSChanged() ? tableProxy.getCommentInRDBMS() : table.getCommentInRDBMS();
            }
        } else if (object instanceof TableViewProxy) {
            TableViewProxy tableViewProxy = (TableViewProxy)object;
            if (tableViewProxy.isCommentInRDBMSChanged()) {
                tableCommentOn = tableViewProxy.getCommentInRDBMS();
            } else {
                TableView view = (TableView)tableViewProxy.getObject();
                tableCommentOn = view.getCommentInRDBMS();
            }
        } else if (object instanceof SnapshotOracle) {
            tableCommentOn = object.getCommentInRDBMS();
        }
        if (this.isNotEmpty(tableCommentOn) || !checkForEmptyComment) {
            if (prettyPrint) {
                buffer.append(NEWLINE);
                buffer.append(NEWLINE);
            }
            StringBuffer tempBuffer = new StringBuffer();
            SQLStatementBuilder.appendStringWithSpace(tempBuffer, "COMMENT ON");
            if (object instanceof SnapshotOracle || snapshot) {
                SQLStatementBuilder.appendStringWithSpace(tempBuffer, "MATERIALIZED");
                SQLStatementBuilder.appendStringWithSpace(tempBuffer, "VIEW");
            } else {
                SQLStatementBuilder.appendStringWithSpace(tempBuffer, "TABLE");
            }
            SQLStatementBuilder.appendStringWithSpace(tempBuffer, object.getStorageDesign().getFormatedLongNameDDL(object));
            String advancedComment = tempBuffer.toString();
            SQLStatementBuilder.appendStringWithSpace(tempBuffer, "IS");
            SQLStatementBuilder.appendString(tempBuffer, '\'');
            SQLStatementBuilder.appendString(tempBuffer, this.replaceSingleQuote(tableCommentOn));
            SQLStatementBuilder.appendString(tempBuffer, '\'');
            this.appendToBuffer(buffer, tempBuffer, advancedComment);
            SQLStatementBuilder.appendNewLine(tempBuffer, prettyPrint, 0);
            SQLStatementBuilder.appendLineFinisher(tempBuffer, prettyPrint);
            this.appendToBuffer(buffer, tempBuffer, advancedComment);
        }
        buffer.append(NEWLINE);
    }

    protected void appendViewCommentOn(StorageDesign storageDesign, StringBuffer buffer, TableView view, TableViewProxy tableViewProxy, boolean prettyPrint) {
        String viewComment;
        if (tableViewProxy != null) {
            this.appendCommentOn(buffer, tableViewProxy, prettyPrint);
            if (view == null) {
                view = (TableView)tableViewProxy.getObject();
            }
        } else if (view != null && (viewComment = view.getCommentInRDBMS()) != null && !"".equalsIgnoreCase(viewComment)) {
            SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
            StringBuffer tempBuffer = new StringBuffer();
            SQLStatementBuilder.appendStringWithSpace(tempBuffer, "COMMENT ON");
            SQLStatementBuilder.appendStringWithSpace(tempBuffer, "TABLE");
            SQLStatementBuilder.appendStringWithSpace(tempBuffer, storageDesign.getFormatedLongNameDDL(view));
            String advancedComment = tempBuffer.toString();
            SQLStatementBuilder.appendStringWithSpace(tempBuffer, "IS");
            SQLStatementBuilder.appendString(tempBuffer, '\'');
            SQLStatementBuilder.appendString(tempBuffer, this.replaceSingleQuote(viewComment));
            SQLStatementBuilder.appendStringWithSpace(tempBuffer, '\'');
            this.appendToBuffer(buffer, tempBuffer, advancedComment);
            SQLStatementBuilder.appendNewLine(tempBuffer, prettyPrint, 0);
            SQLStatementBuilder.appendLineFinisher(tempBuffer, prettyPrint);
            this.appendToBuffer(buffer, tempBuffer, advancedComment);
        }
        if (view != null) {
            ContainedObject[] elements = view.getElements();
            for (int i = 0; i < elements.length; ++i) {
                ContainedObject elm = elements[i];
                String columnComment = elm.getCommentInRDBMS();
                if (columnComment == null || "".equalsIgnoreCase(columnComment)) continue;
                SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
                StringBuffer tempBuffer = new StringBuffer();
                SQLStatementBuilder.appendStringWithSpace(tempBuffer, "COMMENT ON");
                SQLStatementBuilder.appendStringWithSpace(tempBuffer, "COLUMN");
                ModelIDObject viewObject = tableViewProxy;
                if (viewObject == null) {
                    viewObject = view;
                }
                String formattedName = storageDesign.getFormatedLongNameDDL(viewObject) + '.' + storageDesign.getFormatedName(elm);
                SQLStatementBuilder.appendStringWithSpace(tempBuffer, formattedName);
                String advancedComment = tempBuffer.toString();
                SQLStatementBuilder.appendStringWithSpace(tempBuffer, "IS");
                SQLStatementBuilder.appendString(tempBuffer, '\'');
                SQLStatementBuilder.appendString(tempBuffer, this.replaceSingleQuote(columnComment));
                SQLStatementBuilder.appendStringWithSpace(tempBuffer, '\'');
                this.appendToBuffer(buffer, tempBuffer, advancedComment);
                SQLStatementBuilder.appendNewLine(tempBuffer, prettyPrint, 0);
                SQLStatementBuilder.appendLineFinisher(tempBuffer, prettyPrint);
                this.appendToBuffer(buffer, tempBuffer, advancedComment);
            }
        }
    }

    public void appendExistenceDependencyConstraints(StringBuffer oldbuffer, TableProxy tableProxy, boolean prettyPrint, SQLStatementBuilder sbuilder, String terminaton_str, int constr_length, DDLGenerationStatus status) {
        Table table = (Table)tableProxy.getObject();
        Column discrCol = table.getDiscriminatorColumn();
        if (discrCol != null && table.isExistDependencyGenerateInDDl()) {
            ColumnProxy columnProxy;
            discrCol.validateDependentColumnsDescriptors();
            List<Column.DependentColumnDescriptor> list = discrCol.getDependentColumnDescriptors();
            if (list.size() == 0) {
                return;
            }
            String baseConstr = table.getExistDependencyConstraintName();
            if (baseConstr == null || "".equals(baseConstr)) {
                baseConstr = table.getAbbreviation();
                if (baseConstr == null || "".equals(baseConstr)) {
                    baseConstr = table.getName();
                }
                baseConstr = baseConstr + "_ExDep";
            }
            if ((columnProxy = (ColumnProxy)tableProxy.getStorageDesign().getStorageObject(discrCol.getObjectID())) == null) {
                return;
            }
            if (table.getExistDependencyGenerationLevel().equals(Table.DC_DDL_LEVEL_SINGLE_STATEMENT)) {
                this.appendExistenceDependencySingle(oldbuffer, tableProxy, discrCol, list, baseConstr, prettyPrint, sbuilder, terminaton_str, constr_length);
            } else if (table.getExistDependencyGenerationLevel().equals(Table.DC_DDL_LEVEL_DISCRIMINATOR_VALUE)) {
                this.appendExistenceDependencyValue(oldbuffer, tableProxy, discrCol, list, baseConstr, prettyPrint, sbuilder, terminaton_str, constr_length);
            } else if (table.getExistDependencyGenerationLevel().equals(Table.DC_DDL_LEVEL_COLUMN_LEVEL)) {
                SQLStatementBuilder.appendExistenceDependencyColumn(oldbuffer, tableProxy, discrCol, list, baseConstr, prettyPrint, sbuilder, terminaton_str, constr_length, status);
            }
        }
    }

    public void appendOptionalFKCheckConstraints(StringBuffer oldbuffer, TableProxy tableProxy, boolean prettyPrint, SQLStatementBuilder sbuilder, String terminaton_str, int constr_length) {
        Table table = (Table)tableProxy.getObject();
        List<ContainedObject> columns = Arrays.asList(table.getElements());
        for (FKIndexAssociation fk : table.getFKAssociationsList()) {
            FKElement[] fkcols = fk.getColumns();
            if (fk.isMandatory() || !fk.isColumnDependencyConstraintGenerateInDDL() || fkcols.length <= 0) continue;
            String text1 = "";
            Iterator<ContainedObject> it = columns.iterator();
            ArrayList<Column> mandatoryDependantColsList = new ArrayList<Column>();
            ArrayList<Column> dependantColsList = new ArrayList<Column>();
            while (it.hasNext()) {
                FKIndexAssociation colFk;
                Column col = (Column)it.next();
                if (col.getDependOnForeignKey() == null || !(colFk = col.getDependOnForeignKey()).getObjectID().equals(fk.getObjectID())) continue;
                if (col.isDependOnFK_AsMandatory()) {
                    mandatoryDependantColsList.add(col);
                }
                dependantColsList.add(col);
            }
            boolean first = true;
            if (dependantColsList.size() > 0) {
                for (Column column : Arrays.asList(fkcols)) {
                    if (first) {
                        first = false;
                        text1 = text1 + column.getName() + " IS NULL ";
                        continue;
                    }
                    text1 = text1 + "AND " + column.getName() + " IS NULL ";
                }
                for (Column column : dependantColsList) {
                    text1 = text1 + "AND " + column.getName() + " IS NULL ";
                }
            }
            if (text1.length() <= 0) continue;
            String text2 = "";
            if (mandatoryDependantColsList.size() > 0) {
                for (Column column : Arrays.asList(fkcols)) {
                    if (column.isMandatory()) continue;
                    text2 = text2 + column.getName() + " IS NOT NULL AND ";
                }
                for (Column col1 : mandatoryDependantColsList) {
                    text2 = text2 + col1.getName() + " IS NOT NULL AND ";
                }
                if (text2.length() > 0) {
                    text2 = text2.substring(0, text2.lastIndexOf(" AND"));
                }
            }
            StorageDesign storageDesign = tableProxy.getStorageDesign();
            String string = storageDesign.getFormatedLongNameDDL(tableProxy);
            StringBuffer buffer = new StringBuffer();
            SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
            SQLStatementBuilder.appendStringWithSpace(buffer, "ALTER");
            SQLStatementBuilder.appendStringWithSpace(buffer, "TABLE");
            SQLStatementBuilder.appendStringWithSpace(buffer, string);
            SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 1);
            SQLStatementBuilder.appendStringWithSpace(buffer, "ADD");
            String constraintName = fk.getColumnDependencyConstraintGenerateName();
            if (constraintName != null && constraintName.trim().length() > 0 && (!constraintName.startsWith("SYS_") || storageDesign.getDesign().getSettings().isIncludeSystemNames())) {
                SQLStatementBuilder.appendStringWithSpace(buffer, "CONSTRAINT");
                constraintName = storageDesign.getFormatedName(constraintName);
                SQLStatementBuilder.appendStringWithSpace(buffer, constraintName);
                SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 1);
            }
            SQLStatementBuilder.appendStringWithSpace(buffer, "CHECK");
            SQLStatementBuilder.appendStringWithSpace(buffer, '(');
            if (!"".equals(text2)) {
                SQLStatementBuilder.appendStringWithSpace(buffer, '(');
            }
            SQLStatementBuilder.appendString(buffer, text1.trim());
            if (!"".equals(text2)) {
                SQLStatementBuilder.appendStringWithSpace(buffer, ')');
                SQLStatementBuilder.appendStringWithSpace(buffer, "OR");
                SQLStatementBuilder.appendStringWithSpace(buffer, '(');
                SQLStatementBuilder.appendString(buffer, text2.trim());
                SQLStatementBuilder.appendStringWithSpace(buffer, ')');
            }
            SQLStatementBuilder.appendStringWithSpace(buffer, ')');
            String advancedComments = "Alter Table " + string + " Add Check Constraint " + constraintName;
            sbuilder.appendToBuffer(oldbuffer, buffer, advancedComments);
            SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(terminaton_str);
            SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
            sbuilder.appendToBuffer(oldbuffer, buffer, "");
            this.incrementAlterTable();
        }
    }

    public void appendExistenceDependencySingle(StringBuffer oldbuffer, TableProxy tableProxy, Column discrCol, List<Column.DependentColumnDescriptor> list, String cname, boolean prettyPrint, SQLStatementBuilder sbuilder, String terminaton_str, int constr_length) {
        StringBuffer buffer = new StringBuffer();
        StorageDesign storageDesign = tableProxy.getStorageDesign();
        List<Column> cols = discrCol.getDependentColumnList();
        ModelIDObject discrColObject = storageDesign.getStorageObject(discrCol.getObjectID());
        if (discrColObject == null) {
            discrColObject = discrCol;
        }
        String dcolname = storageDesign.getFormatedName(discrColObject);
        String text = "";
        boolean first = true;
        for (String value : discrCol.getValues()) {
            if (!first) {
                text = text + "\n OR (";
            } else {
                first = false;
                text = text + "(";
            }
            text = text + dcolname + " = " + discrCol.formatDiscriminatorValue(value);
            Map map = discrCol.getDependentColumnDescriptorsMap(value);
            boolean cfirst = false;
            for (Column col : cols) {
                if (col.isMandatory()) continue;
                ModelIDObject colObject = storageDesign.getStorageObject(col.getObjectID());
                if (colObject == null) {
                    colObject = col;
                }
                String colname = storageDesign.getFormatedName(colObject);
                Column.DependentColumnDescriptor desc = (Column.DependentColumnDescriptor)map.get(col.getObjectID());
                if (desc == null) {
                    if (!cfirst) {
                        text = text + " AND";
                    } else {
                        cfirst = false;
                    }
                    text = text + " " + colname + " IS NULL";
                    continue;
                }
                if (!desc.isDependAsMandatory()) continue;
                if (!cfirst) {
                    text = text + " AND";
                } else {
                    cfirst = false;
                }
                text = text + " " + colname + " IS NOT NULL";
            }
            text = text + ")";
        }
        String formattedLongName = storageDesign.getFormatedLongNameDDL(tableProxy);
        SQLStatementBuilder.appendNewLine(oldbuffer, prettyPrint, 0);
        SQLStatementBuilder.appendNewLine(oldbuffer, prettyPrint, 0);
        SQLStatementBuilder.appendStringWithSpace(buffer, "ALTER");
        SQLStatementBuilder.appendStringWithSpace(buffer, "TABLE");
        SQLStatementBuilder.appendStringWithSpace(buffer, formattedLongName);
        SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 1);
        SQLStatementBuilder.appendStringWithSpace(buffer, "ADD");
        if (!(cname.equals("") || cname.toUpperCase(Locale.ROOT).startsWith("SYS_") && !storageDesign.getDesign().getSettings().isIncludeSystemNames() || cname.length() > constr_length)) {
            cname = storageDesign.getFormatedName(cname);
            SQLStatementBuilder.appendStringWithSpace(buffer, "CONSTRAINT");
            SQLStatementBuilder.appendStringWithSpace(buffer, cname);
        }
        SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 1);
        SQLStatementBuilder.appendStringWithSpace(buffer, "CHECK");
        SQLStatementBuilder.appendStringWithSpace(buffer, '(');
        SQLStatementBuilder.appendString(buffer, text);
        SQLStatementBuilder.appendStringWithSpace(buffer, ')');
        String advancedComments = "Alter Table " + formattedLongName + " Add Check Constraint " + cname;
        sbuilder.appendToBuffer(oldbuffer, buffer, advancedComments);
        SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
        buffer.append(terminaton_str);
        SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
        sbuilder.appendToBuffer(oldbuffer, buffer, "");
        this.incrementAlterTable();
    }

    public void appendExistenceDependencyValue(StringBuffer oldbuffer, TableProxy tableProxy, Column discrCol, List<Column.DependentColumnDescriptor> list, String base_cname, boolean prettyPrint, SQLStatementBuilder sbuilder, String terminaton_str, int constr_length) {
        StringBuffer buffer = new StringBuffer();
        StorageDesign storageDesign = tableProxy.getStorageDesign();
        int ind = 0;
        List<Column> cols = discrCol.getDependentColumnList();
        ModelIDObject discrColObject = storageDesign.getStorageObject(discrCol.getObjectID());
        if (discrColObject == null) {
            discrColObject = discrCol;
        }
        String dcolname = storageDesign.getFormatedName(discrColObject);
        Iterator it = discrCol.getValues().iterator();
        while (it.hasNext()) {
            String text = "";
            String cname = base_cname + ++ind;
            String value = (String)it.next();
            text = text + dcolname + " != " + discrCol.formatDiscriminatorValue(value);
            text = text + "\n OR (";
            Map map = discrCol.getDependentColumnDescriptorsMap(value);
            boolean cfirst = true;
            for (Column col : cols) {
                if (col.isMandatory()) continue;
                ModelIDObject colObject = storageDesign.getStorageObject(col.getObjectID());
                if (colObject == null) {
                    colObject = col;
                }
                String colname = storageDesign.getFormatedName(colObject);
                Column.DependentColumnDescriptor desc = (Column.DependentColumnDescriptor)map.get(col.getObjectID());
                if (desc == null) {
                    if (!cfirst) {
                        text = text + " AND";
                    } else {
                        cfirst = false;
                    }
                    text = text + " " + colname + " IS NULL";
                    continue;
                }
                if (!desc.isDependAsMandatory()) continue;
                if (!cfirst) {
                    text = text + " AND";
                } else {
                    cfirst = false;
                }
                text = text + " " + colname + " IS NOT NULL";
            }
            text = text + ")";
            String formattedLongName = storageDesign.getFormatedLongNameDDL(tableProxy);
            SQLStatementBuilder.appendNewLine(oldbuffer, prettyPrint, 0);
            SQLStatementBuilder.appendNewLine(oldbuffer, prettyPrint, 0);
            SQLStatementBuilder.appendStringWithSpace(buffer, "ALTER");
            SQLStatementBuilder.appendStringWithSpace(buffer, "TABLE");
            SQLStatementBuilder.appendStringWithSpace(buffer, formattedLongName);
            SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 1);
            SQLStatementBuilder.appendStringWithSpace(buffer, "ADD");
            if (!(cname.equals("") || cname.toUpperCase(Locale.ROOT).startsWith("SYS_") && !storageDesign.getDesign().getSettings().isIncludeSystemNames() || cname.length() > constr_length)) {
                cname = storageDesign.getFormatedName(cname);
                SQLStatementBuilder.appendStringWithSpace(buffer, "CONSTRAINT");
                SQLStatementBuilder.appendStringWithSpace(buffer, cname);
            }
            SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 1);
            SQLStatementBuilder.appendStringWithSpace(buffer, "CHECK");
            SQLStatementBuilder.appendStringWithSpace(buffer, '(');
            SQLStatementBuilder.appendString(buffer, text);
            SQLStatementBuilder.appendStringWithSpace(buffer, ')');
            String advancedComments = "Alter Table " + formattedLongName + " Add Check Constraint " + cname;
            sbuilder.appendToBuffer(oldbuffer, buffer, advancedComments);
            SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(terminaton_str);
            SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
            sbuilder.appendToBuffer(oldbuffer, buffer, "");
            this.incrementAlterTable();
        }
    }

    private static void appendExistenceDependencyColumn(StringBuffer oldbuffer, TableProxy tableProxy, Column discrCol, List<Column.DependentColumnDescriptor> list, String base_cname, boolean prettyPrint, SQLStatementBuilder sbuilder, String terminaton_str, int constr_length, DDLGenerationStatus status) {
        StringBuffer buffer = new StringBuffer();
        StorageDesign storageDesign = tableProxy.getStorageDesign();
        int ind = 0;
        List<Column> cols = discrCol.getDependentColumnList();
        ModelIDObject discrColObject = storageDesign.getStorageObject(discrCol.getObjectID());
        if (discrColObject == null) {
            discrColObject = discrCol;
        }
        String dcolname = storageDesign.getFormatedName(discrColObject);
        for (String value : discrCol.getValues()) {
            Map map = discrCol.getDependentColumnDescriptorsMap(value);
            for (Column col : cols) {
                Column.DependentColumnDescriptor desc;
                if (col.isMandatory() || (desc = (Column.DependentColumnDescriptor)map.get(col.getObjectID())) != null && !desc.isDependAsMandatory()) continue;
                String text = "";
                String cname = base_cname + ++ind;
                text = text + dcolname + " != " + discrCol.formatDiscriminatorValue(value) + " OR ";
                ModelIDObject colObject = storageDesign.getStorageObject(col.getObjectID());
                if (colObject == null) {
                    colObject = col;
                }
                String colname = storageDesign.getFormatedName(colObject);
                if (desc == null) {
                    text = text + " " + colname + " IS NULL ";
                } else if (desc.isDependAsMandatory()) {
                    text = text + " " + colname + " IS NOT NULL ";
                }
                String formattedLongName = storageDesign.getFormatedLongNameDDL(tableProxy);
                SQLStatementBuilder.appendNewLine(oldbuffer, prettyPrint, 0);
                SQLStatementBuilder.appendNewLine(oldbuffer, prettyPrint, 0);
                SQLStatementBuilder.appendStringWithSpace(buffer, "ALTER");
                SQLStatementBuilder.appendStringWithSpace(buffer, "TABLE");
                SQLStatementBuilder.appendStringWithSpace(buffer, formattedLongName);
                SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 1);
                SQLStatementBuilder.appendStringWithSpace(buffer, "ADD");
                if (!(cname.equals("") || cname.toUpperCase(Locale.ROOT).startsWith("SYS_") && !storageDesign.getDesign().getSettings().isIncludeSystemNames() || cname.length() > constr_length)) {
                    cname = storageDesign.getFormatedName(cname);
                    SQLStatementBuilder.appendStringWithSpace(buffer, "CONSTRAINT");
                    SQLStatementBuilder.appendStringWithSpace(buffer, cname);
                }
                SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 1);
                SQLStatementBuilder.appendStringWithSpace(buffer, "CHECK");
                SQLStatementBuilder.appendStringWithSpace(buffer, '(');
                SQLStatementBuilder.appendString(buffer, text);
                SQLStatementBuilder.appendStringWithSpace(buffer, ')');
                String advancedComments = "Alter Table " + formattedLongName + " Add Check Constraint " + cname;
                sbuilder.appendToBuffer(oldbuffer, buffer, advancedComments);
                SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(terminaton_str);
                SQLStatementBuilder.appendNewLine(buffer, prettyPrint, 0);
                sbuilder.appendToBuffer(oldbuffer, buffer, "");
                if (status == null) continue;
                status.incrementAlterTable();
            }
        }
    }

    protected String getColumnList(TableView view) {
        return this.getColumnList(view, false);
    }

    protected String getColumnList(TableView view, boolean force) {
        String result = "";
        if (!view.isBST()) {
            ContainedObject[] elements = view.getElements();
            if (force || view.hasValidHeader()) {
                StorageDesign storageDesign = this.getStorageDesign(view);
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < elements.length; ++i) {
                    String headerAlias = ((AbstractViewElement)elements[i]).getPresentationName(true);
                    buffer.append(i == 0 ? (char)'(' : ',');
                    buffer.append(' ');
                    buffer.append(storageDesign.getFormatedName(headerAlias));
                }
                if (buffer.length() > 0) {
                    buffer.append(' ');
                    buffer.append(')');
                    result = buffer.toString();
                }
            }
        }
        return result;
    }

    public String appendConstraints(TableProxy tableProxy) {
        return null;
    }

    public String appendConstraints(TableViewProxy tableProxy) {
        return null;
    }

    protected void incrementErrors() {
        this.getStatus().incrementErrors();
    }

    protected void incrementWarnings() {
        this.getStatus().incrementWarnings();
    }

    protected void incrementCreateDatabase() {
        this.getStatus().incrementCreateDatabase();
    }

    protected void incrementCreateTable() {
        this.getStatus().incrementCreateTable();
    }

    protected void incrementCreateIndex() {
        this.getStatus().incrementCreateIndex();
    }

    protected void incrementCreateTablespace() {
        this.getStatus().incrementCreateTablespace();
    }

    protected void incrementCreateView() {
        this.getStatus().incrementCreateView();
    }

    protected void incrementAlterTable() {
        this.getStatus().incrementAlterTable();
    }

    protected void incrementAlterView() {
        this.getStatus().incrementAlterView();
    }

    protected void incrementCreateTrigger() {
        this.getStatus().incrementCreateTrigger();
    }

    protected void incrementORDSDropSchema() {
        this.getStatus().incrementORDSDropSchema();
    }

    protected void incrementORDSEnableSchema() {
        this.getStatus().incrementORDSEnableSchema();
    }

    protected void incrementORDSEnableObject() {
        this.getStatus().incrementORDSEnableObject();
    }

    protected void incrementAlterTrigger() {
        this.getStatus().incrementAlterTrigger();
    }

    protected void incrementCreatePackage() {
        this.getStatus().incrementCreatePackage();
    }

    protected void incrementCreateProc() {
        this.getStatus().incrementCreateProc();
    }

    protected void incrementCreateFunction() {
        this.getStatus().incrementCreateFunction();
    }

    protected void incrementCreatePackageBody() {
        this.getStatus().incrementCreatePackageBody();
    }

    protected void incrementCreateStructuredType() {
        this.getStatus().incrementCreateStructuredType();
    }

    protected void incrementCreateStructuredTypeBody() {
        this.getStatus().incrementCreateStructuredTypeBody();
    }

    protected void incrementCreateCollectionType() {
        this.getStatus().incrementCreateCollectionType();
    }

    protected void incrementCreateSynomym() {
        this.getStatus().incrementCreateSynomym();
    }

    protected void incrementCreateCluster() {
        this.getStatus().incrementCreateCluster();
    }

    protected void incrementCreateContext() {
        this.getStatus().incrementCreateContext();
    }

    protected void incrementCreateDimension() {
        this.getStatus().incrementCreateDimension();
    }

    protected void incrementCreateDirectory() {
        this.getStatus().incrementCreateDirectory();
    }

    protected void incrementCreateRole() {
        this.getStatus().incrementCreateRole();
    }

    protected void incrementCreateRollbackSegment() {
        this.getStatus().incrementCreateRollbackSegment();
    }

    protected void incrementCreateSequence() {
        this.getStatus().incrementCreateSequence();
    }

    protected void incrementCreateSnapshot() {
        this.getStatus().incrementCreateSnapshot();
    }

    protected void incrementCreateDiskgroup() {
        this.getStatus().incrementCreateDiskgroup();
    }

    protected void incrementCreateUser() {
        this.getStatus().incrementCreateUser();
    }

    protected void incrementRedactionPolicies() {
        this.getStatus().incrementRedactionPolicies();
    }

    protected void incrementTSDPPolicies() {
        this.getStatus().incrementTSDPPolicies();
    }

    protected void incrementDropTriggers() {
        this.getStatus().incrementDropTrigger();
    }

    protected void incrementDropProcedures() {
        this.getStatus().incrementDropProcedure();
    }

    protected void incrementDropSynonym() {
        this.getStatus().incrementDropSynonym();
    }

    protected void incrementDropSequence() {
        this.getStatus().incrementDropSequence();
    }

    protected void incrementDropTablespace() {
        this.getStatus().incrementDropTablespace();
    }

    public DDLAdvancedGenerator getddlAdvancedGenenerator() {
        return this.getStatus().getddlAdvancedGenenerator();
    }

    public int getAdvancedStep() {
        return this.getStatus().advancedStep;
    }

    protected void incrementAdvancedStep() {
        this.getStatus().incrementAdvancedStep();
    }

    public boolean isIncludeComments() {
        return DDLGenerationOptions.isIncludeComments();
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    public DDLGenerationStatus getStatus() {
        this.status = this.getDDLGenerator() != null ? this.getDDLGenerator().getStatus() : new DDLGenerationStatus();
        return this.status;
    }
}

