/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableViewProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBViewOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableView || object instanceof TableViewProxyOraclev10g;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        boolean generateView;
        StringBuffer buffer = new StringBuffer();
        TableView view = null;
        TableViewProxyOraclev10g proxy = null;
        boolean createOnly = false;
        if (object instanceof TableView) {
            RDBMSSite site;
            view = (TableView)object;
            createOnly = view.isCreateOnly();
            RelationalDesign rd = (RelationalDesign)view.getDesignPart();
            if (rd.getStorageDesign(site = rd.getSelectedRDBMSSite()) instanceof StorageDesignOraclev10g) {
                this.storageDesign = rd.getStorageDesign(site);
                proxy = (TableViewProxyOraclev10g)this.storageDesign.getProxy(view);
            }
            generateView = view.isMarkedGenerate();
        } else {
            proxy = (TableViewProxyOraclev10g)object;
            view = (TableView)proxy.getObject();
            createOnly = view.isCreateOnly();
            this.storageDesign = proxy.getStorageDesign();
            generateView = proxy.isMarkedGenerate();
        }
        if (!view.isValidSQL()) {
            SSBViewOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Invalid View " + view.getName());
            this.incrementErrors();
            SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            return;
        }
        if (proxy != null) {
            String stmt = view.isBST() ? view.getUserDefinedSQL() : proxy.getDefinition();
            if ((stmt = stmt.trim()).endsWith(";")) {
                stmt = stmt.substring(0, stmt.length() - 1).trim();
            }
            if (!"".equalsIgnoreCase(stmt)) {
                if (generateView) {
                    int index;
                    if (proxy.isCommentChanged()) {
                        this.appendComment(oldbuffer, proxy);
                    } else {
                        this.appendComment(oldbuffer, view);
                    }
                    String createViewPart = "";
                    boolean includesColumnList = false;
                    if (Token.getFirstToken(stmt).equalsIgnoreCase("CREATE") && (index = StringUtilities.indexOf(stmt, "VIEW")) > -1) {
                        int viewNameIndex;
                        int dotIndex;
                        createViewPart = stmt.substring(0, index + 4);
                        String stmtWithoutNL = (stmt = stmt.substring(index + 4).trim()).replaceAll("[\t\n\f\r\u000b]+", " ");
                        String oldViewName = Token.getFirstName(stmtWithoutNL, '\"', '\"');
                        int bracketIndex = oldViewName.indexOf(40);
                        if (bracketIndex > -1) {
                            oldViewName = oldViewName.substring(0, bracketIndex);
                        }
                        if ((dotIndex = oldViewName.indexOf(46)) > -1) {
                            oldViewName = oldViewName.substring(dotIndex + 1);
                        }
                        if ((viewNameIndex = stmt.indexOf(oldViewName, dotIndex)) > -1 && (stmt = stmt.substring(viewNameIndex + oldViewName.length())).startsWith("\"")) {
                            stmt = stmt.substring(1);
                        }
                        if ((stmt = stmt.trim()).toUpperCase(Locale.ROOT).startsWith("AS")) {
                            stmt = stmt.substring(2).trim();
                        } else if (stmt.startsWith("(")) {
                            includesColumnList = true;
                        }
                    }
                    String beforeView = "YES".equalsIgnoreCase(proxy.getForce()) ? (createOnly ? "CREATE FORCE" : "CREATE OR REPLACE FORCE") : (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL() ? (createOnly ? "CREATE NOFORCE" : "CREATE OR REPLACE NOFORCE") : (createOnly ? "CREATE" : "CREATE OR REPLACE"));
                    if ("YES".equalsIgnoreCase(proxy.getEditioning()) && this.storageDesign instanceof StorageDesignOraclev11g) {
                        beforeView = beforeView + " EDITIONING";
                    }
                    if (!Token.startsWithString(createViewPart, beforeView)) {
                        createViewPart = beforeView + " VIEW";
                    }
                    ModelIDObject viewObject = this.storageDesign.isOpen() ? proxy : view;
                    createViewPart = createViewPart + ' ' + this.storageDesign.getFormatedLongNameDDL(viewObject);
                    if (view.isBST()) {
                        if (stmt.toUpperCase(Locale.ROOT).startsWith("OF")) {
                            createViewPart = createViewPart + NEWLINE + ' ' + stmt;
                            stmt = "";
                        } else {
                            createViewPart = createViewPart + this.appendStructuredType(view, proxy);
                        }
                    }
                    if (stmt.equals("")) {
                        stmt = createViewPart;
                    } else if (includesColumnList) {
                        stmt = createViewPart + ' ' + stmt;
                    } else {
                        String columnList = this.getColumnList(view);
                        stmt = createViewPart + ' ' + columnList + ' ' + "AS" + NEWLINE + stmt;
                    }
                    this.appendBeforeCreateScript(oldbuffer, prettyPrint, view);
                    this.appendPrompt(buffer, proxy, "VIEW");
                    SSBViewOraclev10g.appendStringWithSpace(buffer, stmt);
                    this.appendWith(buffer, proxy);
                    this.appendToBuffer(oldbuffer, buffer, createViewPart);
                    SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBViewOraclev10g.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, createViewPart);
                    SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.incrementCreateView();
                    this.appendAfterCreateScript(oldbuffer, prettyPrint, view);
                    if (view.getDesign().getSettings().isGenerateCommentsInRDBMS()) {
                        this.appendViewCommentOn(this.storageDesign, oldbuffer, view, proxy, prettyPrint);
                    }
                    this.appendPermissions(oldbuffer, proxy, prettyPrint);
                }
            } else {
                SSBViewOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Invalid View " + view.getName() + " with empty body");
                this.incrementErrors();
            }
            SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        }
    }

    private String appendStructuredType(TableView view, TableViewProxyOraclev10g viewProxy) {
        StringBuffer forInsert = new StringBuffer();
        SSBViewOraclev10g.appendStringWithSpace(forInsert, NEWLINE);
        SSBViewOraclev10g.appendStringWithSpace(forInsert, "OF");
        StructuredType structuredType = view.getBasedOnStructuredType();
        if (structuredType != null) {
            StructuredTypeProxy stp = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getProxy(structuredType.getObjectID());
            SSBViewOraclev10g.appendStringWithSpace(forInsert, this.storageDesign.getFormatedLongNameDDL(stp));
        } else {
            String structTypeName = view.getBasedOnStructuredTypeLongName();
            if (!view.getDesign().getSettings().isIncludeSchemaInDDL()) {
                structTypeName = structTypeName.substring(structTypeName.indexOf(46) + 1);
            }
            SSBViewOraclev10g.appendStringWithSpace(forInsert, this.storageDesign.getFormatedName(structTypeName));
        }
        TableViewProxy superView = viewProxy.getSuperView();
        if (superView != null) {
            SSBViewOraclev10g.appendStringWithSpace(forInsert, "UNDER");
            SSBViewOraclev10g.appendStringWithSpace(forInsert, this.storageDesign.getFormatedLongNameDDL(superView));
        } else {
            String schemaElement = viewProxy.getXmlSchemaElement();
            if (!"".equalsIgnoreCase(schemaElement)) {
                String schemaUrl = viewProxy.getXmlSchemaUrl();
                if (!"".equalsIgnoreCase(schemaUrl)) {
                    SSBViewOraclev10g.appendStringWithSpace(forInsert, "XMLSCHEMA");
                    forInsert.append('\"').append(schemaUrl).append('\"').append(' ');
                }
                SSBViewOraclev10g.appendStringWithSpace(forInsert, "ELEMENT");
                forInsert.append('\"').append(schemaElement).append('\"').append(' ');
            }
            SSBViewOraclev10g.appendStringWithSpace(forInsert, "WITH");
            SSBViewOraclev10g.appendStringWithSpace(forInsert, "OBJECT");
            SSBViewOraclev10g.appendStringWithSpace(forInsert, "IDENTIFIER");
            String oidAttributes = viewProxy.getOidAttributes();
            if (oidAttributes == null || oidAttributes.isEmpty()) {
                SSBViewOraclev10g.appendStringWithSpace(forInsert, "DEFAULT");
            } else {
                SSBViewOraclev10g.appendStringWithSpace(forInsert, '(');
                this.appendOidAttributes(forInsert, oidAttributes);
                SSBViewOraclev10g.appendStringWithSpace(forInsert, ')');
            }
        }
        return forInsert.toString();
    }

    private void appendOidAttributes(StringBuffer buff, String attrs) {
        StringTokenizer tokenizer = new StringTokenizer(attrs, ",");
        String attr = null;
        int attrNum = 0;
        while (tokenizer.hasMoreTokens()) {
            attr = tokenizer.nextToken().trim();
            StringBuffer attrBuff = new StringBuffer(attr);
            while (tokenizer.hasMoreTokens() && Token.tokenNumber(attr, "(") > Token.tokenNumber(attr, ")")) {
                attrBuff.append(",").append(tokenizer.nextToken());
                attr = attrBuff.toString();
            }
            if (attrNum > 0) {
                SSBViewOraclev10g.appendStringWithSpace(buff, ',');
            }
            if (Token.hasCloseAndOpenBrackets(attr)) {
                SSBViewOraclev10g.appendStringWithSpace(buff, attr);
            } else {
                SSBViewOraclev10g.appendStringWithSpace(buff, this.storageDesign.getFormatedName(attr));
            }
            ++attrNum;
        }
    }

    private void appendWith(StringBuffer buffer, TableViewProxyOracle viewProxy) {
        if ("YES".equalsIgnoreCase(viewProxy.getReadOnly())) {
            if (buffer.indexOf("WITH READ ONLY") == -1) {
                buffer.append(NEWLINE).append("    ");
                buffer.append("WITH READ ONLY");
            }
        } else if (viewProxy.getCheckOption() && viewProxy.getDefinition() != null && viewProxy.getDefinition().trim().length() != 0) {
            int withCheckOptionIndex = buffer.lastIndexOf("WITH CHECK OPTION");
            if (withCheckOptionIndex == -1) {
                buffer.append(NEWLINE).append("    ");
                SSBViewOraclev10g.appendStringWithSpace(buffer, "WITH CHECK OPTION");
            }
            if (!"".equalsIgnoreCase(viewProxy.getCheckOptionName())) {
                int constraintIndex = buffer.lastIndexOf("CONSTRAINT ");
                if (constraintIndex > withCheckOptionIndex && withCheckOptionIndex > -1) {
                    buffer.delete(constraintIndex, buffer.length());
                }
                buffer.append("CONSTRAINT ").append(viewProxy.getCheckOptionName());
            }
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, TableViewProxyOracle viewProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)this.storageDesign).getPermissionsSet();
        for (PermissionsOraclev10g permissions : permissionsSet) {
            if (permissions.getView() != null && permissions.getView().equals(viewProxy) && !permissions.getPrivileges().equalsIgnoreCase("")) {
                SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, permissions);
                SSBViewOraclev10g.appendStringWithSpace(buffer, "GRANT");
                SSBViewOraclev10g.appendStringWithSpace(buffer, permissions.getPrivileges());
                this.appendObject(buffer, permissions);
                this.appendTo(buffer, permissions, this.storageDesign);
                advancedComment = buffer.toString();
                this.appendHierrarchyOption(buffer, permissions);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if (permissions.getView() != null && permissions.getView().equals(viewProxy) && !permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendComment(buffer, permissions);
                SSBViewOraclev10g.appendStringWithSpace(buffer, "GRANT");
                SSBViewOraclev10g.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
                this.appendObject(buffer, permissions);
                this.appendTo(buffer, permissions, this.storageDesign);
                advancedComment = buffer.toString();
                this.appendHierrarchyOption(buffer, permissions);
                this.appendGrantOption(buffer, permissions);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if (permissions.getView() == null || !permissions.getView().equals(viewProxy) || permissions.getPrivilegesWithHierarchyOption().equalsIgnoreCase("")) continue;
            SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, permissions);
            SSBViewOraclev10g.appendStringWithSpace(buffer, "GRANT");
            SSBViewOraclev10g.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
            this.appendObject(buffer, permissions);
            this.appendTo(buffer, permissions, this.storageDesign);
            advancedComment = buffer.toString();
            buffer.append(NEWLINE);
            SSBViewOraclev10g.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if (permissions.getView() != null) {
            buffer.append(NEWLINE);
            SSBViewOraclev10g.appendStringWithSpace(buffer, "ON");
            SSBViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(permissions.getView()));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if (permissions.getRole() == null) {
            buffer.append(NEWLINE);
            SSBViewOraclev10g.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            buffer.append(NEWLINE);
            SSBViewOraclev10g.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    private void appendPKDefinition(StringBuffer oldbuffer, TableView view, TableViewProxy viewProxy, boolean prettyPrint) {
        String columns;
        KeyObject pk = view.getPK();
        if (pk != null && pk.isMarkedGenerate() && !"".equalsIgnoreCase(columns = pk.getColumnsAsString(this.storageDesign))) {
            if (!"".equalsIgnoreCase(pk.getComment())) {
                this.appendComment(oldbuffer, pk);
            }
            int maxConstraintNameLength = ((TableViewProxyOracle)viewProxy).getMaxConstraintNameLength();
            String pkName = pk.getName();
            if (pkName.length() > maxConstraintNameLength) {
                SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBViewOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + maxConstraintNameLength + ")");
                SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.incrementErrors();
            }
            StringBuffer buffer = new StringBuffer();
            this.appendPrompt(buffer, view, "PRIMARY KEY ON");
            SSBViewOraclev10g.appendStringWithSpace(buffer, "ALTER");
            SSBViewOraclev10g.appendStringWithSpace(buffer, "VIEW");
            SSBViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(viewProxy));
            SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBViewOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!pkName.startsWith("SYS_") || this.storageDesign.getDesign().getSettings().isIncludeSystemNames()) {
                SSBViewOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
            }
            String advancedComment = buffer.toString();
            SSBViewOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            SSBViewOraclev10g.appendStringWithSpace(buffer, '(');
            SSBViewOraclev10g.appendStringWithSpace(buffer, columns);
            SSBViewOraclev10g.appendStringWithSpace(buffer, ')');
            SSBViewOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBViewOraclev10g.appendLineFinisher(buffer, prettyPrint);
            SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.incrementAlterView();
        }
    }

    private void appendUniqueDefinition(StringBuffer oldbuffer, TableView view, TableViewProxy viewProxy, boolean prettyPrint) {
        List list = view.getUniqueKeysList();
        for (KeyObject unique : list) {
            if (!unique.isMarkedGenerate()) continue;
            SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            if (!"".equalsIgnoreCase(unique.getComment())) {
                this.appendComment(oldbuffer, unique);
            }
            int maxConstraintNameLength = ((TableViewProxyOracle)viewProxy).getMaxConstraintNameLength();
            String uniqueName = unique.getName();
            if (uniqueName.length() > maxConstraintNameLength) {
                SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBViewOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + maxConstraintNameLength + ")");
                SSBViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.incrementErrors();
            }
            StringBuffer buffer = new StringBuffer();
            this.appendPrompt(buffer, view, "UNIQUE KEY ON");
            SSBViewOraclev10g.appendStringWithSpace(buffer, "ALTER");
            SSBViewOraclev10g.appendStringWithSpace(buffer, "VIEW");
            SSBViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(viewProxy));
            SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBViewOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!uniqueName.startsWith("SYS_") || this.storageDesign.getDesign().getSettings().isIncludeSystemNames()) {
                SSBViewOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
            }
            String advancedComment = buffer.toString();
            SSBViewOraclev10g.appendStringWithSpace(buffer, "UNIQUE");
            SSBViewOraclev10g.appendStringWithSpace(buffer, '(');
            SSBViewOraclev10g.appendStringWithSpace(buffer, unique.getColumnsAsString(this.storageDesign));
            SSBViewOraclev10g.appendStringWithSpace(buffer, ')');
            SSBViewOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBViewOraclev10g.appendLineFinisher(buffer, prettyPrint);
            SSBViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.incrementAlterView();
        }
    }

    @Override
    public String appendConstraints(TableViewProxy viewProxy) {
        StringBuffer sb = new StringBuffer();
        if (viewProxy instanceof TableViewProxyOraclev10g) {
            TableView view = (TableView)viewProxy.getObject();
            this.storageDesign = viewProxy.getStorageDesign();
            this.appendPKDefinition(sb, view, viewProxy, true);
            this.appendUniqueDefinition(sb, view, viewProxy, true);
        }
        return sb.toString();
    }
}

