/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHClusterOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHCollectionTypeOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDBLinksOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDatafileOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDimensionOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDirectoryOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHFunctionOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHMViewLog;
import oracle.dbtools.crest.imports.metadata.oracle.MOHObjectColumnsOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPackageOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHProcedureOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSensitiveTypeOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSequenceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSynonymOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTSDPPolicyOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableSpaceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTempTableSpaceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHUserOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHViewOracle;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHBitmapIndexesv10g;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHUndoTableSpaceOraclev10g;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHContextOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHExternalTableOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHRoleOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTableOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeIncompleteOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHUndoTableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.StorageDesignOraclev20c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.util.Closeables;

public class DBMExtractionHandlerOracle
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private List mohObjectsv9i = null;
    private List mohObjectsv10g = null;
    public boolean dbaUser = false;
    private MOHDirectoryOracle directoryHandler;
    private MOHTableOracle tableHandler;
    private MOHTableSpaceOracle tableSpaceHandlerOracle;
    private MOHTypeIncompleteOraclev9i mohTypeIncompleteOraclev9i;

    public DBMExtractionHandlerOracle(Design design) {
        super(design);
    }

    @Override
    public void init(Connection connection) {
        super.init(connection);
        this.setDBAUser(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDBAUser(Connection conn) {
        block7: {
            if (conn != null) {
                PreparedStatement statement = null;
                ResultSet rs = null;
                try {
                    try {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ').append("COUNT").append('(').append('*').append(')');
                        buffer.append(' ').append("FROM").append(' ').append("dba_users");
                        statement = conn.prepareStatement(buffer.toString());
                        rs = statement.executeQuery();
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ').append("COUNT").append('(').append('*').append(')');
                        buffer.append(' ').append("FROM").append(' ').append("dba_all_tables");
                        statement = conn.prepareStatement(buffer.toString());
                        rs = statement.executeQuery();
                        this.dbaUser = true;
                    }
                    catch (SQLException se) {
                        try {
                            this.dbaUser = false;
                        }
                        catch (Throwable throwable) {
                            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                            throw throwable;
                        }
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        break block7;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                }
                catch (Exception ex) {
                    this.dbaUser = false;
                }
            }
        }
    }

    @Override
    public List getSchemas(Connection conn) throws Exception {
        List list = super.getSchemas(conn);
        this.setDBAUser(conn);
        return list;
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return this.getMOHObjectsv9i();
            }
        }
        return this.getMOHObjectsv10g();
    }

    private List getMOHObjectsv9i() {
        if (this.mohObjectsv9i == null) {
            this.mohObjectsv9i = new ArrayList();
            this.tableSpaceHandlerOracle = new MOHTableSpaceOracle(this, this.dbaUser);
            this.mohObjectsv9i.add(this.tableSpaceHandlerOracle);
            this.mohObjectsv9i.add(new MOHTempTableSpaceOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHUndoTableSpaceOraclev9i(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHDatafileOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHRoleOraclev9i(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHUserOracle(this, this.dbaUser));
            this.mohTypeIncompleteOraclev9i = new MOHTypeIncompleteOraclev9i(this, this.dbaUser);
            this.mohObjectsv9i.add(this.mohTypeIncompleteOraclev9i);
            this.mohObjectsv9i.add(new MOHTypeOraclev9i(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHCollectionTypeOracle(this, this.dbaUser));
            this.directoryHandler = new MOHDirectoryOracle(this, this.dbaUser);
            this.mohObjectsv9i.add(this.directoryHandler);
            this.mohObjectsv9i.add(new MOHSequenceOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHContextOraclev9i(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHClusterOracle(this, this.dbaUser));
            MOHViewOracle viewHandler = new MOHViewOracle(this);
            this.tableHandler = new MOHTableOraclev9i(this, this.dbaUser);
            viewHandler.setTableHandlerOracle(this.tableHandler);
            this.tableHandler.setViewHandlerOracle(viewHandler);
            this.mohObjectsv9i.add(viewHandler);
            this.mohObjectsv9i.add(this.tableHandler);
            this.mohObjectsv10g.add(new MOHExternalTableOraclev9i(this, this.dbaUser));
            MOHBitmapIndexesv10g bitmapJoinIndexeHandler = new MOHBitmapIndexesv10g(this, this.dbaUser);
            this.tableHandler.setBitmapJoinIndexHandler(bitmapJoinIndexeHandler);
            this.mohObjectsv10g.add(bitmapJoinIndexeHandler);
            this.mohObjectsv9i.add(new MOHObjectColumnsOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHMViewLog(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHProcedureOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHDimensionOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHSynonymOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHDBLinksOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHPackageOracle(this, this.dbaUser));
            this.mohObjectsv9i.add(new MOHFunctionOracle(this, this.dbaUser));
        }
        return this.mohObjectsv9i;
    }

    private List getMOHObjectsv10g() {
        if (this.mohObjectsv10g == null) {
            this.mohObjectsv10g = new ArrayList();
            this.tableSpaceHandlerOracle = new MOHTableSpaceOracle(this, this.dbaUser);
            this.mohObjectsv10g.add(this.tableSpaceHandlerOracle);
            this.mohObjectsv10g.add(new MOHTempTableSpaceOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHUndoTableSpaceOraclev10g(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHDatafileOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHRoleOraclev9i(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHUserOracle(this, this.dbaUser));
            this.mohTypeIncompleteOraclev9i = new MOHTypeIncompleteOraclev9i(this, this.dbaUser);
            this.mohObjectsv10g.add(this.mohTypeIncompleteOraclev9i);
            this.mohObjectsv10g.add(new MOHTypeOraclev9i(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHCollectionTypeOracle(this, this.dbaUser));
            this.directoryHandler = new MOHDirectoryOracle(this, this.dbaUser);
            this.mohObjectsv10g.add(this.directoryHandler);
            this.mohObjectsv10g.add(new MOHSequenceOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHContextOraclev9i(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHClusterOracle(this, this.dbaUser));
            MOHViewOracle viewHandler = new MOHViewOracle(this);
            this.tableHandler = new MOHTableOraclev9i(this, this.dbaUser);
            viewHandler.setTableHandlerOracle(this.tableHandler);
            this.tableHandler.setViewHandlerOracle(viewHandler);
            this.mohObjectsv10g.add(viewHandler);
            this.mohObjectsv10g.add(this.tableHandler);
            this.mohObjectsv10g.add(new MOHExternalTableOraclev9i(this, this.dbaUser));
            MOHBitmapIndexesv10g bitmapJoinIndexeHandler = new MOHBitmapIndexesv10g(this, this.dbaUser);
            this.tableHandler.setBitmapJoinIndexHandler(bitmapJoinIndexeHandler);
            this.mohObjectsv10g.add(bitmapJoinIndexeHandler);
            this.mohObjectsv10g.add(new MOHObjectColumnsOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHMViewLog(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHProcedureOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHDimensionOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHSynonymOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHDBLinksOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHPackageOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHFunctionOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHSensitiveTypeOracle(this, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTSDPPolicyOracle(this, this.dbaUser));
        }
        return this.mohObjectsv10g;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        RDBMSSiteSet rdbmsSiteSet = this.getDesign().getRDBMSSiteSet();
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return rdbmsSiteSet.get(StorageDesignOraclev9i.RDBMS_TYPE);
            }
            case 10: {
                return rdbmsSiteSet.get(StorageDesignOraclev10g.RDBMS_TYPE);
            }
            case 11: {
                return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
            }
            case 20: 
            case 21: {
                return rdbmsSiteSet.get(StorageDesignOraclev20c.RDBMS_TYPE);
            }
            case 12: {
                if (this.dbMinorVersion < 2) {
                    return rdbmsSiteSet.get(StorageDesignOraclev12c.RDBMS_TYPE);
                }
                return rdbmsSiteSet.get(StorageDesignOraclev12cR2.RDBMS_TYPE);
            }
        }
        return rdbmsSiteSet.get(StorageDesignOraclev12cR2.RDBMS_TYPE);
    }

    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog) throws Exception {
        if (!this.isNullStorageDesign(this.getDesign().getRelationalDesign().getStorageDesign())) {
            super.generateDesign(conn, selectedObjects, importLog);
        }
    }

    public MOHDirectoryOracle getDirectoryHandler() {
        return this.directoryHandler;
    }

    @Override
    public MOHTableOracle getTableHandler() {
        return this.tableHandler;
    }

    public MOHTypeIncompleteOraclev9i getMOHTypeIncompleteOraclev9i() {
        return this.mohTypeIncompleteOraclev9i;
    }

    public List getMViews(Connection conn, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (conn != null) {
            this.getMOHObjects();
            MOHTableOracle moHandler = this.getTableHandler();
            List<DBObject> extracted = moHandler.getMViews(conn, schemas);
            for (DBObject obj : extracted) {
                if (!(obj instanceof DBObject)) continue;
                list.add(obj);
            }
        }
        return list;
    }

    public List getTables(Connection conn, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (conn != null) {
            this.getMOHObjects();
            MOHTableOracle moHandler = this.getTableHandler();
            List extracted = moHandler.getTables(conn, schemas);
            for (Object obj : extracted) {
                if (!(obj instanceof DBObject)) continue;
                list.add((DBObject)obj);
            }
        }
        return list;
    }

    public MOHTableSpaceOracle getTableSpaceHandlerOracle() {
        return this.tableSpaceHandlerOracle;
    }

    public List<DBObject> getTablespaces(Connection conn) throws Exception {
        List<DBObject> list = null;
        if (conn != null) {
            this.getMOHObjects();
            MOHTableSpaceOracle moHandler = this.getTableSpaceHandlerOracle();
            list = moHandler.getTablespaces(conn);
        }
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List<DBObject> getNonSchemaObjects(Connection conn, String type) throws Exception {
        List<DBObject> list = null;
        if (conn != null) {
            this.getMOHObjects();
            if ("TABLESPACE".equalsIgnoreCase(type)) {
                MOHTableSpaceOracle moHandler = this.getTableSpaceHandlerOracle();
                list = moHandler.getTablespaces(conn);
            } else if ("DIRECTORY".equalsIgnoreCase(type)) {
                MOHDirectoryOracle moHandler = this.getDirectoryHandler();
                list = moHandler.getDirectories(conn);
            }
        }
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }
}

