/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHSensitiveTypeOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SENSITIVE TYPE";
    protected boolean dbaUser;
    private static final Logger LOGGER = new Logger(MOHSensitiveTypeOracle.class);

    public MOHSensitiveTypeOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        if (!this.dbaUser || !this.getDesign().getSettings().isIncludeRedactionInDDL()) return;
        try {
            ResultSet rs;
            PreparedStatement column_statement;
            Statement statement;
            boolean found;
            block19: {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignOraclev12c)) return;
                found = false;
                statement = sqlConnection.createStatement();
                column_statement = null;
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("NAME").append(',').append(' ');
                buffer.append("USER_COMMENT").append(' ');
                buffer.append("FROM").append(' ').append("DBA_SENSITIVE_COLUMN_TYPES");
                String sql = buffer.toString();
                rs = statement.executeQuery(sql);
                try {
                    if (rs == null) break block19;
                    while (rs.next()) {
                        String name = rs.getString(1);
                        String comment = rs.getString(2);
                        SensitiveType sensitiveType = (SensitiveType)storageDesign.getDesign().getSensitiveTypeSet().getByName(name);
                        if (sensitiveType == null) {
                            sensitiveType = storageDesign.getDesign().getSensitiveTypeSet().createSensitiveType();
                            sensitiveType.setName(name);
                        }
                        if (comment != null && !"".equalsIgnoreCase(comment)) {
                            sensitiveType.setDescription(comment);
                        }
                        found = true;
                        if (column_statement == null) {
                            buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ').append("SCHEMA_NAME").append(',').append(' ');
                            buffer.append("TABLE_NAME").append(',').append(' ');
                            buffer.append("COLUMN_NAME").append(',').append(' ');
                            buffer.append("USER_COMMENT").append(' ');
                            buffer.append("FROM").append(' ').append("DBA_SENSITIVE_DATA").append(' ');
                            buffer.append("WHERE").append(' ').append("SENSITIVE_TYPE").append(' ').append('=').append(' ').append('?').append(' ');
                            String csql = buffer.toString();
                            column_statement = sqlConnection.prepareStatement(csql);
                        }
                        column_statement.setString(1, name);
                        ResultSet rsColumns = column_statement.executeQuery();
                        Throwable throwable = null;
                        try {
                            if (rsColumns == null) continue;
                            while (rsColumns.next()) {
                                Column column;
                                String schemaName = rsColumns.getString(1);
                                String tableName = rsColumns.getString(2);
                                String columnName = rsColumns.getString(3);
                                String sensitiveDesc = rsColumns.getString(4);
                                Table table = null;
                                table = schemaName != null && !"".equalsIgnoreCase(schemaName) ? storageDesign.getPhysicalDesign().getTableSet().getBySchemaAndName(schemaName, tableName) : (Table)storageDesign.getPhysicalDesign().getTableSet().getByName(tableName);
                                if (table == null || (column = (Column)table.getElementByName(columnName)) == null) continue;
                                column.setSensitiveType(sensitiveType);
                                if (sensitiveDesc == null || "".equalsIgnoreCase(sensitiveDesc)) continue;
                                column.setSensitiveTypeDescription(sensitiveDesc);
                            }
                            rsColumns.close();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (rsColumns == null) continue;
                            if (throwable != null) {
                                try {
                                    rsColumns.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            rsColumns.close();
                        }
                    }
                    rs.close();
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, column_statement, statement});
                    throw throwable;
                }
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, column_statement, statement});
            if (!found) return;
        }
        catch (Exception e) {
            LOGGER.error("MOHSensitiveTypeOracle.generate():", e);
        }
    }
}

