/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.DDLFileMaker;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.imports.metadata.oracle.DDLOptions;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHBitmapIndexesv10g;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTableOraclev9i;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.UpdatableStatus;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.model.persistence.LogicalDataTypesReader;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.util.Closeables;
import oracle.jdbc.OracleDriver;

public class SchemaDDLGenerator
implements DDLOptions {
    public static List<String> PARAM_LIST = new ArrayList<String>();
    private static String webPath;

    public static void main(String[] args) throws Exception {
        HashMap<String, Boolean> emptyOptions = new HashMap<String, Boolean>();
        emptyOptions.put("tables", true);
        emptyOptions.put("views", true);
        emptyOptions.put("clust", true);
        emptyOptions.put("types", true);
        emptyOptions.put("mviews", true);
        emptyOptions.put("mvnnconst", true);
        emptyOptions.put("indexes", true);
        emptyOptions.put("all_dependent", true);
        emptyOptions.put("constraints", true);
        emptyOptions.put("pack", true);
        emptyOptions.put("func", true);
        emptyOptions.put("proc", true);
        emptyOptions.put("syn", true);
        emptyOptions.put("psyn", true);
        emptyOptions.put("dim", false);
        emptyOptions.put("comments", false);
        emptyOptions.put("obj_grants", false);
        emptyOptions.put("partitions", false);
        emptyOptions.put("storage", false);
        emptyOptions.put("triggers", false);
        emptyOptions.put("prompt", false);
        emptyOptions.put("tablespace", false);
        emptyOptions.put("logging", false);
        emptyOptions.put("showschema", false);
        Design.dmInternalsDistDir = "D:/Projects/DMWS/DistributedData/datamodeler";
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521:fdb11r21", "system", "system");
        ArrayList schemas = new ArrayList();
        String result = SchemaDDLGenerator.getIndexDDL(conn, "SH", "BJI4", null, true);
    }

    public String getSchemaDDL(Connection conn, List<String> schemas, Map options, boolean separateMV) {
        return this.getSchemaDDL(conn, schemas, options, separateMV, null);
    }

    public String getSchemaDDL(Connection conn, List<String> schemas, Map options, boolean separateMV, UpdatableStatus updatableStatus) {
        MetaFileLoader.DMWEB = true;
        Design des = SchemaDDLGenerator.getDesign(true, false, false);
        RelationalDesign relModel = des.getRelationalDesign();
        DBMExtractionHandlerOracle handler = new DBMExtractionHandlerOracle(des);
        handler.init(conn);
        handler.setParseQueriesAfterImport(false);
        handler.setUpdatableStatus(updatableStatus);
        relModel.setSelectedRDBMSSite(handler.getRDBMSSite());
        StorageDesignOracle sd = (StorageDesignOracle)relModel.getStorageDesign();
        sd.openStorageDesign();
        this.processOptions(options, des);
        TimeLog.log("Start getting objects to import");
        List objects = this.getObjectToImport(conn, handler, schemas, options, separateMV);
        TimeLog.log("Start import");
        ImportLogger importLog = new ImportLogger();
        try {
            handler.generateDesign(conn, objects, importLog);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        TimeLog.log("End import");
        if (updatableStatus != null && updatableStatus.isCancelled()) {
            return "";
        }
        if (updatableStatus != null) {
            updatableStatus.updateStatus("DDL generation");
        }
        DDLFileMaker ddlFileMaker = new DDLFileMaker(des);
        sd.clearMarkGenerateForUsersAndRoles();
        sd.clearMarkGenerateForTablespaces();
        if (!des.getSettings().isImportIndexes()) {
            sd.clearMarkGenerateForIndexes();
        }
        if (!des.getSettings().isImportMViews()) {
            sd.clearMarkGenerateForMViews();
        }
        if (des.getSettings().isImportMViews() && !des.getSettings().isImportTables()) {
            sd.clearMarkGenerateForTables();
        }
        ddlFileMaker.setStorageDesign(sd);
        ddlFileMaker.generateDDLContent();
        TimeLog.log("End DDL generation");
        if (updatableStatus != null) {
            updatableStatus.updateStatus(" End DDL generation");
        }
        return ddlFileMaker.getContent();
    }

    public static void importIndex(Connection conn, String indexOwner, String indexName, Design des) {
        SchemaDDLGenerator.importIndex(conn, null, null, indexOwner, indexName, null, des);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importIndex(Connection conn, String tableOwner, String tableName, String indexOwner, String indexName, String indexType, Design des) {
        try {
            RelationalDesign relModel = null;
            if (des == null) {
                des = SchemaDDLGenerator.getDesign(false, false, false);
                relModel = des.addRelationalDesign();
            } else {
                relModel = des.getRelationalDesign();
            }
            DBMExtractionHandlerOracle handler = new DBMExtractionHandlerOracle(des);
            handler.init(conn);
            relModel.setSelectedRDBMSSite(handler.getRDBMSSite());
            handler.getMOHObjects();
            boolean dbaUser = handler.dbaUser;
            if (tableName == null || tableName.isEmpty() || tableOwner == null || tableOwner.isEmpty()) {
                String sql = "select table_owner, table_name, index_type from " + (dbaUser ? "dba_indexes" : "all_indexes");
                sql = sql + " where owner = ? and index_name = ?";
                PreparedStatement ps = null;
                try {
                    ps = conn.prepareStatement(sql);
                    ps.setString(1, indexOwner);
                    ps.setString(2, indexName);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs != null && rs.next()) {
                            tableOwner = rs.getString(1);
                            tableName = rs.getString(2);
                            indexType = rs.getString(3);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error(e);
                }
                finally {
                    Closeables.close((Object)ps);
                }
                if (tableName == null || tableName.isEmpty() || tableOwner == null || tableOwner.isEmpty()) {
                    return;
                }
            }
            MOHTableOraclev9i moh = (MOHTableOraclev9i)handler.getTableHandler();
            ArrayList<DBObject> list = new ArrayList<DBObject>();
            DBObject dbo = new DBObject(true, tableName, "TABLE", tableOwner);
            list.add(dbo);
            ImportLogger importLog = new ImportLogger();
            moh.generate(conn, list, importLog, indexOwner, indexName);
            MOHBitmapIndexesv10g mohb = moh.getBitmapJoinIndexHandler();
            mohb.generate(conn, list, importLog);
            mohb.postGenerateProcessing(conn);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public static String getIndexDDL(Connection conn, String indexOwner, String indexName, Design des, boolean time) {
        return SchemaDDLGenerator.getIndexDDL(conn, null, null, indexOwner, indexName, null, des, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getIndexDDL(Connection conn, String tableOwner, String tableName, String indexOwner, String indexName, String indexType, Design des, boolean time) {
        String result = "";
        try {
            RelationalDesign relModel = null;
            if (des == null) {
                des = SchemaDDLGenerator.getDesign(false, false, false);
                relModel = des.addRelationalDesign();
            } else {
                relModel = des.getRelationalDesign();
            }
            des.setRelationalDesign(relModel);
            des.setPropagatePKChahges(false);
            des.setImporting(true);
            des.getSettings().setImportPartitions(true);
            DBMExtractionHandlerOracle handler = new DBMExtractionHandlerOracle(des);
            handler.init(conn);
            relModel.setSelectedRDBMSSite(handler.getRDBMSSite());
            handler.getMOHObjects();
            boolean dbaUser = handler.dbaUser;
            if (tableName == null || tableName.isEmpty() || tableOwner == null || tableOwner.isEmpty()) {
                String sql = "select table_owner, table_name, index_type from " + (dbaUser ? "dba_indexes" : "all_indexes");
                sql = sql + " where owner = ? and index_name = ?";
                PreparedStatement ps = null;
                try {
                    ps = conn.prepareStatement(sql);
                    ps.setString(1, indexOwner);
                    ps.setString(2, indexName);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs != null && rs.next()) {
                            tableOwner = rs.getString(1);
                            tableName = rs.getString(2);
                            indexType = rs.getString(3);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error(e);
                    String string = result;
                    return string;
                }
                finally {
                    Closeables.close((Object)ps);
                }
                if (tableName == null) return result;
                if (tableName.isEmpty()) return result;
                if (tableOwner == null) return result;
                if (tableOwner.isEmpty()) {
                    return result;
                }
            }
            if ("IOT - TOP".equalsIgnoreCase(indexType)) {
                return "-- index " + indexOwner + "." + indexName + " is index for PK on index organized table";
            }
            StorageDesignOracle sd = (StorageDesignOracle)relModel.getStorageDesign(handler.getRDBMSSite());
            MOHTableOraclev9i moh = (MOHTableOraclev9i)handler.getTableHandler();
            ArrayList<DBObject> list = new ArrayList<DBObject>();
            DBObject dbo = new DBObject(true, tableName, "TABLE", tableOwner);
            list.add(dbo);
            ImportLogger importLog = new ImportLogger();
            moh.generate(conn, list, importLog, indexOwner, indexName);
            MOHBitmapIndexesv10g mohb = moh.getBitmapJoinIndexHandler();
            mohb.generate(conn, list, importLog);
            mohb.postGenerateProcessing(conn);
            sd.clearMarkGenerateForUsersAndRoles();
            sd.clearMarkGenerateForMViews();
            sd.clearMarkGenerateForTablespaces();
            sd.clearMarkGenerateForTables();
            Table table = des.getRelationalDesign().getTableSet().getBySchemaAndName(tableOwner, tableName);
            if (table == null) return result;
            Index ind = table.getIndexByName(indexName);
            if (ind == null) return result;
            ind.setMarkedGenerate(true);
            DDLFileMaker ddlFileMaker = new DDLFileMaker(des);
            ddlFileMaker.setStorageDesign(sd);
            ddlFileMaker.generateDDLContent(false, false, time);
            return ddlFileMaker.getContent();
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDBlinkDDL(Connection sqlConnection, String owner, String name, boolean time) {
        PreparedStatement statement = null;
        String ddl = "";
        if (time) {
            ddl = "--   at:     " + MDConfiguration.timeToString(System.currentTimeMillis()) + "\n";
        }
        ResultSet rs = null;
        try {
            boolean failed = false;
            String sql = "SELECT USERNAME,OWNER,HOST,DB_LINK FROM dba_db_links WHERE  OWNER = ? and db_link = ?";
            statement = sqlConnection.prepareStatement(sql);
            try {
                statement.setString(1, owner);
                statement.setString(2, name);
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                failed = true;
            }
            if (failed) {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception e) {
                        Logger.error(e);
                    }
                }
                sql = "SELECT USERNAME,OWNER,HOST,DB_LINK FROM all_db_links WHERE  OWNER = ? and db_link = ?";
                statement = sqlConnection.prepareStatement(sql);
                statement.setString(1, owner);
                statement.setString(2, name);
                rs = statement.executeQuery();
            }
            if (rs != null) {
                if (rs.next()) {
                    String userName = rs.getString(1);
                    String host = rs.getString(3);
                    ddl = ddl + SchemaDDLGenerator.getDBLinkDDL(owner, name, userName, host);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
            if (statement == null) return ddl;
        }
        catch (Exception e) {
            Logger.error(e);
            return ddl;
        }
        try {
            statement.close();
            return ddl;
        }
        catch (SQLException e) {
            Logger.error(e);
            return ddl;
        }
        finally {
            Closeables.close(rs);
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    Logger.error(e);
                }
            }
        }
    }

    private static String getDBLinkDDL(String owner, String name, String userName, String host) {
        String res = "CREATE ";
        if ("PUBLIC".equalsIgnoreCase(owner)) {
            res = res + "PUBLIC ";
        }
        res = res + "DATABASE LINK " + name;
        if (userName != null && !userName.isEmpty()) {
            res = res + "\n  ";
            res = "CURRENT_USER".equalsIgnoreCase(userName) ? res + " CONNECT TO " + userName : res + " CONNECT TO " + userName + " IDENTIFIED BY :pswd_" + userName;
        }
        if (host != null && !host.isEmpty()) {
            res = res + "\n  ";
            res = res + " USING '" + host + "'";
        }
        res = res + ";";
        return res;
    }

    public static String getSynonymDDL(Connection conn, String owner, String name, boolean time) {
        Object statement = null;
        String ddl = "";
        SynonymDescriptor sd = SchemaDDLGenerator.getSynonymDescriptor(conn, owner, name);
        if (sd != null) {
            ddl = SchemaDDLGenerator.getSynonymDDL(sd);
        }
        return ddl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SynonymDescriptor getSynonymDescriptor(Connection conn, String owner, String name) {
        SynonymDescriptor synonymDescriptor;
        Statement statement = null;
        int ver = AbstractDBMExtractionHandler.getOracleVersionInt(conn);
        ver = 11;
        ResultSet rs = null;
        try {
            boolean failed = false;
            String sql = "";
            sql = ver >= 12 ? "select s.owner, s.synonym_name, s.table_owner, s.table_name, s.db_link\n , o.editionable \n" + (ver > 12 ? " , o.sharing\n" : "") + " from dba_synonyms s, dba_objects o\n where \n s.owner = o.owner and s.synonym_name = o.object_name and s.owner = ? \n and s.synonym_name = ? and o.object_type = 'SYNONYM'" : "select s.owner, s.synonym_name, s.table_owner, s.table_name, s.db_link\n from dba_synonyms s\n where s.owner = ?  and s.synonym_name = ? ";
            statement = conn.prepareStatement(sql);
            try {
                statement.setString(1, owner);
                statement.setString(2, name);
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                failed = true;
            }
            if (failed) {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception e) {
                        Logger.error(e);
                    }
                }
                sql = "";
                sql = ver >= 12 ? "select s.owner, s.synonym_name, s.table_owner, s.table_name, s.db_link\n , o.editionable \n" + (ver > 12 ? " , o.sharing\n" : "") + " from all_synonyms s, all_objects o\n where \n s.owner = o.owner and s.synonym_name = o.object_name and s.owner = ? \n and s.synonym_name = ? and o.object_type = 'SYNONYM'" : "select s.owner, s.synonym_name, s.table_owner, s.table_name, s.db_link\n from all_synonyms s\n where s.owner = ?  and s.synonym_name = ? ";
                statement = conn.prepareStatement(sql);
                rs = null;
                try {
                    statement.setString(1, owner);
                    statement.setString(2, name);
                    rs = statement.executeQuery();
                }
                catch (Exception e) {
                    failed = true;
                }
            }
            if (rs == null) return null;
            try {
                if (!rs.next()) return null;
                SynonymDescriptor sd = new SynonymDescriptor();
                sd.name = name;
                sd.owner = owner;
                sd.towner = rs.getString(3);
                sd.tname = rs.getString(4);
                sd.db_link = rs.getString(5);
                if (ver >= 12) {
                    sd.editionable = rs.getString(6);
                    if (ver > 12) {
                        sd.sharing = rs.getString(7);
                    }
                }
                synonymDescriptor = sd;
                Closeables.close((Object)rs);
                if (statement == null) return synonymDescriptor;
            }
            catch (Exception e) {
                Logger.error_("SchemaDDLGenerator.SynonymDescriptor", e);
                return null;
            }
            finally {
                rs.close();
            }
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
        try {
            statement.close();
            return synonymDescriptor;
        }
        catch (SQLException e) {
            Logger.error_("SchemaDDLGenerator.SynonymDescriptor", e);
        }
        return synonymDescriptor;
        finally {
            Closeables.close(rs);
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    Logger.error_("SchemaDDLGenerator.SynonymDescriptor", e);
                }
            }
        }
    }

    private static String getSynonymDDL(SynonymDescriptor sd) {
        return SchemaDDLGenerator.getSynonymDDL(sd.owner, sd.name, sd.towner, sd.tname, sd.db_link, sd.editionable, sd.sharing);
    }

    private static String getSynonymDDL(String owner, String name, String towner, String tname, String db_link, String editionable, String sharing) {
        String res = "CREATE OR REPLACE";
        if (editionable != null) {
            res = res + ("Y".equalsIgnoreCase(editionable) ? " EDITIONABLE" : " NONEDITIONABLE");
        }
        if ("PUBLIC".equalsIgnoreCase(owner)) {
            res = res + " PUBLIC";
        }
        res = res + " SYNONYM " + ("PUBLIC".equalsIgnoreCase(owner) ? "" : owner + ".") + name + "\n   ";
        if (sharing != null) {
            res = sharing.startsWith("METADATA") ? res + " SHARING = METADATA" : res + " SHARING = NONE";
        }
        res = res + " FOR " + towner + "." + tname;
        if (db_link != null && !db_link.isEmpty()) {
            res = res + " @" + db_link;
        }
        res = res + ";";
        return res;
    }

    private void processOptions(Map options, Design design) {
        Settings settings = design.getSettings();
        Boolean val = (Boolean)options.get("partitions");
        if (val != null) {
            settings.setImportPartitions(val);
        }
        if ((val = (Boolean)options.get("types")) != null) {
            settings.setImportObjectTypes(val);
            settings.setScanForUsedStructuredTypes(false);
        }
        if ((val = (Boolean)options.get("triggers")) != null) {
            settings.setImportTriggers(val);
        }
        if ((val = (Boolean)options.get("spatial")) != null) {
            settings.setImportSpatialProperties(val);
        }
        if ((val = (Boolean)options.get("storage")) != null) {
            settings.setIncludeStorageInDDL(val);
        }
        if ((val = (Boolean)options.get("systemNames")) != null) {
            settings.setIncludeSystemNames(val);
        }
        if ((val = (Boolean)options.get("comments")) != null) {
            settings.setGenerateCommentsInRDBMS(val);
            settings.setImportCommentsInRDBMS(val);
        }
        if ((val = (Boolean)options.get("quoted")) != null) {
            settings.setUseQuotedIdentifiers(val);
        }
        if ((val = (Boolean)options.get("redact")) != null) {
            settings.setIncludeRedactionInDDL(val);
        }
        if ((val = (Boolean)options.get("tsdp")) != null) {
            settings.setIncludeTSDPInDDL(val);
        }
        if ((val = (Boolean)options.get("supplog")) != null) {
            settings.setIncludeSupplementalLogInDDL(val);
        }
        if ((val = (Boolean)options.get("prompt")) != null) {
            settings.setIncludePromptInDDL(val);
        }
        if ((val = (Boolean)options.get("logging")) != null) {
            settings.setIncludeLoggingInDDL(val);
        }
        if ((val = (Boolean)options.get("tablespace")) != null) {
            settings.setIncludeTablespaceInDDL(val);
        }
        if ((val = (Boolean)options.get("showschema")) != null) {
            settings.setIncludeSchemaInDDL(val);
        }
        if ((val = (Boolean)options.get("tables")) != null) {
            settings.setImportTables(val);
        }
        if ((val = (Boolean)options.get("mviews")) != null) {
            settings.setImportMViews(val);
        }
        if ((val = (Boolean)options.get("mvlogs")) != null) {
            settings.setImportMVLogs(val);
        }
        if ((val = (Boolean)options.get("indexes")) != null) {
            settings.setImportIndexes(val);
        }
        if ((val = (Boolean)options.get("syn")) != null) {
            settings.setImportSynonyms(val);
        }
        if ((val = (Boolean)options.get("psyn")) != null) {
            settings.setImportPublicSynonyms(val);
        }
        if ((val = (Boolean)options.get("constraints")) != null) {
            settings.setImportConstraints(val);
        }
        if ((val = (Boolean)options.get("bytesize")) != null) {
            settings.setShowByteCharInDDL(val);
        }
    }

    private List getObjectToImport(Connection conn, DBMExtractionHandlerOracle handler, List<String> schemas, Map options, boolean separateMV) {
        ArrayList objects = new ArrayList();
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (String sch : schemas) {
            list.add(new DBObject(true, sch));
        }
        try {
            Boolean val = (Boolean)options.get("types");
            if (val != null && val.booleanValue()) {
                objects.addAll(handler.getDBObjects(conn, list, "OBJECT"));
            }
            if ((val = (Boolean)options.get("clust")) != null && val.booleanValue()) {
                objects.addAll(handler.getDBObjects(conn, list, "CLUSTER"));
            }
            val = (Boolean)options.get("tables");
            Boolean mval = (Boolean)options.get("mviews");
            if (!separateMV) {
                if (val != null && val.booleanValue() || mval != null && mval.booleanValue()) {
                    objects.addAll(handler.getDBObjects(conn, list, "TABLE"));
                }
            } else {
                if (val != null && val.booleanValue()) {
                    objects.addAll(handler.getDBObjects(conn, list, "TABLE"));
                }
                if (mval != null && mval.booleanValue()) {
                    objects.addAll(handler.getMViews(conn, list));
                }
            }
            if ((val = (Boolean)options.get("views")) != null && val.booleanValue()) {
                objects.addAll(handler.getDBObjects(conn, list, "VIEW"));
            }
            if ((val = (Boolean)options.get("mvlogs")) != null && val.booleanValue()) {
                objects.addAll(handler.getDBObjects(conn, list, "MATERIALIZED_VIEW_LOG"));
            }
            if ((val = (Boolean)options.get("dim")) != null && val.booleanValue()) {
                objects.addAll(handler.getDBObjects(conn, list, "DIMENSION"));
            }
            if ((val = (Boolean)options.get("seq")) != null && val.booleanValue()) {
                objects.addAll(handler.getDBObjects(conn, list, "SEQUENCE"));
            }
            if ((val = (Boolean)options.get("func")) != null && val.booleanValue()) {
                objects.addAll(handler.getDBObjects(conn, list, "FUNCTION"));
            }
            if ((val = (Boolean)options.get("proc")) != null && val.booleanValue()) {
                objects.addAll(handler.getDBObjects(conn, list, "PROCEDURE"));
            }
            if ((val = (Boolean)options.get("pack")) != null && val.booleanValue()) {
                objects.addAll(handler.getDBObjects(conn, list, "PACKAGE"));
            }
            val = (Boolean)options.get("syn");
            Boolean pval = (Boolean)options.get("psyn");
            if (val != null && val.booleanValue() || pval != null && pval.booleanValue()) {
                objects.addAll(handler.getDBObjects(conn, list, "SYNONYM"));
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return objects;
    }

    static Design getDesign(boolean allDetails, boolean triggers, boolean spatial) {
        Design des = new Design();
        LogicalDataTypesReader lr = new LogicalDataTypesReader();
        lr.recreateLogicalTypes(des);
        RelationalDesign relModel = des.addRelationalDesign();
        des.setRelationalDesign(relModel);
        des.setPropagatePKChahges(false);
        des.setImporting(true);
        des.setLoading(true);
        Settings s = des.getSettings();
        if (!allDetails) {
            s.setImportPartitions(false);
            s.setImportTriggers(false);
            s.setScanForUsedStructuredTypes(false);
            s.setImportSpatialProperties(false);
            s.setImportSecondaryTables(false);
        } else {
            s.setImportPartitions(true);
            s.setImportTriggers(triggers);
            s.setScanForUsedStructuredTypes(true);
            s.setImportSpatialProperties(spatial);
            s.setImportSecondaryTables(false);
        }
        return des;
    }

    static {
        PARAM_LIST.add("tables");
        PARAM_LIST.add("views");
        PARAM_LIST.add("indexes");
        PARAM_LIST.add("triggers");
        PARAM_LIST.add("constraints");
        PARAM_LIST.add("mviews");
        PARAM_LIST.add("mvlogs");
        PARAM_LIST.add("types");
        PARAM_LIST.add("seq");
        PARAM_LIST.add("syn");
        PARAM_LIST.add("psyn");
        PARAM_LIST.add("pack");
        PARAM_LIST.add("proc");
        PARAM_LIST.add("func");
        PARAM_LIST.add("clust");
        PARAM_LIST.add("dim");
        PARAM_LIST.add("obj_grants");
        PARAM_LIST.add("partitions");
        PARAM_LIST.add("comments");
        PARAM_LIST.add("storage");
        PARAM_LIST.add("bytesize");
        PARAM_LIST.add("showschema");
        PARAM_LIST.add("tablespace");
        PARAM_LIST.add("logging");
        PARAM_LIST.add("redact");
        PARAM_LIST.add("tsdp");
        PARAM_LIST.add("supplog");
        PARAM_LIST.add("prompt");
        webPath = "/WEB-INF/datamodeler";
    }

    public static class SynonymDescriptor {
        public String owner;
        public String name;
        public String towner;
        public String tname;
        public String db_link;
        public String editionable;
        public String sharing;
    }
}

