/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHExternalTableOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "EXTERNAL TABLE";
    private static final Logger LOGGER = new Logger(MOHExternalTableOraclev9i.class);
    protected boolean dbaUser;
    boolean shouldCreateHiveUDPLibrary = false;
    PreparedStatement parallelStmt = null;

    public MOHExternalTableOraclev9i(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        PreparedStatement statement;
        block28: {
            StorageDesign stoDes = this.getStorageDesign();
            if (!(stoDes instanceof StorageDesignOracle)) {
                LOGGER.error("Unable to find Storage Design!");
                return;
            }
            this.shouldCreateHiveUDPLibrary = false;
            statement = null;
            try {
                for (int i = 0; i < selectedObjects.size(); ++i) {
                    DBObject dbo = (DBObject)selectedObjects.get(i);
                    String ownerName = dbo.getSchema();
                    ResultSet rs = null;
                    try {
                        if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                        try {
                            if (statement == null) {
                                StringBuffer buffer = new StringBuffer();
                                buffer.append("SELECT").append(' ');
                                buffer.append("b.").append("LOCATION").append(',');
                                buffer.append("b.").append("directory_name").append(',');
                                buffer.append("DEFAULT_DIRECTORY_NAME").append(',');
                                buffer.append("REJECT_LIMIT").append(',');
                                buffer.append("PROPERTY").append(',');
                                buffer.append("TYPE_NAME").append(',');
                                buffer.append("ACCESS_PARAMETERS").append(' ');
                                buffer.append("FROM").append(' ');
                                buffer.append(this.dbaUser ? "dba_external_tables" : "all_external_tables").append(' ').append("a").append(',');
                                buffer.append(this.dbaUser ? "dba_external_locations" : "all_external_locations").append(' ').append("b").append(' ');
                                buffer.append("WHERE").append(' ');
                                buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
                                buffer.append("AND").append(' ');
                                buffer.append("a.").append("TABLE_NAME").append('=').append('?').append(' ');
                                buffer.append("AND").append(' ');
                                buffer.append("a.").append("OWNER").append('=').append("b.").append("OWNER").append("(+) ");
                                buffer.append("AND").append(' ');
                                buffer.append("a.").append("TABLE_NAME").append('=').append("b.").append("TABLE_NAME").append("(+)");
                                statement = sqlConnection.prepareStatement(buffer.toString());
                            }
                            statement.setString(1, ownerName);
                            statement.setString(2, dbo.getName());
                            rs = statement.executeQuery();
                        }
                        catch (Exception e) {
                            LOGGER.error("MOHExternalTableOraclev9i.extract():", e);
                        }
                        Table table = null;
                        TableProxyOracle externalTable = null;
                        if (rs != null) {
                            while (rs.next()) {
                                StorageDesignOracle storageDesign = (StorageDesignOracle)stoDes;
                                String name = dbo.getName();
                                String location = rs.getString("LOCATION");
                                String dirName = rs.getString("directory_name");
                                String defDirName = rs.getString("DEFAULT_DIRECTORY_NAME");
                                String rejectLimit = rs.getString("REJECT_LIMIT");
                                String projColumn = rs.getString("PROPERTY");
                                String driverType = rs.getString("TYPE_NAME");
                                String accessParams = rs.getString("ACCESS_PARAMETERS");
                                if (externalTable == null) {
                                    accessParams = accessParams == null ? "" : accessParams.trim();
                                    if (dbo.getTable() != null) {
                                        table = (Table)dbo.getTable();
                                        externalTable = (TableProxyOracle)dbo.getTableProxy();
                                    } else {
                                        table = this.getRelationalDesign().createTable();
                                        table.setSchema(dbo.getSchema());
                                        if (!dbo.getSchema().equals(dbo.getSchema().toUpperCase()) && table.getSchemaObject() != null) {
                                            table.getSchemaObject().setNameHasQuotes(true);
                                        }
                                        table.setName(dbo.getName());
                                        if (!dbo.getName().equals(dbo.getName().toUpperCase())) {
                                            table.setNameHasQuotes(true);
                                        }
                                        dbo.setTable(table);
                                        this.stampModelObject(table, dbo);
                                        externalTable = (TableProxyOracle)storageDesign.getTableProxySet().getProxy(table.getObjectID());
                                        externalTable.setName(name);
                                        if (!name.equals(name.toUpperCase())) {
                                            externalTable.setNameHasQuotes(true);
                                        }
                                        dbo.setTableProxy(externalTable);
                                    }
                                    table.setTypeID("6");
                                    if (externalTable != null) {
                                        externalTable.setName(name);
                                        if (!name.equals(name.toUpperCase())) {
                                            externalTable.setNameHasQuotes(true);
                                        }
                                        externalTable.setProjectColumn(projColumn);
                                        externalTable.setOrganization("EXTERNAL");
                                        if (defDirName != null && !defDirName.isEmpty()) {
                                            DirectoryOracle directory = (DirectoryOracle)storageDesign.getDirectorySet().getByName(defDirName);
                                            externalTable.setDefaultDir(directory);
                                            if (directory == null) {
                                                externalTable.setDefaultDirName(defDirName);
                                            }
                                        }
                                        externalTable.setRejectLimit(rejectLimit);
                                        externalTable.setAccessDriverType(driverType);
                                        accessParams = MOHExternalTableOraclev9i.processAndClearHiveAccessParams(externalTable, accessParams, driverType);
                                        if ("ORAcLE_HIVE".equalsIgnoreCase(driverType)) {
                                            this.shouldCreateHiveUDPLibrary = true;
                                        }
                                        if (driverType != null && driverType.toUpperCase().startsWith("ORACLE_")) {
                                            externalTable.setAccessParametersType("Opaque Format Spec");
                                            externalTable.setOpaqueFormatSpec(accessParams);
                                        } else {
                                            externalTable.setAccessParametersType("CLOB Subquery");
                                            externalTable.setClobSubquery(accessParams);
                                        }
                                        this.initParallel(sqlConnection, externalTable, ownerName, this.parallelStmt);
                                        this.stampModelObject(externalTable, dbo);
                                    }
                                }
                                externalTable.addLocation(dirName, location);
                            }
                            rs.close();
                        }
                        importLog.incrementImportedStatements();
                        this.addToHandledObjects(dbo);
                        continue;
                    }
                    finally {
                        Closeables.close(rs);
                    }
                }
                if (!this.shouldCreateHiveUDPLibrary) break block28;
                try {
                    if (this.getDesign() != null) {
                        MOHTable.createHiveUDPLibrary(this.getDesign());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new PreparedStatement[]{this.parallelStmt, statement});
                throw throwable;
            }
        }
        Closeables.close((Object[])new PreparedStatement[]{this.parallelStmt, statement});
    }

    public static String processAndClearHiveAccessParams(TableProxyOracle tp, String spec, String driverType) {
        String tspec = spec.trim();
        if ("ORAcLE_HIVE".equalsIgnoreCase(driverType) && spec != null && !"".equals(tspec)) {
            List list = MOHExternalTableOraclev9i.getParametersList(tspec);
            list = MOHExternalTableOraclev9i.processAndClearRecognized(tp, list);
            spec = "";
            for (String param : list) {
                spec = spec + param;
            }
            MOHExternalTableOraclev9i.resetHiveProperties(tp);
        }
        return spec;
    }

    private static void resetHiveProperties(TableProxyOracle tp) {
        String hschema;
        Table table = (Table)tp.getObject();
        String hname = table.getProperty(MOHTable.HIVE_NAME);
        if (hname == null || "".equals(hname)) {
            table.setProperty(MOHTable.HIVE_NAME, table.getName().toLowerCase());
        }
        if ((hschema = table.getProperty(MOHTable.HIVE_SCHEMA)) == null || "".equals(hschema)) {
            table.setProperty(MOHTable.HIVE_SCHEMA, "default");
        }
        for (ContainedObject co : table.getElementsCollection()) {
            hname = co.getProperty(MOHTable.HIVE_NAME);
            if (hname != null && !"".equals(hname)) continue;
            co.setProperty(MOHTable.HIVE_NAME, co.getName().toLowerCase());
        }
    }

    private static List getParametersList(String spec) {
        ArrayList<String> list = new ArrayList<String>();
        String current = "";
        String[] parts = spec.split("\n");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            current = i != parts.length - 1 ? current + part + "\n" : current + part;
            if (part.endsWith("\\") || part.endsWith("\\\r")) continue;
            list.add(current);
            current = "";
        }
        return list;
    }

    private static List processAndClearRecognized(TableProxyOracle tp, List params) {
        ArrayList<String> list = new ArrayList<String>();
        for (String item : params) {
            if (MOHExternalTableOraclev9i.processedHiveParam(tp, item)) continue;
            list.add(item);
        }
        return list;
    }

    private static boolean processedHiveParam(TableProxyOracle tp, String param) {
        if (MOHExternalTableOraclev9i.processedHiveTableNameParam(tp, param)) {
            return true;
        }
        if (MOHExternalTableOraclev9i.processedHiveDataModeParam(tp, param)) {
            return true;
        }
        return MOHExternalTableOraclev9i.processedHiveColMapParam(tp, param);
    }

    private static boolean processedHiveTableNameParam(TableProxyOracle tp, String param) {
        if (param.startsWith("com.oracle.bigdata.tablename")) {
            int ind = param.indexOf(58);
            if (ind == -1) {
                ind = param.indexOf(61);
            }
            if (ind > -1) {
                Table table = (Table)tp.getObject();
                String p = param.substring(ind + 1).trim();
                p.replace("\n", "");
                p.replace("\r", "");
                ind = p.indexOf(46);
                String name = p;
                if (ind > 0) {
                    name = p.substring(ind + 1);
                    String schema = p.substring(0, ind - 1);
                    table.setProperty(MOHTable.HIVE_SCHEMA, schema);
                }
                table.setProperty(MOHTable.HIVE_NAME, name);
                return true;
            }
        }
        return false;
    }

    private static boolean processedHiveColMapParam(TableProxyOracle tp, String param) {
        if (param.startsWith("com.oracle.bigdata.colMap")) {
            int ind = param.indexOf(58);
            if (ind == -1) {
                ind = param.indexOf(61);
            }
            if (ind > -1) {
                Table table = (Table)tp.getObject();
                String p = param.substring(ind + 1).trim();
                p.replaceAll("\n", "");
                p.replace("\r", "");
                p.replaceAll("\\\\", "");
                p.replace("[", "");
                p.replace("]", "");
                String[] pairs = p.split("}");
                for (int i = 0; i < pairs.length; ++i) {
                    ContainedObject co;
                    String[] parts;
                    String pair = pairs[i];
                    if ("".equals(pair)) continue;
                    int br = pair.indexOf(123);
                    if (br > -1) {
                        pair = pair.substring(br + 1);
                    }
                    if ((parts = pair.split(",")).length != 2) continue;
                    String cname = "";
                    int col = parts[0].indexOf(58);
                    if (col > -1) {
                        cname = parts[0].substring(col + 1);
                        cname = Token.getName(cname);
                    }
                    col = parts[1].indexOf(58);
                    String fname = "";
                    if (col > -1) {
                        fname = parts[1].substring(col + 1);
                        fname = Token.getName(fname);
                    }
                    if ("".equals(fname) || "".equals(cname) || (co = table.getElementByName(cname)) == null) continue;
                    co.setProperty(MOHTable.HIVE_NAME, fname);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean processedHiveDataModeParam(TableProxyOracle tp, String param) {
        if (param.startsWith("com.oracle.bigdata.datamode")) {
            int ind = param.indexOf(58);
            if (ind == -1) {
                ind = param.indexOf(61);
            }
            if (ind > -1) {
                String p = param.substring(ind + 1).trim();
                p.replace("\n", "");
                p.replace("\r", "");
                tp.setBigDataRowProcessing(p);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initParallel(Connection sqlConnection, TableProxyOracle externalTable, String owner, PreparedStatement parallelStmt) throws Exception {
        ResultSet rs = null;
        try {
            if (parallelStmt == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("DEGREE").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_all_tables" : "all_all_tables").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("TABLE_NAME").append('=').append('?');
                parallelStmt = sqlConnection.prepareStatement(buffer.toString());
            }
            parallelStmt.setString(1, owner);
            parallelStmt.setString(2, externalTable.getName());
            rs = parallelStmt.executeQuery();
            if (rs != null) {
                if (rs.next()) {
                    String parallel = rs.getString("DEGREE");
                    if ("1".equals(parallel.trim())) {
                        externalTable.setParallel("NO");
                    } else {
                        externalTable.setParallel("YES");
                        externalTable.setDegree(parallel.trim());
                    }
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHExternalTableOraclev9i.initParallel():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    protected String removeBrackets(String input) {
        String result;
        int length = input.length();
        int ind = input.indexOf(40);
        if (ind > 0) {
            result = input.substring(0, ind);
            int close_ind = input.indexOf(41);
            if (close_ind > 0 && close_ind < length - 1) {
                String rest = input.substring(close_ind + 1, length);
                result = result.trim() + ' ' + this.removeBrackets(rest).trim();
            }
        } else {
            result = input;
        }
        return result;
    }
}

