/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;

public abstract class SynonymOracle
extends AbstractStorageObjectOracle
implements OwnedObjectOracle {
    private UserOracle user = null;
    private String userName = "";
    private String isPublic = "NO";
    private UserOracle objectUser = null;
    private String objectUserName = "";
    private String object = "";
    private boolean objNameHasQuotes = false;
    private String dbLink = "";
    private String refferedObjectID = "";
    protected StorageObjectCollection synonyms = new StorageObjectCollection();
    public static final String TYPE_NAME = "Synonym";

    public SynonymOracle() {
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(SynonymOracle.class);
    }

    public void initStorageObjects(StorageDesignOracle storageDesign) {
        this.synonyms = new StorageObjectCollection();
        this.synonyms.setStorageObjectSet(storageDesign.getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(SynonymOracle.class);
        this.addSynonymsFromDesign(storageDesign.getSynonymSet());
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        this.user = user;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getUserName() {
        UserOracle user = this.getUser();
        if (user != null) {
            return user.getName();
        }
        return this.userName;
    }

    public void setUserName(String name) {
        this.userName = name;
        ModelObject user = this.getStorageDesignOracle().getUserSet().getByName(name);
        if (user != null) {
            this.setUser((UserOracle)user);
        }
    }

    public void setPublic(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.isPublic = value;
            this.fireDataFieldChange();
        }
    }

    public String getPublic() {
        return this.isPublic;
    }

    public UserOracle getObjectUser() {
        return this.objectUser;
    }

    public void setObjectUser(UserOracle objectUser) {
        this.objectUser = objectUser;
        this.fireDataFieldChange();
    }

    public String getObjectUserName() {
        UserOracle objectUser = this.getObjectUser();
        if (objectUser != null) {
            return objectUser.getName();
        }
        return this.objectUserName;
    }

    public void setObjectUserName(String name) {
        this.objectUserName = name;
        ModelObject objectUser = this.getStorageDesignOracle().getUserSet().getByName(name);
        if (objectUser != null) {
            this.setObjectUser((UserOracle)objectUser);
        }
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public boolean getObjNameHasQuotes() {
        return this.objNameHasQuotes;
    }

    public void setObjNameHasQuotes(boolean objNameHasQuotes) {
        this.objNameHasQuotes = objNameHasQuotes;
    }

    public String getDBLink() {
        return this.dbLink;
    }

    public void setDBLink(String dbLink) {
        this.dbLink = dbLink;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && "NO".equalsIgnoreCase(this.isPublic)) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getUser() != null && "NO".equalsIgnoreCase(this.isPublic)) {
            name = this.getUser().getLongName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    public void setReferredObjectID(String refferedObjectID) {
        this.refferedObjectID = refferedObjectID;
    }

    public String getReferredObjectID() {
        return this.refferedObjectID;
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.synonyms;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void remove(boolean force) {
        super.remove(force);
        if (this.refferedObjectID.length() > 0) {
            StorageObject referredObject = this.getStorageDesign().getStorageObject(this.refferedObjectID);
            if (referredObject instanceof SynonymOracle) {
                ((SynonymOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof FunctionOracle) {
                ((FunctionOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof PackageOracle) {
                ((PackageOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof TableProxyOracle) {
                ((TableProxyOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof TableViewProxyOracle) {
                ((TableViewProxyOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof SequenceOracle) {
                ((SequenceOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof StoredProcedureOracle) {
                ((StoredProcedureOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof SnapshotOracle) {
                ((SnapshotOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof StructuredTypeProxyOracle) {
                ((StructuredTypeProxyOracle)referredObject).removeSynonym(this);
            } else if (referredObject instanceof CollectionTypeProxyOracle) {
                ((CollectionTypeProxyOracle)referredObject).removeSynonym(this);
            }
        }
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    public SynonymOracle createSynonym() {
        SynonymOracle syn = (SynonymOracle)this.synonyms.createElement(null);
        syn.setReferredObjectID(this.getObjectID());
        syn.setPAC_Element(this);
        return syn;
    }

    public void removeSynonym(SynonymOracle syn) {
        this.synonyms.remove(syn);
        this.setDirty(true);
    }

    public void addSynonym(SynonymOracle syn) {
        this.synonyms.add(syn);
        this.setDirty(true);
    }

    public void addSynonymsFromDesign(StorageObjectSet set) {
        for (SynonymOracle syn : set) {
            if (!syn.getReferredObjectID().equalsIgnoreCase(this.getObjectID())) continue;
            syn.setParent(this.synonyms);
            this.synonyms.add(syn);
        }
    }

    public void fillReferedObjectID() {
    }

    public void addSynonymToReferredObjectsSynonymSet() {
        if (this.getReferredObjectID().length() > 0) {
            StorageObject referredSO = this.getStorageDesign().getStorageObject(this.getReferredObjectID());
            if (referredSO instanceof TableProxyOracle) {
                ((TableProxyOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof TableViewProxyOracle) {
                ((TableViewProxyOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof PackageOracle) {
                ((PackageOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof SnapshotOracle) {
                ((SnapshotOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof StructuredTypeProxyOracle) {
                ((StructuredTypeProxyOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof CollectionTypeProxyOracle) {
                ((CollectionTypeProxyOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof StoredProcedureOracle) {
                ((StoredProcedureOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof SynonymOracle) {
                ((SynonymOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof SequenceOracle) {
                ((SequenceOracle)referredSO).addSynonym(this);
            } else if (referredSO instanceof FunctionOracle) {
                ((FunctionOracle)referredSO).addSynonym(this);
            }
        }
    }

    public void removeSynonymFromReferredObjectsSynonymSet() {
        if (this.getReferredObjectID().length() > 0) {
            StorageObject referredSO = this.getStorageDesign().getStorageObject(this.getReferredObjectID());
            if (referredSO instanceof TableProxyOracle) {
                ((TableProxyOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof TableViewProxyOracle) {
                ((TableViewProxyOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof PackageOracle) {
                ((PackageOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof SnapshotOracle) {
                ((SnapshotOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof StructuredTypeProxyOracle) {
                ((StructuredTypeProxyOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof CollectionTypeProxyOracle) {
                ((CollectionTypeProxyOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof StoredProcedureOracle) {
                ((StoredProcedureOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof SynonymOracle) {
                ((SynonymOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof SequenceOracle) {
                ((SequenceOracle)referredSO).removeSynonym(this);
            } else if (referredSO instanceof FunctionOracle) {
                ((FunctionOracle)referredSO).removeSynonym(this);
            }
        }
    }
}

