/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.swingui.search.PropertyObject;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;

public class ClassDescription
implements Cloneable,
MDXMLConstants {
    public static final int PROP_TYPE_ATTRIBUTE = 1;
    public static final int PROP_TYPE_ELEMENT = 2;
    private List<PropertyDescription> propertiesList = new ArrayList<PropertyDescription>();
    private List<PropertyDescription> attributePropertiesList;
    private List<CollectionDescription> collectionsList = new ArrayList<CollectionDescription>();
    private List<PropertyDescription> roPropertiesList = new ArrayList<PropertyDescription>();
    private List<PropertyDescription> roSearchablePropertiesList = new ArrayList<PropertyDescription>();
    private String className;
    private String parentClassName;
    public Class objectClass;
    private String xmlName;
    public List propertiesDependency = new ArrayList();
    public boolean isPropertyMap = false;
    public boolean isCreateAllExtItemsFirst = false;
    private static final String ITEM_NAME = "item";
    private static final String KEY_NAME = "key";
    private static final String VALUE_NAME = "value";
    private Map contextMap = new HashMap();
    private List contexts = new ArrayList();
    public String beforeTransformName;
    public String beforeTransformExtName;
    public String afterInitName;
    public String afterInitExtName;
    public Method beforeTransform;
    public Method beforeTransformExt;
    public Method afterInit;
    public Method afterInitExt;
    private boolean hasElementsOrCollections = true;

    public static void main(String[] args) {
    }

    protected Object clone() throws CloneNotSupportedException {
        ArrayList pdList;
        ClassDescription cd = (ClassDescription)super.clone();
        ArrayList<PropertyDescription> list = new ArrayList<PropertyDescription>(this.propertiesList);
        cd.propertiesList = list;
        ArrayList<CollectionDescription> clist = new ArrayList<CollectionDescription>(this.collectionsList);
        cd.collectionsList = clist;
        ArrayList<PropertyDescription> roList = new ArrayList<PropertyDescription>(this.roPropertiesList);
        cd.roPropertiesList = roList;
        ArrayList<PropertyDescription> roSearchableList = new ArrayList<PropertyDescription>(this.roSearchablePropertiesList);
        cd.roSearchablePropertiesList = roSearchableList;
        cd.propertiesDependency = pdList = new ArrayList(this.propertiesDependency);
        cd.contextMap = new HashMap(this.contextMap);
        cd.contexts = new ArrayList(this.contexts);
        cd.beforeTransformExtName = this.beforeTransformExtName;
        cd.beforeTransformName = this.beforeTransformName;
        cd.beforeTransformExt = this.beforeTransformExt;
        cd.beforeTransform = this.beforeTransform;
        cd.afterInitName = this.afterInitName;
        cd.afterInit = this.afterInit;
        cd.afterInitExtName = this.afterInitExtName;
        cd.afterInitExt = this.afterInitExt;
        return cd;
    }

    public List<PropertyDescription> getPropertiesList() {
        return this.propertiesList;
    }

    public List<PropertyDescription> getAttributePropertiesList() {
        if (this.attributePropertiesList == null) {
            this.attributePropertiesList = new ArrayList<PropertyDescription>();
            for (PropertyDescription pd : this.propertiesList) {
                if (!pd.isAttribute()) continue;
                this.attributePropertiesList.add(pd);
            }
        }
        return this.attributePropertiesList;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String toString() {
        return this.getClassName();
    }

    public String getXmlName() {
        if (this.xmlName == null) {
            int ind = this.className.lastIndexOf(46) + 1;
            this.xmlName = this.className.substring(ind);
        }
        return this.xmlName;
    }

    public void setXmlName(String xmlName) {
        this.xmlName = xmlName;
    }

    public List<CollectionDescription> getCollectionsList() {
        return this.collectionsList;
    }

    public List<CollectionDescription> getOrderedCollectionsList(String context) {
        List list;
        if (context != null && !"".equals(context) && (list = (List)this.contextMap.get(context + "collectionOrder")) != null) {
            return list;
        }
        return this.collectionsList;
    }

    public PropertyDescription getPropertyDescriptionByName(String name) {
        for (PropertyDescription pd : this.propertiesList) {
            if (!pd.name.equalsIgnoreCase(name)) continue;
            return pd;
        }
        return null;
    }

    public PropertyDescription getPropertyDescriptionByXMLName(String name) {
        for (PropertyDescription pd : this.propertiesList) {
            if (!pd.xmlName.equalsIgnoreCase(name)) continue;
            return pd;
        }
        return null;
    }

    public PropertyDescription getROPropertyDescriptionByName(String name) {
        for (PropertyDescription pd : this.getROPropertiesList()) {
            if (!pd.name.equalsIgnoreCase(name)) continue;
            return pd;
        }
        return null;
    }

    public PropertyDescription getPropertyDescriptionByNameInclRO(String name) {
        for (PropertyDescription pd : this.propertiesList) {
            if (!pd.name.equalsIgnoreCase(name)) continue;
            return pd;
        }
        for (PropertyDescription pd : this.roPropertiesList) {
            if (!pd.name.equalsIgnoreCase(name)) continue;
            return pd;
        }
        return null;
    }

    public PropertyDescription getSearchablePropertyDescriptionByName(String name) {
        for (PropertyDescription pd : this.getSearchablePropertyDescriptionsList()) {
            if (!pd.name.equalsIgnoreCase(name)) continue;
            return pd;
        }
        return null;
    }

    public Map getContextMap() {
        return this.contextMap;
    }

    public CollectionDescription getCollectionDescriptionByName(String name) {
        if (name != null) {
            for (CollectionDescription cold : this.getCollectionsList()) {
                if (!name.equals(cold.name)) continue;
                return cold;
            }
        }
        return null;
    }

    public List getContexts() {
        return this.contexts;
    }

    public void removePropertyDescription(PropertyDescription pd) {
        this.propertiesList.remove(pd);
    }

    public void removeROPropertyDescription(PropertyDescription pd) {
        this.roPropertiesList.remove(pd);
    }

    public void removeCollectionDescription(CollectionDescription cold) {
        this.collectionsList.remove(cold);
    }

    public boolean isHasElementsOrCollections() {
        return this.hasElementsOrCollections;
    }

    public void resetElementsAndCollectionsFlag() {
        if (this.isPropertyMap) {
            this.hasElementsOrCollections = true;
            return;
        }
        for (PropertyDescription pd : this.propertiesList) {
            if (!pd.isElement()) continue;
            this.hasElementsOrCollections = true;
            return;
        }
        this.hasElementsOrCollections = this.collectionsList.size() > 0;
    }

    public List<PropertyDescription> getROPropertiesList() {
        return this.roPropertiesList;
    }

    public List<PropertyDescription> getSearchableROPropertiesList() {
        return this.roSearchablePropertiesList;
    }

    public List<PropertyDescription> getSearchablePropertyObjectsList() {
        PropertyObject po;
        ArrayList<PropertyDescription> list = new ArrayList<PropertyDescription>();
        for (PropertyDescription pd : this.getPropertiesList()) {
            if (!pd.isSearch() || !ClassDescription.hasNoArgument(pd.getter)) continue;
            po = new PropertyObject(pd, "", false, false, true, false);
            list.add((PropertyDescription)((Object)po));
        }
        for (PropertyDescription pd : this.getROPropertiesList()) {
            if (!pd.isSearch() || pd.getter == null || !ClassDescription.hasNoArgument(pd.getter)) continue;
            po = new PropertyObject(pd, "", false, false, false, true);
            list.add((PropertyDescription)((Object)po));
        }
        Collections.sort(list, new PropertyObjectsComparator());
        return list;
    }

    public List<PropertyDescription> getSearchablePropertyDescriptionsList() {
        ArrayList<PropertyDescription> list = new ArrayList<PropertyDescription>();
        for (PropertyDescription pd : this.getPropertiesList()) {
            if (!pd.isSearch() || !ClassDescription.hasNoArgument(pd.getter)) continue;
            list.add(pd);
        }
        for (PropertyDescription pd : this.getROPropertiesList()) {
            if (!pd.isSearch() || !ClassDescription.hasNoArgument(pd.getter)) continue;
            list.add(pd);
        }
        Collections.sort(list, new PropertyDescriptionsComparator());
        return list;
    }

    private static boolean hasNoArgument(Method method) {
        return method.getParameterTypes().length == 0;
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public void setParentClassName(String parentClassName) {
        this.parentClassName = parentClassName;
    }

    public void updatePropertyDependencies(PropertyDescription oprop, PropertyDescription nprop) {
        for (MetaDataManager.ObjectDependence od : this.propertiesDependency) {
            if (od.object == oprop) {
                od.object = nprop;
            }
            if (!od.dependOn.remove(oprop)) continue;
            od.dependOn.add(nprop);
        }
    }

    private static class PropertyDescriptionsComparator
    implements Comparator {
        private PropertyDescriptionsComparator() {
        }

        public int compare(Object one, Object two) {
            PropertyDescription s1 = (PropertyDescription)one;
            PropertyDescription s2 = (PropertyDescription)two;
            String name1 = s1.name;
            String name2 = s2.name;
            return name1.compareTo(name2);
        }
    }

    private static class PropertyObjectsComparator
    implements Comparator {
        private PropertyObjectsComparator() {
        }

        public int compare(Object one, Object two) {
            PropertyObject s1 = (PropertyObject)one;
            PropertyObject s2 = (PropertyObject)two;
            String name1 = s1.getPropertyDescription().name;
            String name2 = s2.getPropertyDescription().name;
            return name1.compareTo(name2);
        }
    }

    public static class CollectionDescription {
        public String name;
        public String className;
        public String itemClassName;
        public String xmlName;
        public String itemXmlName;
        public String itemContainment;
        public String getterName;
        public String setterName;
        public String createItemName;
        public String removeItemName;
        public String addItemName;
        public String applyListName;
        public String getItemByIDName;
        public String moveMethodName;
        public boolean keepOrder = false;
        public boolean isMapItem = false;
        public boolean isEngPropertyHolderItem;
        public boolean isObjectViewItem = false;
        public boolean isTVConnectorItem = false;
        public boolean isTVDiagramItem = false;
        public Method getter;
        public Method setter;
        public Method createItem;
        public Method removeItem;
        public Method applyList;
        public Method getItemByID;
        public Method moveMethod;
        public Method addItem;
        public boolean itemIsRef = false;
        public boolean listOfRefs = false;
        public boolean nativeList = false;
        public boolean orderTheList = false;
        public String idName = "IDREF";
        public String refsXMLName = "IDREFS";
        public boolean isIDObjectSet = false;
        public boolean isProxyitem = false;
        public boolean isOrderImportant = true;
        public boolean isExternalCollection = false;
        public boolean createAllItemsFirst = false;
        public String preProcessName;
        public Method preProcess;
        public boolean isPhysicalModelItem = false;
        public boolean useInReport = false;

        public boolean isUseInReport() {
            return this.useInReport;
        }
    }

    public static class PropertyDescription
    implements Cloneable {
        public String name;
        public String className;
        public String xmlName;
        public String oldXmlName;
        public String defaultValue;
        public String getterName;
        public String setterName;
        public String createPropertyName;
        public String itemClassName;
        public int propType = 2;
        public Method getter;
        public Method setter;
        public Method createPMap;
        public Method createProperty;
        public Method removeProperty;
        public String relatedValue;
        public String relatedPropertyName;
        public boolean referred = false;
        public boolean ddlRelated = false;
        public boolean idObjecttranslator = false;
        public boolean simpleClass;
        public boolean stringClass = true;
        public boolean isBoolean = false;
        public boolean isNumeric = false;
        public boolean isPropertyMap = false;
        public boolean isMap = false;
        public boolean isRectangle = false;
        public boolean isLoggingProp = false;
        public boolean isCreatedTimeProp = false;
        public boolean isColorProperty = false;
        public boolean isListOfRefs = false;
        public boolean isMergeCompare = false;
        public String pmItemName = "item";
        public String pmKeyName = "key";
        public String pmValueName = "value";
        public String createPMapName;
        public PropertyTranslator propertyTranslator;
        public String presentationName;
        public String removePropertyName;
        public boolean isID = false;
        public boolean isAfterCollectionProcessing = false;
        public boolean isExternalProperty = false;
        public String beforeCollection;
        public String afterCollection;
        public boolean search = false;
        public boolean skipClassName = false;
        public PropertyDescription relatedProperty;
        public boolean useInReport = false;
        public boolean dateTime = false;
        private Map encodedEnumMap;

        public String toString() {
            return "name=" + this.name + "/n className(datatype)=" + this.className;
        }

        protected Object clone() {
            PropertyDescription pd = null;
            try {
                pd = (PropertyDescription)super.clone();
            }
            catch (CloneNotSupportedException e) {
                Logger.error(e);
            }
            return pd;
        }

        public boolean isAttribute() {
            return this.propType == 1;
        }

        public boolean isElement() {
            return this.propType == 2;
        }

        public boolean isDdlRelated() {
            return this.ddlRelated;
        }

        public boolean isSimpleClass() {
            return this.simpleClass;
        }

        public boolean isStringClass() {
            return this.stringClass;
        }

        public boolean isReferred() {
            return this.referred;
        }

        public boolean isSearch() {
            return this.search;
        }

        public boolean isContainedClass() {
            return !this.isReferred() && !this.isSimpleClass() && !this.isStringClass() && !this.isReferred();
        }

        public boolean isIdObjecttranslator() {
            return this.idObjecttranslator;
        }

        public Map getCoddedEnumMap() {
            if (this.encodedEnumMap == null) {
                this.encodedEnumMap = new HashMap();
            }
            return this.encodedEnumMap;
        }

        public boolean hasCodedEnum() {
            return this.encodedEnumMap != null && !this.encodedEnumMap.isEmpty();
        }

        public boolean isUseInReport() {
            return this.useInReport;
        }

        public boolean isDateTime() {
            return this.dateTime;
        }
    }
}

