/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class MDTransformer
implements MDXMLConstants {
    protected ClassDescription classDescription;
    protected Class objectClass;
    protected MetaDataManager metaDataManager;
    protected MDTransformationManager transformationManager;
    public static boolean includeID = true;
    public static boolean includeLoggingProps = true;
    public static boolean SKP_DEFAULTS = true;
    public static boolean SKP_CLASS_NAME = false;
    private static final Logger LOGGER = new Logger(MDTransformer.class);

    void init(Class objectClass, ClassDescription classDescription, MetaDataManager metaDataManager, MDTransformationManager transformationManager) {
        this.classDescription = classDescription;
        this.objectClass = objectClass;
        this.metaDataManager = metaDataManager;
        this.transformationManager = transformationManager;
    }

    public Object getOrCreateObjectByName(Object object, String value, ClassDescription.PropertyDescription pd) {
        return null;
    }

    public void setProperty(Object object, String value, ClassDescription.PropertyDescription pd) {
        Method method = pd.setter;
        if (method != null) {
            Object obj = null;
            try {
                obj = this.getOrCreateObjectByName(object, value, pd);
                if (obj == null) {
                    if (pd.propertyTranslator != null) {
                        obj = pd.propertyTranslator.translateFromString(value);
                    } else if (obj == null && object instanceof ID_ObjectPropertyTranslator) {
                        obj = ((ID_ObjectPropertyTranslator)object).translateIdToObject(pd.name, value);
                    }
                }
                method.invoke(object, obj);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for setter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for setter", e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                LOGGER.error("Invocation error for setter", e);
            }
            catch (Exception e) {
                Logger.error(e);
            }
        } else if (object instanceof PropertyMap) {
            ((PropertyMap)object).setProperty(pd.name, value);
        }
    }

    public static void setRelatedProperty(Object object, ClassDescription.PropertyDescription pd) {
        Method method;
        if (pd.relatedProperty != null && (method = pd.relatedProperty.setter) != null) {
            try {
                Object obj = null;
                if (pd.relatedProperty.propertyTranslator != null) {
                    obj = pd.relatedProperty.propertyTranslator.translateFromString(pd.relatedValue);
                }
                method.invoke(object, obj);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for setter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for setter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for setter", e);
            }
        }
    }

    public String getProperty(Object object, ClassDescription.PropertyDescription pd) {
        return this.getProperty(object, pd, false);
    }

    public String getQuotedNameProperty(Object object, ClassDescription.PropertyDescription pd, String value) {
        return value;
    }

    public String getProperty(Object object, ClassDescription.PropertyDescription pd, boolean nameAsID) {
        Method method = pd.getter;
        if (method != null) {
            if (method.getDeclaringClass().isInstance(object)) {
                try {
                    Object result = method.invoke(object, new Object[0]);
                    if (nameAsID && result instanceof ModelIDObject) {
                        return ((ModelIDObject)result).getName();
                    }
                    if (pd.propertyTranslator != null) {
                        String str = pd.propertyTranslator.translateToString(result);
                        return this.getQuotedNameProperty(object, pd, str);
                    }
                    if (object instanceof ID_ObjectPropertyTranslator) {
                        String id = ((ID_ObjectPropertyTranslator)object).translateObjectToID(pd.name, result);
                        return id;
                    }
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("No access rights for getter method", e);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Illegal argument for getter", e);
                }
                catch (InvocationTargetException e) {
                    LOGGER.error("Invocation error for getter", e);
                }
                catch (Exception e) {
                    Logger.error(e);
                }
            }
        } else if (object instanceof PropertyMap) {
            return ((PropertyMap)object).getProperty(pd.name);
        }
        return null;
    }

    public static Object getObjectForProperty(Object composite, ClassDescription.PropertyDescription pd) {
        Method method = pd.getter;
        if (method != null) {
            try {
                Object result = method.invoke(composite, new Object[0]);
                return result;
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for getter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for getter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for getter", e);
            }
        }
        return null;
    }

    public void setObjectForProperty(Object composite, ClassDescription.PropertyDescription pd, Object property) {
        Method method = pd.setter;
        if (method != null) {
            try {
                method.invoke(composite, property);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for getter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for getter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for getter", e);
            }
        }
    }

    public static Object getCollection(Object composite, ClassDescription.CollectionDescription cold) {
        Method method = cold.getter;
        if (method != null) {
            try {
                Object result = method.invoke(composite, new Object[0]);
                return result;
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for getter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for getter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for getter", e);
            }
        }
        return null;
    }

    Object createObject(Object container, Method method) {
        if (container != null && method != null) {
            try {
                return method.invoke(container, (Object[])null);
            }
            catch (IllegalArgumentException e) {
                Logger.error(e);
            }
            catch (IllegalAccessException e) {
                Logger.error(e);
            }
            catch (InvocationTargetException e) {
                Logger.error(e);
            }
        }
        return null;
    }

    Object createItem(Object container, Method method) {
        if (container != null && method != null) {
            try {
                return method.invoke(container, (Object[])null);
            }
            catch (IllegalArgumentException e) {
                Logger.error(e);
            }
            catch (IllegalAccessException e) {
                Logger.error(e);
            }
            catch (InvocationTargetException e) {
                Logger.error(e);
            }
        }
        return null;
    }

    static void applyList(Object container, Method method, List list) {
        if (container != null && method != null) {
            try {
                method.invoke(container, list);
            }
            catch (IllegalArgumentException e) {
                Logger.error(e);
            }
            catch (IllegalAccessException e) {
                Logger.error(e);
            }
            catch (InvocationTargetException e) {
                Logger.error(e);
            }
        }
    }

    static void moveContained(Object container, Method method, Object contained, Integer position) {
        if (container != null && method != null && contained != null) {
            try {
                method.invoke(container, contained, position);
            }
            catch (IllegalArgumentException e) {
                Logger.error(e);
            }
            catch (IllegalAccessException e) {
                Logger.error(e);
            }
            catch (InvocationTargetException e) {
                Logger.error(e);
            }
        }
    }

    Object getItemByID(Object container, Method method, String id) {
        if (container != null && method != null) {
            try {
                return method.invoke(container, id);
            }
            catch (IllegalArgumentException e) {
                Logger.error(e);
            }
            catch (IllegalAccessException e) {
                Logger.error(e);
            }
            catch (InvocationTargetException e) {
                Logger.error(e);
            }
        }
        return null;
    }

    static void removeItem(Object container, Method method, Object item) {
        if (container != null && method != null) {
            try {
                method.invoke(container, item);
            }
            catch (IllegalArgumentException e) {
                Logger.error(e);
            }
            catch (IllegalAccessException e) {
                Logger.error(e);
            }
            catch (InvocationTargetException e) {
                Logger.error(e);
            }
        }
    }

    void addItem(Object container, Method method, Object item) {
        if (container != null && method != null) {
            try {
                method.invoke(container, item);
            }
            catch (IllegalArgumentException e) {
                Logger.error(e);
            }
            catch (IllegalAccessException e) {
                Logger.error(e);
            }
            catch (InvocationTargetException e) {
                Logger.error(e);
            }
        }
    }

    void removeProperty(Object container, Method method) {
        if (container != null && method != null) {
            try {
                method.invoke(container, (Object[])null);
            }
            catch (IllegalArgumentException e) {
                Logger.error(e);
            }
            catch (IllegalAccessException e) {
                Logger.error(e);
            }
            catch (InvocationTargetException e) {
                Logger.error(e);
            }
        }
    }

    public ClassDescription getClassDescription() {
        return this.classDescription;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public MDTransformationManager getTransformationManager() {
        return this.transformationManager;
    }

    public abstract String transformFromObjectToString(Object var1, List var2);

    public void setDefaultProperty(Object object, ClassDescription.PropertyDescription pd) {
        if (pd.isContainedClass()) {
            this.removeProperty(object, pd.removeProperty);
        } else if (pd.isPropertyMap) {
            if (object instanceof PropertyMap) {
                PropertyMap pmap = (PropertyMap)object;
                pmap.clearProperties();
            } else {
                this.removeProperty(object, pd.removeProperty);
            }
        } else if (pd.isMap) {
            if (object instanceof Map) {
                Map pmap = (Map)object;
                pmap.clear();
            } else {
                this.removeProperty(object, pd.removeProperty);
            }
        } else if (!"".equals(pd.defaultValue)) {
            this.setProperty(object, pd.defaultValue, pd);
        }
    }

    public Collection getObjectList(Object sourceCol, ClassDescription.CollectionDescription cold) {
        if (sourceCol instanceof Collection) {
            return (Collection)sourceCol;
        }
        if (sourceCol instanceof ElementSet) {
            ArrayList list = new ArrayList();
            ((ElementSet)sourceCol).addAllElementsTo(list);
            if (cold.isProxyitem) {
                Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
            }
            return list;
        }
        return null;
    }

    public void invokeMethod(Object object, Method method) {
        if (method != null) {
            try {
                method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for getter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for getter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for getter", e);
            }
        }
    }

    public boolean canProcessCollectionItem(ClassDescription.CollectionDescription cold) {
        return (cold.createItem != null || cold.itemIsRef || cold.isProxyitem || cold.isObjectViewItem || cold.isTVDiagramItem || cold.isTVConnectorItem || cold.isPhysicalModelItem) && !cold.isMapItem;
    }

    public static Iterator getObjectsIterator(Object object, ClassDescription.CollectionDescription cold) {
        Object sourceCol = MDTransformer.getCollection(object, cold);
        if (sourceCol instanceof Collection) {
            return ((Collection)sourceCol).iterator();
        }
        if (sourceCol instanceof ModelIDObjectSet) {
            return ((ModelIDObjectSet)sourceCol).iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected Element getFirstElementByTagName(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            Element elem = (Element)nodes.item(0);
            return elem;
        }
        return null;
    }

    static void orderAndClearList(Object container, ClassDescription.CollectionDescription cold, List oldElements, List elements) {
        if (cold.isProxyitem) {
            return;
        }
        for (Object obj : oldElements) {
            if (elements.contains(obj)) continue;
            if (cold.removeItem != null) {
                MDTransformer.removeItem(container, cold.removeItem, obj);
                continue;
            }
            if (!(obj instanceof ModelIDObject) || cold.itemIsRef || obj instanceof PermissionsOracle) continue;
            ((ModelIDObject)obj).remove();
        }
        if (cold.applyList != null) {
            MDTransformer.applyList(container, cold.applyList, elements);
        } else if (cold.moveMethod != null) {
            for (int i = 0; i < elements.size(); ++i) {
                Object obj = elements.get(i);
                MDTransformer.moveContained(container, cold.moveMethod, obj, i);
            }
        } else if (cold.nativeList) {
            Object obj;
            obj = MDTransformer.getCollection(container, cold);
            if (obj instanceof List) {
                try {
                    List target = (List)obj;
                    if (target.size() > 0) {
                        target.clear();
                    }
                    if (elements.size() > 0) {
                        target.addAll(elements);
                    }
                }
                catch (Exception exception) {}
            }
        } else if (cold.isIDObjectSet) {
            // empty if block
        }
    }

    List getListWithElements(Object container, ClassDescription.CollectionDescription cold) {
        Object col = MDTransformer.getCollection(container, cold);
        if (col != null) {
            ElementSet idset;
            if (col instanceof Collection) {
                Collection collection = (Collection)col;
                if (collection.size() > 0) {
                    ArrayList list = new ArrayList();
                    list.addAll(collection);
                    return list;
                }
            } else if (col instanceof ElementSet && (idset = (ElementSet)col).size() > 0) {
                ArrayList list = new ArrayList();
                idset.addAllElementsTo(list);
                return list;
            }
        }
        return Collections.EMPTY_LIST;
    }

    Object getItemByID(List oldItems, String id, ClassDescription.CollectionDescription cold) {
        for (Object obj : oldItems) {
            if (obj instanceof ModelIDObject) {
                if (!((ModelIDObject)obj).getObjectID().equals(id)) continue;
                return obj;
            }
            return null;
        }
        return null;
    }

    public static TransformerFactory transformerFactoryOracle() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance("oracle.xml.jaxp.JXSAXTransformerFactory", null);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setURIResolver(IgnoreURIResolver.INSTANCE);
        return factory;
    }

    public static TransformerFactory transformerFactory() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setURIResolver(IgnoreURIResolver.INSTANCE);
        return factory;
    }

    private static final class IgnoreURIResolver
    implements URIResolver {
        static final IgnoreURIResolver INSTANCE = new IgnoreURIResolver();

        private IgnoreURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return new StreamSource(new StringReader(""));
        }
    }
}

