/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.placeholder;

import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;

public class DesignPartViewPlaceHolder
extends PlaceHolder {
    private DesignPartView dpv;

    public DesignPartViewPlaceHolder(DesignPart designPart) {
        super(designPart);
    }

    public DesignPartViewPlaceHolder(DesignPart designPart, String name) {
        super(designPart);
        this.setName(name);
    }

    public DesignPartViewPlaceHolder(DesignPart designPart, DesignPartView dpv) {
        super(designPart);
        this.setObject(dpv);
        if (dpv != null) {
            this.setObjectID(dpv.getDPVId());
        }
        this.dpv = dpv;
        if (dpv != null) {
            dpv.setPlaceHolder(this);
        }
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    public void setDesignPartView(DesignPartView dpv) {
        this.setObject(dpv);
        this.dpv = dpv;
        if (dpv != null) {
            dpv.setPlaceHolder(this);
            this.setObjectID(dpv.getDPVId());
        }
    }

    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    @Override
    public String getName() {
        return this.dpv.getName();
    }

    @Override
    public boolean setName(String name) {
        if (!this.getName().equals(name)) {
            this.dpv.setName(name);
            if (this.containerSet != null) {
                this.containerSet.sort();
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
        return true;
    }

    @Override
    public String getObjectTypeName() {
        return "DesignPartViewPlaceHolder";
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("DesignPartViewPlaceHolder");
    }

    @Override
    public Object getParent() {
        return this.getDesignObjectSet();
    }

    @Override
    public String getObjectID() {
        if (this.dpv != null) {
            return this.dpv.getDPVId();
        }
        String id = super.getObjectID();
        this.setObjectID(id);
        return id;
    }

    @Override
    public String getStorageName() {
        if (this.dpv != null) {
            return this.dpv.getStorageName();
        }
        return super.getStorageName();
    }
}

