/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;

public class DesignPartView {
    public static final int TITLE_PADDING = 3;
    public static final int COLUMN_PADDING = 1;
    public static final int COLUMN_LEFT = 25;
    public static final int LEVEL_STEP = 12;
    public static final int DATATYPE_LEFT = 40;
    public static final int ALLOW_NULL_LEFT = 16;
    public static final int TYPE_LEFT = 2;
    public static final int ROW_SPACING = 3;
    public static final int MORE_ARROW_PADDING = 4;
    public static final int MORE_ARROW_WIDTH = 8;
    public static final int MORE_ARROW_HEIGHT = 8;
    public static final int BACHMAN_NOTATION = 0;
    public static final int BARKER_NOTATION = 1;
    public static final int IE_NOTATION = 2;
    private String dpvId;
    private String generatorId;
    protected List topViews = new ArrayList();
    private boolean autoRoute = false;
    private int notation = 0;
    private boolean showNamesOnly = false;
    private boolean showElements = false;
    private boolean showKeyElements = false;
    private boolean showDatatype = false;
    private boolean showFKeys = false;
    private boolean showKeys = false;
    private boolean showIndexes = false;
    private boolean showKeyAndIndexColumns = false;
    private boolean showAllDetails = true;
    private boolean showLabels = false;
    private boolean showRelAttributes = false;
    private boolean showLabelsChanging = false;
    private boolean showSchemaName = true;
    private boolean showComments = false;
    private boolean expandComplexTypes = false;
    public Point pt;
    private boolean boxInBox = false;
    private boolean showGrid;
    private boolean gridEnabled = false;
    private boolean showPageGrid = false;
    private Color diagramColor = Color.WHITE;
    private boolean showClassificationTypes = false;
    private boolean showDynamicProperties = false;
    protected Map modelToView = new HashMap();
    private DesignPart designPart;
    private static Graphics offgraphics;
    private boolean loadedCompletely = false;
    private String name = "";
    private PlaceHolder host;
    public static final Dimension TOPVIEW_SIZE;

    public DesignPartView(DesignPart desPart) {
        this.designPart = desPart;
        this.notation = desPart.getDesign().getSettings().getNotation();
        this.boxInBox = desPart.getDesign().getSettings().isBoxInBox();
    }

    public void registerTopView(TopView tv) {
        if (tv != null && !(tv instanceof TVLabel) && !this.topViews.contains(tv)) {
            this.topViews.add(tv);
        }
    }

    public void unregisterTopView(TopView tv) {
        if (tv != null) {
            this.topViews.remove(tv);
        }
    }

    public void removeView(TopView view) {
        DesignObject obj = view.getModel();
        if (obj != null) {
            this.modelToView.remove(obj);
        }
    }

    public void removeViewNoneCascade(TopView view) {
        DesignObject obj = view.getModel();
        if (obj != null) {
            this.modelToView.remove(obj);
        }
    }

    public void removeViewFor(DesignObject object) {
        TopView view = (TopView)this.modelToView.get(object);
        if (view == null) {
            return;
        }
        if (view.isConnection() && view instanceof TVConnector) {
            this.modelToView.remove(object);
            ((TVConnector)view).removeConnection();
        } else {
            this.modelToView.remove(object);
        }
    }

    public TopView getViewFor(DesignObject object) {
        TopView tv = (TopView)this.modelToView.get(object);
        if (tv == null && (tv = this.getFirstViewFor(object)) != null) {
            this.modelToView.put(object, tv);
        }
        return tv;
    }

    public TopView getFirstViewFor(DesignObject object) {
        for (TopView tv : this.topViews) {
            if (tv.getModel() != object) continue;
            return tv;
        }
        return null;
    }

    public DesignPart getDesignPart() {
        return this.designPart;
    }

    public boolean isMainDiagram() {
        return true;
    }

    public static Graphics getGraphics() {
        if (offgraphics == null) {
            BufferedImage offscreen = new BufferedImage(10, 10, 1);
            offgraphics = ((Image)offscreen).getGraphics();
        }
        return offgraphics;
    }

    public static FontMetrics getFontMetrics(Font font) {
        return DesignPartView.getGraphics().getFontMetrics(font);
    }

    public boolean isShowNamesOnly() {
        return this.showNamesOnly;
    }

    public void setShowNamesOnly(boolean showNamesOnly) {
        this.showNamesOnly = showNamesOnly;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TopView createTopViewFor(DesignObject object) {
        void var2_7;
        Object var2_2 = null;
        if (object instanceof Table) {
            TVTable tVTable = new TVTable(this);
        } else if (object instanceof TableView) {
            TVView tVView = new TVView(this);
        } else if (object instanceof FKIndexAssociation) {
            if (((FKIndexAssociation)object).getRemoteTable() == null) return null;
            TVFKRelation tVFKRelation = new TVFKRelation(this);
        } else {
            if (!(object instanceof TypeSubstitution)) return null;
            TVTypeSubstitution tVTypeSubstitution = new TVTypeSubstitution(this);
        }
        var2_7.setModel(object);
        var2_7.setSize(new Dimension(TOPVIEW_SIZE));
        return var2_7;
    }

    public TopView openViewFor(DesignObject object) {
        TopView view = this.getViewFor(object);
        if (view == null) {
            this.addViewFor(object);
            view = this.getViewFor(object);
        }
        return view;
    }

    public TopView addViewFor(DesignObject object) {
        if (this.getViewFor(object) != null) {
            return null;
        }
        TopView view = this.createTopViewFor(object);
        if (view == null) {
            return null;
        }
        if (object != null && object.isVisible()) {
            this.modelToView.put(object, view);
        }
        return view;
    }

    public void add(TopView view) {
        this.modelToView.put(view.getModel(), view);
    }

    public void registerForTreemodel(TopView tv) {
    }

    public void unregisterFromTreemodel(TopView tv) {
    }

    public static List<Prop> getVisibleProperties(ContainerObject container) {
        return Collections.EMPTY_LIST;
    }

    public static String getLongestPropertyText(List<Prop> props) {
        String name = "";
        for (Prop pr : props) {
            String n = pr.name + " - " + pr.value;
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    public boolean isShowDynamicProperties() {
        return this.showDynamicProperties;
    }

    public void setShowDynamicProperties(boolean showDynamicProperties) {
        this.showDynamicProperties = showDynamicProperties;
    }

    public boolean showElements() {
        return this.showElements;
    }

    public void setShowElements(boolean showElements) {
        this.showElements = showElements;
    }

    public boolean showKeyElements() {
        return this.showKeyElements;
    }

    public void setShowKeyElements(boolean showKeyElements) {
        this.showKeyElements = showKeyElements;
    }

    public boolean showFKeys() {
        return this.showFKeys;
    }

    public void setShowFKeys(boolean showFKeys) {
        this.showFKeys = showFKeys;
    }

    public boolean showKeys() {
        return this.showKeys;
    }

    public void setShowKeys(boolean showKeys) {
        this.showKeys = showKeys;
    }

    public boolean showIndexes() {
        return this.showIndexes;
    }

    public void setShowIndexes(boolean showIndexes) {
        this.showIndexes = showIndexes;
    }

    public boolean showKeyAndIndexColumns() {
        return this.showKeyAndIndexColumns;
    }

    public void setShowKeyAndIndexColumns(boolean showKeyAndIndexColumns) {
        this.showKeyAndIndexColumns = showKeyAndIndexColumns;
    }

    public boolean showDatatype() {
        return this.showDatatype;
    }

    public void setShowDatatype(boolean showDatatype) {
        this.showDatatype = showDatatype;
    }

    public boolean showAllDetails() {
        return this.showAllDetails;
    }

    public void setShowAllDetails(boolean showAllDetails) {
        this.showAllDetails = showAllDetails;
    }

    public boolean showSchemaName() {
        return this.showSchemaName;
    }

    public void setShowSchemaName(boolean showSchemaName) {
        this.showSchemaName = showSchemaName;
    }

    public boolean showComments() {
        return this.showComments;
    }

    public void setShowComments(boolean showComments) {
        this.showComments = showComments;
    }

    public Rectangle2D getTopViewsBounds() {
        return this.getTopViewsBounds(this.topViews);
    }

    public boolean isShowClassificationTypes() {
        return this.showClassificationTypes;
    }

    public void setShowClassificationTypes(boolean showClassificationTypes) {
        this.showClassificationTypes = showClassificationTypes;
    }

    public boolean isLoadedCompletely() {
        return this.loadedCompletely;
    }

    public void setLoadedCompletely(boolean loadedCompletely) {
        this.loadedCompletely = loadedCompletely;
    }

    public boolean isExpandComplexTypes() {
        return this.expandComplexTypes;
    }

    public void setExpandComplexTypes(boolean expandComplexTypes) {
        this.expandComplexTypes = expandComplexTypes;
    }

    public Rectangle2D getTopViewsBounds(List topViews) {
        if (topViews.size() > 0) {
            Iterator it = topViews.iterator();
            Rectangle2D.Double ret = null;
            while (it.hasNext()) {
                TopView tv = (TopView)it.next();
                Rectangle tmp = null;
                tmp = tv.getBounds();
                if (ret == null) {
                    ret = new Rectangle2D.Double(((RectangularShape)tmp).getX(), ((RectangularShape)tmp).getY(), ((RectangularShape)tmp).getWidth(), ((RectangularShape)tmp).getHeight());
                }
                if (tmp == null) continue;
                Rectangle2D.union(ret, tmp, ret);
            }
            return ret;
        }
        return null;
    }

    public void move(int dx, int dy) {
        for (TopView tv : this.topViews) {
            tv.move(dx, dy);
        }
    }

    public static String[] wrapText(String text, int length) {
        if (length > 0) {
            Pattern wrapRE = Pattern.compile("([\\S\\S&&[^\\p{Punct}]]{" + length + ",}|.{1," + length + "})(\\p{Punct}+|\\s+|$)");
            LinkedList<String> list = new LinkedList<String>();
            Matcher m = wrapRE.matcher(text);
            while (m.find()) {
                list.add(m.group());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[]{text};
    }

    public static int getMaxChars(String text, FontMetrics fm, int length) {
        for (int i = 0; i < text.length(); ++i) {
            String subStr = text.substring(0, i);
            int s1 = fm.stringWidth(subStr);
            if (s1 <= length) continue;
            return i;
        }
        return text.length();
    }

    public boolean showLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
        this.displayLabels();
    }

    public boolean showRelAttributes() {
        return this.showRelAttributes;
    }

    public void setShowRelAttributes(boolean showRelAttributes) {
        this.showRelAttributes = showRelAttributes;
    }

    public void clearLables() {
    }

    public boolean isShowLabelsChanging() {
        return this.showLabelsChanging;
    }

    public void setShowLabelsChanging(boolean showLabelsChanging) {
        this.showLabelsChanging = showLabelsChanging;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean gridEnabled) {
        this.gridEnabled = gridEnabled;
    }

    public boolean showGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public boolean showPageGrid() {
        return this.showPageGrid;
    }

    public void setShowPageGrid(boolean showPageGrid) {
        this.showPageGrid = showPageGrid;
    }

    public Color getDiagramColor() {
        return this.diagramColor;
    }

    public void setDiagramColor(Color diagramColor) {
        this.diagramColor = diagramColor;
    }

    public boolean isAutoRoute() {
        return this.autoRoute;
    }

    public void setAutoRoute(boolean autoRoute) {
        this.autoRoute = autoRoute;
    }

    public static String getLongestTypeName(TypeElement[] elements, int level) {
        String pref = "";
        for (int i = 0; i < level; ++i) {
            pref = pref + "MMM";
        }
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            StructuredType st2;
            TypeElement te;
            CollectionType ct;
            TypeElement elm;
            String n = pref + elements[i].getName();
            if (n.length() > name.length()) {
                name = n;
            }
            if ((elm = elements[i]).getType() instanceof StructuredType && !elm.isReference()) {
                StructuredType st22 = (StructuredType)elm.getType();
                if (st22 == null || (n = DesignPartView.getLongestTypeName(st22.getElements(), level + 1)).length() <= name.length()) continue;
                name = n;
                continue;
            }
            if (!(elm.getType() instanceof CollectionType) || elm.isReference() || (ct = (CollectionType)elm.getType()) == null || !((te = ct.getElementType()).getType() instanceof StructuredType) || te.isReference() || (n = DesignPartView.getLongestTypeName((st2 = (StructuredType)te.getType()).getElements(), level + 1)).length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    public static String getLongestTypeName(TypeElement[] elements, boolean expandComplextypes) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            StructuredType st2;
            TypeElement te2;
            CollectionType ct;
            TypeElement elm;
            String n = elements[i].getName();
            if (n.length() > name.length()) {
                name = n;
            }
            if ((elm = elements[i]).getType() instanceof StructuredType && expandComplextypes && !elm.isReference()) {
                StructuredType st22 = (StructuredType)elm.getType();
                if (st22 == null || (n = DesignPartView.getLongestTypeName(st22.getElements(), 1)).length() <= name.length()) continue;
                name = n;
                continue;
            }
            if (!(elm.getType() instanceof CollectionType) || !expandComplextypes || elm.isReference() || (ct = (CollectionType)elm.getType()) == null || !((te2 = ct.getElementType()).getType() instanceof StructuredType) || te2.isReference() || (st2 = (StructuredType)te2.getType()) == null || (n = DesignPartView.getLongestTypeName(st2.getElements(), 1)).length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    public static String getLongestTypeName(TypeElement[] elements) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            String n = elements[i].getName();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    protected static String getDataType(ContainedObjectWithDomain element, ContainerObject container) {
        if (container instanceof Table) {
            String formulaDesc = element.getFormulaDesc();
            if (formulaDesc != null && formulaDesc.length() > 0 && ("Derived".equalsIgnoreCase(element.getSourceType()) || "Aggregate".equalsIgnoreCase(element.getSourceType()) || element instanceof Column && ((Column)element).isComputed().booleanValue())) {
                return formulaDesc;
            }
            if (element.isReference() && element.getDataType() instanceof StructuredType) {
                return "REF " + element.getDataType().toString();
            }
        }
        if (element instanceof ColumnView && !"".equalsIgnoreCase(element.getStructAttributeID())) {
            return ((ColumnView)element).getDataTypeString();
        }
        Datatype datatype = element.getDataType();
        if (datatype instanceof DistinctType && element instanceof Column) {
            String rdbmsName = element.getSelectedRDBMSType().toString();
            if (rdbmsName.startsWith("DB2")) {
                return datatype.getName();
            }
            datatype = element.getDataType(rdbmsName);
        }
        if (datatype != null) {
            return datatype.toString();
        }
        return "";
    }

    public static String getLongestDTName(ContainedObject[] elements, ContainerObject container, boolean expandComplextypes) {
        String name = "";
        String dbType = container.getSelectedRDBMSType().toString();
        for (int i = 0; i < elements.length; ++i) {
            StructuredType st;
            TypeElement te;
            CollectionType ct;
            String n = DesignPartView.getDataType((ContainedObjectWithDomain)elements[i], container);
            if (n.length() > name.length()) {
                name = n;
            }
            if (!expandComplextypes || !(elements[i] instanceof ContainedObjectWithDomain)) continue;
            ContainedObjectWithDomain cod = (ContainedObjectWithDomain)elements[i];
            if (cod.getUse() == 3 && !cod.isReference()) {
                StructuredType st2 = cod.getStructuredType();
                if (st2 == null || (n = DesignPartView.getLongestDTNameInStrType(st2, expandComplextypes, dbType)).length() <= name.length()) continue;
                name = n;
                continue;
            }
            if (cod.getUse() != 4 || (ct = cod.getCollectionType()) == null || !((te = ct.getElementType()).getType() instanceof StructuredType) || te.isReference() || (st = (StructuredType)te.getType()) == null || (n = DesignPartView.getLongestDTNameInStrType(st, expandComplextypes, dbType)).length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    public static String getLongestDTNameInStrType(StructuredType st, boolean expandComplextypes, String dbType) {
        TypeElement[] tes;
        String name = "";
        for (TypeElement te : tes = st.getElements()) {
            StructuredType st2;
            TypeElement te2;
            CollectionType ct;
            String n = te.getDataType(dbType);
            if (n.length() > name.length()) {
                name = n;
            }
            if (te.getType() instanceof StructuredType && expandComplextypes && !te.isReference()) {
                StructuredType st22 = (StructuredType)te.getType();
                if (st22 == null || (n = DesignPartView.getLongestDTNameInStrType(st22, expandComplextypes, dbType)).length() <= name.length()) continue;
                name = n;
                continue;
            }
            if (!(te.getType() instanceof CollectionType) || !expandComplextypes || (ct = (CollectionType)te.getType()) == null || !((te2 = ct.getElementType()).getType() instanceof StructuredType) || te2.isReference() || (st2 = (StructuredType)te2.getType()) == null || (n = DesignPartView.getLongestDTNameInStrType(st2, expandComplextypes, dbType)).length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    public static String getLongestName(ContainedObject[] elements, boolean expandComplextypes) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            StructuredType st;
            TypeElement te;
            CollectionType ct;
            String n = elements[i].getName();
            if (n.length() > name.length()) {
                name = n;
            }
            if (!expandComplextypes || !(elements[i] instanceof ContainedObjectWithDomain)) continue;
            ContainedObjectWithDomain cod = (ContainedObjectWithDomain)elements[i];
            if (cod.getUse() == 3 && !cod.isReference()) {
                StructuredType st2 = cod.getStructuredType();
                if (st2 == null) continue;
                TypeElement[] tes = st2.getElements();
                n = DesignPartView.getLongestTypeName(tes, 1);
                if (StructuredType.UNIONTYPE.equalsIgnoreCase(st2.getHiveType())) {
                    n = ">" + n;
                }
                if (n.length() <= name.length()) continue;
                name = n;
                continue;
            }
            if (cod.getUse() != 4 || (ct = cod.getCollectionType()) == null || !((te = ct.getElementType()).getType() instanceof StructuredType) || te.isReference() || (st = (StructuredType)te.getType()) == null) continue;
            TypeElement[] tes = st.getElements();
            n = DesignPartView.getLongestTypeName(tes, 1);
            if (StructuredType.UNIONTYPE.equalsIgnoreCase(st.getHiveType())) {
                n = ">" + n;
            }
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    public List getTVShapes() {
        ArrayList<TopView> list = null;
        for (TopView tv : this.topViews) {
            if (!(tv instanceof ContainerView)) continue;
            if (list == null) {
                list = new ArrayList<TopView>();
            }
            list.add(tv);
        }
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List getTVConnectors() {
        ArrayList<TopView> list = null;
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVConnector)) continue;
            if (list == null) {
                list = new ArrayList<TopView>();
            }
            list.add(tv);
        }
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List getTopviewsList() {
        return Collections.unmodifiableList(this.topViews);
    }

    public void straightenLines(boolean deletePoints) {
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVConnector)) continue;
            ((TVConnector)tv).straightLine(false, true);
        }
    }

    public void straightenLines(List list) {
        TVConnector tv;
        for (FKIndexAssociation fk : list) {
            if (!fk.isSelfReference() || (tv = (TVConnector)fk.getViewFor(this)) == null) continue;
            tv.straightLine(false, true);
        }
        for (FKIndexAssociation fk : list) {
            if (fk.isSelfReference() || (tv = (TVConnector)fk.getViewFor(this)) == null) continue;
            tv.straightLine(false, true);
        }
    }

    public void straightenLinesForTypeSubst() {
        if (this.getDesignPart() instanceof RelationalDesign) {
            RelationalDesign rd = (RelationalDesign)this.getDesignPart();
            Iterator it = rd.getTypeSubstitutionSet().iterator();
            while (it.hasNext()) {
                TypeSubstitution fk = (TypeSubstitution)it.next();
                TVConnector tv = (TVConnector)fk.getViewFor(this);
                if (tv == null) continue;
                tv.straightLine(false, true);
            }
        }
    }

    public String getDPVId() {
        return this.dpvId;
    }

    public void setDPVId(String dpvId) {
        this.dpvId = dpvId;
    }

    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "subviews/" + this.getDPVId() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public TopView createTopViewForGlobal(DesignObject object) {
        return this.createTopViewFor(object);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPlaceHolder(PlaceHolder host) {
        this.host = host;
    }

    public PlaceHolder getPlaceHolder() {
        return this.host;
    }

    public String getGeneratorId() {
        return this.generatorId;
    }

    public void setGeneratorId(String generatorId) {
        this.generatorId = generatorId;
    }

    public void displayLabels() {
        Object[] cellViews = this.getTopviewsList().toArray();
        for (int j = 0; j < cellViews.length; ++j) {
            TopView tv = (TopView)cellViews[j];
            if (!tv.isConnection() || !(tv instanceof TVConnector)) continue;
            ((TVConnector)tv).displayLabels();
        }
    }

    public boolean isBoxInBox() {
        return this.boxInBox;
    }

    public void setBoxInBox(boolean boxInBox) {
        this.boxInBox = boxInBox;
    }

    public int getNotation() {
        return this.notation;
    }

    public void setNotation(int notation) {
        this.notation = notation;
    }

    static {
        TOPVIEW_SIZE = new Dimension(280, 320);
    }

    public static class Prop {
        public String name;
        public String value;
        public Color color;
    }
}

